/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor.contentassist;

import com.objfac.xml.parsers.Lexer;
import java.util.ArrayList;

public class TokenCache {
    public static final int IN = 0;
    public static final int AFTER = 1;
    public static final int BEFORE = 2;
    public static final int BETWEEN = 3;
    public static final int UNKNOWN = 4;
    private static final int NTOKENS = 20;
    ArrayList tokens = new ArrayList();
    private int first = -1;
    private int cur = -1;
    private int location = 4;
    private Lexer lexer;
    private int lastpos;
    private int off;
    private int abs;

    public TokenCache(Lexer lexer, char[] cArray, int n, int n2, int n3, int n4) {
        lexer.popAllBuffers();
        lexer.pushBuffer(cArray, n, n2, null, null);
        this.lexer = lexer;
        this.off = n3;
        this.lastpos = n;
        this.abs = n4;
    }

    public int nextToken() {
        int n = this.lexer.nextToken();
        if (this.addToken()) {
            int n2 = this.lexer.getPosition();
            int n3 = this.lexer.getTokenBegin();
            this.tokens.add(new Token(n, n3, n2, this.lexer.getToken()));
            if (this.off == n3) {
                this.setLocation(2);
            } else if (this.off < n3 && this.off >= this.lastpos) {
                this.setLocation(3);
            } else if (this.off == n2) {
                this.setLocation(1);
            } else if (this.off > n3 && this.off < n2) {
                this.setLocation(0);
            }
            this.lastpos = n2 + 1;
        }
        return n;
    }

    private boolean addToken() {
        if (this.location != 4) {
            return false;
        }
        if (++this.cur == 20) {
            this.cur = 0;
        }
        if (this.cur == this.first) {
            ++this.first;
        }
        if (this.first == 20 || this.first < 0) {
            this.first = 0;
        }
        return true;
    }

    public int getBeg() {
        return this.abs + this.lexer.getTokenBegin();
    }

    public int getEnd() {
        return this.abs + this.lexer.getTokenEnd();
    }

    public String getToken() {
        return this.lexer.getToken();
    }

    public int prevType(int n) {
        Token token = this.getRelToken(n);
        return token.typ;
    }

    private Token getRelToken(int n) {
        int n2 = this.tokens.size() - 1 + n;
        return (Token)this.tokens.get(n2);
    }

    public int prevBeg(int n) {
        Token token = this.getRelToken(n);
        return this.abs + token.beg;
    }

    public int prevEnd(int n) {
        Token token = this.getRelToken(n);
        return this.abs + token.end;
    }

    public String prevToken(int n) {
        Token token = this.getRelToken(n);
        return token.tok;
    }

    public boolean haveTokens() {
        return this.tokens.size() > 0;
    }

    public boolean haveToken(int n) {
        int n2 = this.tokens.size() - 1 + n;
        return n2 >= 0 && n2 < this.tokens.size();
    }

    public int getLocation() {
        return this.location;
    }

    private void setLocation(int n) {
        this.location = n;
    }

    private static class Token {
        int typ;
        int beg;
        int end;
        String tok;

        public Token(int n, int n2, int n3, String string) {
            this.typ = n;
            this.beg = n2;
            this.end = n3;
            this.tok = string;
        }
    }
}

