/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor.contentassist;

import com.objfac.util.Local;
import com.objfac.walker.IWalker;
import com.objfac.walker.IWalkerContext;
import com.objfac.xml.Util;
import com.objfac.xml.XMLCharacter;
import com.objfac.xml.io.Encoding;
import com.objfac.xml.parsers.Lexer;
import com.objfac.xmleditor.XMLEditor;
import com.objfac.xmleditor.XMLPlugin;
import com.objfac.xmleditor.contentassist.ContentAssistUtil;
import com.objfac.xmleditor.contentassist.TokenCache;
import com.objfac.xmleditor.contentassist.XMLCompletionProposal;
import com.objfac.xmleditor.resources.XMLConstants;
import com.objfac.xmleditor.template.IVariable;
import com.objfac.xmleditor.xmltree.XMLNode;
import com.objfac.xmleditor.xmltree.XMLTree;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationPresenter;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.graphics.Point;

public class XMLContentAssistProcessor
implements IContentAssistProcessor {
    private char[] fInfoChars;
    private char[] fProposalChars;
    public static final int TAG = 0;
    public static final int TPJ = 1;
    public static final int TDT = 2;
    public static final int ATT = 3;
    public static final int ATX = 4;
    public static final int ATJ = 5;
    public static final int VAL = 6;
    public static final int VAX = 7;
    public static final int VAJ = 8;
    public static final int TXT = 9;
    public static final int TDX = 10;
    public static final int ENT = 11;
    public static final int PNT = 12;
    public static final int MOD = 13;
    public static final int NOT = 14;
    public static final int NOQ = 15;
    public static final int VAE = 16;
    public static final int END = 17;
    public static final int ELM = 18;
    public static final int PCD = 19;
    public static final int CDT = 20;
    public static final int TAU = 21;
    private static final String[] NONE = new String[0];
    protected static final String[] fTagProposals = new String[]{"?xml", "?", "!--", "!DOCTYPE"};
    protected IContextInformationValidator fValidator = new Validator();
    private String fError;
    private static final int IN_WHITESPACE = 0;
    private XMLNode fPartition;
    private ITextViewer fViewer;
    private XMLEditor fEditor;
    private XMLTree fTree;
    private int fBeg;
    private int fEnd;
    private int fStart;
    private boolean useTopLevelElements = true;
    private static HashMap fWellKnownPrefix = new HashMap();
    private HashSet fAttrSet;
    private TokenCache fTokens;
    private static final int NTOKENS = 10;
    private static final Lexer fLexer;
    private static final HashMap fTagReplacements;
    private static final HashMap fModelReplacements;
    private String[] fTpjProposals = new String[]{"page", "include", "taglib"};
    private static final String XMLVERSION = "version";
    private static final String XMLENCODING = "encoding";
    private static final String XMLSTANDALONE = "standalone";
    private static final String[] xmlattrs;
    private static final int IXMLVERSION = 0;
    private static final int IXMLENCODING = 1;
    private static final int IXMLSTANDALONE = 2;
    private static final String[] VXMLVERSION;
    private static final String[] VXMLSTANDALONE;

    static {
        fWellKnownPrefix.put("http://relaxng.org/ns/structure/1.0", "rng");
        fWellKnownPrefix.put("http://relaxng.org/ns/annotation/1.0", "doc");
        fWellKnownPrefix.put("http://www.w3.org/XML/1998/namespace", "xml");
        fWellKnownPrefix.put("http://www.w3.org/2001/XMLSchema-datatypes", "xsd");
        fWellKnownPrefix.put("http://www.w3.org/2001/XMLSchema", "xs");
        fWellKnownPrefix.put("http://www.w3.org/2001/XMLSchema-instance", "xsi");
        fLexer = new Lexer();
        fTagReplacements = new HashMap(9);
        fTagReplacements.put("?xml", "?xml version=\"1.0\"${cursor}?>");
        fTagReplacements.put("?", "?${cursor}?>");
        fTagReplacements.put("!DOCTYPE", "!DOCTYPE ${cursor}>");
        fTagReplacements.put("!--", "!--${cursor}-->");
        fTagReplacements.put("![CDATA[", "![CDATA[${cursor}]]>");
        fTagReplacements.put("!ELEMENT", "!ELEMENT ${cursor}>");
        fTagReplacements.put("!ATTLIST", "!ATTLIST ${cursor}>");
        fTagReplacements.put("!ENTITY", "!ENTITY ${cursor}>");
        fTagReplacements.put("!ENTITY %", "!ENTITY % ${cursor}>");
        fTagReplacements.put("!NOTATION", "!NOTATION ${cursor}>");
        fTagReplacements.put("<?xml", "<?xml version=\"1.0\"${cursor}?>");
        fTagReplacements.put("<?", "<?${cursor}?>");
        fTagReplacements.put("<!DOCTYPE", "<!DOCTYPE ${cursor}>");
        fTagReplacements.put("<!--", "<!--${cursor}-->");
        fTagReplacements.put("<![CDATA[", "<![CDATA[${cursor}]]>");
        fTagReplacements.put("]]>", "]]>${cursor}");
        fTagReplacements.put("<!ELEMENT", "<!ELEMENT ${cursor}>");
        fTagReplacements.put("<!ATTLIST", "<!ATTLIST ${cursor}>");
        fTagReplacements.put("<!ENTITY", "<!ENTITY ${cursor}>");
        fTagReplacements.put("<!ENTITY %", "<!ENTITY % ${cursor}>");
        fTagReplacements.put("<!NOTATION", "<!NOTATION ${cursor}>");
        fModelReplacements = new HashMap(4);
        fModelReplacements.put("ANY", "ANY${cursor}");
        fModelReplacements.put("EMPTY", "EMPTY${cursor}");
        fModelReplacements.put("(#PCDATA)", "(#PCDATA)${cursor}");
        fModelReplacements.put("(#PCDATA|)*", "(#PCDATA|${cursor})*");
        xmlattrs = new String[]{XMLVERSION, XMLENCODING, XMLSTANDALONE};
        VXMLVERSION = new String[]{"1.0"};
        VXMLSTANDALONE = new String[]{"no", "yes"};
    }

    public XMLContentAssistProcessor(char[] cArray, char[] cArray2) {
        this.fProposalChars = cArray;
        this.fInfoChars = cArray2;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer iTextViewer, int n) {
        this.fError = null;
        this.fViewer = iTextViewer;
        this.fTokens = null;
        this.fEditor = (XMLEditor)XMLEditor.getEditorForDocument(this.fViewer.getDocument());
        this.fTree = this.fEditor.getXMLTree();
        try {
            Point point = iTextViewer.getSelectedRange();
            int n2 = point.x;
            int n3 = point.x + point.y;
            if (n != n2) {
                n2 = n3 = n;
            }
            this.fBeg = n2;
            this.fEnd = n3;
            ICompletionProposal[] iCompletionProposalArray = this.computeCompletionProposals();
            Object var6_7 = null;
            this.fViewer = null;
            this.fTokens = null;
            this.fEditor = null;
            this.fTree = null;
            return iCompletionProposalArray;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.fViewer = null;
            this.fTokens = null;
            this.fEditor = null;
            this.fTree = null;
            throw throwable;
        }
    }

    public IContextInformation[] computeContextInformation(ITextViewer iTextViewer, int n) {
        IContextInformation[] iContextInformationArray = new IContextInformation[]{};
        int n2 = 0;
        while (n2 < iContextInformationArray.length) {
            iContextInformationArray[n2] = new ContextInformation(Local.format((String)"CompletionProcessor.ContextInfo.display.pattern", (Object)new Integer(n2), (Object)new Integer(n)), Local.format((String)"CompletionProcessor.ContextInfo.value.pattern", (Object)new Integer(n2), (Object)new Integer(n - 5), (Object)new Integer(n + 5)));
            ++n2;
        }
        return iContextInformationArray;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this.fProposalChars;
    }

    private boolean isAutoChar(char c) {
        int n = 0;
        int n2 = this.fProposalChars.length;
        while (n < n2) {
            if (c == this.fProposalChars[n]) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return this.fInfoChars;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return this.fValidator;
    }

    public String getErrorMessage() {
        return this.fError;
    }

    private ICompletionProposal[] computeCompletionProposals() {
        Object object;
        char[] cArray = new char[1];
        String[] stringArray = NONE;
        String[] stringArray2 = NONE;
        this.fStart = this.fBeg;
        int n = this.computeContext();
        switch (n) {
            case 0: 
            case 17: 
            case 21: {
                cArray = XMLCompletionProposal.TAG_TRIGGER;
                break;
            }
            case 2: 
            case 10: 
            case 13: {
                cArray = XMLCompletionProposal.TDT_TRIGGER;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 9: {
                cArray = XMLCompletionProposal.ATT_TRIGGER;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 20: {
                cArray = XMLCompletionProposal.VAL_TRIGGER;
                break;
            }
            case 11: 
            case 12: {
                cArray = XMLCompletionProposal.ENT_TRIGGER;
                break;
            }
            case 18: 
            case 19: {
                cArray = XMLCompletionProposal.TDT_TRIGGER;
                break;
            }
            case 14: {
                this.fError = this.noProposals();
            }
            default: {
                return new ICompletionProposal[0];
            }
        }
        this.fStart = this.computeStart(this.fStart);
        stringArray = this.computeProposals(n);
        stringArray2 = this.computeReplacements(n, stringArray);
        IVariable[] iVariableArray = XMLCompletionProposal.BUILTINVARIABLES;
        if (this.fStart < this.fBeg && n != 21) {
            LinkedList<String> linkedList = new LinkedList<String>();
            object = new LinkedList();
            String string = "";
            try {
                string = this.fViewer.getDocument().get(this.fStart, this.fBeg - this.fStart);
            }
            catch (BadLocationException badLocationException) {
                XMLPlugin.log(badLocationException);
            }
            int n2 = string.length();
            int n3 = 0;
            while (n3 < stringArray.length) {
                String string2;
                if (stringArray[n3].length() >= n2 && (string2 = stringArray[n3].substring(0, n2)).equalsIgnoreCase(string)) {
                    linkedList.add(stringArray[n3]);
                    ((LinkedList)object).add(stringArray2[n3]);
                }
                ++n3;
            }
            if (linkedList.size() == 0) {
                this.fError = this.noProposals();
                return new ICompletionProposal[0];
            }
            stringArray = linkedList.toArray(new String[linkedList.size()]);
            stringArray2 = ((LinkedList)object).toArray(new String[((LinkedList)object).size()]);
        }
        int n4 = stringArray == null ? 0 : stringArray.length;
        object = new ICompletionProposal[n4];
        if (n4 > 0) {
            this.fEditor.setWatchPos(this.fEnd);
        }
        int n5 = 0;
        while (n5 < n4) {
            object[n5] = new XMLCompletionProposal(stringArray[n5], stringArray2[n5], this.fStart, cArray, iVariableArray);
            ++n5;
        }
        Arrays.sort(object, new Comparator(){

            public int compare(Object object, Object object2) {
                ICompletionProposal iCompletionProposal = (ICompletionProposal)object;
                ICompletionProposal iCompletionProposal2 = (ICompletionProposal)object2;
                String string = iCompletionProposal.getDisplayString();
                String string2 = iCompletionProposal2.getDisplayString();
                char c = string.length() > 0 ? string.charAt(0) : (char)'\u0000';
                char c2 = string2.length() > 0 ? string2.charAt(0) : (char)'\u0000';
                boolean bl = XMLCharacter.isIDPart((char)c);
                boolean bl2 = XMLCharacter.isIDPart((char)c2);
                if (bl && !bl2) {
                    return -1;
                }
                if (!bl && bl2) {
                    return 1;
                }
                return string.compareToIgnoreCase(string2);
            }
        });
        return object;
    }

    private int computeContext() {
        int n;
        IDocument iDocument = this.fViewer.getDocument();
        if (this.fBeg == 0 && iDocument.getLength() == 0) {
            return 9;
        }
        String string = "\u00000";
        try {
            if (this.fBeg > 0) {
                string = iDocument.get(this.fBeg - 1, 1);
            }
        }
        catch (BadLocationException badLocationException) {
            XMLPlugin.log(badLocationException);
        }
        char c = string.charAt(0);
        boolean bl = this.isAutoChar(c);
        switch (c) {
            case '<': {
                n = this.inDTD() ? 2 : 0;
                break;
            }
            case '&': {
                n = 11;
                break;
            }
            case '%': {
                n = 12;
                break;
            }
            default: {
                n = this.computeContext(iDocument, bl, c);
            }
        }
        return n;
    }

    private boolean inDTD() {
        int n = this.fEditor.getEditorKind();
        if (n == 1) {
            return true;
        }
        XMLTree xMLTree = this.fEditor.getXMLTree();
        XMLNode xMLNode = xMLTree.getDoctype();
        if (xMLNode != null && xMLNode.getType() == "com.objfac.xmldoctypestart") {
            XMLNode xMLNode2 = xMLNode.getNextSibling();
            if (this.fBeg >= xMLNode.getOffset() + xMLNode.getLength() && (xMLNode2 == null || this.fBeg < xMLNode2.getOffset())) {
                return true;
            }
        }
        return false;
    }

    private String get(int n, int n2) {
        IDocument iDocument = this.fViewer.getDocument();
        if (n >= 0 && n + n2 <= iDocument.getLength()) {
            try {
                return iDocument.get(n, n2);
            }
            catch (BadLocationException badLocationException) {
                XMLPlugin.log(badLocationException);
            }
        }
        return "";
    }

    private String get(int n) {
        return this.get(n, 1);
    }

    private int computeContext(IDocument iDocument, boolean bl, char c) {
        try {
            XMLNode xMLNode = this.fPartition = this.fTree.findExactNode(this.fBeg);
            if (xMLNode.getOffset() == this.fBeg) {
                if (c == ' ') {
                    return this.sayNo(true);
                }
                if (this.fBeg > 0 && xMLNode.getType() != "com.objfac.xmltext") {
                    XMLNode xMLNode2 = xMLNode;
                    this.fPartition = this.fTree.findExactNode(this.fBeg - 1);
                    xMLNode = this.fPartition;
                    if (xMLNode.getType() == "com.objfac.xmlstarttag" && xMLNode2.getType() == "com.objfac.xmlendtag" && xMLNode.getQName().equals(xMLNode2.getQName())) {
                        this.fPartition = xMLNode2;
                        return 16;
                    }
                }
            }
            int n = XMLConstants.getIntType(xMLNode.getType());
            switch (n) {
                case 5: {
                    return 20;
                }
                case 0: 
                case 8: 
                case 9: {
                    return this.sayNo(bl);
                }
            }
            int n2 = xMLNode.getOffset();
            int n3 = xMLNode.getLength();
            if (n2 == this.fBeg && n != 11) {
                return this.sayNo(bl);
            }
            char[] cArray = iDocument.get(n2, n3).toCharArray();
            int n4 = this.fBeg - n2;
            switch (n) {
                case 15: {
                    return this.parseAttlist(cArray, n2, n3, n4, bl);
                }
                case 7: {
                    return this.parseDoctype(cArray, n2, n3, n4, bl);
                }
                case 2: 
                case 3: {
                    return this.parseElement(cArray, n2, n3, n4, bl);
                }
                case 10: {
                    return this.parseJspDecl(cArray, n2, n3, n4, bl);
                }
                case 6: {
                    return this.parseXmlDecl(cArray, n2, n3, n4, bl);
                }
                case 4: {
                    return this.parseEndTag(cArray, n2, n3, n4, bl);
                }
                case 14: {
                    return this.parseElementDecl(cArray, n2, n3, n4, bl);
                }
                case 11: {
                    return this.parseText(cArray, n2, n3, n4, bl);
                }
                case 1: 
                case 12: 
                case 13: {
                    return this.parseEntityDecl(cArray, n2, n3, n4, bl);
                }
                case 16: {
                    return this.parseInclude(xMLNode, bl);
                }
            }
        }
        catch (BadLocationException badLocationException) {
            XMLPlugin.log(badLocationException);
        }
        return this.sayNo(bl);
    }

    private int parseInclude(XMLNode xMLNode, boolean bl) {
        XMLNode xMLNode2 = xMLNode.getParent();
        if (xMLNode2 != null && !this.inDTD()) {
            return 21;
        }
        return this.sayNo(bl);
    }

    private boolean elementContents(ITypedRegion iTypedRegion) {
        XMLNode xMLNode = ((XMLNode)iTypedRegion).getParent();
        return xMLNode != null && xMLNode.getType() == "com.objfac.xmlstarttag";
    }

    private boolean noData(XMLNode xMLNode) {
        XMLNode xMLNode2 = xMLNode.getFirstChild();
        while (xMLNode2 != null) {
            String string = xMLNode2.getType();
            if (!this.isWhitespace(xMLNode2) && string != "com.objfac.xmlpi" && string != "com.objfac.xmlcomment" && string != "com.objfac.xmlendtag") {
                return false;
            }
            xMLNode2 = xMLNode2.getNextSibling();
        }
        return true;
    }

    private boolean isWhitespace(XMLNode xMLNode) {
        return xMLNode.getType() == "com.objfac.xmltext" && XMLCharacter.isWhitespace((String)xMLNode.getContents());
    }

    private int parseText(char[] cArray, int n, int n2, int n3, boolean bl) {
        int n4 = 0;
        while (n4 < n2 && n4 < n3 && XMLCharacter.isWhitespace((char)cArray[n4])) {
            ++n4;
        }
        if (n4 == n3) {
            return this.inDTD() ? 10 : (this.elementContents(this.fPartition) ? 16 : 9);
        }
        return this.sayNo(bl);
    }

    /*
     * Unable to fully structure code
     */
    private int parseEntityDecl(char[] var1_1, int var2_2, int var3_3, int var4_4, boolean var5_5) {
        var6_6 = "<!ENTITY".length();
        if (var3_3 >= var6_6) ** GOTO lbl5
        return 21;
lbl-1000:
        // 1 sources

        {
            ++var6_6;
lbl5:
            // 2 sources

            ** while (var6_6 < var3_3 && var6_6 < var4_4 && XMLCharacter.isWhitespace((char)var1_1[var6_6]))
        }
lbl6:
        // 1 sources

        if (var6_6 == var3_3 || var6_6 == var4_4) {
            return this.sayNo(var5_5);
        }
        if (var1_1[var6_6] != '%') ** GOTO lbl16
        ++var6_6;
        while (var6_6 < var3_3 && var6_6 < var4_4 && XMLCharacter.isWhitespace((char)var1_1[var6_6])) {
            ++var6_6;
        }
        if (var6_6 != var3_3 && var6_6 != var4_4) ** GOTO lbl16
        return this.sayNo(var5_5);
lbl-1000:
        // 1 sources

        {
            ++var6_6;
lbl16:
            // 3 sources

            ** while (var6_6 < var3_3 && var6_6 < var4_4 && XMLCharacter.isIDPart((char)var1_1[var6_6]))
        }
lbl17:
        // 1 sources

        if (var6_6 != var3_3 && var6_6 != var4_4) ** GOTO lbl20
        return this.sayNo(var5_5);
lbl-1000:
        // 1 sources

        {
            ++var6_6;
lbl20:
            // 2 sources

            ** while (var6_6 < var3_3 && var6_6 < var4_4 && XMLCharacter.isWhitespace((char)var1_1[var6_6]))
        }
lbl21:
        // 1 sources

        if (var1_1[var6_6] == '\'' || var1_1[var6_6] == '\"') {
            var7_7 = var1_1[var6_6++];
            var8_8 = var6_6;
            while (var6_6 < var3_3 && var1_1[var6_6] != var7_7) {
                ++var6_6;
            }
            if (var6_6 == var3_3 || var6_6 < var4_4) {
                return this.sayNo(var5_5);
            }
            var9_9 = var4_4 - 1;
            while (var9_9 >= var8_8) {
                var10_10 = var1_1[var9_9];
                if (var10_10 == '%') {
                    return 12;
                }
                if (var10_10 == '&') {
                    return 11;
                }
                if (!XMLCharacter.isIDPart((char)var10_10)) break;
                --var9_9;
            }
        }
        return this.sayNo(var5_5);
    }

    /*
     * Unable to fully structure code
     */
    private int parseElementDecl(char[] var1_1, int var2_2, int var3_3, int var4_4, boolean var5_5) {
        var6_6 = "<!ELEMENT".length();
        if (var3_3 >= var6_6) ** GOTO lbl5
        return 21;
lbl-1000:
        // 1 sources

        {
            ++var6_6;
lbl5:
            // 2 sources

            ** while (var6_6 < var3_3 && var6_6 < var4_4 && XMLCharacter.isWhitespace((char)var1_1[var6_6]))
        }
lbl6:
        // 1 sources

        if (var6_6 != var3_3 && var6_6 != var4_4) ** GOTO lbl9
        return this.sayNo(var5_5);
lbl-1000:
        // 1 sources

        {
            ++var6_6;
lbl9:
            // 2 sources

            ** while (var6_6 < var3_3 && var6_6 < var4_4 && XMLCharacter.isIDPart((char)var1_1[var6_6]))
        }
lbl10:
        // 1 sources

        if (var6_6 != var3_3 && var6_6 != var4_4) ** GOTO lbl13
        return this.sayNo(var5_5);
lbl-1000:
        // 1 sources

        {
            ++var6_6;
lbl13:
            // 2 sources

            ** while (var6_6 < var3_3 && var6_6 < var4_4 && XMLCharacter.isWhitespace((char)var1_1[var6_6]))
        }
lbl14:
        // 1 sources

        if (var6_6 == var4_4) {
            return 13;
        }
        if (var6_6 == var3_3) {
            return this.sayNo(var5_5);
        }
        if (var1_1[var6_6] == '(') {
            var7_7 = var4_4;
            while (var7_7 > var2_2 && XMLCharacter.isWhitespace((char)var1_1[var7_7 - 1])) {
                --var7_7;
            }
            if (var1_1[--var7_7] == '(' && var7_7 == var6_6) {
                return 19;
            }
            if (var1_1[var7_7] == '(' || var1_1[var7_7] == '|' || var1_1[var7_7] == ',') {
                return 18;
            }
        }
        return this.sayNo(var5_5);
    }

    private int sayNo(boolean bl) {
        return bl ? 15 : 14;
    }

    private int parseEndTag(char[] cArray, int n, int n2, int n3, boolean bl) {
        int n4 = 15;
        if (bl) {
            if (n3 == 2 && cArray[0] == '<') {
                n4 = 17;
            }
        } else {
            while (--n3 > 1 && XMLCharacter.isIDPart((char)cArray[n3])) {
            }
            if (n3 == 1 && cArray[n3] == '/' && cArray[n3 - 1] == '<') {
                this.fStart = n + 2;
                n4 = 17;
            }
        }
        return n4;
    }

    private int parseXmlDecl(char[] cArray, int n, int n2, int n3, boolean bl) {
        TokenCache tokenCache = this.fTokens = new TokenCache(fLexer, cArray, 0, n2, n3, n);
        this.fAttrSet = this.collectAttributes(cArray, n, n2, n3, tokenCache);
        int n4 = tokenCache.getLocation();
        if (n4 == 0 && tokenCache.prevType(0) == 64) {
            return 7;
        }
        if (n4 != 3 && n4 != 2) {
            return this.sayNo(bl);
        }
        if (this.fAttrSet.contains(XMLVERSION) && this.fAttrSet.contains(XMLENCODING) && this.fAttrSet.contains(XMLSTANDALONE)) {
            return this.sayNo(bl);
        }
        return 4;
    }

    private int parseElement(char[] cArray, int n, int n2, int n3, boolean bl) {
        int n4;
        TokenCache tokenCache = this.fTokens = new TokenCache(fLexer, cArray, 0, n2, n3, n);
        this.fAttrSet = this.collectAttributes(cArray, n, n2, n3, tokenCache);
        int n5 = tokenCache.getLocation();
        int n6 = tokenCache.prevType(0);
        if ((n5 == 0 || n5 == 1) && n6 == 32) {
            int n7 = tokenCache.prevType(-1);
            if (n7 == 4) {
                return 0;
            }
            return 3;
        }
        if (n5 == 0 && n6 == 64) {
            return 6;
        }
        if ((n5 == 3 || n5 == 2) && ((n4 = tokenCache.prevType(-1)) == 64 || n4 == 32 && tokenCache.prevType(-2) == 4)) {
            return 3;
        }
        return this.sayNo(bl);
    }

    private boolean isCompletion() {
        if (this.fTokens == null) {
            return false;
        }
        int n = this.fTokens.getLocation();
        int n2 = this.fTokens.prevType(0);
        return (n == 0 || n == 1) && n2 == 32;
    }

    private int computeStart(int n) {
        XMLNode xMLNode;
        if (this.fTokens != null) {
            int n2 = this.fTokens.getLocation();
            int n3 = this.fTokens.prevType(0);
            if ((n2 == 0 || n2 == 1) && n3 == 32) {
                return this.fTokens.prevBeg(0);
            }
        }
        if ((xMLNode = this.currentTag()) != null && xMLNode.getType() != "com.objfac.xmlcomment" && this.fBeg > xMLNode.getOffset()) {
            String string = xMLNode.getContents();
            int n4 = this.fBeg - xMLNode.getOffset() - 1;
            while (n4 >= 0) {
                char c = string.charAt(n4);
                if (!XMLCharacter.isIDPart((char)c)) {
                    return xMLNode.getOffset() + n4 + 1;
                }
                --n4;
            }
        }
        return n;
    }

    private int computeEnd(int n) {
        if (this.fTokens != null) {
            int n2 = this.fTokens.getLocation();
            int n3 = this.fTokens.prevType(0);
            if ((n2 == 0 || n2 == 1) && n3 == 32) {
                return this.fTokens.prevEnd(0);
            }
        }
        return n;
    }

    private int parseJspDecl(char[] cArray, int n, int n2, int n3, boolean bl) {
        TokenCache tokenCache = this.fTokens = new TokenCache(fLexer, cArray, 0, n2, n3, n);
        this.fAttrSet = this.collectAttributes(cArray, n, n2, n3, tokenCache);
        int n4 = tokenCache.getLocation();
        if (n4 == 0 && tokenCache.prevType(0) == 64 && n3 == tokenCache.prevBeg(0) + 1) {
            return 8;
        }
        if (n4 != 3 && n4 != 2) {
            return this.sayNo(bl);
        }
        if (this.fAttrSet.isEmpty() || tokenCache.prevToken(-1).equals("%@")) {
            return 1;
        }
        return 5;
    }

    private int parseDoctype(char[] cArray, int n, int n2, int n3, boolean bl) {
        return this.sayNo(bl);
    }

    private int parseAttlist(char[] cArray, int n, int n2, int n3, boolean bl) {
        return this.sayNo(bl);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private HashSet collectAttributes(char[] cArray, int n, int n2, int n3, TokenCache tokenCache) {
        HashSet<String> hashSet;
        block11: {
            HashSet<String> hashSet2;
            block10: {
                HashSet<String> hashSet3;
                block9: {
                    try {
                        HashSet<String> hashSet4 = new HashSet<String>();
                        if (tokenCache.nextToken() != 4) {
                            hashSet3 = hashSet4;
                            Object var8_10 = null;
                            break block9;
                        }
                        int n4 = tokenCache.nextToken();
                        if (!(n4 == 32 || n4 == 16 && tokenCache.nextToken() == 32 && tokenCache.getToken().equals("xml"))) {
                            hashSet2 = hashSet4;
                            break block10;
                        }
                        n4 = tokenCache.nextToken();
                        block2: while (true) {
                            if (n4 != 32) {
                                hashSet = hashSet4;
                                break block11;
                            }
                            do {
                                hashSet4.add(tokenCache.getToken());
                            } while ((n4 = tokenCache.nextToken()) == 32);
                            while (n4 == 0x800000) {
                                n4 = tokenCache.nextToken();
                            }
                            while (true) {
                                if (n4 != 64) continue block2;
                                n4 = tokenCache.nextToken();
                            }
                            break;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var8_13 = null;
                        fLexer.popAllBuffers();
                        throw throwable;
                    }
                }
                fLexer.popAllBuffers();
                return hashSet3;
            }
            Object var8_11 = null;
            fLexer.popAllBuffers();
            return hashSet2;
        }
        Object var8_12 = null;
        fLexer.popAllBuffers();
        return hashSet;
    }

    private String noProposals() {
        return Local.getString((String)"completion_No_proposals_available_1");
    }

    private String[] computeReplacements(int n, String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        switch (n) {
            case 0: 
            case 2: 
            case 10: {
                this.computeTagReplacements(stringArray, stringArray2);
                break;
            }
            case 21: {
                this.computeTauReplacements(stringArray, stringArray2);
                break;
            }
            case 3: 
            case 4: {
                this.computeAttReplacements(stringArray, stringArray2);
                break;
            }
            case 11: 
            case 12: {
                this.computeEntityReplacements(stringArray, stringArray2);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                this.computeValueReplacements(stringArray, stringArray2);
                break;
            }
            case 16: {
                this.computeElementValueReplacements(stringArray, stringArray2);
                break;
            }
            case 17: {
                this.computeEndTagReplacements(stringArray, stringArray2);
                break;
            }
            case 13: {
                this.computeModelReplacements(stringArray, stringArray2);
                break;
            }
            case 9: {
                this.computeTextReplacements(stringArray, stringArray2);
                break;
            }
            default: {
                System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            }
        }
        return stringArray2;
    }

    private void computeTauReplacements(String[] stringArray, String[] stringArray2) {
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            int n2 = string.indexOf(124);
            stringArray2[n] = string.substring(n2 + 1);
            stringArray[n] = string.substring(0, n2);
            ++n;
        }
    }

    private void computeElementValueReplacements(String[] stringArray, String[] stringArray2) {
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            if (string.charAt(0) == '<') {
                this.computeTagReplacements(stringArray, stringArray2, n);
            } else {
                stringArray2[n] = String.valueOf(string) + "${cursor}";
            }
            ++n;
        }
    }

    private void computeModelReplacements(String[] stringArray, String[] stringArray2) {
        int n = 0;
        while (n < stringArray2.length) {
            stringArray2[n] = (String)fModelReplacements.get(stringArray[n]);
            ++n;
        }
    }

    private void computeEndTagReplacements(String[] stringArray, String[] stringArray2) {
        int n = 0;
        while (n < stringArray2.length) {
            stringArray2[n] = String.valueOf(stringArray[n]) + ">${cursor}";
            ++n;
        }
    }

    private void computeValueReplacements(String[] stringArray, String[] stringArray2) {
        int n = 34;
        if (this.fStart > 0) {
            IDocument iDocument = this.fViewer.getDocument();
            try {
                String string = iDocument.get(this.fStart - 1, 1);
                if (string.charAt(0) == '\'') {
                    n = 39;
                }
            }
            catch (BadLocationException badLocationException) {
                XMLPlugin.log(badLocationException);
            }
        }
        this.computeTrailingReplacements(stringArray, stringArray2, (char)n);
    }

    private void computeTrailingReplacements(String[] stringArray, String[] stringArray2, char c) {
        IDocument iDocument = this.fViewer.getDocument();
        if (this.fEnd < iDocument.getLength()) {
            try {
                String string = iDocument.get(this.fEnd, 1);
                if (string.charAt(0) == c) {
                    ++this.fEnd;
                }
            }
            catch (BadLocationException badLocationException) {
                XMLPlugin.log(badLocationException);
            }
        }
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            stringArray2[n] = String.valueOf(string) + c;
            ++n;
        }
    }

    private void computeEntityReplacements(String[] stringArray, String[] stringArray2) {
        this.computeTrailingReplacements(stringArray, stringArray2, ';');
    }

    private void computeAttReplacements(String[] stringArray, String[] stringArray2) {
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            stringArray2[n] = String.valueOf(string) + "=\"${cursor}\"";
            ++n;
        }
    }

    private void computeTagReplacements(String[] stringArray, String[] stringArray2) {
        int n = 0;
        while (n < stringArray.length) {
            this.computeTagReplacements(stringArray, stringArray2, n);
            ++n;
        }
    }

    private void computeTagReplacements(String[] stringArray, String[] stringArray2, int n) {
        String string = stringArray[n];
        String string2 = (String)fTagReplacements.get(string);
        if (string2 == null) {
            char c;
            int n2 = string.length();
            int n3 = 0;
            int n4 = string.length();
            while (n3 < n4) {
                c = string.charAt(n3);
                if (c == ' ' || c == '/' || c == '>' || c == '$' || c == ',') {
                    n2 = n3;
                    break;
                }
                ++n3;
            }
            string2 = string;
            string = string.substring(string.charAt(0) == '<' ? 1 : 0, n2);
            n3 = string2.charAt(0) != '/' && (string2.charAt(0) != '<' || string2.charAt(1) != '/') ? 0 : 1;
            n4 = string2.indexOf("${cursor}") >= 0 ? 1 : 0;
            c = string2.endsWith(">") ? (char)'\u0000' : '\u0001';
            boolean bl = string2.endsWith("/") || c == '\u0000' && string2.charAt(string2.length() - 2) == '/';
            boolean bl2 = string2.endsWith(",") || c == '\u0000' && string2.charAt(string2.length() - 2) == ',';
            int n5 = string2.length() - (c != '\u0000' ? 0 : 1) - (bl ? 1 : 0) - (bl2 ? 1 : 0);
            string2 = string2.substring(0, n5);
            if (n3 == 0) {
                if (bl) {
                    string2 = n4 != 0 ? String.valueOf(string2) + "/>" : (c != '\u0000' ? String.valueOf(string2) + "${cursor}/>" : String.valueOf(string2) + "/>${cursor}");
                } else {
                    String string3 = string.charAt(0) == '<' ? string.substring(1) : string;
                    String string4 = "</" + string3 + ">" + (bl2 ? "," : "");
                    string2 = n4 != 0 ? String.valueOf(string2) + ">" + string4 : (c != '\u0000' ? String.valueOf(string2) + "${cursor}>" + string4 : String.valueOf(string2) + ">${cursor}" + string4);
                }
            }
        }
        stringArray[n] = string;
        stringArray2[n] = string2;
    }

    private void computeTextReplacements(String[] stringArray, String[] stringArray2) {
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].charAt(0) == '<') {
                this.computeTagReplacements(stringArray, stringArray2, n);
            } else {
                stringArray2[n] = stringArray[n];
            }
            ++n;
        }
    }

    private String[] computeProposals(int n) {
        String[] stringArray = NONE;
        switch (n) {
            case 0: {
                stringArray = this.computeNodeProposals("");
                break;
            }
            case 9: {
                stringArray = this.computeNodeProposals("<");
                break;
            }
            case 21: {
                stringArray = this.computeTauProposals();
                break;
            }
            case 2: {
                stringArray = this.computeDTDTagProposals("");
                break;
            }
            case 10: {
                stringArray = this.computeDTDTagProposals("<");
                break;
            }
            case 1: {
                stringArray = this.fTpjProposals;
                break;
            }
            case 4: {
                stringArray = this.computeXmlProposals();
                break;
            }
            case 5: {
                break;
            }
            case 3: {
                stringArray = this.computeAttrProposals();
                break;
            }
            case 6: 
            case 8: {
                stringArray = this.computeValueProposals();
                break;
            }
            case 7: {
                stringArray = this.computeXmlValueProposals();
                break;
            }
            case 16: {
                stringArray = this.computeElementValueProposals();
                break;
            }
            case 11: {
                stringArray = this.computeEntityProposals();
                break;
            }
            case 12: {
                stringArray = this.computeParameterEntityProposals();
                break;
            }
            case 17: {
                stringArray = this.computeEndTagProposals();
                break;
            }
            case 13: {
                stringArray = this.computeModelProposals();
                break;
            }
            case 18: 
            case 19: {
                stringArray = this.computePCDataOrElementProposals(n == 19);
                break;
            }
            case 20: {
                stringArray = this.computeCDataProposals();
            }
        }
        return stringArray;
    }

    private String[] computeTauProposals() {
        LinkedList linkedList = new LinkedList();
        XMLNode xMLNode = this.currentTag();
        String string = xMLNode.getContents();
        this.fStart = xMLNode.getOffset();
        int n = this.fBeg - xMLNode.getOffset();
        if (n > 0) {
            String string2 = string.substring(0, n);
            this.add(linkedList, string2, "<!--", "<!--${cursor}-->");
            if (this.fEditor.getEditorKind() == 1) {
                this.add(linkedList, string2, "<![", "<![${cursor}[ ]]>");
                this.add(linkedList, string2, "<!ELEMENT", "<!ELEMENT ${cursor}>");
                this.add(linkedList, string2, "<!ATTLIST", "<!ATTLIST ${cursor}>");
                this.add(linkedList, string2, "<!ENTITY", "<!ENTITY ${cursor}>");
                this.add(linkedList, string2, "<!ENTITY %", "<!ENTITY % ${cursor}>");
                this.add(linkedList, string2, "<!NOTATION", "<!NOTATION ${cursor}>");
            } else if (this.inDTD()) {
                this.add(linkedList, string2, "<!ELEMENT", "<!ELEMENT ${cursor}>");
                this.add(linkedList, string2, "<!ATTLIST", "<!ATTLIST ${cursor}>");
                this.add(linkedList, string2, "<!ENTITY", "<!ENTITY ${cursor}>");
                this.add(linkedList, string2, "<!ENTITY %", "<!ENTITY % ${cursor}>");
                this.add(linkedList, string2, "<!NOTATION", "<!NOTATION ${cursor}>");
            } else {
                this.add(linkedList, string2, "<![CDATA[", "<![CDATA[${cursor}]]>");
            }
        }
        return linkedList.toArray(new String[linkedList.size()]);
    }

    private void add(LinkedList linkedList, String string, String string2, String string3) {
        String string4;
        int n = string.length();
        if (string2.length() > n && (string4 = string2.substring(0, n)).equalsIgnoreCase(string)) {
            linkedList.add(String.valueOf(string2.substring(n)) + '|' + string3);
        }
    }

    private String[] computeCDataProposals() {
        String string;
        String[] stringArray = NONE;
        XMLNode xMLNode = this.currentTag();
        if (xMLNode.getType() == "com.objfac.xmlcdata" && !"]]>".equals(string = this.get(xMLNode.getOffset() + xMLNode.getLength() - 3, 3))) {
            stringArray = new String[]{"]]>"};
        }
        return stringArray;
    }

    private String[] computePCDataOrElementProposals(boolean bl) {
        LinkedList<String> linkedList = new LinkedList<String>();
        IWalker iWalker = this.fEditor.getWalker();
        iWalker.setRootContext();
        String[] stringArray = iWalker.getElements();
        int n = 1;
        while (n < stringArray.length) {
            String string = stringArray[n];
            linkedList.add(string);
            n += 2;
        }
        if (bl) {
            linkedList.add("#PCDATA");
        }
        return linkedList.toArray(new String[linkedList.size()]);
    }

    private String[] computeElementValueProposals() {
        String[] stringArray = NONE;
        XMLNode xMLNode = this.fPartition;
        XMLNode xMLNode2 = this.fTree.getRoot();
        IWalker iWalker = ContentAssistUtil.findNode(this.fEditor, xMLNode2, xMLNode);
        if (iWalker != null) {
            iWalker.getElements();
            if (stringArray.length == 0 && this.noData(xMLNode.getParent())) {
                stringArray = iWalker.getTextValues();
            } else {
                LinkedList linkedList = new LinkedList();
                this.getAllowedInContext(linkedList, xMLNode, iWalker, "<");
                stringArray = this.array(linkedList);
            }
            stringArray = this.addGenericProposals(stringArray);
            stringArray = this.addCData(stringArray, xMLNode, iWalker);
        }
        return stringArray;
    }

    private String[] addCData(String[] stringArray, XMLNode xMLNode, IWalker iWalker) {
        if (!iWalker.canContainText()) {
            return stringArray;
        }
        return this.addProposal(stringArray, "<![CDATA[");
    }

    private String[] addGenericProposals(String[] stringArray) {
        int n = stringArray.length;
        String[] stringArray2 = new String[n + 2];
        System.arraycopy(stringArray, 0, stringArray2, 0, n);
        stringArray2[n] = "<!--";
        stringArray2[n + 1] = "<?";
        return stringArray2;
    }

    private String[] addProposal(String[] stringArray, String string) {
        int n = stringArray.length;
        String[] stringArray2 = new String[n + 1];
        System.arraycopy(stringArray, 0, stringArray2, 0, n);
        stringArray2[n] = string;
        return stringArray2;
    }

    private String[] computeModelProposals() {
        String[] stringArray = new String[]{"ANY", "EMPTY", "(#PCDATA)", "(#PCDATA|)*"};
        return stringArray;
    }

    private String[] computeDTDTagProposals(String string) {
        String[] stringArray = new String[]{String.valueOf(string) + "!ELEMENT", String.valueOf(string) + "!ATTLIST", String.valueOf(string) + "!ENTITY", String.valueOf(string) + "!ENTITY %", String.valueOf(string) + "!NOTATION", String.valueOf(string) + "!--", String.valueOf(string) + "?"};
        return stringArray;
    }

    private String[] computeEndTagProposals() {
        XMLNode xMLNode;
        String[] stringArray = NONE;
        XMLNode xMLNode2 = this.fTree.findNode(this.fBeg);
        if (xMLNode2 != null && xMLNode2.getType() == "com.objfac.xmlendtag" && (xMLNode = xMLNode2.parent) != null) {
            String string = xMLNode.getQName();
            XMLNode xMLNode3 = xMLNode.lastChild;
            if (xMLNode3 == null || xMLNode3 == xMLNode2 || xMLNode3.getType() != "com.objfac.xmlendtag" || !xMLNode3.getQName().equals(string)) {
                stringArray = new String[]{string};
            }
        }
        return stringArray;
    }

    private String[] computeTagProposals() {
        LinkedList linkedList = new LinkedList();
        XMLNode xMLNode = this.fTree.getRoot();
        XMLNode xMLNode2 = this.fTree.getDoctype();
        if (this.fBeg == 0 && this.fTree.getXMLDecl() == null) {
            return this.addXmlProposals(linkedList, xMLNode2 == null, xMLNode == null);
        }
        if (xMLNode == null || this.fBeg < xMLNode.getOffset()) {
            return this.addDoctypeProposals(linkedList, xMLNode2 == null, xMLNode == null);
        }
        XMLNode xMLNode3 = this.fTree.findExactNode(this.fBeg == 0 ? 0 : this.fBeg - 1);
        return this.computeSchemaTagProposals(linkedList, xMLNode, xMLNode3);
    }

    private String[] computeSchemaTagProposals(LinkedList linkedList, XMLNode xMLNode, XMLNode xMLNode2) {
        linkedList.add("!--");
        linkedList.add("?");
        IWalker iWalker = this.findParentContext(xMLNode, xMLNode2);
        if (iWalker != null) {
            iWalker.skipAttributes();
            this.getAllowedInContext(linkedList, xMLNode2, iWalker, "");
        }
        return this.array(linkedList);
    }

    private void getAllowedInContext(LinkedList linkedList, XMLNode xMLNode, IWalker iWalker, String string) {
        String[] stringArray = iWalker.getElements();
        IWalkerContext iWalkerContext = iWalker.getContext();
        int n = 0;
        while (n < stringArray.length) {
            CharSequence charSequence;
            Object object;
            String string2 = stringArray[n];
            String string3 = stringArray[n + 1];
            String string4 = "";
            String string5 = "";
            String string6 = "";
            HashMap<Object, String> hashMap = null;
            if (iWalker.acceptElement(string2, string3, string3)) {
                object = iWalker.getAttributes();
                if (((String[])object).length > 0) {
                    object = iWalker.getRequiredAttributes();
                    if (((String[])object).length > 0) {
                        Object object2;
                        Object object3;
                        charSequence = new StringBuffer();
                        int n2 = 0;
                        while (n2 < ((Object)object).length) {
                            object3 = object[n2];
                            object2 = object[n2 + 1];
                            String string7 = "";
                            if (((String)object3).length() > 0) {
                                String string8;
                                String string9 = string8 = hashMap == null ? null : (String)hashMap.get(object3);
                                if (string8 == null && (xMLNode == null || (string8 = xMLNode.getPrefix((String)object3)) == null)) {
                                    string8 = this.inventPrefix(iWalker, xMLNode, (String)object3, hashMap);
                                    if (hashMap == null) {
                                        hashMap = new HashMap<Object, String>();
                                    }
                                    hashMap.put(object3, string8);
                                }
                                string7 = String.valueOf(string8) + ':';
                            }
                            ((StringBuffer)charSequence).append(' ').append(string7).append((String)object2).append("=\"");
                            if (n2 == 0) {
                                ((StringBuffer)charSequence).append("${cursor}");
                            }
                            ((StringBuffer)charSequence).append('\"');
                            n2 += 2;
                        }
                        if (hashMap != null) {
                            Iterator iterator = hashMap.keySet().iterator();
                            while (iterator.hasNext()) {
                                object3 = (String)iterator.next();
                                object2 = (String)hashMap.get(object3);
                                ((StringBuffer)charSequence).append(" xmlns").append(':').append((String)object2).append("=\"");
                                ((StringBuffer)charSequence).append((String)object3).append('\"');
                            }
                        }
                        string5 = ((StringBuffer)charSequence).toString();
                    }
                } else {
                    string6 = ">";
                }
                iWalker.skipAttributes();
                if (iWalker.isEmpty()) {
                    string4 = "/";
                } else if (iWalker.isElementOnly()) {
                    string4 = ",";
                }
            } else {
                Assert.isTrue((boolean)false, (String)("Internal error: element " + string3 + " not accepted"));
            }
            object = "";
            if (!iWalker.isDTD()) {
                if ("".equals(string2)) {
                    if (xMLNode != null && (charSequence = xMLNode.getNamespace("")) != null && !"".equals(charSequence)) {
                        string5 = String.valueOf(string5) + " xmlns=\"\"";
                    }
                } else if (xMLNode != null && xMLNode.getParent() != null && string2.equals(xMLNode.getParent().getNamespace())) {
                    object = Util.getPrefix((String)xMLNode.getParent().getQName());
                } else if (xMLNode != null && xMLNode.getParent() == null) {
                    if (!"".equals(string2)) {
                        string5 = String.valueOf(string5) + " xmlns=\"" + string2 + '\"';
                    }
                } else {
                    object = xMLNode == null ? null : xMLNode.getPrefix(string2);
                    if (object == null && (object = hashMap == null ? null : (String)hashMap.get(string2)) == null) {
                        object = this.inventPrefix(iWalker, xMLNode, string2, hashMap);
                        string5 = String.valueOf(string5) + " xmlns:" + (String)object + "=\"" + string2 + '\"';
                    }
                }
            }
            if (((String)object).length() == 0) {
                linkedList.add(String.valueOf(string) + string3 + string5 + string4 + string6);
            } else {
                linkedList.add(String.valueOf(string) + (String)object + ':' + string3 + string5 + string4 + string6);
            }
            n += 2;
            iWalker.setContext(iWalkerContext);
        }
    }

    private String inventPrefix(IWalker iWalker, XMLNode xMLNode, String string, HashMap hashMap) {
        String string2;
        block3: {
            Collection<Object> collection;
            block4: {
                collection = hashMap == null ? new LinkedList() : hashMap.values();
                string2 = iWalker.getDefaultPrefix(string);
                if (string2 == null || collection.contains(string2)) {
                    string2 = this.wellKnownPrefix(string);
                }
                if (string2 != null && !collection.contains(string2)) break block3;
                if (xMLNode == null) break block4;
                String string3 = null;
                string2 = "ns";
                int n = 1;
                while (collection.contains(string2) || (string3 = xMLNode.getNamespace(string2)) != "" && !string.equals(string3)) {
                    string2 = "ns" + n;
                    ++n;
                }
                break block3;
            }
            if (string2 != null) break block3;
            string2 = "ns";
            int n = 1;
            while (collection.contains(string2)) {
                string2 = "ns" + n;
                ++n;
            }
        }
        return string2;
    }

    private String wellKnownPrefix(String string) {
        return (String)fWellKnownPrefix.get(string);
    }

    private String[] addDoctypeProposals(LinkedList linkedList, boolean bl, boolean bl2) {
        if (bl) {
            linkedList.add("!DOCTYPE");
        }
        if (bl2) {
            this.addRootProposals(linkedList);
        }
        linkedList.add("!--");
        return this.array(linkedList);
    }

    private String[] array(Collection collection) {
        return collection.toArray(new String[collection.size()]);
    }

    private String[] addXmlProposals(LinkedList linkedList, boolean bl, boolean bl2) {
        linkedList.add("?xml");
        return this.addDoctypeProposals(linkedList, bl, bl2);
    }

    private String[] addRootProposals(LinkedList linkedList) {
        IWalker iWalker = this.fEditor.getWalker();
        iWalker.setRootContext();
        this.getAllowedInContext(linkedList, null, iWalker, "");
        return this.array(linkedList);
    }

    private String[] computeXmlProposals() {
        String[] stringArray = NONE;
        XMLNode xMLNode = this.fEditor.getXMLTree().getXMLDecl();
        if (xMLNode != null) {
            boolean[] blArray = new boolean[xmlattrs.length];
            List list = xMLNode.getAttributeList();
            Object object = list.iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                int n = 0;
                while (n < xmlattrs.length) {
                    if (string.equals(xmlattrs[n])) {
                        blArray[n] = false;
                    }
                    ++n;
                }
            }
            object = new LinkedList();
            int n = 0;
            while (n < blArray.length) {
                if (blArray[n]) {
                    ((LinkedList)object).add(xmlattrs[n]);
                }
                ++n;
            }
            stringArray = ((LinkedList)object).toArray(new String[((LinkedList)object).size()]);
        }
        return stringArray;
    }

    private String[] computeXmlValueProposals() {
        String[] stringArray = NONE;
        String string = this.fTokens.prevToken(-2);
        int n = 0;
        while (n < xmlattrs.length) {
            if (xmlattrs[n].equals(string)) {
                switch (n) {
                    case 0: {
                        stringArray = VXMLVERSION;
                        break;
                    }
                    case 1: {
                        stringArray = Encoding.getStandardEncodings();
                        break;
                    }
                    case 2: {
                        stringArray = VXMLSTANDALONE;
                    }
                }
                break;
            }
            ++n;
        }
        return stringArray;
    }

    private String[] computeAttrProposals() {
        IWalker iWalker;
        String[] stringArray = NONE;
        XMLNode xMLNode = this.currentTag();
        if (xMLNode == null) {
            return stringArray;
        }
        XMLNode xMLNode2 = this.fTree.getRoot();
        IWalker iWalker2 = ContentAssistUtil.findElement(this.fEditor, xMLNode2, xMLNode);
        if (iWalker2 == null && this.useTopLevelElements) {
            iWalker = this.fEditor.getWalker();
            iWalker.setRootContext();
            if (iWalker.acceptElement(xMLNode.getNamespace(), xMLNode.getLocalname(), xMLNode.getQName())) {
                iWalker2 = iWalker;
            }
        }
        if (iWalker2 != null) {
            iWalker = iWalker2.getAttributes();
            Map map = xMLNode.getAttributes();
            LinkedList<IWalker> linkedList = new LinkedList<IWalker>();
            int n = 1;
            while (n < ((IWalker)iWalker).length) {
                if (!map.containsKey(iWalker[n])) {
                    linkedList.add(iWalker[n]);
                }
                n += 2;
            }
            stringArray = linkedList.toArray(new String[linkedList.size()]);
        }
        return stringArray;
    }

    private IWalker findParentContext(XMLNode xMLNode, XMLNode xMLNode2) {
        boolean bl = false;
        IWalker iWalker = this.fEditor.getWalker();
        iWalker.setRootContext();
        if (xMLNode == xMLNode2) {
            bl = true;
        } else if (iWalker.acceptElement(xMLNode.getNamespace(), xMLNode.getLocalname(), xMLNode.getQName())) {
            bl = this.findParentContext(xMLNode, xMLNode2, iWalker);
        }
        return bl ? iWalker : null;
    }

    private boolean findParentContext(XMLNode xMLNode, XMLNode xMLNode2, IWalker iWalker) {
        boolean bl = false;
        IWalkerContext iWalkerContext = iWalker.getContext();
        iWalker.skipAttributes();
        XMLNode xMLNode3 = xMLNode.firstChild;
        while (!bl && xMLNode3 != null) {
            if (xMLNode3 == xMLNode2) {
                bl = true;
            } else {
                String string = xMLNode3.getType();
                if ((string == "com.objfac.xmlemptytag" || string == "com.objfac.xmlstarttag") && iWalker.acceptElement(xMLNode3.getNamespace(), xMLNode3.getLocalname(), xMLNode3.getQName()) && !(bl = this.findParentContext(xMLNode3, xMLNode2, iWalker))) {
                    iWalker.skipContents();
                }
            }
            xMLNode3 = xMLNode3.nextSibling;
        }
        if (!bl) {
            iWalker.setContext(iWalkerContext);
        }
        return bl;
    }

    private String[] computeValueProposals() {
        String[] stringArray = NONE;
        XMLNode xMLNode = this.currentTag();
        if (xMLNode == null) {
            return stringArray;
        }
        XMLNode xMLNode2 = this.fTree.getRoot();
        IWalker iWalker = ContentAssistUtil.findElement(this.fEditor, xMLNode2, xMLNode);
        if (iWalker != null) {
            stringArray = this.getAttrValueProposals(iWalker);
        }
        return stringArray;
    }

    private String[] getAttrValueProposals(IWalker iWalker) {
        String[] stringArray = NONE;
        if (this.fTokens.getLocation() == 0 && this.fTokens.prevType(0) == 64 && this.fTokens.prevType(-1) == 0x800000 && this.fTokens.prevType(-2) == 32) {
            String string;
            String string2;
            XMLTree xMLTree;
            XMLNode xMLNode;
            String string3;
            String string4 = string3 = this.fTokens.prevToken(-2);
            String string5 = string3;
            String string6 = "";
            int n = string3.indexOf(58);
            if (n > 0 && ((xMLNode = (xMLTree = this.fEditor.getXMLTree()).findExactNode(this.fBeg)).getType() == "com.objfac.xmlstarttag" || xMLNode.getType() == "com.objfac.xmlemptytag") && (string2 = xMLNode.getNamespace(string = string3.substring(0, n))) != null && string2.length() > 0) {
                string6 = string2;
                string5 = string3.substring(n + 1);
            }
            stringArray = this.getAttrValueProposals(iWalker, string4, string5, string6);
        }
        return stringArray;
    }

    private String[] getAttrValueProposals(IWalker iWalker, String string, String string2, String string3) {
        String[] stringArray = NONE;
        String[] stringArray2 = iWalker.getAttributeValues(string3, string2, string);
        if (stringArray2.length > 0) {
            stringArray = new String[stringArray2.length];
            int n = 0;
            while (n < stringArray2.length) {
                stringArray[n] = stringArray2[n];
                ++n;
            }
        } else {
            String[] stringArray3 = iWalker.getAttributeTypes(string3, string2, string);
            int cfr_ignored_0 = stringArray3.length;
        }
        iWalker.acceptAttributeSkipValue(string3, string2, string);
        return stringArray;
    }

    private XMLNode currentTag() {
        return this.fTree.findExactNode(this.fBeg > 0 ? this.fBeg - 1 : this.fBeg);
    }

    private String[] computeEntityProposals() {
        IWalker iWalker = this.fEditor.getWalker();
        return iWalker.getGEs();
    }

    private String[] computeParameterEntityProposals() {
        IWalker iWalker = this.fEditor.getWalker();
        return iWalker.getPEs();
    }

    private String[] computeTextProposals() {
        IWalker iWalker = this.fEditor.getWalker();
        iWalker.setRootContext();
        XMLTree xMLTree = this.fEditor.getXMLTree();
        XMLNode xMLNode = xMLTree.getXMLDecl();
        XMLNode xMLNode2 = xMLTree.getDoctype();
        XMLNode xMLNode3 = xMLTree.getRoot();
        XMLNode xMLNode4 = this.currentTag();
        if (xMLNode4 == null) {
            return this.xmlAndDoctypeProposals(xMLNode, xMLNode2, iWalker);
        }
        XMLNode xMLNode5 = xMLNode4.getParent();
        if (xMLNode5 == null) {
            LinkedList<String> linkedList = new LinkedList<String>();
            linkedList.add("<!--");
            if (xMLNode == null && this.fBeg == 0) {
                linkedList.add("<?xml");
            }
            if (xMLNode2 == null && (xMLNode3 == null || this.fBeg <= xMLNode3.getOffset())) {
                linkedList.add("<!DOCTYPE");
            }
            if (!(xMLNode3 != null || xMLNode != null && this.fBeg <= xMLNode.getOffset() + xMLNode.getLength() || xMLNode2 != null && this.fBeg <= xMLNode2.getOffset() + xMLNode2.getLength())) {
                String string;
                if (xMLNode2 != null && (string = this.getRootNameFromDoctype(xMLNode2)).length() > 0) {
                    linkedList.add("<" + string + "${cursor}>");
                    return linkedList.toArray(new String[linkedList.size()]);
                }
                return this.contextTextProposals(iWalker, linkedList);
            }
            return linkedList.toArray(new String[linkedList.size()]);
        }
        iWalker = ContentAssistUtil.findNode(this.fEditor, xMLNode3, xMLNode4);
        if (iWalker != null) {
            return this.contextTextProposals(iWalker);
        }
        return NONE;
    }

    private String[] computeNodeProposals(String string) {
        XMLNode xMLNode;
        IWalker iWalker = this.fEditor.getWalker();
        iWalker.setRootContext();
        XMLTree xMLTree = this.fEditor.getXMLTree();
        XMLNode xMLNode2 = xMLTree.getXMLDecl();
        XMLNode xMLNode3 = xMLTree.getDoctype();
        XMLNode xMLNode4 = xMLTree.getRoot();
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add(String.valueOf(string) + "!--");
        linkedList.add(String.valueOf(string) + "?");
        XMLNode xMLNode5 = this.currentTag();
        if (xMLNode5 == null || (xMLNode = xMLNode5.getParent()) == null || xMLNode4 == null) {
            if (xMLNode2 == null && this.fBeg == 0) {
                linkedList.add(String.valueOf(string) + "?xml");
            }
            if (xMLNode3 == null && (xMLNode4 == null || this.fBeg <= xMLNode4.getOffset())) {
                linkedList.add(String.valueOf(string) + "!DOCTYPE");
            }
            if (!(xMLNode4 != null || xMLNode2 != null && this.fBeg <= xMLNode2.getOffset() + xMLNode2.getLength() || xMLNode3 != null && this.fBeg <= xMLNode3.getOffset() + xMLNode3.getLength())) {
                String string2;
                if (xMLNode3 != null && (string2 = this.getRootNameFromDoctype(xMLNode3)).length() > 0) {
                    linkedList.add(String.valueOf(string) + string2 + "${cursor}>");
                    return linkedList.toArray(new String[linkedList.size()]);
                }
                return this.contextNodeProposals(iWalker, xMLNode5, linkedList, string);
            }
        } else {
            iWalker = ContentAssistUtil.findNode(this.fEditor, xMLNode4, xMLNode5);
            if (iWalker != null) {
                if (xMLNode5.getNextSibling() == null) {
                    this.getEndTagProposal(xMLNode, linkedList, string);
                }
                return this.contextNodeProposals(iWalker, xMLNode5, linkedList, string);
            }
        }
        return linkedList.toArray(new String[linkedList.size()]);
    }

    private void getEndTagProposal(XMLNode xMLNode, LinkedList linkedList, String string) {
        String string2 = xMLNode.getNamespace();
        String string3 = xMLNode.getLocalname();
        String string4 = string2.length() == 0 ? "" : String.valueOf(string2) + ":";
        linkedList.add(String.valueOf(string) + '/' + string4 + string3 + ">${cursor}");
    }

    private String[] contextNodeProposals(IWalker iWalker, XMLNode xMLNode, LinkedList linkedList, String string) {
        this.getAllowedInContext(linkedList, xMLNode, iWalker, string);
        if (string.length() > 0) {
            String[] stringArray = iWalker.getTextValues();
            int n = 0;
            while (n < stringArray.length) {
                linkedList.add(stringArray[n]);
                ++n;
            }
        }
        if (iWalker.canContainText()) {
            linkedList.add("![CDATA[");
        }
        return linkedList.toArray(new String[linkedList.size()]);
    }

    private String getRootNameFromDoctype(XMLNode xMLNode) {
        String string = xMLNode.getContents();
        int n = "<!DOCTYPE".length();
        while (n < string.length() && XMLCharacter.isWhitespace((char)string.charAt(n))) {
            ++n;
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (n < string.length() && XMLCharacter.isIDPart((char)string.charAt(n))) {
            stringBuffer.append(string.charAt(n++));
        }
        return stringBuffer.toString();
    }

    private String[] xmlAndDoctypeProposals(XMLNode xMLNode, XMLNode xMLNode2, IWalker iWalker) {
        LinkedList<String> linkedList = new LinkedList<String>();
        if (xMLNode == null && this.fBeg == 0) {
            linkedList.add("<?xml");
        }
        if (xMLNode2 == null) {
            linkedList.add("<!DOCTYPE");
        }
        return this.contextTextProposals(iWalker, linkedList);
    }

    private String[] contextTextProposals(IWalker iWalker, LinkedList linkedList) {
        this.getAllowedInContext(linkedList, null, iWalker, "<");
        String[] stringArray = iWalker.getTextValues();
        int n = 0;
        while (n < stringArray.length) {
            linkedList.add(stringArray[n]);
            ++n;
        }
        return linkedList.toArray(new String[linkedList.size()]);
    }

    private String[] contextTextProposals(IWalker iWalker) {
        LinkedList linkedList = new LinkedList();
        return this.contextTextProposals(iWalker, linkedList);
    }

    protected static class Validator
    implements IContextInformationValidator,
    IContextInformationPresenter {
        protected int fOffset;
        protected ITextViewer fViewer;
        protected IContextInformation fInfo;

        protected Validator() {
        }

        public boolean isContextInformationValid(int n) {
            return false;
        }

        public void install(IContextInformation iContextInformation, ITextViewer iTextViewer, int n) {
            this.fInfo = iContextInformation;
            this.fViewer = iTextViewer;
            this.fOffset = n;
        }

        public boolean updatePresentation(int n, TextPresentation textPresentation) {
            return false;
        }
    }
}

