/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor.dtd;

import com.objfac.xmleditor.dtd.ElementDecl;
import com.objfac.xmleditor.dtd.EntityDecl;
import com.objfac.xmleditor.dtd.ExternalEntityDecl;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeMap;

public class DTDDecl {
    public TreeMap elements;
    public TreeMap generalEntities;
    public TreeMap notations;
    public LinkedList parameterEntities;
    public static final String DUMMY_NAME = "n9_-_-";

    public void addElement(ElementDecl elementDecl) {
        if (DUMMY_NAME.equals(elementDecl.elementName)) {
            return;
        }
        if (this.elements == null) {
            this.elements = new TreeMap();
        }
        this.elements.put(elementDecl.elementName, elementDecl);
    }

    public void addGeneralEntity(EntityDecl entityDecl) {
        if (this.generalEntities == null) {
            this.generalEntities = new TreeMap();
        }
        this.generalEntities.put(entityDecl.entityName, entityDecl);
    }

    public void addParameterEntity(EntityDecl entityDecl) {
        if (this.parameterEntities == null) {
            this.parameterEntities = new LinkedList();
        }
        this.parameterEntities.add(entityDecl);
    }

    public void addNotation(ExternalEntityDecl externalEntityDecl) {
        if (this.notations == null) {
            this.notations = new TreeMap();
        }
        this.notations.put(externalEntityDecl.entityName, externalEntityDecl);
    }

    public static String getFakeDocument(String string, String string2) {
        if (string == null) {
            string = "";
        }
        return "<!DOCTYPE n9_-_- PUBLIC \"" + string + "\" \"" + string2 + "\" " + "[<!ELEMENT " + DUMMY_NAME + " EMPTY>]>\n" + "<" + DUMMY_NAME + "/>";
    }

    public static String getFakeDoctype(String string, String string2, String string3) {
        if (string2 == null) {
            string2 = "";
        }
        return "<!DOCTYPE " + string + " PUBLIC \"" + string2 + "\" \"" + string3 + "\">";
    }

    public void print(PrintWriter printWriter) {
        String string;
        boolean bl = this.count(this.elements) + this.count(this.generalEntities) + this.count(this.parameterEntities) + this.count(this.notations) > 1;
        String string2 = bl ? "Parameter Entities" : "";
        String string3 = bl ? "General Entities" : "";
        String string4 = string = bl ? "Notations" : "";
        if (this.elements != null) {
            if (bl) {
                printWriter.println("<!-- ========== Elements ========== -->");
            }
            Iterator iterator = this.elements.values().iterator();
            while (iterator.hasNext()) {
                ElementDecl elementDecl = (ElementDecl)iterator.next();
                elementDecl.print(printWriter);
            }
        }
        if (this.parameterEntities != null) {
            this.printEntities(printWriter, this.parameterEntities.iterator(), string2);
        }
        if (this.notations != null) {
            this.printEntities(printWriter, this.notations.values().iterator(), string);
        }
        if (this.generalEntities != null) {
            this.printEntities(printWriter, this.generalEntities.values().iterator(), string3);
        }
    }

    private void printEntities(PrintWriter printWriter, Iterator iterator, String string) {
        if (string != null) {
            printWriter.println("<!-- ========== " + string + " ========== -->");
        }
        while (iterator.hasNext()) {
            EntityDecl entityDecl = (EntityDecl)iterator.next();
            entityDecl.print(printWriter);
        }
    }

    private int count(Object object) {
        return object == null ? 0 : 1;
    }
}

