/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor.generators;

import com.objfac.util.Local;
import com.objfac.util.SystemOutWriter;
import com.objfac.xml.XMLCharacter;
import com.objfac.xml.io.ILogger;
import com.objfac.xml.parsers.IErrorHandler;
import com.objfac.xml.parsers.SystemErrorHandler;
import com.objfac.xml.schema.QName;
import com.objfac.xmleditor.XMLPlugin;
import com.objfac.xmleditor.partition.IXMLNode;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XMLDTDGenerator
extends DefaultHandler {
    private String fStartName;
    protected static int MIN_ATOMIC_INSTANCES = 1;
    protected static int MIN_ENUMERATION_INSTANCES = 10;
    protected static int MAX_ENUMERATION_VALUES = 20;
    protected static int MIN_ENUMERATION_RATIO = 3;
    protected static int MIN_FIXED = 5;
    protected static int MIN_ID_VALUES = 10;
    protected static int MAX_ID_VALUES = 100000;
    TreeMap elementList;
    Stack elementStack;
    private IErrorHandler errorHandler;
    private String fEOL;
    boolean haveBoolean = false;
    private ILogger fLogger;
    private LinkedList fStartStack = new LinkedList();
    private String fNamespace;
    private boolean fDtd;
    private boolean fAllowMultipleNamespaces;
    private QName fQName = new QName();
    private Namespace fNamespaces = new Namespace("xml", "fubar");
    Writer fWriter;
    private static final int CLOSED = 0;
    private static final int CLOSE_EXTENSION = 1;
    private static final int CLOSE_COMPLEX = 2;

    public static void main(String[] stringArray) throws Exception {
        XMLDTDGenerator xMLDTDGenerator;
        if (stringArray.length != 1) {
            System.err.println("Usage: java DTDSAXGen input-file >output-file");
            System.exit(1);
        }
        if ((xMLDTDGenerator = new XMLDTDGenerator((IErrorHandler)new SystemErrorHandler())).run(stringArray[0]) && xMLDTDGenerator.printDTD((Writer)new SystemOutWriter(), "\n")) {
            System.exit(0);
        }
        System.exit(1);
    }

    public XMLDTDGenerator(IErrorHandler iErrorHandler) {
        this.elementList = new TreeMap();
        this.elementStack = new Stack();
        this.errorHandler = iErrorHandler;
    }

    private void error(String string) {
        if (this.errorHandler == null) {
            System.err.println(string);
        } else {
            this.errorHandler.error(string);
        }
    }

    private boolean run(String string) {
        try {
            InputSource inputSource = new InputSource(new File(string).toURL().toString());
            XMLReader xMLReader = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
            xMLReader.setContentHandler(this);
            xMLReader.parse(inputSource);
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.error("File " + string + " not found");
            return false;
        }
        catch (Exception exception) {
            this.error("Failed while parsing source file: " + exception.getMessage());
            return false;
        }
    }

    public boolean run(IXMLNode iXMLNode, ILogger iLogger) {
        this.fLogger = iLogger;
        while (iXMLNode != null && iXMLNode.getType() != "com.objfac.xmlstarttag" && iXMLNode.getType() != "com.objfac.xmlemptytag") {
            iXMLNode = iXMLNode.nextSibling();
        }
        if (iXMLNode != null) {
            this.fDtd = true;
            try {
                this.parse(iXMLNode);
            }
            catch (IllegalStateException illegalStateException) {
                this.fLogger.log(illegalStateException.getMessage());
            }
        }
        return true;
    }

    public String parseRoot(IXMLNode iXMLNode, boolean bl) {
        this.fAllowMultipleNamespaces = bl;
        return this.parseRoot(iXMLNode);
    }

    public String parseRoot(IXMLNode iXMLNode) {
        this.fNamespace = iXMLNode.getNamespace();
        this.fStartName = iXMLNode.getLocalname();
        this.fDtd = false;
        this.parse(iXMLNode);
        return this.fNamespace;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String parse(IXMLNode iXMLNode) {
        iXMLNode.getQName();
        this.startElement(iXMLNode);
        try {
            try {
                String string = this.parseChildren(iXMLNode);
                Object var3_3 = null;
                this.endElement(iXMLNode);
                return string;
            }
            catch (StackOverflowError stackOverflowError) {
                if (this.fLogger == null) throw stackOverflowError;
                this.fLogger.log("Stack overflow - document is too deeply nested - attempting to recover.");
                this.fLogger.log("Caution: On some JVMs, recovery is unsafe.");
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.endElement(iXMLNode);
            throw throwable;
        }
        {
            Object var3_5 = null;
            this.endElement(iXMLNode);
            return iXMLNode.getQName();
        }
    }

    private void parseEmptyTag(IXMLNode iXMLNode) {
        iXMLNode.getQName();
        this.startElement(iXMLNode);
        this.endElement(iXMLNode);
    }

    private String parseChildren(IXMLNode iXMLNode) {
        IXMLNode iXMLNode2 = iXMLNode.firstChild();
        while (iXMLNode2 != null) {
            int n;
            String string;
            String string2 = iXMLNode2.getType();
            if (string2 == "com.objfac.xmlemptytag") {
                this.parseEmptyTag(iXMLNode2);
            }
            if (string2 == "com.objfac.xmlstarttag") {
                string = iXMLNode2.getQName();
                this.fStartStack.addFirst(string);
                String string3 = this.parse(iXMLNode2);
                this.fStartStack.removeFirst();
                if (!string.equals(string3)) {
                    if (string3 == null) {
                        throw new IllegalStateException(MessageFormat.format("Missing end tag: expecting </{0}>", string));
                    }
                    throw new IllegalStateException(MessageFormat.format("Mismatched end tag: expecting </{0}> found </{1}>", string, string3));
                }
            } else if (string2 == "com.objfac.xmltext" || string2 == "com.objfac.xmlcdata") {
                string = iXMLNode2.getContents();
                try {
                    this.characters(string.toCharArray(), 0, string.length());
                }
                catch (SAXException sAXException) {
                    XMLPlugin.log(sAXException);
                }
            } else if (string2 == "com.objfac.xmlendtag" && (n = this.fStartStack.indexOf(string = iXMLNode2.getQName())) >= 0) {
                return string;
            }
            iXMLNode2 = iXMLNode2.nextSibling();
        }
        return null;
    }

    private void endElement(IXMLNode iXMLNode) {
        try {
            this.endElement(null, null, this.fDtd || this.fAllowMultipleNamespaces ? iXMLNode.getQName() : iXMLNode.getLocalname());
        }
        catch (SAXException sAXException) {
            XMLPlugin.log(sAXException);
        }
    }

    private void startElement(IXMLNode iXMLNode) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        String string = null;
        if (!this.fDtd) {
            iXMLNode.getQName(this.fQName);
            string = this.fQName.localname;
            if (!this.fQName.nsEquals(this.fNamespace)) {
                if (!this.fAllowMultipleNamespaces) {
                    this.errorHandler.error(Local.format((String)"element {0} not in target namespace", (Object)iXMLNode.getQName()));
                } else {
                    object4 = this.getPrefix(iXMLNode.getQName());
                    if (this.differentDefinition((String)object4, (String)(object3 = this.fQName.namespace))) {
                        object4 = this.getUniquePrefix((String)object4);
                    }
                    this.addNamespace((String)object4, (String)object3);
                    string = String.valueOf(object4) + ':' + string;
                }
            }
        } else {
            string = iXMLNode.getQName();
        }
        object4 = new StackEntry();
        object3 = (ElementDetails)this.elementList.get(string);
        if (object3 == null) {
            object3 = new ElementDetails(string);
            this.elementList.put(string, object3);
        }
        ((StackEntry)object4).elementDetails = object3;
        ((StackEntry)object4).sequenceNumber = -1;
        ++((ElementDetails)object3).occurrences;
        Map map = iXMLNode.getAttributes();
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            object2 = iterator.next();
            object = (String)object2.getKey();
            if (!this.fDtd && ((String)object).startsWith("xmlns")) continue;
            String string2 = (String)object2.getValue();
            AttributeDetails attributeDetails = (AttributeDetails)((ElementDetails)object3).attributes.get(object);
            if (attributeDetails == null) {
                attributeDetails = new AttributeDetails((String)object);
                ((ElementDetails)object3).attributes.put(object, attributeDetails);
            }
            if (!attributeDetails.values.contains(string2)) {
                attributeDetails.values.add(string2);
                if (attributeDetails.allNames && !this.isValidName(string2)) {
                    attributeDetails.allNames = false;
                }
                if (attributeDetails.allNMTOKENs && !this.isValidNMTOKEN(string2)) {
                    attributeDetails.allNMTOKENs = false;
                    attributeDetails.allBoolean = false;
                }
                if (attributeDetails.allBoolean) {
                    attributeDetails.allBoolean = this.isValidBoolean(string2);
                }
                if (attributeDetails.allInteger) {
                    attributeDetails.allInteger = this.isValidInteger(string2);
                }
                if (attributeDetails.allDecimal) {
                    attributeDetails.allDecimal = this.isValidDecimal(string2);
                }
                if (attributeDetails.unique && attributeDetails.allNames && attributeDetails.occurrences <= MAX_ID_VALUES) {
                    attributeDetails.values.add(string2);
                } else if (attributeDetails.values.size() <= MAX_ENUMERATION_VALUES) {
                    attributeDetails.values.add(string2);
                }
            } else {
                attributeDetails.unique = false;
            }
            ++attributeDetails.occurrences;
        }
        if (!this.elementStack.isEmpty()) {
            boolean bl;
            object2 = (StackEntry)this.elementStack.peek();
            object = ((StackEntry)object2).elementDetails;
            int n = ((StackEntry)object2).sequenceNumber;
            boolean bl2 = bl = ((StackEntry)object2).latestChild == null || !((StackEntry)object2).latestChild.equals(string);
            if (bl) {
                ++n;
                ++((StackEntry)object2).sequenceNumber;
            }
            ((StackEntry)object2).latestChild = string;
            TreeMap treeMap = ((ElementDetails)object).children;
            ChildDetails childDetails = (ChildDetails)treeMap.get(string);
            if (childDetails == null) {
                childDetails = new ChildDetails();
                childDetails.name = string;
                childDetails.position = n;
                childDetails.repeatable = false;
                childDetails.optional = false;
                treeMap.put(string, childDetails);
                ((ElementDetails)object).childseq.addElement(childDetails);
                if (((ElementDetails)object).occurrences != 1) {
                    childDetails.optional = true;
                }
            } else {
                if (((ElementDetails)object).occurrences == 1 && bl) {
                    ((ElementDetails)object).sequenced = false;
                }
                if (((ElementDetails)object).childseq.size() <= n || !((ChildDetails)((ElementDetails)object).childseq.elementAt((int)n)).name.equals(string)) {
                    ((ElementDetails)object).sequenced = false;
                }
            }
            if (!bl) {
                childDetails.repeatable = true;
            }
        }
        this.elementStack.push(object4);
    }

    private void addNamespace(String string, String string2) {
        Namespace namespace = this.fNamespaces;
        while (namespace != null) {
            if (namespace.prefix.equals(string) && namespace.uri.equals(string2)) {
                return;
            }
            namespace = namespace.next;
        }
        this.fNamespaces.next = new Namespace(string, string2, this.fNamespaces.next);
    }

    private String getUniquePrefix(String string) {
        int n = 1;
        String string2 = String.valueOf(string) + n;
        while (this.prefixExists(string2)) {
            string2 = String.valueOf(string) + ++n;
        }
        return string2;
    }

    private boolean prefixExists(String string) {
        Namespace namespace = this.fNamespaces;
        while (namespace != null) {
            if (namespace.prefix.equals(string)) {
                return true;
            }
            namespace = namespace.next;
        }
        return false;
    }

    private boolean differentDefinition(String string, String string2) {
        Namespace namespace = this.fNamespaces;
        while (namespace != null) {
            if (namespace.prefix.equals(string) && !namespace.uri.equals(string2)) {
                return true;
            }
            namespace = namespace.next;
        }
        return false;
    }

    private String getPrefix(String string) {
        int n = string.indexOf(58);
        if (n < 0) {
            return "";
        }
        return string.substring(0, n);
    }

    private boolean isValidName(String string) {
        if (!this.isValidNMTOKEN(string)) {
            return false;
        }
        char c = string.charAt(0);
        return XMLCharacter.isIDStart((int)c);
    }

    private boolean isValidNMTOKEN(String string) {
        if (string.length() == 0) {
            return false;
        }
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            char c = string.charAt(n);
            if (!XMLCharacter.isIDPart((char)c)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private boolean isValidBoolean(String string) {
        return "true".equals(string) || "false".equals(string) || "1".equals(string) || "0".equals(string);
    }

    private boolean isValidInteger(String string) {
        if (string.length() == 0) {
            return false;
        }
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            char c = string.charAt(n);
            if (c < '0' || c > '9') {
                return false;
            }
            ++n;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private boolean isValidDecimal(String var1_1) {
        if (var1_1.length() == 0) {
            return false;
        }
        var2_2 = 0;
        var3_3 = var1_1.length();
        var4_4 = '\u0000';
        while (var2_2 < var3_3) {
            var4_4 = var1_1.charAt(var2_2);
            if (var4_4 == '.') break;
            if (var4_4 < '0' || var4_4 > '9') {
                return false;
            }
            ++var2_2;
        }
        var5_5 = var2_2;
        if (var2_2++ == var3_3 || var4_4 != '.') {
            return false;
        }
        if (var2_2 != var3_3 || var5_5 != 0) ** GOTO lbl22
        return false;
lbl-1000:
        // 1 sources

        {
            var4_4 = var1_1.charAt(var2_2);
            if (var4_4 < '0' || var4_4 > '9') {
                return false;
            }
            ++var2_2;
lbl22:
            // 2 sources

            ** while (var2_2 < var3_3)
        }
lbl23:
        // 1 sources

        return true;
    }

    public boolean printDTD(Writer writer, String string) {
        this.fEOL = string;
        this.fWriter = writer;
        try {
            this.internalPrintDTD();
            return true;
        }
        catch (IOException iOException) {
            this.error("Error during printDTD: " + iOException.toString());
            return false;
        }
    }

    private void internalPrintDTD() throws IOException {
        Iterator iterator = this.elementList.keySet().iterator();
        while (iterator.hasNext()) {
            Object object;
            String string = (String)iterator.next();
            ElementDetails elementDetails = (ElementDetails)this.elementList.get(string);
            TreeMap treeMap = elementDetails.children;
            Set set = treeMap.keySet();
            if (set.size() == 0 && !elementDetails.hasCharacterContent) {
                this.writeln("<!ELEMENT " + string + " EMPTY>");
            } else if (set.size() == 0 && elementDetails.hasCharacterContent) {
                this.writeln("<!ELEMENT " + string + " (#PCDATA)>");
            } else if (set.size() > 0 && !elementDetails.hasCharacterContent) {
                this.write("<!ELEMENT " + string + " (");
                if (elementDetails.sequenced) {
                    object = elementDetails.childseq.elements();
                    while (true) {
                        ChildDetails childDetails = (ChildDetails)object.nextElement();
                        this.write(childDetails.name);
                        if (childDetails.repeatable && !childDetails.optional) {
                            this.write("+");
                        }
                        if (childDetails.repeatable && childDetails.optional) {
                            this.write("*");
                        }
                        if (childDetails.optional && !childDetails.repeatable) {
                            this.write("?");
                        }
                        if (!object.hasMoreElements()) break;
                        this.write(",");
                    }
                    this.writeln(")>");
                } else {
                    object = set.iterator();
                    while (object.hasNext()) {
                        this.write((String)object.next());
                        if (!object.hasNext()) continue;
                        this.write("|");
                    }
                    this.writeln(")*>");
                }
            } else if (set.size() > 0 && elementDetails.hasCharacterContent) {
                this.write("<!ELEMENT " + string + " (#PCDATA");
                object = set.iterator();
                while (object.hasNext()) {
                    this.write("|" + (String)object.next());
                }
                this.writeln(")*>");
            }
            object = elementDetails.attributes;
            boolean bl = false;
            Set set2 = ((TreeMap)object).keySet();
            int n = set2.size();
            Iterator iterator2 = set2.iterator();
            if (n > 1) {
                this.writeln("<!ATTLIST " + string);
            }
            while (iterator2.hasNext()) {
                Object object2;
                String string2;
                boolean bl2;
                String string3 = (String)iterator2.next();
                AttributeDetails attributeDetails = (AttributeDetails)((TreeMap)object).get(string3);
                boolean bl3 = attributeDetails.occurrences == elementDetails.occurrences;
                boolean bl4 = attributeDetails.allNames && !bl && attributeDetails.unique && attributeDetails.occurrences >= MIN_ID_VALUES;
                boolean bl5 = bl3 && attributeDetails.values.size() == 1 && attributeDetails.occurrences >= MIN_FIXED;
                boolean bl6 = bl2 = attributeDetails.allNMTOKENs && attributeDetails.occurrences >= MIN_ENUMERATION_INSTANCES && attributeDetails.values.size() <= attributeDetails.occurrences / MIN_ENUMERATION_RATIO && attributeDetails.values.size() <= MAX_ENUMERATION_VALUES;
                if (n == 1) {
                    this.write("<!ATTLIST " + string + " " + string3 + " ");
                } else {
                    this.write("\t" + string3 + " ");
                }
                String string4 = string2 = attributeDetails.allNMTOKENs ? "NMTOKEN" : "CDATA";
                if (bl4) {
                    this.write("ID");
                    bl = true;
                } else if (bl5) {
                    object2 = (String)attributeDetails.values.first();
                    if (n == 1) {
                        this.writeln(String.valueOf(string2) + " #FIXED \"" + XMLDTDGenerator.escape((String)object2) + "\" >");
                    } else {
                        this.writeln(String.valueOf(string2) + " #FIXED \"" + XMLDTDGenerator.escape((String)object2) + "\"");
                    }
                } else if (bl2) {
                    this.write("(");
                    object2 = attributeDetails.values.iterator();
                    while (object2.hasNext()) {
                        this.write((String)object2.next());
                        if (!object2.hasNext()) break;
                        this.write("|");
                    }
                    this.write(")");
                } else {
                    this.write(string2);
                }
                if (bl5) continue;
                if (bl3) {
                    if (n == 1) {
                        this.writeln(" #REQUIRED>");
                        continue;
                    }
                    this.writeln(" #REQUIRED");
                    continue;
                }
                if (n == 1) {
                    this.writeln(" #IMPLIED>");
                    continue;
                }
                this.writeln(" #IMPLIED");
            }
            if (n <= 1) continue;
            this.writeln(">");
        }
    }

    private void write(String string) throws IOException {
        this.fWriter.write(string);
    }

    private void writeln(String string) throws IOException {
        this.fWriter.write(string);
        this.fWriter.write(this.fEOL);
    }

    private void writeln() throws IOException {
        this.fWriter.write(this.fEOL);
    }

    public boolean printRncSchema(Writer writer, String string, String string2) {
        this.fEOL = string;
        this.fWriter = writer;
        try {
            this.internalPrintRncSchema(string2);
            return true;
        }
        catch (IOException iOException) {
            this.error("Error during printRncSchema: " + iOException.toString());
            return false;
        }
    }

    private void internalPrintRncSchema(String string) throws IOException {
        if (string != null && string.length() > 0) {
            this.writeln("default namespace \"" + string + "\"");
        }
        Object object = this.fNamespaces.next;
        while (object != null) {
            this.writeln("namespace " + ((Namespace)object).prefix + "= \"" + ((Namespace)object).uri + '\"');
            object = ((Namespace)object).next;
        }
        this.writeln("start = " + this.fStartName);
        object = this.elementList.keySet().iterator();
        while (object.hasNext()) {
            boolean bl;
            boolean bl2;
            boolean bl3;
            Iterator iterator;
            boolean bl4;
            String string2 = (String)object.next();
            String string3 = this.getDefineName(string2);
            ElementDetails elementDetails = (ElementDetails)this.elementList.get(string2);
            TreeMap treeMap = elementDetails.children;
            Set set = treeMap.keySet();
            TreeMap treeMap2 = elementDetails.attributes;
            if (set.size() == 0 && treeMap2.size() == 0) {
                if (elementDetails.hasCharacterContent) {
                    boolean bl5;
                    bl4 = elementDetails.allInteger && elementDetails.occurrences >= MIN_ATOMIC_INSTANCES;
                    boolean bl6 = elementDetails.allDecimal && elementDetails.occurrences >= MIN_ATOMIC_INSTANCES;
                    boolean bl7 = elementDetails.allBoolean && elementDetails.occurrences >= MIN_ATOMIC_INSTANCES;
                    boolean bl8 = bl5 = elementDetails.allNMTOKENs && elementDetails.occurrences >= MIN_ENUMERATION_INSTANCES && elementDetails.values.size() <= elementDetails.occurrences / MIN_ENUMERATION_RATIO && elementDetails.values.size() <= MAX_ENUMERATION_VALUES;
                    if (bl4) {
                        this.writeln(String.valueOf(string3) + " = element " + string2 + " { xsd:integer }");
                        continue;
                    }
                    if (bl6) {
                        this.writeln(String.valueOf(string3) + " = element " + string2 + " { xsd:decimal }");
                        continue;
                    }
                    if (bl7) {
                        this.writeln(String.valueOf(string3) + " = element " + string2 + " { xsd:boolean }");
                        continue;
                    }
                    if (bl5) {
                        this.writeln(String.valueOf(string3) + " =");
                        this.writeln("\telement " + string2 + " {");
                        this.writeln(String.valueOf(string2) + " = element " + string2 + " {");
                        iterator = elementDetails.values.iterator();
                        boolean bl9 = true;
                        while (iterator.hasNext()) {
                            if (bl9) {
                                this.writeln("\t\t\"" + (String)iterator.next() + "\"");
                            } else {
                                this.writeln("\t\t| \"" + (String)iterator.next() + "\"");
                            }
                            bl9 = false;
                        }
                        this.writeln("\t}");
                        continue;
                    }
                    this.writeln(String.valueOf(string3) + " = element " + string2 + " { text }");
                    continue;
                }
                this.writeln(String.valueOf(string3) + " = element " + string2 + " { empty }");
                continue;
            }
            this.writeln(String.valueOf(string3) + " =");
            this.writeln("\telement " + string2 + " {");
            bl4 = false;
            Set set2 = treeMap2.keySet();
            set2.size();
            Iterator iterator2 = set2.iterator();
            String string4 = "\t\t";
            while (iterator2.hasNext()) {
                Object object2;
                boolean bl10;
                iterator = (String)iterator2.next();
                AttributeDetails attributeDetails = (AttributeDetails)treeMap2.get(iterator);
                bl3 = attributeDetails.occurrences == elementDetails.occurrences;
                bl2 = bl3 && attributeDetails.values.size() == 1 && attributeDetails.occurrences >= MIN_FIXED;
                boolean bl11 = attributeDetails.allInteger && attributeDetails.occurrences >= MIN_ATOMIC_INSTANCES;
                bl = attributeDetails.allDecimal && attributeDetails.occurrences >= MIN_ATOMIC_INSTANCES;
                boolean bl12 = attributeDetails.allBoolean && attributeDetails.occurrences >= MIN_ATOMIC_INSTANCES;
                boolean bl13 = attributeDetails.allNames && !bl4 && attributeDetails.unique && attributeDetails.occurrences >= MIN_ID_VALUES;
                boolean bl14 = bl10 = attributeDetails.allNMTOKENs && attributeDetails.occurrences >= MIN_ENUMERATION_INSTANCES && attributeDetails.values.size() <= attributeDetails.occurrences / MIN_ENUMERATION_RATIO && attributeDetails.values.size() <= MAX_ENUMERATION_VALUES;
                if (bl2) {
                    object2 = (String)attributeDetails.values.first();
                    this.write(String.valueOf(string4) + "attribute " + iterator + " { \"" + (String)object2 + "\" }");
                } else if (bl11) {
                    this.write(String.valueOf(string4) + "attribute " + iterator + " { xsd:integer }");
                } else if (bl) {
                    this.write(String.valueOf(string4) + "attribute " + iterator + " { xsd:decimal }");
                } else if (bl12) {
                    this.write(String.valueOf(string4) + "attribute " + iterator + " { xsd:boolean }");
                } else if (bl13) {
                    this.write(String.valueOf(string4) + "attribute " + iterator + " { xsd:ID }");
                    bl4 = true;
                } else if (bl10) {
                    this.writeln(String.valueOf(string4) + "attribute " + iterator + " {");
                    object2 = attributeDetails.values.iterator();
                    boolean bl15 = true;
                    while (object2.hasNext()) {
                        if (bl15) {
                            this.writeln(String.valueOf(string4) + "\t\"" + (String)object2.next() + "\"");
                        } else {
                            this.writeln(String.valueOf(string4) + "\t| \"" + (String)object2.next() + "\"");
                        }
                        bl15 = false;
                    }
                    this.write(String.valueOf(string4) + "}");
                } else if (attributeDetails.allNMTOKENs) {
                    this.write(String.valueOf(string4) + "attribute " + iterator + " { token }");
                } else {
                    this.write(String.valueOf(string4) + "attribute " + iterator + " { string }");
                }
                if (!bl3) {
                    this.write("?");
                }
                this.writeln(",");
            }
            if (set.size() == 0 && !elementDetails.hasCharacterContent) {
                this.writeln(String.valueOf(string4) + "empty");
            } else if (set.size() == 0 && elementDetails.hasCharacterContent) {
                boolean bl16 = elementDetails.allInteger && elementDetails.occurrences >= MIN_ATOMIC_INSTANCES;
                boolean bl17 = elementDetails.allDecimal && elementDetails.occurrences >= MIN_ATOMIC_INSTANCES;
                bl3 = elementDetails.allBoolean && elementDetails.occurrences >= MIN_ATOMIC_INSTANCES;
                boolean bl18 = bl2 = elementDetails.allNMTOKENs && elementDetails.occurrences >= MIN_ENUMERATION_INSTANCES && elementDetails.values.size() <= elementDetails.occurrences / MIN_ENUMERATION_RATIO && elementDetails.values.size() <= MAX_ENUMERATION_VALUES;
                if (bl16) {
                    this.writeln(String.valueOf(string4) + "xsd:integer");
                } else if (bl17) {
                    this.writeln(String.valueOf(string4) + "xsd:decimal");
                } else if (bl3) {
                    this.writeln(String.valueOf(string4) + "xsd:boolean");
                } else if (bl2) {
                    Iterator iterator3 = elementDetails.values.iterator();
                    bl = true;
                    while (iterator3.hasNext()) {
                        if (bl) {
                            this.writeln(String.valueOf(string4) + "\t\"" + (String)iterator3.next() + "\"");
                        } else {
                            this.writeln(String.valueOf(string4) + "\t| \"" + (String)iterator3.next() + "\"");
                        }
                        bl = false;
                    }
                } else {
                    this.writeln(String.valueOf(string4) + "text");
                }
            } else if (set.size() > 0 && !elementDetails.hasCharacterContent) {
                if (elementDetails.sequenced) {
                    iterator = elementDetails.childseq.elements();
                    while (iterator.hasMoreElements()) {
                        ChildDetails childDetails = (ChildDetails)iterator.nextElement();
                        this.write(String.valueOf(string4) + this.getDefineName(childDetails.name));
                        if (childDetails.repeatable && !childDetails.optional) {
                            this.write("+");
                        }
                        if (childDetails.repeatable && childDetails.optional) {
                            this.write("*");
                        }
                        if (childDetails.optional && !childDetails.repeatable) {
                            this.write("?");
                        }
                        if (!iterator.hasMoreElements()) {
                            this.writeln("");
                            break;
                        }
                        this.writeln(",");
                    }
                } else {
                    iterator = set.iterator();
                    boolean bl19 = true;
                    while (iterator.hasNext()) {
                        String string5 = this.getDefineName((String)iterator.next());
                        if (bl19) {
                            this.write(String.valueOf(string4) + "( " + string5);
                        } else {
                            this.write(String.valueOf(string4) + "| " + string5);
                        }
                        bl19 = false;
                        if (!iterator.hasNext()) {
                            this.writeln(" )*");
                            break;
                        }
                        this.writeln("");
                    }
                }
            } else if (set.size() > 0 && elementDetails.hasCharacterContent) {
                this.writeln(String.valueOf(string4) + "mixed {");
                iterator = set.iterator();
                boolean bl20 = true;
                while (iterator.hasNext()) {
                    String string6 = this.getDefineName((String)iterator.next());
                    if (bl20) {
                        this.write(String.valueOf(string4) + "( " + string6);
                    } else {
                        this.write(String.valueOf(string4) + "| " + string6);
                    }
                    bl20 = false;
                    if (!iterator.hasNext()) {
                        this.writeln(" )*");
                        break;
                    }
                    this.writeln("");
                }
                this.writeln(String.valueOf(string4) + "}");
            }
            this.writeln("\t}");
        }
    }

    private String getDefineName(String string) {
        return string.replace(':', '_');
    }

    public boolean printRngSchema(Writer writer, String string, String string2) {
        this.fEOL = string;
        this.fWriter = writer;
        try {
            this.internalPrintRngSchema(string2);
            return true;
        }
        catch (IOException iOException) {
            this.error("Error during printRngSchema: " + iOException.toString());
            return false;
        }
    }

    private void internalPrintRngSchema(String string) throws IOException {
        if (string != null && string.length() > 0) {
            this.writeln("<grammar xmlns=\"http://relaxng.org/ns/structure/1.0\"");
            this.writeln("         ns=\"" + string + "\"");
        } else {
            this.writeln("<grammar xmlns=\"http://relaxng.org/ns/structure/1.0\"");
        }
        Object object = this.fNamespaces.next;
        while (object != null) {
            this.writeln("         xmlns:" + ((Namespace)object).prefix + " = \"" + ((Namespace)object).uri + "\"");
            object = ((Namespace)object).next;
        }
        this.writeln("         datatypeLibrary=\"http://www.w3.org/2001/XMLSchema-datatypes\">");
        this.writeln("\t<start>");
        this.writeln("\t\t<ref name=\"" + this.fStartName + "\"/>");
        this.writeln("\t</start>");
        object = this.elementList.keySet().iterator();
        while (object.hasNext()) {
            boolean bl;
            boolean bl2;
            boolean bl3;
            Object object2;
            Iterator iterator;
            String string2 = (String)object.next();
            ElementDetails elementDetails = (ElementDetails)this.elementList.get(string2);
            TreeMap treeMap = elementDetails.children;
            Set set = treeMap.keySet();
            this.writeln("\t<define name=\"" + this.getDefineName(string2) + "\">");
            this.writeln("\t\t<element name=\"" + string2 + "\">");
            TreeMap treeMap2 = elementDetails.attributes;
            boolean bl4 = false;
            Set set2 = treeMap2.keySet();
            set2.size();
            Iterator iterator2 = set2.iterator();
            String string3 = "\t\t\t";
            while (iterator2.hasNext()) {
                Object object3;
                iterator = (String)iterator2.next();
                object2 = (AttributeDetails)treeMap2.get(iterator);
                bl3 = ((AttributeDetails)object2).occurrences == elementDetails.occurrences;
                bl2 = bl3 && ((AttributeDetails)object2).values.size() == 1 && ((AttributeDetails)object2).occurrences >= MIN_FIXED;
                boolean bl5 = ((AttributeDetails)object2).allInteger && ((AttributeDetails)object2).occurrences >= MIN_ATOMIC_INSTANCES;
                bl = ((AttributeDetails)object2).allDecimal && ((AttributeDetails)object2).occurrences >= MIN_ATOMIC_INSTANCES;
                boolean bl6 = ((AttributeDetails)object2).allBoolean && ((AttributeDetails)object2).occurrences >= MIN_ATOMIC_INSTANCES;
                boolean bl7 = ((AttributeDetails)object2).allNames && !bl4 && ((AttributeDetails)object2).unique && ((AttributeDetails)object2).occurrences >= MIN_ID_VALUES;
                boolean bl8 = ((AttributeDetails)object2).allNMTOKENs && ((AttributeDetails)object2).occurrences >= MIN_ENUMERATION_INSTANCES && ((AttributeDetails)object2).values.size() <= ((AttributeDetails)object2).occurrences / MIN_ENUMERATION_RATIO && ((AttributeDetails)object2).values.size() <= MAX_ENUMERATION_VALUES;
                String string4 = String.valueOf(string3) + "\t";
                if (!bl3) {
                    this.writeln(String.valueOf(string3) + "<optional>");
                    this.writeln(String.valueOf(string3) + "\t<attribute name=\"" + iterator + "\">");
                    string4 = String.valueOf(string3) + "\t\t";
                } else {
                    this.writeln(String.valueOf(string3) + "<attribute name=\"" + iterator + "\">");
                }
                if (bl2) {
                    object3 = (String)((AttributeDetails)object2).values.first();
                    if (((AttributeDetails)object2).allNMTOKENs) {
                        this.writeln(String.valueOf(string4) + "<value type=\"NMTOKEN\">" + (String)object3 + "</value>");
                    } else {
                        this.writeln(String.valueOf(string4) + "<value type=\"string\">" + (String)object3 + "</value>");
                    }
                } else if (bl5) {
                    this.writeln(String.valueOf(string4) + "<data type=\"integer\"/>");
                } else if (bl) {
                    this.writeln(String.valueOf(string4) + "<data type=\"decimal\"/>");
                } else if (bl6) {
                    this.writeln(String.valueOf(string4) + "<data type=\"boolean\"/>");
                } else if (bl7) {
                    this.writeln(String.valueOf(string4) + "<data type=\"ID\"/>");
                    bl4 = true;
                } else if (bl8) {
                    this.writeln(String.valueOf(string4) + "<choice>");
                    object3 = ((AttributeDetails)object2).values.iterator();
                    while (object3.hasNext()) {
                        this.writeln(String.valueOf(string4) + "\t<value>" + (String)object3.next() + "</value>");
                    }
                    this.writeln(String.valueOf(string4) + "</choice>");
                } else if (((AttributeDetails)object2).allNMTOKENs) {
                    this.writeln(String.valueOf(string4) + "<data type=\"token\"/>");
                } else {
                    this.writeln(String.valueOf(string4) + "<text/>");
                }
                if (!bl3) {
                    this.writeln(String.valueOf(string3) + "\t</attribute>");
                    this.writeln(String.valueOf(string3) + "</optional>");
                    continue;
                }
                this.writeln(String.valueOf(string3) + "</attribute>");
            }
            if (set.size() == 0 && !elementDetails.hasCharacterContent) {
                this.writeln(String.valueOf(string3) + "<empty/>");
            } else if (set.size() == 0 && elementDetails.hasCharacterContent) {
                boolean bl9 = elementDetails.allInteger && elementDetails.occurrences >= MIN_ATOMIC_INSTANCES;
                boolean bl10 = elementDetails.allDecimal && elementDetails.occurrences >= MIN_ATOMIC_INSTANCES;
                bl3 = elementDetails.allBoolean && elementDetails.occurrences >= MIN_ATOMIC_INSTANCES;
                boolean bl11 = bl2 = elementDetails.allNMTOKENs && elementDetails.occurrences >= MIN_ENUMERATION_INSTANCES && elementDetails.values.size() <= elementDetails.occurrences / MIN_ENUMERATION_RATIO && elementDetails.values.size() <= MAX_ENUMERATION_VALUES;
                if (bl9) {
                    this.writeln(String.valueOf(string3) + "<data type=\"integer\"/>");
                } else if (bl10) {
                    this.writeln(String.valueOf(string3) + "<data type=\"decimal\"/>");
                } else if (bl3) {
                    this.writeln(String.valueOf(string3) + "<data type=\"boolean\"/>");
                } else if (bl2) {
                    Iterator iterator3 = elementDetails.values.iterator();
                    bl = true;
                    while (iterator3.hasNext()) {
                        if (bl) {
                            this.writeln(String.valueOf(string3) + "\t<value>" + (String)iterator3.next() + "</value>");
                        } else {
                            this.writeln(String.valueOf(string3) + "\t| <value>" + (String)iterator3.next() + "</value>");
                        }
                        bl = false;
                    }
                } else {
                    this.writeln(String.valueOf(string3) + "<text/>");
                }
            } else if (set.size() > 0 && !elementDetails.hasCharacterContent) {
                if (elementDetails.sequenced) {
                    iterator = elementDetails.childseq.elements();
                    while (iterator.hasMoreElements()) {
                        object2 = (ChildDetails)iterator.nextElement();
                        String string5 = this.getDefineName(((ChildDetails)object2).name);
                        if (!((ChildDetails)object2).repeatable && !((ChildDetails)object2).optional) {
                            this.writeln(String.valueOf(string3) + "<ref name=\"" + string5 + "\"/>");
                        } else if (((ChildDetails)object2).repeatable && !((ChildDetails)object2).optional) {
                            this.writeln(String.valueOf(string3) + "<oneOrMore>");
                            this.writeln(String.valueOf(string3) + "\t<ref name=\"" + string5 + "\"/>");
                            this.writeln(String.valueOf(string3) + "</oneOrMore>");
                        }
                        if (((ChildDetails)object2).repeatable && ((ChildDetails)object2).optional) {
                            this.writeln(String.valueOf(string3) + "<zeroOrMore>");
                            this.writeln(String.valueOf(string3) + "\t<ref name=\"" + string5 + "\"/>");
                            this.writeln(String.valueOf(string3) + "</zeroOrMore>");
                        }
                        if (!((ChildDetails)object2).optional || ((ChildDetails)object2).repeatable) continue;
                        this.writeln(String.valueOf(string3) + "<optional>");
                        this.writeln(String.valueOf(string3) + "\t<ref name=\"" + string5 + "\"/>");
                        this.writeln(String.valueOf(string3) + "</optional>");
                    }
                } else {
                    this.writeln(String.valueOf(string3) + "<zeroOrMore>");
                    this.writeln(String.valueOf(string3) + "\t<choice>");
                    iterator = set.iterator();
                    while (iterator.hasNext()) {
                        object2 = this.getDefineName((String)iterator.next());
                        this.writeln(String.valueOf(string3) + "\t\t<ref name=\"" + (String)object2 + "\"/>");
                    }
                    this.writeln(String.valueOf(string3) + "\t</choice>");
                    this.writeln(String.valueOf(string3) + "</zeroOrMore>");
                }
            } else if (set.size() > 0 && elementDetails.hasCharacterContent) {
                this.writeln(String.valueOf(string3) + "<mixed>");
                this.writeln(String.valueOf(string3) + "\t<zeroOrMore>");
                this.writeln(String.valueOf(string3) + "\t\t<choice>");
                iterator = set.iterator();
                while (iterator.hasNext()) {
                    this.writeln(String.valueOf(string3) + "\t\t\t<ref name=\"" + this.getDefineName((String)iterator.next()) + "\"/>");
                }
                this.writeln(String.valueOf(string3) + "\t\t</choice>");
                this.writeln(String.valueOf(string3) + "\t</zeroOrMore>");
                this.writeln(String.valueOf(string3) + "<mixed>");
            }
            this.writeln("\t\t</element>");
            this.writeln("\t</define>");
        }
        this.writeln("</grammar>");
    }

    public boolean printSchema(Writer writer, String string, String string2) {
        this.fEOL = string;
        this.fWriter = writer;
        try {
            this.internalPrintSchema(string2);
            return true;
        }
        catch (IOException iOException) {
            this.error("Error during printSchema: " + iOException.toString());
            return false;
        }
    }

    private void internalPrintSchema(String string) throws IOException {
        this.write("<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"");
        if (string != null && string.length() > 0) {
            this.writeln();
            this.writeln("           targetNamespace=\"" + string + "\"");
            this.writeln("           xmlns=\"" + string + "\"");
            this.write("           elementFormDefault=\"qualified\"");
        }
        this.writeln(">");
        Iterator iterator = this.elementList.keySet().iterator();
        while (iterator.hasNext()) {
            Object object;
            Iterator iterator2;
            boolean bl;
            String string2 = (String)iterator.next();
            ElementDetails elementDetails = (ElementDetails)this.elementList.get(string2);
            TreeMap treeMap = elementDetails.attributes;
            Set set = treeMap.keySet();
            int n = set.size();
            TreeMap treeMap2 = elementDetails.children;
            Set set2 = treeMap2.keySet();
            int n2 = set2.size();
            int n3 = -1;
            if (n2 == 0 && !elementDetails.hasCharacterContent) {
                this.writeln("\t<xs:element name=\"" + string2 + "\">");
                if (n == 0) {
                    this.writeln("\t\t<xs:complexType/>");
                    this.writeln("\t</xs:element>");
                    n3 = 0;
                } else {
                    this.writeln("\t\t<xs:complexType>");
                    n3 = 2;
                }
            } else if (n2 == 0 && elementDetails.hasCharacterContent) {
                boolean bl2;
                boolean bl3 = elementDetails.allInteger && elementDetails.occurrences >= MIN_ATOMIC_INSTANCES;
                bl = elementDetails.allDecimal && elementDetails.occurrences >= MIN_ATOMIC_INSTANCES;
                boolean bl4 = elementDetails.allBoolean && elementDetails.occurrences >= MIN_ATOMIC_INSTANCES;
                boolean bl5 = bl2 = elementDetails.allNMTOKENs && elementDetails.occurrences >= MIN_ENUMERATION_INSTANCES && elementDetails.values.size() <= elementDetails.occurrences / MIN_ENUMERATION_RATIO && elementDetails.values.size() <= MAX_ENUMERATION_VALUES;
                if (n == 0) {
                    n3 = 0;
                    if (bl3) {
                        this.writeln("\t<xs:element name=\"" + string2 + "\" type=\"xs:integer\"/>");
                    } else if (bl) {
                        this.writeln("\t<xs:element name=\"" + string2 + "\" type=\"xs:decimal\"/>");
                    } else if (bl4) {
                        this.writeln("\t<xs:element name=\"" + string2 + "\" type=\"xs:boolean\"/>");
                    } else if (bl2) {
                        this.writeln("\t<xs:element name=\"" + string2 + "\">");
                        this.writeln("\t\t<xs:simpleType>");
                        this.writeln("\t\t\t<xs:restriction base=\"xs:string\">");
                        iterator2 = elementDetails.values.iterator();
                        while (iterator2.hasNext()) {
                            this.writeln("\t\t\t\t<xs:enumeration value=\"" + (String)iterator2.next() + "\"/>");
                        }
                        this.writeln("\t\t\t</xs:restriction>");
                        this.writeln("\t\t</xs:simpleType>");
                        this.writeln("\t</xs:element>");
                    } else {
                        this.writeln("\t<xs:element name=\"" + string2 + "\" type=\"xs:string\"/>");
                    }
                } else {
                    n3 = 1;
                    if (bl3) {
                        this.writeln("\t<xs:element name=\"" + string2 + "\">");
                        this.writeln("\t\t<xs:complexType>");
                        this.writeln("\t\t\t<xs:simpleContent>");
                        this.writeln("\t\t\t\t<xs:extension base=\"xs:integer\">");
                    } else if (bl) {
                        this.writeln("\t<xs:element name=\"" + string2 + "\">");
                        this.writeln("\t\t<xs:complexType>");
                        this.writeln("\t\t\t<xs:simpleContent>");
                        this.writeln("\t\t\t\t<xs:extension base=\"xs:decimal\">");
                    } else if (bl4) {
                        this.writeln("\t<xs:element name=\"" + string2 + "\">");
                        this.writeln("\t\t<xs:complexType>");
                        this.writeln("\t\t\t<xs:simpleContent>");
                        this.writeln("\t\t\t\t<xs:extension base=\"xs:boolean\">");
                    } else if (bl2) {
                        this.writeln("\t<xs:simpleType name=\"" + string2 + "-type\">");
                        this.writeln("\t\t<xs:restriction base=\"xs:string\">");
                        iterator2 = elementDetails.values.iterator();
                        while (iterator2.hasNext()) {
                            this.writeln("\t\t\t<xs:enumeration value=\"" + (String)iterator2.next() + "\"/>");
                        }
                        this.writeln("\t\t</xs:restriction>");
                        this.writeln("\t</xs:simpleType>");
                        this.writeln("\t<xs:element name=\"" + string2 + "\">");
                        this.writeln("\t\t<xs:complexType>");
                        this.writeln("\t\t\t<xs:simpleContent>");
                        this.writeln("\t\t\t\t<xs:extension base=\"" + string2 + "-type\">");
                    } else {
                        this.writeln("\t<xs:element name=\"" + string2 + "\">");
                        this.writeln("\t\t<xs:complexType>");
                        this.writeln("\t\t\t<xs:simpleContent>");
                        this.writeln("\t\t\t\t<xs:extension base=\"xs:string\">");
                    }
                }
            } else if (n2 > 0 && !elementDetails.hasCharacterContent) {
                this.writeln("\t<xs:element name=\"" + string2 + "\">");
                this.writeln("\t\t<xs:complexType>");
                if (elementDetails.sequenced) {
                    this.writeln("\t\t\t<xs:sequence>");
                    object = elementDetails.childseq.elements();
                    while (object.hasMoreElements()) {
                        ChildDetails childDetails = (ChildDetails)object.nextElement();
                        this.write("\t\t\t\t<xs:element ref=\"" + childDetails.name + "\"");
                        if (childDetails.repeatable && !childDetails.optional) {
                            this.write(" maxOccurs=\"unbounded\"");
                        } else if (childDetails.repeatable && childDetails.optional) {
                            this.write(" minOccurs=\"0\" maxOccurs=\"unbounded\"");
                        } else if (childDetails.optional && !childDetails.repeatable) {
                            this.write(" minOccurs=\"0\"");
                        }
                        this.writeln("/>");
                    }
                    this.writeln("\t\t\t</xs:sequence>");
                } else {
                    this.writeln("\t\t\t<xs:choice minOccurs=\"0\" maxOccurs=\"unbounded\">");
                    object = set2.iterator();
                    while (object.hasNext()) {
                        this.writeln("\t\t\t\t<xs:element ref=\"" + (String)object.next() + "\"/>");
                    }
                    this.writeln("\t\t\t</xs:choice>");
                }
                n3 = 2;
            } else if (n2 > 0 && elementDetails.hasCharacterContent) {
                this.writeln("\t<xs:element name=\"" + string2 + "\">");
                this.writeln("\t\t<xs:complexType mixed=\"true\">");
                this.writeln("\t\t\t<xs:choice minOccurs=\"0\" maxOccurs=\"unbounded\">");
                object = set2.iterator();
                while (object.hasNext()) {
                    this.writeln("\t\t\t\t<xs:element ref=\"" + (String)object.next() + "\"/>");
                }
                this.writeln("\t\t\t</xs:choice>");
                n3 = 2;
            }
            object = "";
            if (n3 == 1) {
                object = "\t\t\t\t\t";
            } else if (n3 == 2) {
                object = "\t\t\t";
            }
            bl = false;
            Iterator iterator3 = set.iterator();
            while (iterator3.hasNext()) {
                Object object2;
                String string3;
                String string4 = (String)iterator3.next();
                iterator2 = (AttributeDetails)treeMap.get(string4);
                boolean bl6 = ((AttributeDetails)((Object)iterator2)).occurrences == elementDetails.occurrences;
                boolean bl7 = bl6 && ((AttributeDetails)((Object)iterator2)).values.size() == 1 && ((AttributeDetails)((Object)iterator2)).occurrences >= MIN_FIXED;
                boolean bl8 = ((AttributeDetails)((Object)iterator2)).allInteger && ((AttributeDetails)((Object)iterator2)).occurrences >= MIN_ATOMIC_INSTANCES;
                boolean bl9 = ((AttributeDetails)((Object)iterator2)).allDecimal && ((AttributeDetails)((Object)iterator2)).occurrences >= MIN_ATOMIC_INSTANCES;
                boolean bl10 = ((AttributeDetails)((Object)iterator2)).allBoolean && ((AttributeDetails)((Object)iterator2)).occurrences >= MIN_ATOMIC_INSTANCES;
                boolean bl11 = ((AttributeDetails)((Object)iterator2)).allNames && !bl && ((AttributeDetails)((Object)iterator2)).unique && ((AttributeDetails)((Object)iterator2)).occurrences >= MIN_ID_VALUES;
                boolean bl12 = ((AttributeDetails)((Object)iterator2)).allNMTOKENs && ((AttributeDetails)((Object)iterator2)).occurrences >= MIN_ENUMERATION_INSTANCES && ((AttributeDetails)((Object)iterator2)).values.size() <= ((AttributeDetails)((Object)iterator2)).occurrences / MIN_ENUMERATION_RATIO && ((AttributeDetails)((Object)iterator2)).values.size() <= MAX_ENUMERATION_VALUES;
                this.write(String.valueOf(object) + "<xs:attribute name=\"" + string4 + "\"");
                String string5 = string3 = ((AttributeDetails)((Object)iterator2)).allNMTOKENs ? "xs:NMTOKEN" : "xs:string";
                if (bl7) {
                    object2 = (String)((AttributeDetails)((Object)iterator2)).values.first();
                    this.write(" type=\"xs:string\" fixed=\"" + XMLDTDGenerator.escape((String)object2) + "\"");
                } else if (bl8) {
                    this.write(" type=\"xs:integer\"");
                } else if (bl9) {
                    this.write(" type=\"xs:decimal\"");
                } else if (bl10) {
                    this.write(" type=\"xs:boolean\"");
                } else if (bl11) {
                    this.write(" type=\"xs:ID\"");
                    bl = true;
                } else if (!bl12) {
                    this.write(" type=\"" + string3 + "\"");
                }
                if (!bl7 && bl6) {
                    this.write(" use=\"required\"");
                }
                if (bl12) {
                    this.writeln(">");
                    this.writeln(String.valueOf(object) + "\t<xs:simpleType>");
                    this.writeln(String.valueOf(object) + "\t\t<xs:restriction base=\"xs:string\">");
                    object2 = ((AttributeDetails)((Object)iterator2)).values.iterator();
                    while (object2.hasNext()) {
                        this.writeln(String.valueOf(object) + "\t\t\t<xs:enumeration value=\"" + (String)object2.next() + "\"/>");
                    }
                    this.writeln(String.valueOf(object) + "\t\t</xs:restriction>");
                    this.writeln(String.valueOf(object) + "\t</xs:simpleType>");
                    this.writeln(String.valueOf(object) + "</xs:attribute>");
                    continue;
                }
                this.writeln("/>");
            }
            switch (n3) {
                case 0: {
                    break;
                }
                case 1: {
                    this.writeln("\t\t\t\t</xs:extension>");
                    this.writeln("\t\t\t</xs:simpleContent>");
                }
                case 2: {
                    this.writeln("\t\t</xs:complexType>");
                    this.writeln("\t</xs:element>");
                }
            }
        }
        this.writeln("</xs:schema>");
    }

    private static int escape(char[] cArray, int n, int n2, char[] cArray2) {
        int n3 = 0;
        int n4 = n;
        while (n4 < n + n2) {
            if (cArray[n4] == '<') {
                "&lt;".getChars(0, 4, cArray2, n3);
                n3 += 4;
            } else if (cArray[n4] == '>') {
                "&gt;".getChars(0, 4, cArray2, n3);
                n3 += 4;
            } else if (cArray[n4] == '&') {
                "&amp;".getChars(0, 5, cArray2, n3);
                n3 += 5;
            } else if (cArray[n4] == '\"') {
                "&#34;".getChars(0, 5, cArray2, n3);
                n3 += 5;
            } else if (cArray[n4] == '\'') {
                "&#39;".getChars(0, 5, cArray2, n3);
                n3 += 5;
            } else if (cArray[n4] <= '\u007f') {
                cArray2[n3++] = cArray[n4];
            } else {
                String string = "&#" + Integer.toString(cArray[n4]) + ';';
                string.getChars(0, string.length(), cArray2, n3);
                n3 += string.length();
            }
            ++n4;
        }
        return n3;
    }

    private static String escape(String string) {
        char[] cArray = new char[string.length() * 8];
        int n = XMLDTDGenerator.escape(string.toCharArray(), 0, string.length(), cArray);
        return new String(cArray, 0, n);
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        Object object;
        StackEntry stackEntry = new StackEntry();
        ElementDetails elementDetails = (ElementDetails)this.elementList.get(string3);
        if (elementDetails == null) {
            elementDetails = new ElementDetails(string3);
            this.elementList.put(string3, elementDetails);
        }
        stackEntry.elementDetails = elementDetails;
        stackEntry.sequenceNumber = -1;
        ++elementDetails.occurrences;
        int n = 0;
        while (n < attributes.getLength()) {
            object = attributes.getQName(n);
            if (this.fDtd || !((String)object).startsWith("xmlns")) {
                String string4 = attributes.getValue(n);
                AttributeDetails attributeDetails = (AttributeDetails)elementDetails.attributes.get(object);
                if (attributeDetails == null) {
                    attributeDetails = new AttributeDetails((String)object);
                    elementDetails.attributes.put(object, attributeDetails);
                }
                if (!attributeDetails.values.contains(string4)) {
                    attributeDetails.values.add(string4);
                    if (attributeDetails.allNames && !this.isValidName(string4)) {
                        attributeDetails.allNames = false;
                    }
                    if (attributeDetails.allNMTOKENs && !this.isValidNMTOKEN(string4)) {
                        attributeDetails.allNMTOKENs = false;
                    }
                    if (attributeDetails.unique && attributeDetails.allNames && attributeDetails.occurrences <= MAX_ID_VALUES) {
                        attributeDetails.values.add(string4);
                    } else if (attributeDetails.values.size() <= MAX_ENUMERATION_VALUES) {
                        attributeDetails.values.add(string4);
                    }
                } else {
                    attributeDetails.unique = false;
                }
                ++attributeDetails.occurrences;
            }
            ++n;
        }
        if (!this.elementStack.isEmpty()) {
            boolean bl;
            StackEntry stackEntry2 = (StackEntry)this.elementStack.peek();
            object = stackEntry2.elementDetails;
            int n2 = stackEntry2.sequenceNumber;
            boolean bl2 = bl = stackEntry2.latestChild == null || !stackEntry2.latestChild.equals(string3);
            if (bl) {
                ++n2;
                ++stackEntry2.sequenceNumber;
            }
            stackEntry2.latestChild = string3;
            TreeMap treeMap = ((ElementDetails)object).children;
            ChildDetails childDetails = (ChildDetails)treeMap.get(string3);
            if (childDetails == null) {
                childDetails = new ChildDetails();
                childDetails.name = string3;
                childDetails.position = n2;
                childDetails.repeatable = false;
                childDetails.optional = false;
                treeMap.put(string3, childDetails);
                ((ElementDetails)object).childseq.addElement(childDetails);
                if (((ElementDetails)object).occurrences != 1) {
                    childDetails.optional = true;
                }
            } else {
                if (((ElementDetails)object).occurrences == 1 && bl) {
                    ((ElementDetails)object).sequenced = false;
                }
                if (((ElementDetails)object).childseq.size() <= n2 || !((ChildDetails)((ElementDetails)object).childseq.elementAt((int)n2)).name.equals(string3)) {
                    ((ElementDetails)object).sequenced = false;
                }
            }
            if (!bl) {
                childDetails.repeatable = true;
            }
        }
        this.elementStack.push(stackEntry);
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        StackEntry stackEntry = (StackEntry)this.elementStack.peek();
        ElementDetails elementDetails = (ElementDetails)this.elementList.get(string3);
        if (elementDetails.sequenced) {
            int n = stackEntry.sequenceNumber;
            int n2 = n + 1;
            while (n2 < elementDetails.childseq.size()) {
                ((ChildDetails)elementDetails.childseq.elementAt((int)n2)).optional = true;
                ++n2;
            }
        }
        if (elementDetails.children.size() == 0 && stackEntry.text != null) {
            String string4 = stackEntry.text.toString().trim();
            if (elementDetails.allBoolean && !this.isValidBoolean(string4)) {
                elementDetails.allBoolean = false;
            }
            if (elementDetails.allInteger) {
                elementDetails.allInteger = this.isValidInteger(string4);
            }
            if (elementDetails.allDecimal) {
                elementDetails.allDecimal = this.isValidDecimal(string4);
            }
            if (elementDetails.allNMTOKENs && !this.isValidNMTOKEN(string4)) {
                elementDetails.allNMTOKENs = false;
                elementDetails.allNames = false;
            } else if (elementDetails.allNames && !XMLCharacter.isIDStart((char)string4.charAt(0))) {
                elementDetails.allNames = false;
            }
            if (elementDetails.unique && elementDetails.values.contains(string4)) {
                elementDetails.unique = false;
            }
            elementDetails.values.add(string4);
        } else {
            elementDetails.allBoolean = false;
            elementDetails.allNames = false;
            elementDetails.allNMTOKENs = false;
            elementDetails.unique = false;
        }
        this.elementStack.pop();
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        StackEntry stackEntry = (StackEntry)this.elementStack.peek();
        ElementDetails elementDetails = stackEntry.elementDetails;
        if (!elementDetails.hasCharacterContent) {
            int n3 = n;
            while (n3 < n + n2) {
                if (cArray[n3] > ' ') {
                    elementDetails.hasCharacterContent = true;
                    break;
                }
                ++n3;
            }
        }
        if (stackEntry.text == null) {
            stackEntry.text = new StringBuffer();
        }
        stackEntry.text.append(cArray, n, n2);
    }

    private static class Namespace {
        String prefix;
        String uri;
        Namespace next;

        Namespace(String string, String string2) {
            this.prefix = string;
            this.uri = string2;
        }

        Namespace(String string, String string2, Namespace namespace) {
            this(string, string2);
            this.next = namespace;
        }
    }

    private class ElementDetails {
        String name;
        int occurrences;
        boolean hasCharacterContent;
        boolean sequenced;
        TreeMap children;
        Vector childseq;
        TreeMap attributes;
        TreeSet values;
        boolean unique;
        boolean allBoolean;
        boolean allNames;
        boolean allNMTOKENs;
        public boolean allDecimal;
        public boolean allInteger;
        public String namespace;

        public ElementDetails(String string) {
            this.name = string;
            this.occurrences = 0;
            this.hasCharacterContent = false;
            this.sequenced = true;
            this.children = new TreeMap();
            this.childseq = new Vector();
            this.attributes = new TreeMap();
            this.unique = true;
            this.allBoolean = true;
            this.values = new TreeSet();
            this.allNames = true;
            this.allNMTOKENs = true;
            this.allInteger = true;
            this.allDecimal = true;
            this.namespace = "";
        }
    }

    private class ChildDetails {
        String name;
        int position;
        boolean repeatable;
        boolean optional;

        ChildDetails() {
        }
    }

    private class AttributeDetails {
        String name;
        int occurrences;
        boolean unique;
        boolean allBoolean;
        TreeSet values;
        boolean allNames;
        boolean allNMTOKENs;
        public boolean allDecimal;
        public boolean allInteger;

        public AttributeDetails(String string) {
            this.name = string;
            this.occurrences = 0;
            this.unique = true;
            this.allBoolean = true;
            this.values = new TreeSet();
            this.allNames = true;
            this.allNMTOKENs = true;
            this.allDecimal = true;
            this.allInteger = true;
        }
    }

    private class StackEntry {
        ElementDetails elementDetails;
        int sequenceNumber;
        String latestChild;
        StringBuffer text;

        StackEntry() {
        }
    }
}

