/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor.partition.scanner;

import com.objfac.util.UnimplementedException;
import com.objfac.xmleditor.XMLDocumentProvider;
import com.objfac.xmleditor.partition.IRuleContainer;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;

public class BufferPartitionScanner
implements ITokenScanner,
ICharacterScanner {
    IRuleContainer fBaseScanner;
    private char[] fBuf;
    private int fPos;
    private int fEnd;
    private Token fToken;
    private Token fDefaultToken;
    private int fLin;
    private int[] fLineStarts = new int[1];
    private int fLength;
    protected int fOffset;
    private IRule[] fRules;

    public BufferPartitionScanner() {
        this.fBaseScanner = XMLDocumentProvider.getXMLPartitionScanner();
        this.fRules = this.fBaseScanner.getRules();
    }

    protected BufferPartitionScanner(IRuleContainer iRuleContainer) {
        this.fBaseScanner = iRuleContainer;
        this.fRules = this.fBaseScanner.getRules();
    }

    public void setRange(char[] cArray) {
        this.fBuf = cArray;
        this.fPos = 0;
        this.fEnd = cArray.length;
        this.fLin = 0;
        this.fDefaultToken = new Token(null);
    }

    public int getTokenLength() {
        return this.fPos - this.fOffset;
    }

    public int getTokenOffset() {
        return this.fOffset;
    }

    public IToken nextToken() {
        this.fOffset = this.fPos;
        int n = 0;
        while (n < this.fRules.length) {
            IToken iToken = this.fRules[n].evaluate((ICharacterScanner)this);
            if (!iToken.isUndefined()) {
                return iToken;
            }
            ++n;
        }
        if (this.read() == -1) {
            return Token.EOF;
        }
        return this.fDefaultToken;
    }

    public void setRange(IDocument iDocument, int n, int n2) {
        throw new UnimplementedException();
    }

    public int getColumn() {
        return this.fPos - this.fLineStarts[this.fLin];
    }

    public int getLine() {
        return this.fLin;
    }

    public char[][] getLegalLineDelimiters() {
        return null;
    }

    public int read() {
        char c;
        if (this.fPos >= this.fEnd) {
            if (this.fPos == this.fEnd) {
                ++this.fPos;
            }
            return -1;
        }
        if ((c = this.fBuf[this.fPos++]) == '\r' && this.fPos < this.fEnd && this.fBuf[this.fPos] == '\n') {
            c = this.fBuf[this.fPos++];
        }
        if (c == '\r' || c == '\n') {
            ++this.fLin;
            this.setLineStart();
        }
        return c;
    }

    public void unread() {
        if (this.fPos == 0) {
            throw new IllegalStateException("attempt to unread past start");
        }
        --this.fPos;
        if (this.fPos > 0 && this.fPos < this.fEnd) {
            char c = this.fBuf[this.fPos];
            if (c == '\n' && this.fBuf[this.fPos - 1] == '\r') {
                --this.fPos;
            }
            if (c == '\r' || c == '\n') {
                --this.fLin;
            }
        }
    }

    private void setLineStart() {
        int n = this.fLineStarts.length;
        if (this.fLin >= n) {
            int[] nArray = new int[n * 2];
            System.arraycopy(this.fLineStarts, 0, nArray, 0, n);
            this.fLineStarts = nArray;
        }
        this.fLineStarts[this.fLin] = this.fPos;
    }
}

