/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor.preferences;

import com.objfac.util.Local;
import com.objfac.xmleditor.XMLPlugin;
import com.objfac.xmleditor.preferences.ValidatingPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class XMLAssistPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private boolean fInitialAutoFillEndTag;
    private boolean fInitialAutoRemoveEndTag;
    private boolean fInitialAutoInsertEndTag;
    private Button fAutoInsertEndTag;
    private Button fAutoRemoveEndTag;
    private Button fAutoFillEndTag;
    private Label fDelayLabel;
    private boolean fInitialAutoInsert;
    private Button fAutoInsert;
    private Button fAutoAssist;
    private Text fDelay;
    private int fInitialDelay;
    private boolean fInitialAutoAssist;
    private int fInitialMargin;

    public XMLAssistPreferencePage() {
    }

    public XMLAssistPreferencePage(String string) {
        super(string);
    }

    public XMLAssistPreferencePage(String string, ImageDescriptor imageDescriptor) {
        super(string, imageDescriptor);
    }

    protected Control createContents(Composite composite) {
        this.getPreferenceStore();
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 5;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        this.fAutoAssist = new Button(composite2, 16416);
        this.fAutoAssist.setText(Local.getString((String)"Enable auto-assist"));
        Object object = new GridData();
        object.horizontalAlignment = 1;
        object.horizontalSpan = 2;
        this.fAutoAssist.setLayoutData(object);
        this.fDelayLabel = new Label(composite2, 16384);
        this.fDelayLabel.setText(Local.getString((String)"Delay in milliseconds:"));
        object = new GridData();
        object.verticalAlignment = 2;
        object.horizontalIndent = 16;
        this.fDelayLabel.setLayoutData(object);
        this.fDelay = new Text(composite2, 18436);
        object = new GridData();
        object.horizontalAlignment = 1;
        object.widthHint = 25;
        this.fDelay.setLayoutData(object);
        ValidatingPreferencePage.insertSpacer(composite2, 2);
        this.fAutoInsert = new Button(composite2, 16416);
        this.fAutoInsert.setText(Local.getString((String)"Enable auto-completion if only one choice"));
        object = new GridData();
        object.horizontalAlignment = 1;
        object.horizontalSpan = 2;
        this.fAutoInsert.setLayoutData(object);
        ValidatingPreferencePage.insertSpacer(composite2, 2);
        this.fAutoInsertEndTag = new Button(composite2, 16416);
        this.fAutoInsertEndTag.setText(Local.getString((String)"Automatically insert missing end tag"));
        object = new GridData();
        object.horizontalAlignment = 1;
        object.horizontalSpan = 2;
        this.fAutoInsertEndTag.setLayoutData(object);
        this.fAutoRemoveEndTag = new Button(composite2, 16416);
        this.fAutoRemoveEndTag.setText(Local.getString((String)"Automatically remove extra end tag"));
        object = new GridData();
        object.horizontalAlignment = 1;
        object.horizontalSpan = 2;
        this.fAutoRemoveEndTag.setLayoutData(object);
        this.fAutoFillEndTag = new Button(composite2, 16416);
        this.fAutoFillEndTag.setText(Local.getString((String)"Automatically fill end tag name after </"));
        object = new GridData();
        object.horizontalAlignment = 1;
        object.horizontalSpan = 2;
        this.fAutoFillEndTag.setLayoutData(object);
        composite2.setTabList(new Control[]{this.fDelay, this.fAutoAssist, this.fAutoInsert, this.fAutoInsertEndTag, this.fAutoRemoveEndTag, this.fAutoFillEndTag});
        this.initControls();
        object = new WidthListener();
        this.fDelay.addModifyListener((ModifyListener)object);
        this.fAutoAssist.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                XMLAssistPreferencePage.this.validate();
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        this.validate();
        this.setMessages(null, null);
        return composite2;
    }

    public void setMessages(String string, String string2) {
        this.setErrorMessage(string);
        this.setMessage(string2);
        this.setValid(string == null);
    }

    private void validate() {
        this.setMessages(null, null);
        boolean bl = this.fAutoAssist.getSelection();
        this.fDelayLabel.setEnabled(bl);
        this.fDelay.setEnabled(bl);
        String string = this.fDelay.getText();
        if (bl && (string == null || string.length() == 0)) {
            this.setMessages(Local.getString((String)"Must specify delay (suggest 500)"), null);
        } else if (bl) {
            boolean bl2 = true;
            int n = 0;
            int n2 = string.length();
            while (n < n2) {
                char c = string.charAt(n);
                if (c < '0' || c > '9') {
                    bl2 = false;
                    break;
                }
                ++n;
            }
            if (!bl2) {
                this.setMessages(Local.getString((String)"Only numbers >= 0 allowed"), null);
            } else {
                try {
                    n = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    n = 0;
                }
                if (n < 0) {
                    this.setMessages(Local.getString((String)"Only numbers >= 0 allowed"), null);
                }
            }
        }
    }

    private void initControls() {
        this.fDelay.setText(Integer.toString(this.fInitialDelay));
        this.fDelay.setSelection(0, this.fDelay.getText().length());
        this.fAutoAssist.setSelection(this.fInitialAutoAssist);
        this.fAutoInsert.setSelection(this.fInitialAutoInsert);
        this.fAutoInsertEndTag.setSelection(this.fInitialAutoInsertEndTag);
        this.fAutoRemoveEndTag.setSelection(this.fInitialAutoRemoveEndTag);
        this.fAutoFillEndTag.setSelection(this.fInitialAutoFillEndTag);
    }

    private void defaultControls() {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        int n = iPreferenceStore.getDefaultInt("com.objfac.xmleditor.assistdelay");
        this.fDelay.setText(Integer.toString(n));
        this.fDelay.setSelection(0, this.fDelay.getText().length());
        this.fAutoAssist.setSelection(iPreferenceStore.getDefaultBoolean("com.objfac.xmleditor.autoassist"));
        this.fAutoInsert.setSelection(iPreferenceStore.getDefaultBoolean("com.objfac.xmleditor.autoinsert"));
        this.fAutoInsertEndTag.setSelection(iPreferenceStore.getDefaultBoolean("com.objfac.xmleditor.insertendtag"));
        this.fAutoRemoveEndTag.setSelection(iPreferenceStore.getDefaultBoolean("com.objfac.xmleditor.removeendtag"));
        this.fAutoFillEndTag.setSelection(iPreferenceStore.getDefaultBoolean("com.objfac.xmleditor.fillendtag"));
    }

    public void init(IWorkbench iWorkbench) {
        this.setPreferenceStore(XMLPlugin.getDefault().getPreferenceStore());
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        this.fInitialDelay = iPreferenceStore.getInt("com.objfac.xmleditor.assistdelay");
        this.fInitialAutoAssist = iPreferenceStore.getBoolean("com.objfac.xmleditor.autoassist");
        this.fInitialAutoInsert = iPreferenceStore.getBoolean("com.objfac.xmleditor.autoinsert");
        this.fInitialAutoInsertEndTag = iPreferenceStore.getBoolean("com.objfac.xmleditor.insertendtag");
        this.fInitialAutoRemoveEndTag = iPreferenceStore.getBoolean("com.objfac.xmleditor.removeendtag");
        this.fInitialAutoFillEndTag = iPreferenceStore.getBoolean("com.objfac.xmleditor.fillendtag");
    }

    public boolean performOk() {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        String string = this.fDelay.getText();
        int n = Integer.parseInt(string);
        iPreferenceStore.setValue("com.objfac.xmleditor.assistdelay", n);
        boolean bl = this.fAutoAssist.getSelection();
        iPreferenceStore.setValue("com.objfac.xmleditor.autoassist", bl);
        boolean bl2 = this.fAutoInsert.getSelection();
        iPreferenceStore.setValue("com.objfac.xmleditor.autoinsert", bl2);
        boolean bl3 = this.fAutoInsertEndTag.getSelection();
        iPreferenceStore.setValue("com.objfac.xmleditor.insertendtag", bl3);
        boolean bl4 = this.fAutoRemoveEndTag.getSelection();
        iPreferenceStore.setValue("com.objfac.xmleditor.removeendtag", bl4);
        boolean bl5 = this.fAutoFillEndTag.getSelection();
        iPreferenceStore.setValue("com.objfac.xmleditor.fillendtag", bl5);
        return super.performOk();
    }

    protected void performApply() {
    }

    protected void performDefaults() {
        this.defaultControls();
        super.performDefaults();
    }

    public boolean performCancel() {
        this.initControls();
        return super.performCancel();
    }

    private class WidthListener
    implements ModifyListener {
        WidthListener() {
        }

        public void modifyText(ModifyEvent modifyEvent) {
            XMLAssistPreferencePage.this.validate();
        }
    }
}

