/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor.preferences;

import com.objfac.util.Local;
import com.objfac.xmleditor.actions.ActionUtils;
import com.objfac.xmleditor.preferences.ValidatingPreferencePage;
import com.objfac.xmleditor.preferences.XMLSchemaSettings;
import com.objfac.xmleditor.wizards.WizardUtils;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class XMLBaseNRLPreferencePage
extends ValidatingPreferencePage {
    private String fType;
    private XMLSchemaSettings fXMLSchemaSettings;
    private Button fBoth;
    private Button fNever;
    private Table fTable;
    private int fNumTableRows;
    private boolean fEditing = false;
    private Button fNewButton;
    private Button fEditButton;
    private Button fRemoveButton;
    private String fRoot;
    private String fPub;
    private String fSys;
    private String fPrefix;
    private TableRow[] fTableRows;

    public XMLBaseNRLPreferencePage(String string, String string2) {
        this.init(string, string2);
    }

    public XMLBaseNRLPreferencePage(String string, String string2, String string3) {
        super(string3);
        this.init(string, string2);
    }

    public XMLBaseNRLPreferencePage(String string, String string2, String string3, ImageDescriptor imageDescriptor) {
        super(string3, imageDescriptor);
        this.init(string, string2);
    }

    private void init(String string, String string2) {
        this.fXMLSchemaSettings = new XMLSchemaSettings(string);
        this.fType = string2;
    }

    protected void validate() {
        boolean bl = this.fBoth.getSelection();
        boolean bl2 = bl && this.fTable.getSelectionCount() > 0;
        this.fTable.setEnabled(bl);
        this.fNewButton.setEnabled(bl);
        this.fEditButton.setEnabled(bl2);
        this.fRemoveButton.setEnabled(bl2);
    }

    protected void performDefaults() {
        String string = this.fXMLSchemaSettings.getDefaultMatch();
        if (string != "no") {
            string = "rootorns";
        }
        this.fBoth.setSelection(string.equals("rootorns"));
        this.fNever.setSelection(string.equals("no"));
        TableItem[] tableItemArray = this.fTable.getItems();
        int n = 0;
        while (n < tableItemArray.length) {
            tableItemArray[n].dispose();
            ++n;
        }
        ArrayList arrayList = this.fXMLSchemaSettings.getDefaultMatchRows();
        this.fillTable(arrayList);
        super.performDefaults();
    }

    public boolean performOk() {
        this.fXMLSchemaSettings.setMatch(this.fNever.getSelection() ? "no" : "rootorns");
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        int n = 0;
        while (n < this.fTableRows.length) {
            TableRow tableRow = this.fTableRows[n];
            String[] stringArray = new String[]{tableRow.rootName, tableRow.namespace, tableRow.schemaLocation};
            if (tableRow.prefix.length() > 0) {
                stringArray[0] = "$" + tableRow.prefix;
            }
            arrayList.add(stringArray);
            ++n;
        }
        this.fXMLSchemaSettings.setMatchRows(arrayList);
        return super.performOk();
    }

    protected void performApply() {
    }

    protected Control createContents(Composite composite) {
        ActionUtils.isActionable();
        Composite composite2 = new Composite(composite, 0);
        Object object = new GridLayout();
        ((GridLayout)object).numColumns = 1;
        composite2.setLayout((Layout)object);
        composite2.setLayoutData((Object)new GridData());
        object = new Label(composite2, 16384);
        object.setText(Local.format((String)"Assume {0}...", (Object)this.fType));
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        object.setLayoutData((Object)gridData);
        object = this.fXMLSchemaSettings.getMatch();
        if (object != "no") {
            object = "rootorns";
        }
        this.fNever = new Button(composite2, 16400);
        this.fNever.setText(Local.getString((String)"Never"));
        this.fNever.setSelection(((String)object).equals("no"));
        gridData = new GridData();
        gridData.horizontalAlignment = 1;
        gridData.horizontalIndent = 10;
        this.fNever.setLayoutData((Object)gridData);
        this.fBoth = new Button(composite2, 16400);
        this.fBoth.setText(Local.getString((String)"Root name or namespace match table"));
        this.fBoth.setSelection(((String)object).equals("rootorns"));
        gridData = new GridData();
        gridData.horizontalAlignment = 1;
        gridData.horizontalIndent = 10;
        this.fBoth.setLayoutData((Object)gridData);
        gridData = new Composite(composite2, 16384);
        GridData gridData2 = new GridData(1808);
        gridData.setLayoutData((Object)gridData2);
        Object object2 = new GridLayout();
        object2.numColumns = 2;
        gridData.setLayout((Layout)object2);
        this.fTable = new Table((Composite)gridData, 84740);
        this.fTable.setLinesVisible(true);
        this.fTable.setHeaderVisible(true);
        gridData2 = new GridData(1808);
        gridData2.horizontalIndent = 10;
        this.fTable.setLayoutData((Object)gridData2);
        object2 = new TableLayout();
        ColumnWeightData columnWeightData = new ColumnWeightData(1, 50);
        object2.addColumnData((ColumnLayoutData)columnWeightData);
        ColumnWeightData columnWeightData2 = new ColumnWeightData(2, 100);
        object2.addColumnData((ColumnLayoutData)columnWeightData2);
        ColumnWeightData columnWeightData3 = new ColumnWeightData(2, 100);
        object2.addColumnData((ColumnLayoutData)columnWeightData3);
        this.fTable.setLayout((Layout)object2);
        TableColumn tableColumn = new TableColumn(this.fTable, 0);
        tableColumn.setText(Local.getString((String)"Root"));
        TableColumn tableColumn2 = new TableColumn(this.fTable, 0);
        tableColumn2.setText(Local.getString((String)"Namespace"));
        TableColumn tableColumn3 = new TableColumn(this.fTable, 0);
        tableColumn3.setText(Local.getString((String)"Schema Location"));
        ArrayList arrayList = this.fXMLSchemaSettings.getMatchRows();
        this.fillTable(arrayList);
        this.fTable.addSelectionListener((SelectionListener)this.getMultiplexListener());
        gridData2 = new Composite((Composite)gridData, 16384);
        object2 = new GridData();
        object2.horizontalAlignment = 1;
        object2.verticalAlignment = 1;
        object2.horizontalIndent = 5;
        gridData2.setLayoutData(object2);
        columnWeightData = new RowLayout(512);
        columnWeightData.marginTop = 0;
        columnWeightData.marginBottom = 6;
        columnWeightData.pack = false;
        gridData2.setLayout((Layout)columnWeightData);
        this.fNewButton = new Button((Composite)gridData2, 0x1000000);
        this.fNewButton.setText(Local.getString((String)"New..."));
        this.fEditButton = new Button((Composite)gridData2, 0x1000000);
        this.fEditButton.setText(Local.getString((String)"Edit..."));
        this.fRemoveButton = new Button((Composite)gridData2, 0x1000000);
        this.fRemoveButton.setText(Local.getString((String)"Remove"));
        this.fBoth.addSelectionListener((SelectionListener)this.getMultiplexListener());
        this.fNever.addSelectionListener((SelectionListener)this.getMultiplexListener());
        this.fTable.addSelectionListener((SelectionListener)this.getMultiplexListener());
        object2 = new ButtonListener();
        this.fNewButton.addSelectionListener((SelectionListener)object2);
        this.fEditButton.addSelectionListener((SelectionListener)object2);
        this.fRemoveButton.addSelectionListener((SelectionListener)object2);
        this.validate();
        return composite2;
    }

    private void fillTable(ArrayList arrayList) {
        Object object;
        TableRow tableRow;
        this.fNumTableRows = arrayList.size();
        this.fTableRows = new TableRow[this.fNumTableRows];
        Iterator iterator = arrayList.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            this.fTableRows[n] = tableRow = new TableRow();
            object = (String[])iterator.next();
            if (object[0].startsWith("$")) {
                tableRow.prefix = object[0].substring(1);
            } else {
                tableRow.rootName = object[0];
            }
            tableRow.namespace = object[1];
            tableRow.schemaLocation = object[2];
            ++n;
        }
        n = 0;
        while (n < this.fTableRows.length) {
            tableRow = new TableItem(this.fTable, 0);
            object = this.fTableRows[n];
            tableRow.setText(0, object.rootName);
            tableRow.setText(1, object.namespace);
            tableRow.setText(2, object.schemaLocation);
            ++n;
        }
    }

    private void buttonClicked(Button button) {
        int n;
        if (button == this.fNewButton) {
            RowDialog rowDialog = new RowDialog(this.getShell(), "", "", "", "");
            if (rowDialog.open() == 0) {
                this.addTableRow(this.fRoot, this.fPub, this.fSys, this.fPrefix);
            }
        } else if (button == this.fEditButton) {
            int n2 = this.fTable.getSelectionIndex();
            if (n2 >= 0) {
                TableRow tableRow = this.fTableRows[n2];
                RowDialog rowDialog = new RowDialog(this.getShell(), tableRow.rootName, tableRow.namespace, tableRow.schemaLocation, tableRow.prefix);
                if (rowDialog.open() == 0) {
                    this.setTableRow(n2, this.fRoot, this.fPub, this.fSys, this.fPrefix);
                }
            }
        } else if (button == this.fRemoveButton && (n = this.fTable.getSelectionIndex()) >= 0) {
            this.removeTableRow(n);
        }
    }

    private void removeTableRow(int n) {
        TableItem tableItem = this.fTable.getItem(n);
        tableItem.dispose();
        int cfr_ignored_0 = this.fNumTableRows - 1;
        TableRow[] tableRowArray = new TableRow[--this.fNumTableRows];
        System.arraycopy(this.fTableRows, 0, tableRowArray, 0, n);
        System.arraycopy(this.fTableRows, n + 1, tableRowArray, n, this.fNumTableRows - n);
        this.fTableRows = tableRowArray;
    }

    private void setTableRow(int n, String string, String string2, String string3, String string4) {
        TableItem tableItem = this.fTable.getItem(n);
        tableItem.setText(0, string);
        tableItem.setText(1, string2);
        tableItem.setText(2, string3);
        TableRow tableRow = this.fTableRows[n];
        tableRow.rootName = string;
        tableRow.namespace = string2;
        tableRow.schemaLocation = string3;
        tableRow.prefix = string4;
    }

    private void addTableRow(String string, String string2, String string3, String string4) {
        TableItem tableItem = new TableItem(this.fTable, 0);
        tableItem.setText(0, string);
        tableItem.setText(1, string2);
        tableItem.setText(2, string3);
        TableRow[] tableRowArray = new TableRow[this.fNumTableRows + 1];
        System.arraycopy(this.fTableRows, 0, tableRowArray, 0, this.fNumTableRows);
        TableRow tableRow = new TableRow();
        tableRow.rootName = string;
        tableRow.namespace = string2;
        tableRow.schemaLocation = string3;
        tableRow.prefix = string4;
        tableRowArray[this.fNumTableRows++] = tableRow;
        this.fTableRows = tableRowArray;
    }

    private static class TableRow {
        public String rootName = "";
        public String namespace = "";
        public String schemaLocation = "";
        public String prefix = "";

        TableRow() {
        }
    }

    private class ButtonListener
    implements SelectionListener {
        ButtonListener() {
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            XMLBaseNRLPreferencePage.this.buttonClicked((Button)selectionEvent.widget);
        }
    }

    private class RowDialog
    extends Dialog {
        private Text fPrefixText;
        private Text fRootText;
        private Text fPubText;
        private Text fSysText;
        private String fMsg = "";
        private Label fMsgLabel;

        public RowDialog(Shell shell, String string, String string2, String string3, String string4) {
            super(shell);
            XMLBaseNRLPreferencePage.this.fRoot = string;
            XMLBaseNRLPreferencePage.this.fPub = string2;
            XMLBaseNRLPreferencePage.this.fSys = string3;
            XMLBaseNRLPreferencePage.this.fPrefix = string4;
        }

        protected Control createDialogArea(Composite composite) {
            Composite composite2 = (Composite)super.createDialogArea(composite);
            String string = XMLBaseNRLPreferencePage.this.fRoot.length() == 0 ? Local.getString((String)"New Default Schema") : Local.getString((String)"Edit Default Schema");
            composite.getShell().setText(string);
            Composite composite3 = new Composite(composite2, 0);
            composite3.setLayout((Layout)new GridLayout(3, false));
            this.fMsgLabel = new Label(composite3, 16384);
            GridData gridData = new GridData(769);
            gridData.horizontalSpan = 3;
            gridData.widthHint = 300;
            this.fMsgLabel.setLayoutData((Object)gridData);
            XMLBaseNRLPreferencePage.insertSpacer(composite3, 3);
            gridData = new Label(composite3, 16384);
            gridData.setText(Local.getString((String)"Root name:"));
            gridData.setLayoutData((Object)new GridData());
            this.fRootText = new Text(composite3, 18436);
            this.fRootText.setText(XMLBaseNRLPreferencePage.this.fRoot);
            this.fRootText.setSelection(0, XMLBaseNRLPreferencePage.this.fRoot.length());
            GridData gridData2 = new GridData(768);
            gridData2.horizontalSpan = 2;
            this.fRootText.setLayoutData((Object)gridData2);
            gridData2 = new Label(composite3, 16384);
            gridData2.setText(Local.getString((String)"Namespace:"));
            gridData2.setLayoutData((Object)new GridData());
            this.fPubText = new Text(composite3, 18436);
            this.fPubText.setText(XMLBaseNRLPreferencePage.this.fPub);
            this.fPubText.setSelection(0, XMLBaseNRLPreferencePage.this.fPub.length());
            GridData gridData3 = new GridData(768);
            gridData3.horizontalSpan = 2;
            this.fPubText.setLayoutData((Object)gridData3);
            gridData3 = new Label(composite3, 16384);
            gridData3.setText(Local.getString((String)"Schema location:"));
            gridData3.setLayoutData((Object)new GridData());
            this.fSysText = new Text(composite3, 18436);
            this.fSysText.setText(XMLBaseNRLPreferencePage.this.fSys);
            this.fSysText.setSelection(0, XMLBaseNRLPreferencePage.this.fSys.length());
            GridData gridData4 = new GridData();
            gridData4.widthHint = 300;
            this.fSysText.setLayoutData((Object)gridData4);
            gridData4 = new Button(composite3, 8);
            gridData4.setText(Local.getString((String)"Browse"));
            gridData4.setLayoutData((Object)new GridData());
            gridData4.addSelectionListener((SelectionListener)new WizardUtils.BrowseButtonListener(this.fSysText, this.getShell(), true));
            Label label = new Label(composite3, 16384);
            label.setText(Local.getString((String)"Default prefix:"));
            label.setLayoutData((Object)new GridData());
            this.fPrefixText = new Text(composite3, 18436);
            this.fPrefixText.setText(XMLBaseNRLPreferencePage.this.fPrefix);
            this.fPrefixText.setSelection(0, XMLBaseNRLPreferencePage.this.fPrefix.length());
            Object object = new GridData();
            object.horizontalSpan = 2;
            object.widthHint = 40;
            this.fPrefixText.setLayoutData(object);
            object = new LocalModifyListener();
            this.fRootText.addModifyListener((ModifyListener)object);
            this.fPubText.addModifyListener((ModifyListener)object);
            this.fSysText.addModifyListener((ModifyListener)object);
            this.fPrefixText.addModifyListener((ModifyListener)object);
            composite3.setTabList(new Control[]{this.fRootText, this.fPubText, this.fSysText, this.fPrefixText});
            return composite2;
        }

        protected Control createContents(Composite composite) {
            Control control = super.createContents(composite);
            this.validate();
            return control;
        }

        private void validate() {
            String string = this.fMsg;
            this.fMsg = "";
            String string2 = this.fRootText.getText().trim();
            String string3 = this.fPubText.getText().trim();
            String string4 = this.fSysText.getText().trim();
            String string5 = this.fPrefixText.getText().trim();
            boolean bl = string2.length() > 0;
            boolean bl2 = string3.length() > 0;
            boolean bl3 = string4.length() > 0;
            boolean bl4 = string5.length() > 0;
            this.fRootText.setEnabled(!bl2);
            this.fPubText.setEnabled(bl2 || !bl);
            this.fPrefixText.setEnabled(bl2);
            XMLBaseNRLPreferencePage.this.fRoot = !bl2 ? string2 : "";
            XMLBaseNRLPreferencePage.this.fPub = bl2 || !bl ? string3 : "";
            XMLBaseNRLPreferencePage.this.fSys = string4;
            XMLBaseNRLPreferencePage.this.fPrefix = bl2 ? string5 : "";
            if (!bl && !bl2) {
                this.fMsg = Local.getString((String)"Root name or namespace must be specified");
            } else if (!bl3) {
                this.fMsg = Local.getString((String)"Schema location must be specified");
            }
            Button button = this.getButton(0);
            button.setEnabled(this.fMsg.length() == 0);
            if (!string.equals(this.fMsg)) {
                this.fMsgLabel.setText(this.fMsg);
            }
        }

        private boolean isEmpty(String string) {
            int n = string.length();
            if (n == 0) {
                return true;
            }
            int n2 = 0;
            while (n2 < n) {
                char c = string.charAt(n2);
                if (c > ' ') {
                    return false;
                }
                ++n2;
            }
            return true;
        }

        private class LocalModifyListener
        implements ModifyListener {
            LocalModifyListener() {
            }

            public void modifyText(ModifyEvent modifyEvent) {
                RowDialog.this.validate();
            }
        }
    }
}

