/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor.preferences;

import com.objfac.util.Local;
import com.objfac.xmleditor.actions.ActionUtils;
import com.objfac.xmleditor.preferences.ValidatingPreferencePage;
import com.objfac.xmleditor.preferences.XMLSchemaSettings;
import com.objfac.xmleditor.wizards.WizardUtils;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class XMLBasePreferencePage
extends ValidatingPreferencePage {
    private String fType;
    private XMLSchemaSettings fXMLSchemaSettings;
    private Button fName;
    private Button fNs;
    private Button fBoth;
    private Button fNever;
    private Table fTable;
    private int fTableRows;
    private boolean fEditing = false;
    private Button fNewButton;
    private Button fEditButton;
    private Button fRemoveButton;
    private String fRoot;
    private String fPub;
    private String fSys;
    private static final String[] fMatches = new String[]{"no", "root", "ns", "rootandns"};

    public XMLBasePreferencePage(String string, String string2) {
        this.init(string, string2);
    }

    public XMLBasePreferencePage(String string, String string2, String string3) {
        super(string3);
        this.init(string, string2);
    }

    public XMLBasePreferencePage(String string, String string2, String string3, ImageDescriptor imageDescriptor) {
        super(string3, imageDescriptor);
        this.init(string, string2);
    }

    private void init(String string, String string2) {
        this.fXMLSchemaSettings = new XMLSchemaSettings(string);
        this.fType = string2;
    }

    protected void validate() {
        boolean bl = this.fName.getSelection();
        boolean bl2 = this.fNs.getSelection();
        boolean bl3 = this.fBoth.getSelection();
        boolean bl4 = bl || bl2 || bl3;
        boolean bl5 = bl4 && this.fTable.getSelectionCount() > 0;
        this.fTable.setEnabled(bl4);
        this.fNewButton.setEnabled(bl4);
        this.fEditButton.setEnabled(bl4 && bl5);
        this.fRemoveButton.setEnabled(bl4 && bl5);
    }

    protected void performDefaults() {
        String string = this.fXMLSchemaSettings.getDefaultMatch();
        this.fName.setSelection(string.equals("root"));
        this.fNs.setSelection(string.equals("ns"));
        this.fBoth.setSelection(string.equals("rootandns"));
        this.fNever.setSelection(string.equals("no"));
        TableItem[] tableItemArray = this.fTable.getItems();
        int n = 0;
        while (n < tableItemArray.length) {
            tableItemArray[n].dispose();
            ++n;
        }
        ArrayList arrayList = this.fXMLSchemaSettings.getDefaultMatchRows();
        this.fillTable(arrayList);
        super.performDefaults();
    }

    public boolean performOk() {
        int n = (this.fName.getSelection() ? 1 : 0) + (this.fNs.getSelection() ? 2 : 0) + (this.fBoth.getSelection() ? 3 : 0);
        this.fXMLSchemaSettings.setMatch(fMatches[n]);
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        TableItem[] tableItemArray = this.fTable.getItems();
        int n2 = 0;
        while (n2 < tableItemArray.length) {
            TableItem tableItem = tableItemArray[n2];
            String[] stringArray = new String[3];
            int n3 = 0;
            while (n3 < stringArray.length) {
                stringArray[n3] = tableItem.getText(n3);
                ++n3;
            }
            arrayList.add(stringArray);
            ++n2;
        }
        this.fXMLSchemaSettings.setMatchRows(arrayList);
        return super.performOk();
    }

    protected void performApply() {
    }

    protected Control createContents(Composite composite) {
        ActionUtils.isActionable();
        Composite composite2 = new Composite(composite, 0);
        Object object = new GridLayout();
        ((GridLayout)object).numColumns = 1;
        composite2.setLayout((Layout)object);
        composite2.setLayoutData((Object)new GridData());
        object = new Label(composite2, 16384);
        object.setText(Local.format((String)"Assume {0} if...", (Object)this.fType));
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        object.setLayoutData((Object)gridData);
        object = this.fXMLSchemaSettings.getMatch();
        this.fName = new Button(composite2, 16400);
        this.fName.setText(Local.getString((String)"Root name matches table"));
        this.fName.setSelection(((String)object).equals("root"));
        gridData = new GridData();
        gridData.horizontalAlignment = 1;
        gridData.horizontalIndent = 10;
        this.fName.setLayoutData((Object)gridData);
        this.fNs = new Button(composite2, 16400);
        this.fNs.setText(Local.getString((String)"Root namespace matches table"));
        this.fNs.setSelection(((String)object).equals("ns"));
        gridData = new GridData();
        gridData.horizontalAlignment = 1;
        gridData.horizontalIndent = 10;
        this.fNs.setLayoutData((Object)gridData);
        this.fBoth = new Button(composite2, 16400);
        this.fBoth.setText(Local.getString((String)"Root name and namespace match table"));
        this.fBoth.setSelection(((String)object).equals("rootandns"));
        gridData = new GridData();
        gridData.horizontalAlignment = 1;
        gridData.horizontalIndent = 10;
        this.fBoth.setLayoutData((Object)gridData);
        this.fNever = new Button(composite2, 16400);
        this.fNever.setText(Local.getString((String)"Never"));
        this.fNever.setSelection(((String)object).equals("no"));
        gridData = new GridData();
        gridData.horizontalAlignment = 1;
        gridData.horizontalIndent = 10;
        this.fNever.setLayoutData((Object)gridData);
        gridData = new Composite(composite2, 16384);
        GridData gridData2 = new GridData(1808);
        gridData.setLayoutData((Object)gridData2);
        Object object2 = new GridLayout();
        object2.numColumns = 2;
        gridData.setLayout((Layout)object2);
        this.fTable = new Table((Composite)gridData, 84740);
        this.fTable.setLinesVisible(true);
        this.fTable.setHeaderVisible(true);
        gridData2 = new GridData(1808);
        gridData2.horizontalIndent = 10;
        this.fTable.setLayoutData((Object)gridData2);
        object2 = new TableLayout();
        ColumnWeightData columnWeightData = new ColumnWeightData(1, 50);
        object2.addColumnData((ColumnLayoutData)columnWeightData);
        ColumnWeightData columnWeightData2 = new ColumnWeightData(2, 100);
        object2.addColumnData((ColumnLayoutData)columnWeightData2);
        ColumnWeightData columnWeightData3 = new ColumnWeightData(2, 100);
        object2.addColumnData((ColumnLayoutData)columnWeightData3);
        this.fTable.setLayout((Layout)object2);
        TableColumn tableColumn = new TableColumn(this.fTable, 0);
        tableColumn.setText(Local.getString((String)"Root"));
        TableColumn tableColumn2 = new TableColumn(this.fTable, 0);
        tableColumn2.setText(Local.getString((String)"Namespace"));
        TableColumn tableColumn3 = new TableColumn(this.fTable, 0);
        tableColumn3.setText(Local.getString((String)"Schema Location"));
        ArrayList arrayList = this.fXMLSchemaSettings.getMatchRows();
        this.fillTable(arrayList);
        this.fTable.addSelectionListener((SelectionListener)this.getMultiplexListener());
        gridData2 = new Composite((Composite)gridData, 16384);
        object2 = new GridData();
        object2.horizontalAlignment = 1;
        object2.verticalAlignment = 1;
        object2.horizontalIndent = 5;
        gridData2.setLayoutData(object2);
        columnWeightData = new RowLayout(512);
        columnWeightData.marginTop = 0;
        columnWeightData.marginBottom = 6;
        columnWeightData.pack = false;
        gridData2.setLayout((Layout)columnWeightData);
        this.fNewButton = new Button((Composite)gridData2, 0x1000000);
        this.fNewButton.setText(Local.getString((String)"New..."));
        this.fEditButton = new Button((Composite)gridData2, 0x1000000);
        this.fEditButton.setText(Local.getString((String)"Edit..."));
        this.fRemoveButton = new Button((Composite)gridData2, 0x1000000);
        this.fRemoveButton.setText(Local.getString((String)"Remove"));
        this.fName.addSelectionListener((SelectionListener)this.getMultiplexListener());
        this.fNs.addSelectionListener((SelectionListener)this.getMultiplexListener());
        this.fBoth.addSelectionListener((SelectionListener)this.getMultiplexListener());
        this.fNever.addSelectionListener((SelectionListener)this.getMultiplexListener());
        this.fTable.addSelectionListener((SelectionListener)this.getMultiplexListener());
        object2 = new ButtonListener();
        this.fNewButton.addSelectionListener((SelectionListener)object2);
        this.fEditButton.addSelectionListener((SelectionListener)object2);
        this.fRemoveButton.addSelectionListener((SelectionListener)object2);
        this.validate();
        return composite2;
    }

    private void fillTable(ArrayList arrayList) {
        this.fTableRows = arrayList.size();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            TableItem tableItem = new TableItem(this.fTable, 0);
            String[] stringArray = (String[])iterator.next();
            int n = 0;
            while (n < stringArray.length) {
                tableItem.setText(n, stringArray[n]);
                ++n;
            }
        }
    }

    private void buttonClicked(Button button) {
        block4: {
            block5: {
                block3: {
                    if (button != this.fNewButton) break block3;
                    RowDialog rowDialog = new RowDialog(this.getShell(), "", "", "");
                    if (rowDialog.open() == 0) {
                        TableItem tableItem = new TableItem(this.fTable, 0);
                        tableItem.setText(0, this.fRoot);
                        tableItem.setText(1, this.fPub);
                        tableItem.setText(2, this.fSys);
                    }
                    break block4;
                }
                if (button != this.fEditButton) break block5;
                TableItem[] tableItemArray = this.fTable.getSelection();
                if (tableItemArray.length <= 0) break block4;
                TableItem tableItem = tableItemArray[0];
                RowDialog rowDialog = new RowDialog(this.getShell(), tableItem.getText(0), tableItem.getText(1), tableItem.getText(2));
                if (rowDialog.open() != 0) break block4;
                tableItem.setText(0, this.fRoot);
                tableItem.setText(1, this.fPub);
                tableItem.setText(2, this.fSys);
                break block4;
            }
            if (button == this.fRemoveButton) {
                TableItem[] tableItemArray = this.fTable.getSelection();
                int n = 0;
                while (n < tableItemArray.length) {
                    tableItemArray[n].dispose();
                    ++n;
                }
            }
        }
    }

    private class ButtonListener
    implements SelectionListener {
        ButtonListener() {
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            XMLBasePreferencePage.this.buttonClicked((Button)selectionEvent.widget);
        }
    }

    private class RowDialog
    extends Dialog {
        private Text fRootText;
        private Text fPubText;
        private Text fSysText;
        private String fMsg = "";
        private Label fMsgLabel;

        public RowDialog(Shell shell, String string, String string2, String string3) {
            super(shell);
            XMLBasePreferencePage.this.fRoot = string;
            XMLBasePreferencePage.this.fPub = string2;
            XMLBasePreferencePage.this.fSys = string3;
        }

        protected Control createDialogArea(Composite composite) {
            Composite composite2 = (Composite)super.createDialogArea(composite);
            String string = XMLBasePreferencePage.this.fRoot.length() == 0 ? Local.getString((String)"New Default Schema") : Local.getString((String)"Edit Default Schema");
            composite.getShell().setText(string);
            Composite composite3 = new Composite(composite2, 0);
            composite3.setLayout((Layout)new GridLayout(3, false));
            this.fMsgLabel = new Label(composite3, 16384);
            GridData gridData = new GridData(769);
            gridData.horizontalSpan = 3;
            gridData.widthHint = 300;
            this.fMsgLabel.setLayoutData((Object)gridData);
            XMLBasePreferencePage.insertSpacer(composite3, 3);
            gridData = new Label(composite3, 16384);
            gridData.setText(Local.getString((String)"Root name:"));
            gridData.setLayoutData((Object)new GridData());
            this.fRootText = new Text(composite3, 18436);
            this.fRootText.setText(XMLBasePreferencePage.this.fRoot);
            GridData gridData2 = new GridData(768);
            gridData2.horizontalSpan = 2;
            this.fRootText.setLayoutData((Object)gridData2);
            gridData2 = new Label(composite3, 16384);
            gridData2.setText(Local.getString((String)"Namespace:"));
            gridData2.setLayoutData((Object)new GridData());
            this.fPubText = new Text(composite3, 18436);
            this.fPubText.setText(XMLBasePreferencePage.this.fPub);
            GridData gridData3 = new GridData(768);
            gridData3.horizontalSpan = 2;
            this.fPubText.setLayoutData((Object)gridData3);
            gridData3 = new Label(composite3, 16384);
            gridData3.setText(Local.getString((String)"Schema location:"));
            gridData3.setLayoutData((Object)new GridData());
            this.fSysText = new Text(composite3, 18436);
            this.fSysText.setText(XMLBasePreferencePage.this.fSys);
            GridData gridData4 = new GridData(768);
            this.fSysText.setLayoutData((Object)gridData4);
            gridData4 = new Button(composite3, 8);
            gridData4.setText(Local.getString((String)"Browse"));
            gridData4.setLayoutData((Object)new GridData());
            gridData4.addSelectionListener((SelectionListener)new WizardUtils.BrowseButtonListener(this.fSysText, this.getShell(), true));
            LocalModifyListener localModifyListener = new LocalModifyListener();
            this.fRootText.addModifyListener((ModifyListener)localModifyListener);
            this.fPubText.addModifyListener((ModifyListener)localModifyListener);
            this.fSysText.addModifyListener((ModifyListener)localModifyListener);
            return composite2;
        }

        private void validate() {
            String string = this.fMsg;
            this.fMsg = "";
            XMLBasePreferencePage.this.fRoot = this.fRootText.getText();
            XMLBasePreferencePage.this.fPub = this.fPubText.getText();
            XMLBasePreferencePage.this.fSys = this.fSysText.getText();
            if (this.isEmpty(XMLBasePreferencePage.this.fSys)) {
                this.fMsg = Local.getString((String)"Schema location must be specified");
            }
            Button button = this.getButton(0);
            button.setEnabled(this.fMsg.length() == 0);
            if (!string.equals(this.fMsg)) {
                this.fMsgLabel.setText(this.fMsg);
            }
        }

        private boolean isEmpty(String string) {
            int n = string.length();
            if (n == 0) {
                return true;
            }
            int n2 = 0;
            while (n2 < n) {
                char c = string.charAt(n2);
                if (c > ' ') {
                    return false;
                }
                ++n2;
            }
            return true;
        }

        private class LocalModifyListener
        implements ModifyListener {
            LocalModifyListener() {
            }

            public void modifyText(ModifyEvent modifyEvent) {
                RowDialog.this.validate();
            }
        }
    }
}

