/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor.preferences;

import com.objfac.util.Local;
import com.objfac.xmleditor.XMLPlugin;
import com.objfac.xmleditor.preferences.ValidatingPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class XMLFormatPreferencePage
extends ValidatingPreferencePage
implements IWorkbenchPreferencePage {
    private boolean fInitialFlowLong;
    private Button fFlowLong;
    private Button fSpacesForTabs;
    private Text fTabWidth;
    private Text fWrapMargin;
    private int fInitialWidth;
    private boolean fInitialSpacesForTabs;
    private int fInitialMargin;
    private Button fFormatPasteInsert;
    private boolean fInitialFormatPaste;

    public XMLFormatPreferencePage() {
    }

    public XMLFormatPreferencePage(String string) {
        super(string);
    }

    public XMLFormatPreferencePage(String string, ImageDescriptor imageDescriptor) {
        super(string, imageDescriptor);
    }

    protected Control createContents(Composite composite) {
        int n = 20;
        Composite composite2 = new Composite(composite, 0);
        FormLayout formLayout = new FormLayout();
        formLayout.marginHeight = 5;
        formLayout.marginWidth = 0;
        composite2.setLayout((Layout)formLayout);
        formLayout = new Label(composite2, 16384);
        formLayout.setText(Local.getString((String)"Tab width:"));
        this.fTabWidth = new Text(composite2, 18436);
        FormData formData = new FormData();
        formData.top = new FormAttachment((Control)formLayout, 0, 0x1000000);
        formData.left = new FormAttachment((Control)formLayout, 5);
        this.fTabWidth.setLayoutData((Object)formData);
        this.fSpacesForTabs = new Button(composite2, 16416);
        this.fSpacesForTabs.setText(Local.getString((String)"Use spaces for tabs"));
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.fTabWidth, 5);
        formData.left = new FormAttachment(0, 0);
        this.fSpacesForTabs.setLayoutData((Object)formData);
        formData = new Label(composite2, 16384);
        formData.setText(Local.getString((String)"Wrap margin:"));
        Object object = new FormData();
        object.top = new FormAttachment((Control)this.fSpacesForTabs, n);
        object.left = new FormAttachment(0, 0);
        formData.setLayoutData(object);
        this.fWrapMargin = new Text(composite2, 18436);
        object = new FormData();
        object.top = new FormAttachment((Control)formData, 0, 0x1000000);
        object.left = new FormAttachment((Control)formData, 5);
        this.fWrapMargin.setLayoutData(object);
        this.fFlowLong = new Button(composite2, 16416);
        this.fFlowLong.setText(Local.getString((String)"Automatically format long lines"));
        object = new FormData();
        object.top = new FormAttachment((Control)formData, 5);
        object.left = new FormAttachment(0, 0);
        this.fFlowLong.setLayoutData(object);
        this.fFormatPasteInsert = new Button(composite2, 16416);
        this.fFormatPasteInsert.setText(Local.getString((String)"Automatically format long lines"));
        object = new FormData();
        object.top = new FormAttachment((Control)this.fFlowLong, n);
        object.left = new FormAttachment(0, 0);
        this.fFormatPasteInsert.setLayoutData(object);
        composite2.setTabList(new Control[]{this.fTabWidth, this.fSpacesForTabs, this.fWrapMargin, this.fFlowLong, this.fFormatPasteInsert});
        this.initControls();
        object = new WidthListener();
        this.fTabWidth.addModifyListener((ModifyListener)object);
        this.fWrapMargin.addModifyListener((ModifyListener)object);
        this.validate();
        this.setMessages(null, null);
        return composite2;
    }

    public void setMessages(String string, String string2) {
        this.setErrorMessage(string);
        this.setMessage(string2);
        this.setValid(string == null);
    }

    protected void validate() {
        int n;
        int n2;
        int n3;
        this.setMessages(null, null);
        String string = this.fTabWidth.getText();
        if (string == null || string.length() == 0) {
            this.setMessages(Local.getString((String)"Must specify tab width"), null);
        } else {
            boolean bl = true;
            n3 = 0;
            n2 = string.length();
            while (n3 < n2) {
                n = string.charAt(n3);
                if (n < 48 || n > 57) {
                    bl = false;
                    break;
                }
                ++n3;
            }
            if (!bl) {
                this.setMessages(Local.getString((String)"Only numbers between 1 and 16 allowed"), null);
            } else {
                try {
                    n3 = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    n3 = 0;
                }
                if (n3 < 1 || n3 > 16) {
                    this.setMessages(Local.getString((String)"Only numbers between 1 and 16 allowed"), null);
                }
            }
        }
        if (this.isValid()) {
            String string2 = this.fWrapMargin.getText();
            if (string2 == null || string2.length() == 0) {
                this.setMessages(Local.getString((String)"Must specify wrap margin"), null);
            } else {
                n3 = 1;
                n2 = 0;
                n = string2.length();
                while (n2 < n) {
                    char c = string2.charAt(n2);
                    if (c < '0' || c > '9') {
                        n3 = 0;
                        break;
                    }
                    ++n2;
                }
                if (n3 == 0) {
                    this.setMessages(Local.getString((String)"Only digits allowed (0=unlimited)"), null);
                } else {
                    try {
                        Integer.parseInt(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        n3 = 0;
                    }
                    if (n3 == 0) {
                        this.setMessages(Local.getString((String)"Number too large (0=unlimited)"), null);
                    }
                }
            }
        }
    }

    private void initControls() {
        this.fTabWidth.setText(Integer.toString(this.fInitialWidth));
        this.fTabWidth.setSelection(0, this.fTabWidth.getText().length());
        this.fSpacesForTabs.setSelection(this.fInitialSpacesForTabs);
        this.fWrapMargin.setText(Integer.toString(this.fInitialMargin));
        this.fWrapMargin.setSelection(0, this.fWrapMargin.getText().length());
        this.fFlowLong.setSelection(this.fInitialFlowLong);
        this.fFormatPasteInsert.setSelection(this.fInitialFormatPaste);
    }

    private void defaultControls() {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        int n = iPreferenceStore.getDefaultInt("com.objfac.xmleditor.tabwidth");
        this.fTabWidth.setText(Integer.toString(n));
        this.fTabWidth.setSelection(0, this.fTabWidth.getText().length());
        this.fSpacesForTabs.setSelection(iPreferenceStore.getDefaultBoolean("com.objfac.xmleditor.spaces"));
        int n2 = iPreferenceStore.getDefaultInt("com.objfac.xmleditor.wrapmax");
        this.fWrapMargin.setText(Integer.toString(n2));
        this.fWrapMargin.setSelection(0, this.fWrapMargin.getText().length());
        this.fFlowLong.setSelection(iPreferenceStore.getDefaultBoolean("com.objfac.xmleditor.flowlong"));
        this.fFormatPasteInsert.setSelection(iPreferenceStore.getDefaultBoolean("com.objfac.xmleditor.formatpaste"));
    }

    public void init(IWorkbench iWorkbench) {
        this.setPreferenceStore(XMLPlugin.getDefault().getPreferenceStore());
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        this.fInitialWidth = iPreferenceStore.getInt("com.objfac.xmleditor.tabwidth");
        this.fInitialSpacesForTabs = iPreferenceStore.getBoolean("com.objfac.xmleditor.spaces");
        this.fInitialMargin = iPreferenceStore.getInt("com.objfac.xmleditor.wrapmax");
        this.fInitialFlowLong = iPreferenceStore.getBoolean("com.objfac.xmleditor.flowlong");
        this.fInitialFormatPaste = iPreferenceStore.getBoolean("com.objfac.xmleditor.formatpaste");
    }

    public boolean performOk() {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        String string = this.fTabWidth.getText();
        int n = Integer.parseInt(string);
        iPreferenceStore.setValue("com.objfac.xmleditor.tabwidth", n);
        boolean bl = this.fSpacesForTabs.getSelection();
        iPreferenceStore.setValue("com.objfac.xmleditor.spaces", bl);
        String string2 = this.fWrapMargin.getText();
        int n2 = Integer.parseInt(string2);
        iPreferenceStore.setValue("com.objfac.xmleditor.wrapmax", n2);
        boolean bl2 = this.fFlowLong.getSelection();
        iPreferenceStore.setValue("com.objfac.xmleditor.flowlong", bl2);
        return super.performOk();
    }

    protected void performApply() {
    }

    protected void performDefaults() {
        this.defaultControls();
        super.performDefaults();
    }

    public boolean performCancel() {
        this.initControls();
        return super.performCancel();
    }

    private class WidthListener
    implements ModifyListener {
        WidthListener() {
        }

        public void modifyText(ModifyEvent modifyEvent) {
            XMLFormatPreferencePage.this.validate();
        }
    }
}

