/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor.preferences;

import com.objfac.xmleditor.XMLPlugin;
import com.objfac.xmleditor.preferences.PrefUtils;
import com.objfac.xmleditor.resources.XMLConstants;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.preference.IPreferenceStore;

public class XMLSchemaSettings {
    private String prefix;
    public static final String USE_PREF = "pref";
    public static final String USE_NONE = "none";
    public static final String USE_THIS = "this";
    public static final String PRIMARY = "primary";
    public static final String SECONDARY = "secondary";

    public XMLSchemaSettings(String string) {
        this.prefix = string;
    }

    public String getMatch() {
        return XMLPlugin.getDefault().getPreferenceStore().getString(String.valueOf(this.prefix) + "match");
    }

    public String getDefaultMatch() {
        return XMLPlugin.getDefault().getPreferenceStore().getDefaultString(String.valueOf(this.prefix) + "match");
    }

    public void setMatch(String string) {
        XMLPlugin.getDefault().getPreferenceStore().setValue(String.valueOf(this.prefix) + "match", string);
    }

    public ArrayList getMatchRows() {
        IPreferenceStore iPreferenceStore = XMLPlugin.getDefault().getPreferenceStore();
        String string = iPreferenceStore.getString(String.valueOf(this.prefix) + "root");
        String string2 = iPreferenceStore.getString(String.valueOf(this.prefix) + "ns");
        String string3 = iPreferenceStore.getString(String.valueOf(this.prefix) + "sys");
        return this.makeRows(string, string2, string3);
    }

    private ArrayList makeRows(String string, String string2, String string3) {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        String[] stringArray = PrefUtils.unpackNormalizedArray(string);
        String[] stringArray2 = PrefUtils.unpackNormalizedArray(string2);
        String[] stringArray3 = PrefUtils.unpackNormalizedArray(string3);
        int n = Math.min(stringArray.length, Math.min(stringArray2.length, stringArray3.length));
        int n2 = 0;
        while (n2 < n) {
            String[] stringArray4 = new String[]{PrefUtils.hexUnescape(stringArray[n2]), PrefUtils.hexUnescape(stringArray2[n2]), PrefUtils.hexUnescape(stringArray3[n2])};
            arrayList.add(stringArray4);
            ++n2;
        }
        return arrayList;
    }

    public ArrayList getDefaultMatchRows() {
        IPreferenceStore iPreferenceStore = XMLPlugin.getDefault().getPreferenceStore();
        String string = iPreferenceStore.getDefaultString(String.valueOf(this.prefix) + "root");
        String string2 = iPreferenceStore.getDefaultString(String.valueOf(this.prefix) + "ns");
        String string3 = iPreferenceStore.getDefaultString(String.valueOf(this.prefix) + "sys");
        return this.makeRows(string, string2, string3);
    }

    public void setMatchRows(ArrayList arrayList) {
        Object object;
        int n = arrayList.size();
        String[] stringArray = new String[n];
        String[] stringArray2 = new String[n];
        String[] stringArray3 = new String[n];
        IPreferenceStore iPreferenceStore = XMLPlugin.getDefault().getPreferenceStore();
        int n2 = 0;
        while (n2 < n) {
            object = (String[])arrayList.get(n2);
            stringArray[n2] = PrefUtils.hexEscape(object[0].trim());
            stringArray2[n2] = PrefUtils.hexEscape(PrefUtils.normalizePubid(object[1]));
            stringArray3[n2] = PrefUtils.hexEscape(object[2].trim());
            ++n2;
        }
        String string = PrefUtils.packNormalizedArray(stringArray);
        object = PrefUtils.packNormalizedArray(stringArray2);
        String string2 = PrefUtils.packNormalizedArray(stringArray3);
        iPreferenceStore.setValue(String.valueOf(this.prefix) + "root", string);
        iPreferenceStore.setValue(String.valueOf(this.prefix) + "ns", (String)object);
        iPreferenceStore.setValue(String.valueOf(this.prefix) + "sys", string2);
    }

    public SchemaProps getCurrentProperties(IFile iFile) {
        SchemaProps schemaProps = new SchemaProps();
        schemaProps.fUse = this.getCurrentUse(iFile);
        schemaProps.fSys = this.getCurrentSystemId(iFile);
        return schemaProps;
    }

    public String getCurrentSystemId(IFile iFile) {
        String string;
        try {
            QualifiedName qualifiedName = XMLConstants.getQualifiedName(String.valueOf(this.prefix) + "system");
            string = iFile.getPersistentProperty(qualifiedName);
            if (string == null) {
                string = this.getDefaultSystemId();
            }
        }
        catch (CoreException coreException) {
            XMLPlugin.log(coreException);
            string = this.getDefaultSystemId();
        }
        return string;
    }

    public String getCurrentUse(IFile iFile) {
        String string = this.getDefaultUse();
        try {
            QualifiedName qualifiedName = XMLConstants.getQualifiedName(String.valueOf(this.prefix) + "use");
            String string2 = iFile.getPersistentProperty(qualifiedName);
            if (string2 != null && (string2.equals(USE_PREF) || string2.equals(USE_NONE) || string2.equals(USE_THIS))) {
                string = string2;
            }
        }
        catch (CoreException coreException) {
            XMLPlugin.log(coreException);
        }
        return string;
    }

    public void setCurrentProperties(IFile iFile, SchemaProps schemaProps) {
        try {
            QualifiedName qualifiedName = XMLConstants.getQualifiedName(String.valueOf(this.prefix) + "system");
            iFile.setPersistentProperty(qualifiedName, schemaProps.fSys);
            qualifiedName = XMLConstants.getQualifiedName(String.valueOf(this.prefix) + "use");
            iFile.setPersistentProperty(qualifiedName, schemaProps.fUse);
        }
        catch (CoreException coreException) {
            XMLPlugin.log(coreException);
        }
    }

    public SchemaProps getDefaultProperties() {
        SchemaProps schemaProps = new SchemaProps();
        schemaProps.fSys = this.getDefaultSystemId();
        schemaProps.fUse = this.getDefaultUse();
        return schemaProps;
    }

    private String getDefaultPrimary() {
        return PRIMARY;
    }

    public String getDefaultSystemId() {
        return "";
    }

    public String getDefaultUse() {
        return USE_PREF;
    }

    public static class SchemaProps {
        public String fSys;
        public String fUse;

        public SchemaProps() {
        }

        public SchemaProps(SchemaProps schemaProps) {
            this.fSys = schemaProps.fSys;
            this.fUse = schemaProps.fUse;
        }

        public void reset(SchemaProps schemaProps) {
            this.fSys = schemaProps.fSys;
            this.fUse = schemaProps.fUse;
        }
    }
}

