/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor.project;

import com.objfac.util.Local;
import com.objfac.xmleditor.XMLPlugin;
import com.objfac.xmleditor.project.XMLProjectCreationWizardPage;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;
import org.eclipse.ui.wizards.datatransfer.ZipFileStructureProvider;

public class XMLProjectCreationOperation
implements IRunnableWithProgress {
    private IResource fElementToOpen = null;
    private XMLProjectCreationWizardPage[] fPages;
    private IOverwriteQuery fOverwriteQuery;

    public XMLProjectCreationOperation(XMLProjectCreationWizardPage[] xMLProjectCreationWizardPageArray, IOverwriteQuery iOverwriteQuery) {
        this.fPages = xMLProjectCreationWizardPageArray;
        this.fOverwriteQuery = iOverwriteQuery;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        try {
            iProgressMonitor.beginTask(Local.getString((String)"XML"), this.fPages.length);
            IWorkspaceRoot iWorkspaceRoot = XMLPlugin.getWorkspace().getRoot();
            int n = 0;
            while (n < this.fPages.length) {
                this.createProject(iWorkspaceRoot, this.fPages[n], (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                ++n;
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        iProgressMonitor.done();
    }

    public IResource getElementToOpen() {
        return this.fElementToOpen;
    }

    private void createProject(IWorkspaceRoot iWorkspaceRoot, XMLProjectCreationWizardPage xMLProjectCreationWizardPage, IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
        IResource iResource;
        IConfigurationElement iConfigurationElement = xMLProjectCreationWizardPage.getConfigurationElement();
        IConfigurationElement[] iConfigurationElementArray = iConfigurationElement.getChildren("import");
        IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElement.getChildren("nature");
        IConfigurationElement[] iConfigurationElementArray3 = iConfigurationElement.getChildren("references");
        int n = iConfigurationElementArray == null ? 0 : iConfigurationElementArray.length;
        int n2 = iConfigurationElementArray2 == null ? 0 : iConfigurationElementArray2.length;
        int n3 = iConfigurationElementArray3 == null ? 0 : iConfigurationElementArray3.length;
        iProgressMonitor.beginTask(Local.getString((String)"Creating project"), n + 1);
        String string = xMLProjectCreationWizardPage.getName();
        String[] stringArray = new String[n2];
        int n4 = 0;
        while (n4 < n2) {
            stringArray[n4] = iConfigurationElementArray2[n4].getAttribute("id");
            ++n4;
        }
        IProject[] iProjectArray = new IProject[n3];
        int n5 = 0;
        while (n5 < n3) {
            iProjectArray[n5] = iWorkspaceRoot.getProject(iConfigurationElementArray3[n5].getAttribute("id"));
            ++n5;
        }
        IProject iProject = this.configNewProject(iWorkspaceRoot, string, stringArray, iProjectArray, iProgressMonitor);
        int n6 = 0;
        while (n6 < n) {
            this.doImports(iProject, iConfigurationElementArray[n6], (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            ++n6;
        }
        String string2 = iConfigurationElement.getAttribute("open");
        if (string2 != null && string2.length() > 0 && (iResource = iProject.findMember((IPath)new Path(string2))) != null) {
            this.fElementToOpen = iResource;
        }
    }

    private IProject configNewProject(IWorkspaceRoot iWorkspaceRoot, String string, String[] stringArray, IProject[] iProjectArray, IProgressMonitor iProgressMonitor) throws InvocationTargetException {
        try {
            IProject iProject = iWorkspaceRoot.getProject(string);
            if (!iProject.exists()) {
                iProject.create(null);
            }
            if (!iProject.isOpen()) {
                iProject.open(null);
            }
            IProjectDescription iProjectDescription = iProject.getDescription();
            iProjectDescription.setLocation(null);
            iProjectDescription.setNatureIds(stringArray);
            iProjectDescription.setReferencedProjects(iProjectArray);
            iProject.setDescription(iProjectDescription, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            return iProject;
        }
        catch (CoreException coreException) {
            throw new InvocationTargetException(coreException);
        }
    }

    private void doImports(IProject iProject, IConfigurationElement iConfigurationElement, IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
        try {
            Object object;
            IPath iPath;
            String string = iConfigurationElement.getAttribute("dest");
            if (string == null || string.length() == 0) {
                iPath = iProject.getFullPath();
            } else {
                object = iProject.getFolder(string);
                if (!object.exists()) {
                    object.create(true, true, null);
                }
                iPath = object.getFullPath();
            }
            object = iConfigurationElement.getAttribute("src");
            if (object == null) {
                object = "";
                XMLPlugin.log("Missing import");
                return;
            }
            ZipFile zipFile = this.getZipFileFromPluginDir((String)object);
            this.importFilesFromZip(zipFile, iPath, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
        }
        catch (CoreException coreException) {
            throw new InvocationTargetException(coreException);
        }
    }

    private ZipFile getZipFileFromPluginDir(String string) throws CoreException {
        try {
            URL uRL = new URL(XMLPlugin.getDefault().getDescriptor().getInstallURL(), string);
            return new ZipFile(Platform.asLocalURL((URL)uRL).getFile());
        }
        catch (IOException iOException) {
            String string2 = String.valueOf(string) + ": " + iOException.getMessage();
            Status status = new Status(4, XMLPlugin.getPluginId(), 4, string2, (Throwable)iOException);
            throw new CoreException((IStatus)status);
        }
    }

    private void importFilesFromZip(ZipFile zipFile, IPath iPath, IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
        ZipFileStructureProvider zipFileStructureProvider = new ZipFileStructureProvider(zipFile);
        ImportOperation importOperation = new ImportOperation(iPath, (Object)zipFileStructureProvider.getRoot(), (IImportStructureProvider)zipFileStructureProvider, this.fOverwriteQuery);
        importOperation.run(iProgressMonitor);
    }
}

