/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor.properties;

import com.objfac.util.CaselessMap;
import com.objfac.util.Misc;
import com.objfac.xml.io.Encoding;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;

public class EncodingCombo {
    private Combo fSpecified;
    private CaselessMap fEncodings;
    private String[] fEncodingArray;
    private EncodingComboListener fListener;
    private String fDefault;

    public EncodingCombo(Composite composite, EncodingComboListener encodingComboListener, String string) {
        this.fSpecified = new Combo(composite, 12);
        this.fListener = encodingComboListener;
        this.fDefault = string;
        this.fEncodings = Encoding.getMostlyStandardEncodingMap();
        Collection collection = this.fEncodings.values();
        this.fEncodingArray = collection.toArray(new String[collection.size()]);
        Arrays.sort(this.fEncodingArray, String.CASE_INSENSITIVE_ORDER);
        this.fSpecified.setItems(this.fEncodingArray);
        this.selectDefault();
        MultiplexListener multiplexListener = new MultiplexListener();
        this.fSpecified.addSelectionListener((SelectionListener)multiplexListener);
        this.fSpecified.addModifyListener((ModifyListener)multiplexListener);
    }

    public Combo getCombo() {
        return this.fSpecified;
    }

    public void setSelection(String string) {
        int n = Misc.indexOf((Object[])this.fEncodingArray, (Object)this.fDefault, (Comparator)Misc.STRING_COMPARATOR);
        if (n >= 0) {
            this.fSpecified.select(n);
        }
    }

    public void selectDefault() {
        this.setSelection(this.fDefault);
    }

    public static interface EncodingComboListener {
        public void encodingChanged();
    }

    private class MultiplexListener
    implements SelectionListener,
    ModifyListener {
        MultiplexListener() {
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            EncodingCombo.this.selectDefault();
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            EncodingCombo.this.fListener.encodingChanged();
        }

        public void modifyText(ModifyEvent modifyEvent) {
            EncodingCombo.this.fListener.encodingChanged();
        }
    }
}

