/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor.search;

import com.objfac.util.Local;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;

public class SearchUtils {
    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static IWorkbenchPage getActivePage() {
        return SearchUtils.getActiveWorkbenchWindow().getActivePage();
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (iWorkbenchWindow == null) {
            final IWorkbenchWindow[] iWorkbenchWindowArray = new IWorkbenchWindow[1];
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    SearchUtils.searchForActiveWorkbenchWindow(iWorkbenchWindowArray);
                }
            });
            return iWorkbenchWindowArray[0];
        }
        return iWorkbenchWindow;
    }

    private static void searchForActiveWorkbenchWindow(IWorkbenchWindow[] iWorkbenchWindowArray) {
        Object object;
        iWorkbenchWindowArray[0] = null;
        Display display = Display.getCurrent();
        if (display == null) {
            return;
        }
        Shell shell = display.getActiveShell();
        while (shell != null) {
            object = shell.getData();
            if (object instanceof IWorkbenchWindow) {
                iWorkbenchWindowArray[0] = (IWorkbenchWindow)object;
                return;
            }
            shell = shell.getParent();
        }
        object = display.getShells();
        int n = 0;
        while (n < ((Shell[])object).length) {
            Object object2 = object[n].getData();
            if (object2 instanceof IWorkbenchWindow) {
                iWorkbenchWindowArray[0] = (IWorkbenchWindow)object2;
                return;
            }
            ++n;
        }
    }

    public static IEditorPart[] getDirtyEditors() {
        HashSet<IEditorInput> hashSet = new HashSet<IEditorInput>();
        ArrayList<IEditorPart> arrayList = new ArrayList<IEditorPart>(0);
        IWorkbench iWorkbench = SearchPlugin.getDefault().getWorkbench();
        IWorkbenchWindow[] iWorkbenchWindowArray = iWorkbench.getWorkbenchWindows();
        int n = 0;
        while (n < iWorkbenchWindowArray.length) {
            IWorkbenchPage[] iWorkbenchPageArray = iWorkbenchWindowArray[n].getPages();
            int n2 = 0;
            while (n2 < iWorkbenchPageArray.length) {
                IEditorPart[] iEditorPartArray = iWorkbenchPageArray[n2].getDirtyEditors();
                int n3 = 0;
                while (n3 < iEditorPartArray.length) {
                    IEditorPart iEditorPart = iEditorPartArray[n3];
                    IEditorInput iEditorInput = iEditorPart.getEditorInput();
                    if (!hashSet.contains(iEditorInput)) {
                        hashSet.add(iEditorInput);
                        arrayList.add(iEditorPart);
                    }
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
        return arrayList.toArray(new IEditorPart[arrayList.size()]);
    }

    public static IEditorPart[] getActiveEditors() {
        HashSet<IEditorInput> hashSet = new HashSet<IEditorInput>();
        ArrayList<IEditorPart> arrayList = new ArrayList<IEditorPart>(0);
        IWorkbench iWorkbench = SearchPlugin.getDefault().getWorkbench();
        IWorkbenchWindow[] iWorkbenchWindowArray = iWorkbench.getWorkbenchWindows();
        int n = 0;
        while (n < iWorkbenchWindowArray.length) {
            IWorkbenchPage[] iWorkbenchPageArray = iWorkbenchWindowArray[n].getPages();
            int n2 = 0;
            while (n2 < iWorkbenchPageArray.length) {
                IEditorReference[] iEditorReferenceArray = iWorkbenchPageArray[n2].getEditorReferences();
                int n3 = 0;
                while (n3 < iEditorReferenceArray.length) {
                    IEditorInput iEditorInput;
                    IEditorReference iEditorReference = iEditorReferenceArray[n3];
                    IEditorPart iEditorPart = iEditorReference.getEditor(false);
                    if (iEditorPart != null && !hashSet.contains(iEditorInput = iEditorPart.getEditorInput())) {
                        hashSet.add(iEditorInput);
                        arrayList.add(iEditorPart);
                    }
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
        return arrayList.toArray(new IEditorPart[arrayList.size()]);
    }

    public static String workingSetList(IWorkingSet[] iWorkingSetArray) {
        String string = "";
        if (iWorkingSetArray != null && iWorkingSetArray.length > 0) {
            Arrays.sort(iWorkingSetArray, new WorkingSetComparator());
            boolean bl = false;
            int n = 0;
            while (n < iWorkingSetArray.length) {
                String string2 = iWorkingSetArray[n].getName();
                if (bl) {
                    string = Local.format((String)"Concatenation.format", (Object)string, (Object)string2);
                } else {
                    string = string2;
                    bl = true;
                }
                ++n;
            }
        }
        return string;
    }

    private static class WorkingSetComparator
    implements Comparator {
        private Collator fCollator = Collator.getInstance();

        WorkingSetComparator() {
        }

        public int compare(Object object, Object object2) {
            String string = null;
            String string2 = null;
            if (object instanceof IWorkingSet) {
                string = ((IWorkingSet)object).getName();
            }
            if (object2 instanceof IWorkingSet) {
                string2 = ((IWorkingSet)object2).getName();
            }
            return this.fCollator.compare(string, string2);
        }
    }
}

