/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor.wizards;

import com.objfac.util.Local;
import com.objfac.xmleditor.wizards.FileCreationWizard;
import com.objfac.xmleditor.wizards.WizardUtils;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public abstract class FileParametersPage
extends WizardPage {
    private boolean fInValidate;
    private boolean fFirstTime = true;
    private ArrayList fBrowseListeners;
    private FileCreationWizard fWizard;

    public FileParametersPage(FileCreationWizard fileCreationWizard, String string) {
        super(string);
        this.fWizard = fileCreationWizard;
    }

    public FileParametersPage(FileCreationWizard fileCreationWizard, String string, String string2, ImageDescriptor imageDescriptor) {
        super(string, string2, imageDescriptor);
        this.fWizard = fileCreationWizard;
    }

    public abstract void createControl(Composite var1);

    public boolean isExistingFile(String string) {
        return WizardUtils.isExistingFile(this.fWizard.getContainerFullPath(), string);
    }

    protected void validateFile(String string, String string2) {
        if (string.length() == 0) {
            this.setMessages(Local.format((String)"{0} file path must be specified", (Object)string2), null);
        } else if (!this.isExistingFile(string)) {
            this.setMessages(Local.format((String)"{0} file does not exist", (Object)string2), null);
        } else {
            this.setMessages(null, null);
        }
    }

    protected void validateFile(String string) {
        if (string.length() == 0) {
            this.setMessages(Local.getString((String)"File path must be specified"), null);
        } else if (!this.isExistingFile(string)) {
            this.setMessages(Local.getString((String)"File does not exist"), null);
        } else {
            this.setMessages(null, null);
        }
    }

    protected void setMessages(String string, String string2) {
        this.setMessage(string2);
        this.setErrorMessage(string);
    }

    protected void downgradeMessages() {
        this.setMessages(null, this.getErrorMessage());
    }

    public static void insertSpacer(Composite composite, int n) {
        Label label = new Label(composite, 16384);
        GridData gridData = new GridData();
        gridData.horizontalSpan = n;
        label.setLayoutData((Object)gridData);
        label.setText(" ");
        label.setVisible(false);
    }

    public FileCreationWizard getFileCreationWizard() {
        return this.fWizard;
    }

    public IFile getNewFile() {
        return this.fWizard.getNewFile();
    }

    public IPath getNewFilePath() {
        return this.fWizard.getNewFilePath();
    }

    protected SelectionListener getBrowseButtonListener(Text text, boolean bl) {
        WizardUtils.BrowseButtonListener browseButtonListener = new WizardUtils.BrowseButtonListener(text, this.getShell(), bl);
        if (this.fBrowseListeners == null) {
            this.fBrowseListeners = new ArrayList(1);
        }
        this.fBrowseListeners.add(browseButtonListener);
        return browseButtonListener;
    }

    public void setVisible(boolean bl) {
        if (bl) {
            IPath iPath = this.fWizard.getContainerFullPath();
            if (this.fBrowseListeners != null) {
                int n = 0;
                int n2 = this.fBrowseListeners.size();
                while (n < n2) {
                    ((WizardUtils.BrowseButtonListener)this.fBrowseListeners.get(n)).setContainer(iPath);
                    ++n;
                }
            }
            this.setFromVariables();
            this.validate();
            if (this.fFirstTime) {
                this.downgradeMessages();
                this.fFirstTime = false;
            }
        }
        super.setVisible(bl);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void setFromVariables() {
        this.fInValidate = true;
        try {
            this.doSetFromVariables();
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.fInValidate = false;
            throw throwable;
        }
        {
            Object var1_3 = null;
            this.fInValidate = false;
            return;
        }
    }

    protected abstract void doSetFromVariables();

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void validate() {
        if (this.fInValidate) {
            return;
        }
        this.fInValidate = true;
        try {
            this.setMessages(null, null);
            this.doValidate();
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.fInValidate = false;
            throw throwable;
        }
        {
            Object var1_3 = null;
            this.fInValidate = false;
            return;
        }
    }

    protected abstract void doValidate();
}

