/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor.wizards;

import com.objfac.util.Local;
import com.objfac.xml.io.Encoding;
import com.objfac.xmleditor.properties.EncodingCombo;
import com.objfac.xmleditor.wizards.FileCreationWizard;
import com.objfac.xmleditor.wizards.FileParametersPage;
import java.util.Map;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NewRNGFileParametersPage
extends FileParametersPage {
    private Button fFileBrowse;
    private Label fEncodingLabel;
    private Combo fEncoding;
    private EncodingCombo fEncodingCombo;
    private Button fXmlon;
    private Map fVariables;
    private Text fNs;
    private Button fUseFile;
    private Label fFileLabel;
    private Text fFile;
    private Label fNsLabel;
    private Button fUseDefault;

    public NewRNGFileParametersPage(FileCreationWizard fileCreationWizard, String string, Map map) {
        super(fileCreationWizard, string);
        this.fVariables = map;
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        Object object = new GridLayout(3, false);
        object.marginHeight = 5;
        object.marginWidth = 5;
        composite2.setLayout((Layout)object);
        this.fUseDefault = new Button(composite2, 16);
        this.fUseDefault.setText(Local.getString((String)"Use default template"));
        object = new GridData();
        object.horizontalAlignment = 1;
        object.horizontalSpan = 3;
        this.fUseDefault.setLayoutData(object);
        this.fNsLabel = new Label(composite2, 16384);
        this.fNsLabel.setText(Local.getString((String)"Target namespace:"));
        object = new GridData();
        object.horizontalAlignment = 1;
        object.horizontalIndent = 18;
        this.fNsLabel.setLayoutData(object);
        this.fNs = new Text(composite2, 2052);
        object = new GridData(768);
        object.horizontalSpan = 2;
        this.fNs.setLayoutData(object);
        this.fNs.addModifyListener((ModifyListener)new NsListener());
        this.fXmlon = new Button(composite2, 32);
        this.fXmlon.setText(Local.getString((String)"Generate <?xml declaration"));
        object = new GridData();
        object.horizontalAlignment = 1;
        object.horizontalSpan = 3;
        object.horizontalIndent = 18;
        this.fXmlon.setLayoutData(object);
        this.fXmlon.addSelectionListener((SelectionListener)new XmlonListener());
        this.fEncodingLabel = new Label(composite2, 16384);
        this.fEncodingLabel.setText(Local.getString((String)"Encoding:"));
        object = new GridData();
        object.horizontalAlignment = 1;
        object.horizontalIndent = 36;
        this.fEncodingLabel.setLayoutData(object);
        object = (String)this.fVariables.get("encoding");
        this.fEncodingCombo = new EncodingCombo(composite2, new EncodingListener(), (String)object);
        this.fEncoding = this.fEncodingCombo.getCombo();
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 1;
        this.fEncoding.setLayoutData((Object)gridData);
        NewRNGFileParametersPage.insertSpacer(composite2, 3);
        this.fUseFile = new Button(composite2, 16);
        this.fUseFile.setText(Local.getString((String)"Use file as template"));
        gridData = new GridData();
        gridData.horizontalAlignment = 1;
        gridData.horizontalSpan = 3;
        this.fUseFile.setLayoutData((Object)gridData);
        this.fUseFile.addSelectionListener((SelectionListener)new UseFileListener());
        this.fFileLabel = new Label(composite2, 16384);
        this.fFileLabel.setText(Local.getString((String)"File path:"));
        gridData = new GridData();
        gridData.horizontalAlignment = 1;
        gridData.horizontalIndent = 18;
        this.fFileLabel.setLayoutData((Object)gridData);
        this.fFile = new Text(composite2, 2052);
        gridData = new GridData(768);
        this.fFile.setLayoutData((Object)gridData);
        this.fFile.addModifyListener((ModifyListener)new FileListener());
        this.fFileBrowse = new Button(composite2, 8);
        this.fFileBrowse.setText(Local.getString((String)"Browse"));
        gridData = new GridData();
        gridData.horizontalAlignment = 3;
        this.fFileBrowse.setLayoutData((Object)gridData);
        this.fFileBrowse.addSelectionListener(this.getBrowseButtonListener(this.fFile, true));
        composite2.setTabList(new Control[]{this.fNs, this.fEncoding, this.fFile});
        this.setControl((Control)composite2);
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (this.fUseFile.getSelection()) {
            this.fFile.setSelection(0, this.fFile.getText().length());
            if (!this.fFile.isFocusControl()) {
                this.fFile.setFocus();
            }
        } else {
            this.fNs.setSelection(0, this.fNs.getText().length());
            if (!this.fNs.isFocusControl()) {
                this.fNs.setFocus();
            }
        }
    }

    private void encodingModified() {
        int n = this.fEncoding.getSelectionIndex();
        if (n <= 0) {
            this.fVariables.put("encoding", "");
        } else {
            String string = this.fEncoding.getText();
            if (string == null || string.length() == 0) {
                this.fVariables.put("encoding", "");
            } else {
                String string2 = Encoding.getStandardEquivalent((String)string);
                if (string2 != null) {
                    string = string2;
                }
                this.fVariables.put("encoding", string);
            }
        }
        this.validate();
    }

    protected void doSetFromVariables() {
        Boolean bl = (Boolean)this.fVariables.get("usefile");
        String string = (String)this.fVariables.get("ns");
        Boolean bl2 = (Boolean)this.fVariables.get("xmlon");
        String string2 = (String)this.fVariables.get("encoding");
        String string3 = (String)this.fVariables.get("file");
        this.fUseDefault.setSelection(bl == false);
        this.fUseFile.setSelection(bl.booleanValue());
        this.fNs.setText(string);
        this.fNs.setSelection(0, string.length());
        this.fEncoding.setText(string2);
        this.fFile.setText(string3);
        this.fFile.setSelection(0, string3.length());
        this.fXmlon.setSelection(bl2.booleanValue());
    }

    protected void doValidate() {
        boolean bl = this.fUseFile.getSelection();
        boolean bl2 = this.fXmlon.getSelection();
        String string = this.fNs.getText();
        String string2 = this.fFile.getText();
        String string3 = this.fEncoding.getText();
        this.fFileLabel.setEnabled(bl);
        this.fFile.setEnabled(bl);
        this.fFileBrowse.setEnabled(bl);
        this.fNsLabel.setEnabled(!bl);
        this.fNs.setEnabled(!bl);
        this.fXmlon.setEnabled(!bl);
        this.fEncodingLabel.setEnabled(!bl && bl2);
        this.fEncoding.setEnabled(!bl && bl2);
        this.fVariables.put("xmlon", bl2 ? Boolean.TRUE : Boolean.FALSE);
        this.fVariables.put("encoding", string3);
        this.fVariables.put("ns", string);
        this.fVariables.put("usefile", bl ? Boolean.TRUE : Boolean.FALSE);
        this.fVariables.put("file", string2);
        if (bl) {
            this.validateFile(string2);
        } else if (bl2) {
            if (string3 != null && string3.length() > 0) {
                String string4 = Encoding.getStandardEquivalent((String)string3);
                if (string4 == null) {
                    this.setMessages(null, "Unknown encoding");
                } else if (string4.equals(string3)) {
                    this.setMessages(null, null);
                } else {
                    this.setMessages(null, Local.format((String)"{0} recognized as equivalent to {1}", (Object)string3, (Object)string4));
                }
            } else {
                this.setMessages(null, null);
            }
        } else {
            this.setMessages(null, null);
        }
        this.setPageComplete(this.getErrorMessage() == null);
    }

    private class EncodingListener
    implements EncodingCombo.EncodingComboListener {
        EncodingListener() {
        }

        public void encodingChanged() {
            NewRNGFileParametersPage.this.encodingModified();
        }
    }

    private class XmlonListener
    implements SelectionListener {
        XmlonListener() {
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            NewRNGFileParametersPage.this.fXmlon.setSelection(true);
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            NewRNGFileParametersPage.this.validate();
        }
    }

    private class NsListener
    implements ModifyListener {
        NsListener() {
        }

        public void modifyText(ModifyEvent modifyEvent) {
            NewRNGFileParametersPage.this.validate();
        }
    }

    private class UseFileListener
    implements SelectionListener {
        UseFileListener() {
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            NewRNGFileParametersPage.this.fUseFile.setSelection(false);
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            NewRNGFileParametersPage.this.validate();
        }
    }

    private class FileListener
    implements ModifyListener {
        FileListener() {
        }

        public void modifyText(ModifyEvent modifyEvent) {
            NewRNGFileParametersPage.this.validate();
        }
    }
}

