/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor.wizards;

import com.objfac.util.Local;
import com.objfac.util.Misc;
import com.objfac.walker.IWalker;
import com.objfac.xml.io.IDocumentReaderFactory;
import com.objfac.xml.schema.IExternalEntity;
import com.objfac.xml.schema.impl.ExternalEntity;
import com.objfac.xmleditor.Config;
import com.objfac.xmleditor.resources.PluginFactoryExtension;
import com.objfac.xmleditor.validate.XMLSchemaReaderShell;
import com.objfac.xmleditor.wizards.WizardUtils;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SelectRootDialog
extends TitleAreaDialog {
    private boolean fInValidate;
    private int fSchemaKind;
    private String fSchemaUri;
    private String fRootNamespace;
    private String fRootName;
    private String[] fElements;
    private String fLastSchemaLoc;
    private boolean fError;
    private boolean fValid;
    private List fRootList;
    private IPath fContainer;
    private IFile fBaseFile;
    private Text fSchema;

    public SelectRootDialog(Shell shell, IFile iFile) {
        super(shell);
        this.fBaseFile = iFile;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Local.getString((String)"Select Root"));
    }

    public SelectRootResult show() {
        int n = this.open();
        if (n == 0 && this.fRootName != null) {
            SelectRootResult selectRootResult = new SelectRootResult();
            selectRootResult.rootName = this.fRootName;
            selectRootResult.namespace = this.fRootNamespace;
            selectRootResult.schemaKind = this.fSchemaKind;
            selectRootResult.schemaUri = this.fSchemaUri;
            return selectRootResult;
        }
        return null;
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        Composite composite3 = new Composite(composite2, 0);
        GridData gridData = new GridData(1808);
        gridData.horizontalIndent = 5;
        composite3.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout(3, false);
        composite3.setLayout((Layout)gridLayout);
        gridData = new Label(composite3, 0);
        gridData.setText(Local.getString((String)(!Config.pro() ? "DTD file:" : "Schema or DTD file:")));
        gridLayout = new GridData();
        gridData.setLayoutData((Object)gridLayout);
        this.fSchema = new Text(composite3, 2052);
        gridLayout = new GridData(768);
        this.fSchema.setLayoutData((Object)gridLayout);
        this.fSchema.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                SelectRootDialog.this.schemaChanged();
            }
        });
        this.fContainer = this.fBaseFile.getFullPath().removeLastSegments(1);
        gridLayout = new Button(composite3, 8);
        gridLayout.setText(Local.getString((String)"Browse"));
        GridData gridData2 = new GridData();
        gridLayout.setLayoutData((Object)gridData2);
        gridLayout.addSelectionListener((SelectionListener)new WizardUtils.BrowseButtonListener(this.fSchema, this.getShell(), this.fContainer, true, true));
        gridData2 = new Label(composite3, 0);
        gridData2.setText(Local.getString((String)"Root element names:"));
        GridData gridData3 = new GridData();
        gridData3.horizontalSpan = 3;
        gridData2.setLayoutData((Object)gridData3);
        this.fRootList = new List(composite3, 2564);
        gridData3 = new GridData(768);
        gridData3.horizontalSpan = 3;
        this.fRootList.setLayoutData((Object)gridData3);
        this.fRootList.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SelectRootDialog.this.listSelection();
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                SelectRootDialog.this.listDoubleClick();
            }
        });
        return composite2;
    }

    protected Control createContents(Composite composite) {
        Control control = super.createContents(composite);
        this.setTitleAreaColor(new RGB(255, 255, 255));
        this.setTitle(Local.getString((String)(!Config.pro() ? "Specify DTD and root element name" : "Specify schema and root element name")));
        this.validate();
        return control;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void validate() {
        block26: {
            block25: {
                block24: {
                    block23: {
                        block22: {
                            block21: {
                                block20: {
                                    if (this.fInValidate) {
                                        return;
                                    }
                                    this.fInValidate = true;
                                    try {
                                        this.setMessages(null, null);
                                        String string = this.fSchema.getText();
                                        if (string.length() > 0) {
                                            if (!string.equals(this.fLastSchemaLoc)) {
                                                this.fLastSchemaLoc = string;
                                                this.fRootList.removeAll();
                                                this.fRootName = null;
                                                IPath iPath = this.fBaseFile.getLocation();
                                                String string2 = iPath.toOSString();
                                                String string3 = Misc.pathToUrl((String)string2);
                                                String string4 = Misc.pathToUrl((String)string);
                                                String string5 = Misc.getAbsUrl((String)string3, (String)string4);
                                                int n = WizardUtils.getEditorKind(string5);
                                                if (n < 0) {
                                                    this.setMessages("Could not determine schema type", null);
                                                    Object var16_8 = null;
                                                    this.fInValidate = false;
                                                    return;
                                                }
                                                if (n == 5) {
                                                    this.setMessages("Can't handle this kind of schema yet", null);
                                                    break block20;
                                                }
                                                if (n == 0 || n == 6) {
                                                    this.setMessages("Not recognized as a kind of schema", null);
                                                    break block21;
                                                }
                                                String string6 = n == 1 ? "DTD" : "schema";
                                                this.fSchemaKind = n;
                                                try {
                                                    ExternalEntity externalEntity;
                                                    XMLSchemaReaderShell xMLSchemaReaderShell;
                                                    IWalker iWalker;
                                                    Object object;
                                                    URI uRI = new URI(string5);
                                                    if (string5.startsWith("file:")) {
                                                        object = new File(uRI);
                                                        if (!((File)object).exists()) {
                                                            this.setMessages("File does not exist", null);
                                                            break block22;
                                                        }
                                                        if (!((File)object).isFile()) {
                                                            this.setMessages("Specify file, not directory", null);
                                                            break block23;
                                                        }
                                                    }
                                                    if ((iWalker = (xMLSchemaReaderShell = new XMLSchemaReaderShell()).readSchema((IExternalEntity)(externalEntity = new ExternalEntity(null, null, string5, (IDocumentReaderFactory)(object = PluginFactoryExtension.getFactory()))), n)) == null) {
                                                        this.setMessages(Local.format((String)"Couldn''t read {0}", (Object)string6), null);
                                                        break block24;
                                                    }
                                                    if (iWalker.hasErrors()) {
                                                        this.setMessages(Local.format((String)"Errors in {0}", (Object)string6), null);
                                                    }
                                                    this.fElements = iWalker.getElements();
                                                    if (this.fElements.length == 0) {
                                                        this.setMessages(Local.format((String)"There are no valid root elements in this {0}", (Object)string6), null);
                                                        break block25;
                                                    }
                                                    HashSet<String> hashSet = new HashSet<String>();
                                                    int n2 = 1;
                                                    while (true) {
                                                        if (n2 >= this.fElements.length) {
                                                            Object[] objectArray = hashSet.toArray(new String[hashSet.size()]);
                                                            Arrays.sort(objectArray);
                                                            this.fRootList.setItems((String[])objectArray);
                                                            this.setMessages(null, Local.getString((String)"Select a root element name from the list"));
                                                            break block26;
                                                        }
                                                        hashSet.add(this.fElements[n2]);
                                                        n2 += 2;
                                                    }
                                                }
                                                catch (URISyntaxException uRISyntaxException) {
                                                    this.setMessages(Local.format((String)"URL for {0} has invalid syntax", (Object)string6), null);
                                                    Object var16_15 = null;
                                                    this.fInValidate = false;
                                                    return;
                                                }
                                            }
                                            if (this.fRootList.getItemCount() > 0 && this.fRootList.getSelectionIndex() < 0) {
                                                this.setMessages(null, Local.getString((String)"Select a root element name from the list"));
                                            }
                                            break block26;
                                        }
                                        this.setMessages(null, Local.getString((String)(!Config.pro() ? "Enter the URL of a DTD" : "Enter the URL of a schema or DTD")));
                                        break block26;
                                    }
                                    catch (Throwable throwable) {
                                        Object var16_16 = null;
                                        this.fInValidate = false;
                                        throw throwable;
                                    }
                                }
                                Object var16_9 = null;
                                this.fInValidate = false;
                                return;
                            }
                            Object var16_10 = null;
                            this.fInValidate = false;
                            return;
                        }
                        Object var16_11 = null;
                        this.fInValidate = false;
                        return;
                    }
                    Object var16_12 = null;
                    this.fInValidate = false;
                    return;
                }
                Object var16_13 = null;
                this.fInValidate = false;
                return;
            }
            Object var16_14 = null;
            this.fInValidate = false;
            return;
        }
        Object var16_17 = null;
        this.fInValidate = false;
    }

    private void setMessages(String string, String string2) {
        this.setErrorMessage(string);
        this.setMessage(string2);
        this.getButton(0).setEnabled(string == null && string2 == null);
    }

    protected void listSelection() {
        this.fRootName = null;
        int n = this.fRootList.getSelectionIndex();
        if (n >= 0) {
            String string = this.fRootList.getItem(n);
            int n2 = 1;
            while (n2 < this.fElements.length) {
                if (this.fElements[n2].equals(string)) {
                    this.fRootName = string;
                    this.fRootNamespace = this.fElements[n2 - 1];
                    this.fSchemaUri = this.fSchema.getText();
                    this.setMessages(null, null);
                    break;
                }
                n2 += 2;
            }
        }
    }

    protected void listDoubleClick() {
        this.listSelection();
    }

    protected void schemaChanged() {
        this.validate();
    }

    public static class SelectRootResult {
        public String schemaUri;
        public int schemaKind;
        public String rootName;
        public String namespace;
    }
}

