/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor.xmltree;

import com.objfac.xml.Util;
import com.objfac.xml.XMLCharacter;
import com.objfac.xml.parsers.TagParser;
import com.objfac.xml.schema.QName;
import com.objfac.xmleditor.XMLEditor;
import com.objfac.xmleditor.XMLPlugin;
import com.objfac.xmleditor.partition.DocumentWrapper;
import com.objfac.xmleditor.partition.IAbstractDocument;
import com.objfac.xmleditor.partition.IXMLNode;
import com.objfac.xmleditor.resources.XMLConstants;
import com.objfac.xmleditor.xmltree.XMLTypeFunction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TypedPosition;

public class XMLNode
extends TypedPosition
implements ITypedRegion,
IXMLNode {
    protected static int uniqueValue = 0;
    public XMLNode parent;
    public XMLNode firstChild;
    public XMLNode lastChild;
    public XMLNode nextSibling;
    public XMLNode next;
    protected IAbstractDocument document;
    public boolean added = true;
    public boolean modified = false;
    protected int hash = uniqueValue++;
    protected Namespace chain;
    protected List attlist;
    protected List attoffs;
    private String[] attarray;
    private static final Namespace TAIL = new Namespace("xml", "http://www.w3.org/XML/1998/namespace", null);
    private static final String XMLNS = "xmlns";
    private static final int XMLNS_LEN = "xmlns".length();
    private static final int TOKENS = 3;
    private static final int TOKENS_LEN = 30;

    public XMLNode(int n, int n2, String string, IDocument iDocument) {
        super(n, n2, string);
        this.setDocument(new DocumentWrapper(iDocument));
    }

    public XMLNode(int n, int n2, String string, IAbstractDocument iAbstractDocument) {
        super(n, n2, string);
        this.setDocument(iAbstractDocument);
    }

    public XMLNode(ITypedRegion iTypedRegion) {
        super(iTypedRegion);
    }

    public void setDocument(IAbstractDocument iAbstractDocument) {
        this.document = iAbstractDocument;
    }

    public IAbstractDocument getDocument() {
        return this.document;
    }

    public int getRange() {
        int n = this.getLength();
        String string = this.getType();
        if (string == "com.objfac.xmlstarttag" || string == "com.objfac.xmldoctypestart") {
            n = this.nextSibling != null ? this.nextSibling.getOffset() - this.getOffset() : this.document.getLength() - this.getOffset();
        }
        return n;
    }

    public String getQName() {
        return this.getQName(this.document);
    }

    public String getNamespace() {
        String string = this.getQName();
        int n = string.indexOf(58);
        String string2 = "";
        if (n > 0) {
            string2 = string.substring(0, n);
        }
        return this.getNamespace(string2);
    }

    public String getPrefix(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string.intern();
        Namespace namespace = this.getNamespaceChain();
        while (namespace != null) {
            if (namespace.uri == string2) {
                return namespace.prefix;
            }
            namespace = namespace.next;
        }
        return null;
    }

    public String getNamespace(String string) {
        String string2 = string.intern();
        if (string2 == "xml") {
            return "http://www.w3.org/XML/1998/namespace";
        }
        Namespace namespace = this.getNamespaceChain();
        while (namespace != null) {
            if (namespace.prefix == string2) {
                return namespace.uri;
            }
            namespace = namespace.next;
        }
        return "";
    }

    public Namespace getNamespaceChain() {
        this.recalcNamespaceChain();
        return this.chain;
    }

    private boolean recalcNamespaceChain() {
        boolean bl = false;
        if (this.parent != null && this.parent.recalcNamespaceChain() || this.chain == null) {
            this.calcNamespaceChain();
            bl = true;
        }
        return bl;
    }

    private void calcNamespaceChain() {
        Namespace namespace = this.parent != null ? this.parent.chain : TAIL;
        List list = this.getAttributeList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!iterator.hasNext()) break;
            String string2 = (String)iterator.next();
            if (string2 == null) {
                string2 = string;
            }
            string2 = string2.intern();
            if (!string.startsWith(XMLNS)) continue;
            if (string.length() == XMLNS_LEN) {
                namespace = new Namespace("", string2, namespace);
                continue;
            }
            if (string.charAt(XMLNS_LEN) != ':') continue;
            namespace = new Namespace(string.substring(XMLNS_LEN + 1).intern(), string2, namespace);
        }
        this.chain = namespace;
    }

    public String getLocalname() {
        String string = this.getQName();
        int n = string.indexOf(58);
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    public String getSquirrlyName() {
        String string;
        String string2 = this.getQName();
        String string3 = "";
        String string4 = string2;
        int n = string2.indexOf(58);
        if (n >= 0) {
            string3 = string2.substring(0, n);
            string4 = string2.substring(n + 1);
        }
        if ((string = this.getNamespace(string3)) == null) {
            return string2;
        }
        return "{" + string + '}' + string4;
    }

    public QName getQName(QName qName) {
        return this.getQName(this.getQName(), qName);
    }

    public QName getQName(String string, QName qName) {
        if (qName == null) {
            qName = new QName();
        }
        String string2 = "";
        qName.localname = string;
        int n = string.indexOf(58);
        if (n >= 0) {
            string2 = string.substring(0, n);
            qName.localname = string.substring(n + 1);
        }
        qName.namespace = this.getNamespace(string2);
        return qName;
    }

    public String getOutlineName() {
        return this.getOutlineName(this.document);
    }

    public String toString() {
        return this.getOutlineName(this.document);
    }

    public String getTagStart() {
        switch (XMLConstants.getIntType(this.getType())) {
            case 2: 
            case 3: {
                return "<" + this.get(this.getTagNameRegion(1));
            }
            case 4: {
                return "</" + this.get(this.getTagNameRegion(2));
            }
            case 8: {
                return "<?" + this.get(this.getTagNameRegion(2));
            }
            case 7: 
            case 17: {
                return "<!DOCTYPE";
            }
            case 18: {
                return this.get((IRegion)new Region(this.offset, 1));
            }
            case 0: {
                return "<!--";
            }
            case 1: {
                return "<";
            }
            case 9: {
                return this.get((IRegion)new Region(this.offset, 2));
            }
            case 11: {
                return this.getContents();
            }
            case 16: {
                return "<[[";
            }
            case 19: {
                return "<!NOTATION";
            }
            case 5: {
                return "<![CDATA[";
            }
            case 6: {
                return "<?xml";
            }
            case 10: {
                return this.get((IRegion)new Region(this.offset, 3));
            }
            case 12: {
                return "<!ENTITY";
            }
            case 13: {
                return "<!ENTITY";
            }
            case 14: {
                return "<!ELEMENT";
            }
            case 15: {
                return "<!ATTLIST";
            }
            case 20: 
            case 21: {
                return this.getContents();
            }
        }
        throw new IllegalStateException("Node type " + this.getType() + " not handled");
    }

    public String getTagEnd() {
        switch (XMLConstants.getIntType(this.getType())) {
            case 2: 
            case 4: 
            case 7: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: {
                return ">";
            }
            case 3: {
                return "/>";
            }
            case 6: 
            case 8: {
                return "?>";
            }
            case 17: {
                return "[";
            }
            case 18: {
                return "]>";
            }
            case 0: {
                return "-->";
            }
            case 1: 
            case 11: 
            case 16: {
                return "";
            }
            case 9: 
            case 10: {
                return "%>";
            }
            case 5: {
                return "]]>";
            }
            case 20: 
            case 21: {
                return "";
            }
        }
        throw new IllegalStateException("Node type " + this.getType() + " not handled");
    }

    private String get(IRegion iRegion) {
        try {
            return this.document.get(iRegion.getOffset(), iRegion.getLength());
        }
        catch (BadLocationException badLocationException) {
            XMLPlugin.log(badLocationException);
            return "";
        }
    }

    public IRegion getHighlightRegion() {
        switch (XMLConstants.getIntType(this.getType())) {
            case 2: 
            case 3: {
                return this.getTagNameRegion(1);
            }
            case 4: 
            case 8: {
                return this.getTagNameRegion(2);
            }
            case 7: 
            case 17: {
                return new Region(this.offset, "<!DOCTYPE".length());
            }
            case 18: {
                return new Region(this.offset, 1);
            }
            case 0: {
                return new Region(this.offset, "<!--".length());
            }
            case 1: {
                return new Region(this.offset, 1);
            }
            case 9: {
                return new Region(this.offset, 2);
            }
            case 11: {
                return new Region(this.offset, this.length);
            }
            case 16: {
                return new Region(this.offset, "<[[".length());
            }
            case 19: {
                return new Region(this.offset, "<!NOTATION".length());
            }
            case 5: {
                return new Region(this.offset, "<![CDATA[".length());
            }
            case 6: {
                return new Region(this.offset + 2, "xml".length());
            }
            case 10: {
                return new Region(this.offset, 3);
            }
            case 12: {
                return this.getSTagRegion("<!ENTITY".length());
            }
            case 13: {
                return this.getEntityDeclRegion();
            }
            case 14: {
                return this.getSTagRegion("<!ELEMENT".length());
            }
            case 15: {
                return this.getSTagRegion("<!ATTLIST".length());
            }
            case 20: 
            case 21: {
                return new Region(this.offset + 1, this.getLength() - 2);
            }
        }
        throw new IllegalStateException("Node type " + this.getType() + " not handled");
    }

    private IRegion getEntityDeclRegion() {
        String string = this.getContents();
        int n = "<!ENTITY".length();
        int n2 = string.length();
        int n3 = n;
        char c = '\u0000';
        while (n3 < n2 && XMLCharacter.isWhitespace((char)(c = string.charAt(n3)))) {
            ++n3;
        }
        if (n3 < n2 && c == '%') {
            ++n3;
            while (n3 < n2 && XMLCharacter.isWhitespace((char)(c = string.charAt(n3)))) {
                ++n3;
            }
            if (n3 < n2) {
                String string2 = this.getTagName(string, n3);
                return new Region(this.offset + n3, string2.length());
            }
        }
        return new Region(this.offset, n);
    }

    private IRegion getSTagRegion(int n) {
        String string = this.getContents();
        int n2 = string.length();
        while (n < n2) {
            if (!XMLCharacter.isWhitespace((char)string.charAt(n))) {
                String string2 = this.getTagName(string, n);
                return new Region(this.offset + n, string2.length());
            }
            ++n;
        }
        return new Region(0, n);
    }

    private IRegion getTagNameRegion(int n) {
        return new Region(this.offset + n, this.getTagName(this.getContents(), n).length());
    }

    public String getQName(IAbstractDocument iAbstractDocument) {
        switch (XMLConstants.getIntType(this.getType())) {
            case 2: 
            case 3: {
                return this.getTagName(iAbstractDocument, 1);
            }
            case 4: 
            case 8: {
                return this.getTagName(iAbstractDocument, 2);
            }
            case 7: 
            case 17: {
                return this.getSTagName(iAbstractDocument, "<!DOCTYPE".length());
            }
            case 0: 
            case 1: 
            case 9: 
            case 11: 
            case 16: 
            case 18: 
            case 19: {
                return "";
            }
            case 5: {
                return "CDATA";
            }
            case 6: {
                return "xml";
            }
            case 10: {
                return this.getTagName(iAbstractDocument, 3);
            }
            case 12: {
                return this.getSTagName(iAbstractDocument, "<!ENTITY".length());
            }
            case 13: {
                return this.getEntityDeclName(iAbstractDocument);
            }
            case 14: {
                return this.getSTagName(iAbstractDocument, "<!ELEMENT".length());
            }
            case 15: {
                return this.getSTagName(iAbstractDocument, "<!ATTLIST".length());
            }
            case 20: 
            case 21: {
                return this.getEntityName(iAbstractDocument);
            }
        }
        throw new IllegalStateException("Node type " + this.getType() + " not handled");
    }

    public String getOutlineName(IAbstractDocument iAbstractDocument) {
        switch (XMLConstants.getIntType(this.getType())) {
            case 2: 
            case 3: {
                return this.getOutlineName(iAbstractDocument, 1);
            }
            case 4: 
            case 8: {
                return this.getTagName(iAbstractDocument, 2);
            }
            case 7: 
            case 17: {
                return this.getSTagName(iAbstractDocument, "<!DOCTYPE".length());
            }
            case 0: 
            case 1: 
            case 9: 
            case 11: 
            case 16: 
            case 18: 
            case 19: {
                return "";
            }
            case 5: {
                return "CDATA";
            }
            case 6: {
                return "xml";
            }
            case 10: {
                return this.getTagName(iAbstractDocument, 3);
            }
            case 12: {
                return this.getSTagName(iAbstractDocument, "<!ENTITY".length());
            }
            case 13: {
                return this.getEntityDeclName(iAbstractDocument);
            }
            case 14: {
                return this.getSTagName(iAbstractDocument, "<!ELEMENT".length());
            }
            case 15: {
                return this.getSTagName(iAbstractDocument, "<!ATTLIST".length());
            }
            case 20: 
            case 21: {
                return this.getEntityName(iAbstractDocument);
            }
        }
        throw new IllegalStateException("Node type " + this.getType() + " not handled");
    }

    private String getSTagName(IAbstractDocument iAbstractDocument, int n) {
        return this.getSTagName(this.getContents(iAbstractDocument), n);
    }

    private String getSTagName(String string, int n) {
        int n2 = string.length();
        while (n < n2) {
            if (!XMLCharacter.isWhitespace((char)string.charAt(n))) {
                return this.getTagName(string, n);
            }
            ++n;
        }
        return "";
    }

    private String getTagName(IAbstractDocument iAbstractDocument, int n) {
        return this.getTagName(this.getContents(iAbstractDocument), n);
    }

    private String getTagName(String string, int n) {
        char c;
        int n2 = string.length();
        StringBuffer stringBuffer = new StringBuffer();
        if (n < n2 && XMLCharacter.isIDStart((char)(c = string.charAt(n)))) {
            stringBuffer.append(c);
            while (++n < n2) {
                c = string.charAt(n);
                if (!XMLCharacter.isIDPart((char)c)) break;
                stringBuffer.append(c);
            }
        }
        return stringBuffer.toString();
    }

    private String getOutlineName(IAbstractDocument iAbstractDocument, int n) {
        return this.getOutlineName(this.getContents(iAbstractDocument), n);
    }

    private String getOutlineName(String string, int n) {
        Object object;
        char c;
        int n2 = string.length();
        char c2 = '\u0000';
        StringBuffer stringBuffer = new StringBuffer();
        if (n < n2 && XMLCharacter.isIDStart((char)(c2 = string.charAt(n)))) {
            stringBuffer.append(c2);
            while (++n < n2) {
                c2 = string.charAt(n);
                if (!XMLCharacter.isIDPart((char)c2)) break;
                stringBuffer.append(c2);
            }
        }
        int n3 = stringBuffer.length();
        if (XMLEditor.getAttrOutline()) {
            while (n < n2 && XMLCharacter.isWhitespace((char)(c2 = string.charAt(n)))) {
                ++n;
            }
            if (n < n2 && XMLCharacter.isIDStart((char)c2)) {
                ++n;
                while (n < n2 && XMLCharacter.isIDPart((char)(c2 = string.charAt(n)))) {
                    ++n;
                }
                while (n < n2 && XMLCharacter.isWhitespace((char)(c2 = string.charAt(n)))) {
                    ++n;
                }
                if (n < n2 && c2 == '=') {
                    ++n;
                    while (n < n2 && XMLCharacter.isWhitespace((char)(c2 = string.charAt(n)))) {
                        ++n;
                    }
                    if (n < n2 && (c2 == '\'' || c2 == '\"')) {
                        c = c2;
                        ++n;
                        stringBuffer.append(' ');
                        object = new StringBuffer();
                        while (n < n2 && (c2 = string.charAt(n)) != c) {
                            ((StringBuffer)object).append(c2);
                            ++n;
                        }
                        this.getTokens(((StringBuffer)object).toString(), 0, 0, stringBuffer);
                        if (stringBuffer.length() - n3 > 30) {
                            this.truncate(stringBuffer, 30);
                        }
                        if (stringBuffer.length() == n3 + 1) {
                            stringBuffer.setLength(n3);
                        }
                    }
                }
            }
        }
        if (stringBuffer.length() == n3 && XMLEditor.getTextOutline()) {
            c = '\u0000';
            stringBuffer.append(' ');
            object = this.getFirstChild();
            while (object != null) {
                String string2;
                if (object.getType() == "com.objfac.xmltext") {
                    string2 = ((XMLNode)object).getContents();
                    c = this.getTokens(string2, 0, c, stringBuffer);
                } else if (object.getType() == "com.objfac.xmlcdata") {
                    string2 = ((XMLNode)object).getContents();
                    int n4 = string2.length();
                    if (string2.endsWith("]]>")) {
                        n4 -= "]]>".length();
                    }
                    c = this.getTokens(string2, "<![CDATA[".length(), n4, c, stringBuffer);
                }
                if (stringBuffer.length() - n3 > 30) {
                    this.truncate(stringBuffer, 30);
                    break;
                }
                if (c == '\u0003') break;
                object = ((XMLNode)object).getNextSibling();
            }
            if (stringBuffer.length() == n3 + 1) {
                stringBuffer.setLength(n3);
            }
        }
        return stringBuffer.toString();
    }

    private void truncate(StringBuffer stringBuffer, int n) {
        stringBuffer.setLength(n - 3);
        while (stringBuffer.length() > 0 && stringBuffer.charAt(stringBuffer.length() - 1) == ' ') {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        stringBuffer.append("...");
    }

    private int getTokens(String string, int n, int n2, StringBuffer stringBuffer) {
        return this.getTokens(string, n, string.length(), n2, stringBuffer);
    }

    /*
     * Unable to fully structure code
     */
    private int getTokens(String var1_1, int var2_2, int var3_3, int var4_4, StringBuffer var5_5) {
        var6_6 = var3_3;
        ** GOTO lbl15
        {
            ++var2_2;
            do {
                if (var2_2 < var6_6 && XMLCharacter.isWhitespace((char)var1_1.charAt(var2_2))) continue block0;
                if (var2_2 < var6_6) {
                    var5_5.append(' ');
                }
                while (var2_2 < var6_6 && !XMLCharacter.isWhitespace((char)var1_1.charAt(var2_2))) {
                    var5_5.append(var1_1.charAt(var2_2));
                    ++var2_2;
                }
                ++var4_4;
lbl15:
                // 2 sources

            } while (var2_2 < var6_6 && var4_4 < 3);
        }
        return var4_4;
    }

    private String getEntityDeclName(IAbstractDocument iAbstractDocument) {
        String string = this.getContents(iAbstractDocument);
        int n = "<!ENTITY".length();
        int n2 = string.length();
        while (n < n2) {
            char c = string.charAt(n);
            if (!XMLCharacter.isWhitespace((char)c)) {
                if (c == '%') {
                    return this.getSTagName(string, n + 1);
                }
                return this.getTagName(string, n);
            }
            ++n;
        }
        return "";
    }

    private String getEntityName(IAbstractDocument iAbstractDocument) {
        String string = this.getContents(iAbstractDocument);
        StringBuffer stringBuffer = new StringBuffer();
        int n = 1;
        int n2 = string.length();
        while (n < n2) {
            char c = string.charAt(n);
            if (c == ';') break;
            stringBuffer.append(c);
            ++n;
        }
        return stringBuffer.toString();
    }

    private String getContents(IAbstractDocument iAbstractDocument) {
        try {
            return iAbstractDocument.get(this.getOffset(), this.getLength());
        }
        catch (BadLocationException badLocationException) {
            XMLPlugin.log(badLocationException);
            return "";
        }
    }

    public String getContents() {
        return this.getContents(this.document);
    }

    public boolean equals(Object object) {
        return object == this;
    }

    public int hashCode() {
        return this.getUniqueId();
    }

    public int getUniqueId() {
        return this.hash;
    }

    public Map getAttributes() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        List list = this.getAttributeList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!iterator.hasNext()) break;
            String string2 = (String)iterator.next();
            if (string2 == null) {
                hashMap.put(string, string);
                continue;
            }
            hashMap.put(string, string2);
        }
        return hashMap;
    }

    public List getAttributeList() {
        if (this.attlist == null) {
            String string = this.getContents(this.document);
            this.attoffs = new LinkedList();
            char[] cArray = string.toCharArray();
            int n = 0;
            this.attlist = TagParser.getAttributeList((char[])cArray, (int)n, (int)cArray.length, (List)this.attoffs);
        }
        return this.attlist;
    }

    public String[] getAttributeArray() {
        if (this.attarray == null) {
            String string = this.getContents(this.document);
            char[] cArray = string.toCharArray();
            int n = 0;
            this.attarray = TagParser.getAttributeArray((char[])cArray, (int)n, (int)cArray.length);
        }
        return this.attarray;
    }

    public String getAttributeValue(String string) {
        List list = this.getAttributeList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String string3 = (String)iterator.next();
            if (!string.equals(string2)) continue;
            if (string3 == null) {
                return string;
            }
            return string3;
        }
        return null;
    }

    public List getAttributeOffsets() {
        if (this.attoffs == null) {
            String string = this.getContents(this.document);
            this.attoffs = new LinkedList();
            char[] cArray = string.toCharArray();
            this.attlist = TagParser.getAttributeList((char[])cArray, (int)0, (int)cArray.length, (List)this.attoffs);
        }
        return this.attoffs;
    }

    public int getAttributeOffset(String string) {
        List list = this.getAttributeOffsets();
        List list2 = this.getAttributeList();
        Iterator iterator = list2.iterator();
        Iterator iterator2 = list.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String cfr_ignored_0 = (String)iterator.next();
            Integer n = (Integer)iterator2.next();
            if (!string.equals(string2)) continue;
            return n;
        }
        return -1;
    }

    public AttributeData[] getAttributeData() {
        int n = 0;
        int n2 = 1;
        LinkedList<AttributeData> linkedList = new LinkedList<AttributeData>();
        block0: while (n++ < n2) {
            List list = this.getAttributeOffsets();
            List list2 = this.getAttributeList();
            Iterator iterator = list2.iterator();
            Iterator iterator2 = list.iterator();
            String string = this.getContents();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                String string3 = (String)iterator.next();
                Integer n3 = (Integer)iterator2.next();
                AttributeData attributeData = new AttributeData();
                attributeData.name = string2;
                attributeData.value = string3;
                attributeData.nameBeg = n3;
                int n4 = attributeData.nameEnd = attributeData.nameBeg + string2.length();
                int n5 = string.length();
                while (n4 < n5 && XMLCharacter.isWhitespace((char)string.charAt(n4))) {
                    ++n4;
                }
                attributeData.quoteBeg = attributeData.quoteEnd = n4;
                if (n4 < n5 && string.charAt(n4) == '=') {
                    attributeData.equalOffset = n4++;
                    while (n4 < n5 && XMLCharacter.isWhitespace((char)string.charAt(n4))) {
                        ++n4;
                    }
                    char c = '\u0000';
                    if (n4 < n5 && ((c = string.charAt(n4)) == '\'' || c == '\"')) {
                        attributeData.quoteBeg = n4++;
                        while (n4 < n5 && string.charAt(n4) != c) {
                            ++n4;
                        }
                        attributeData.quoteEnd = ++n4;
                        if (string3.length() != attributeData.quoteEnd - attributeData.quoteBeg - 2) {
                            this.attoffs = null;
                            this.attlist = null;
                            this.attarray = null;
                            linkedList = new LinkedList();
                            if (n != 1) continue block0;
                            n2 = 2;
                            continue block0;
                        }
                    }
                }
                linkedList.add(attributeData);
            }
        }
        return linkedList.toArray(new AttributeData[linkedList.size()]);
    }

    private AttributeData[] calcDataFromScratch() {
        new LinkedList();
        this.getContents();
        return null;
    }

    public AttributeData getAttributeData(String string) {
        AttributeData attributeData = null;
        List list = this.getAttributeOffsets();
        List list2 = this.getAttributeList();
        Iterator iterator = list2.iterator();
        Iterator iterator2 = list.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String string3 = (String)iterator.next();
            Integer n = (Integer)iterator2.next();
            if (!string.equals(string2)) continue;
            attributeData = new AttributeData();
            attributeData.name = string2;
            attributeData.value = string3;
            attributeData.nameBeg = n;
            int n2 = attributeData.nameEnd = attributeData.nameBeg + string.length();
            String string4 = this.getContents();
            int n3 = string4.length();
            while (n2 < n3 && XMLCharacter.isWhitespace((char)string4.charAt(n2))) {
                ++n2;
            }
            if (n2 == n3 || string4.charAt(n2) != '=') break;
            attributeData.equalOffset = n2++;
            while (n2 < n3 && XMLCharacter.isWhitespace((char)string4.charAt(n2))) {
                ++n2;
            }
            char c = '\u0000';
            if (n2 == n3 || (c = string4.charAt(n2)) != '\'' && c != '\"') break;
            attributeData.quoteBeg = n2++;
            while (n2 < n3 && string4.charAt(n2) != c) {
                ++n2;
            }
            if (n2 == n3) break;
            attributeData.quoteEnd = ++n2;
            break;
        }
        return attributeData;
    }

    public AttributeData findAttributeValue(int n) {
        List list = this.getAttributeList();
        Iterator iterator = list.iterator();
        List list2 = this.getAttributeOffsets();
        Iterator iterator2 = list2.iterator();
        AttributeData attributeData = null;
        int n2 = -1;
        int n3 = -1;
        while (iterator2.hasNext()) {
            Integer n4 = (Integer)iterator2.next();
            n3 = n4;
            if (n3 > n) break;
            ++n2;
        }
        int n5 = 0;
        while (n5 <= n2) {
            String string = (String)iterator.next();
            String string2 = (String)iterator.next();
            if (n5 == n2) {
                char c;
                AttributeData attributeData2 = new AttributeData();
                attributeData2.name = string;
                attributeData2.value = string2;
                attributeData2.nameBeg = n3;
                attributeData2.nameEnd = attributeData2.nameBeg + attributeData2.name.length();
                String string3 = this.getContents();
                int n6 = attributeData2.nameEnd;
                int n7 = string3.length();
                if ((n6 = Util.skipWhitespace((String)string3, (int)n6, (int)n7)) >= n || !Util.isChar((char)'=', (String)string3, (int)n6, (int)n7)) break;
                attributeData2.equalOffset = n6++;
                if ((n6 = Util.skipWhitespace((String)string3, (int)n6, (int)n7)) >= n7 || (c = string3.charAt(n6)) != '\'' && c != '\"') break;
                attributeData2.quoteBeg = n6++;
                if ((n6 = Util.skipToChar((char)c, (String)string3, (int)n6, (int)n7)) >= n7) break;
                attributeData2.quoteEnd = ++n6;
                if (!Util.outRange((int)n, (int)attributeData2.quoteBeg, (int)attributeData2.quoteEnd)) break;
                attributeData = attributeData2;
                break;
            }
            ++n5;
        }
        return attributeData;
    }

    public void dumpElements(String string) {
        XMLNode xMLNode = this;
        while (xMLNode != null) {
            String string2 = xMLNode.getType();
            if (string2 == "com.objfac.xmlstarttag") {
                this.dumpElement(xMLNode, string);
                this.dumpChildren(xMLNode, String.valueOf(string) + "  ");
                System.out.println(String.valueOf(string) + "</" + xMLNode.getQName() + ">");
            } else if (string2 == "com.objfac.xmlemptytag") {
                this.dumpElement(xMLNode, string);
            }
            xMLNode = xMLNode.nextSibling;
        }
    }

    private void dumpChildren(XMLNode xMLNode, String string) {
        XMLNode xMLNode2 = xMLNode.firstChild;
        if (xMLNode2 != null) {
            xMLNode2.dumpElements(string);
        }
    }

    private void dumpElement(XMLNode xMLNode, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string).append('<').append(xMLNode.getQName());
        List list = xMLNode.getAttributeList();
        if (list.size() > 0) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (!iterator.hasNext()) break;
                String string3 = (String)iterator.next();
                stringBuffer.append(' ').append(string2).append("='").append(string3).append("'");
            }
        }
        if (xMLNode.firstChild == null) {
            stringBuffer.append('/');
        }
        stringBuffer.append('>');
        System.out.println(stringBuffer.toString());
    }

    public XMLNode getFirstChild() {
        return this.firstChild;
    }

    public IXMLNode firstChild() {
        return this.firstChild;
    }

    public XMLNode getFirstElementChild() {
        XMLNode xMLNode = this.getFirstChild();
        if (xMLNode != null) {
            xMLNode = xMLNode.getSiblingElement();
        }
        return xMLNode;
    }

    public XMLNode getLastChild() {
        return this.lastChild;
    }

    public XMLNode getNextSibling() {
        return this.nextSibling;
    }

    public IXMLNode nextSibling() {
        return this.nextSibling;
    }

    public XMLNode getNextElementSibling() {
        XMLNode xMLNode = this.getNextSibling();
        if (xMLNode != null) {
            xMLNode = xMLNode.getSiblingElement();
        }
        return xMLNode;
    }

    public XMLNode getPrevSibling() {
        XMLNode xMLNode = null;
        if (this.parent != null) {
            XMLNode xMLNode2 = this.parent.firstChild;
            while (xMLNode2 != this) {
                xMLNode = xMLNode2;
                xMLNode2 = xMLNode2.nextSibling;
            }
        }
        return xMLNode;
    }

    public XMLNode getParent() {
        return this.parent;
    }

    public XMLNode getSiblingElement() {
        XMLNode xMLNode = this;
        while (xMLNode != null && !xMLNode.isElement()) {
            xMLNode = xMLNode.getNextSibling();
        }
        return xMLNode;
    }

    public boolean isElement() {
        String string = this.getType();
        return string == "com.objfac.xmlstarttag" || string == "com.objfac.xmlemptytag";
    }

    public boolean isText() {
        return this.getType() == "com.objfac.xmltext";
    }

    public String getTextContents() {
        String string = this.getType();
        if (string != "com.objfac.xmlstarttag") {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        XMLNode xMLNode = this.getFirstChild();
        while (xMLNode != null) {
            String string2 = xMLNode.getType();
            if (string2 == "com.objfac.xmltext") {
                stringBuffer.append(xMLNode.getContents());
            } else if (string2 == "com.objfac.xmlcdata") {
                int n;
                String string3 = xMLNode.getContents();
                int n2 = string3.length();
                int n3 = "<![CDATA[".length();
                int n4 = n = string3.endsWith("]]>") ? n2 - "]]>".length() : n2;
                if (n3 < n) {
                    stringBuffer.append(string3.substring(n3, n));
                }
            }
            xMLNode = xMLNode.getNextSibling();
        }
        return stringBuffer.toString();
    }

    public String getNormalizedTextContents() {
        return Util.normalizeWs((String)this.getTextContents());
    }

    public String getNormalizedAttributeValue(String string) {
        String string2 = this.getAttributeValue(string);
        if (string2 == null) {
            return null;
        }
        return Util.normalizeWs((String)string2);
    }

    public static class Namespace {
        public String prefix;
        public String uri;
        public Namespace next;

        Namespace(String string, String string2, Namespace namespace) {
            this.prefix = string;
            this.uri = string2;
            this.next = namespace;
        }
    }

    private class GetHighlightRegion
    extends XMLTypeFunction {
        GetHighlightRegion() {
        }

        public Region getRegion(String string) {
            return (Region)this.accept(string);
        }

        public Object acceptComment() {
            return new Region(XMLNode.this.offset, "<!--".length());
        }

        public Object acceptTag() {
            return new Region(XMLNode.this.offset, 1);
        }

        public Object acceptStartTag() {
            return XMLNode.this.getTagNameRegion(1);
        }

        public Object acceptEmptyTag() {
            return XMLNode.this.getTagNameRegion(1);
        }

        public Object acceptEndTag() {
            return XMLNode.this.getTagNameRegion(2);
        }

        public Object acceptCData() {
            return new Region(XMLNode.this.offset, "<![CDATA[".length());
        }

        public Object acceptXmlDecl() {
            return new Region(XMLNode.this.offset + 2, "xml".length());
        }

        public Object acceptDoctype() {
            return new Region(XMLNode.this.offset, "<!DOCTYPE".length());
        }

        public Object acceptPI() {
            return XMLNode.this.getTagNameRegion(2);
        }

        public Object acceptJasp() {
            return new Region(XMLNode.this.offset, 2);
        }

        public Object acceptJaspDecl() {
            return new Region(XMLNode.this.offset, 3);
        }

        public Object acceptText() {
            return new Region(XMLNode.this.offset, XMLNode.this.length);
        }

        public Object acceptGEntity() {
            return new Region(XMLNode.this.offset + 1, XMLNode.this.getLength() - 2);
        }

        public Object acceptPEntity() {
            return new Region(XMLNode.this.offset + 1, XMLNode.this.getLength() - 2);
        }

        public Object acceptElement() {
            return XMLNode.this.getSTagRegion("<!ELEMENT".length());
        }

        public Object acceptAttlist() {
            return XMLNode.this.getSTagRegion("<!ATTLIST".length());
        }

        public Object acceptInclude() {
            return new Region(XMLNode.this.offset, "<[[".length());
        }

        public Object acceptDoctypeStart() {
            return new Region(XMLNode.this.offset, "<!DOCTYPE".length());
        }

        public Object acceptDoctypeEnd() {
            return new Region(XMLNode.this.offset, 1);
        }

        public Object acceptNotation() {
            return new Region(XMLNode.this.offset, "<!NOTATION".length());
        }

        public Object acceptGEntityRef() {
            return new Region(XMLNode.this.offset + 1, XMLNode.this.getLength() - 2);
        }

        public Object acceptPEntityRef() {
            return new Region(XMLNode.this.offset + 1, XMLNode.this.getLength() - 2);
        }
    }

    public static class AttributeData {
        public String name;
        public String value;
        public int nameBeg;
        public int nameEnd;
        public int equalOffset = -1;
        public int quoteBeg = -1;
        public int quoteEnd = -1;
    }
}

