/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor.xpath;

import com.objfac.util.UnimplementedException;
import com.objfac.xml.schema.QName;
import com.objfac.xmleditor.xmltree.XMLNode;
import com.objfac.xmleditor.xmltree.XMLTree;
import com.objfac.xmleditor.xpath.DocumentFinder;
import com.objfac.xmleditor.xpath.TreeMapEntry;
import com.objfac.xmleditor.xpath.XMLAttr;
import com.objfac.xmleditor.xpath.XMLDoc;
import com.objfac.xmleditor.xpath.XMLXPath;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.MultiStatus;
import org.jaxen.DefaultNavigator;
import org.jaxen.FunctionCallException;
import org.jaxen.UnsupportedAxisException;
import org.jaxen.XPath;
import org.saxpath.SAXPathException;

public class DocumentNavigator
extends DefaultNavigator {
    private DocumentFinder finder;
    private String url;
    private HashMap treemap;
    private HashMap rootmap;
    private static final Iterator EMPTY = new EmptyIterator();

    public DocumentNavigator(DocumentFinder documentFinder) {
        this.finder = documentFinder;
    }

    public XMLTree setDocument(IFile iFile, MultiStatus multiStatus) {
        this.treemap = new HashMap();
        this.rootmap = new HashMap();
        TreeMapEntry treeMapEntry = this.mapEntry(this.finder.findDocument(iFile, multiStatus));
        if (treeMapEntry != null) {
            this.url = treeMapEntry.url;
        }
        return treeMapEntry == null ? null : treeMapEntry.tree;
    }

    private TreeMapEntry mapEntry(TreeMapEntry treeMapEntry) {
        if (treeMapEntry != null) {
            this.treemap.put(treeMapEntry.tree, treeMapEntry);
            this.treemap.put(treeMapEntry.url, treeMapEntry);
            XMLNode xMLNode = treeMapEntry.tree.getRoot();
            if (xMLNode != null) {
                this.rootmap.put(xMLNode, treeMapEntry);
            }
        }
        return treeMapEntry;
    }

    public DocumentNavigator(XMLTree xMLTree, String string) {
        this.treemap = new HashMap();
        this.rootmap = new HashMap();
        TreeMapEntry treeMapEntry = new TreeMapEntry(xMLTree, string);
        this.treemap.put(xMLTree, treeMapEntry);
        this.treemap.put(string, treeMapEntry);
        XMLNode xMLNode = treeMapEntry.tree.getRoot();
        if (xMLNode != null) {
            this.rootmap.put(xMLNode, treeMapEntry);
        }
    }

    public Iterator getChildAxisIterator(Object object) throws UnsupportedAxisException {
        if (object instanceof XMLTree) {
            return new ChildIterator(((XMLTree)object).getRoot());
        }
        if (object instanceof XMLNode) {
            return new ChildIterator(((XMLNode)object).getFirstChild());
        }
        return EMPTY;
    }

    public Iterator getParentAxisIterator(Object object) throws UnsupportedAxisException {
        if (object instanceof XMLTree) {
            return new ParentIterator(null);
        }
        if (object instanceof XMLNode) {
            XMLNode xMLNode = (XMLNode)object;
            Object object2 = xMLNode.getParent();
            if (object2 == null) {
                TreeMapEntry treeMapEntry = (TreeMapEntry)this.rootmap.get(xMLNode);
                object2 = treeMapEntry.tree;
            }
            return new ParentIterator(object2);
        }
        if (object instanceof XMLAttr) {
            XMLAttr xMLAttr = (XMLAttr)object;
            XMLNode xMLNode = xMLAttr.getParent();
            return new ParentIterator(xMLNode);
        }
        return EMPTY;
    }

    public Iterator getAttributeAxisIterator(Object object) throws UnsupportedAxisException {
        XMLNode xMLNode;
        String string;
        if (object instanceof XMLNode && ((string = (xMLNode = (XMLNode)object).getType()) == "com.objfac.xmlstarttag" || string == "com.objfac.xmlemptytag")) {
            List list = xMLNode.getAttributeList();
            List list2 = xMLNode.getAttributeOffsets();
            Iterator iterator = list.iterator();
            Iterator iterator2 = list2.iterator();
            ArrayList<XMLAttr> arrayList = new ArrayList<XMLAttr>(list.size() / 2);
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                Integer n = (Integer)iterator2.next();
                if (!iterator.hasNext()) break;
                String string3 = (String)iterator.next();
                if (string2.startsWith("xmlns")) continue;
                int n2 = xMLNode.getOffset() + n;
                if (string2.indexOf(58) >= 0) {
                    QName qName = xMLNode.getQName(string2, null);
                    arrayList.add(new XMLAttr(xMLNode, qName.namespace, qName.localname, string2, string3, n2));
                    continue;
                }
                arrayList.add(new XMLAttr(xMLNode, "", string2, string2, string3, n2));
            }
            return new ArrayListIterator(arrayList);
        }
        return EMPTY;
    }

    public Iterator getNamespaceAxisIterator(Object object) throws UnsupportedAxisException {
        XMLNode xMLNode;
        String string;
        if (object instanceof XMLNode && ((string = (xMLNode = (XMLNode)object).getType()) == "com.objfac.xmlstarttag" || string == "com.objfac.xmlemptytag")) {
            ArrayList<XMLNode.Namespace> arrayList = new ArrayList<XMLNode.Namespace>();
            HashSet<String> hashSet = new HashSet<String>();
            XMLNode.Namespace namespace = xMLNode.getNamespaceChain();
            while (namespace != null) {
                if (!hashSet.contains(namespace.prefix)) {
                    arrayList.add(namespace);
                    hashSet.add(namespace.prefix);
                }
                namespace = namespace.next;
            }
            return new ArrayListIterator(arrayList);
        }
        return EMPTY;
    }

    public String getElementNamespaceUri(Object object) {
        XMLNode xMLNode = (XMLNode)object;
        return xMLNode.getNamespace();
    }

    public String getElementName(Object object) {
        XMLNode xMLNode = (XMLNode)object;
        return xMLNode.getLocalname();
    }

    public String getElementQName(Object object) {
        XMLNode xMLNode = (XMLNode)object;
        return xMLNode.getQName();
    }

    public String getAttributeNamespaceUri(Object object) {
        XMLAttr xMLAttr = (XMLAttr)object;
        return xMLAttr.getNamespace();
    }

    public String getAttributeName(Object object) {
        XMLAttr xMLAttr = (XMLAttr)object;
        return xMLAttr.getLocalname();
    }

    public String getAttributeQName(Object object) {
        XMLAttr xMLAttr = (XMLAttr)object;
        return xMLAttr.getQName();
    }

    public boolean isDocument(Object object) {
        return object instanceof XMLDoc;
    }

    public boolean isElement(Object object) {
        if (!(object instanceof XMLNode)) {
            return false;
        }
        XMLNode xMLNode = (XMLNode)object;
        String string = xMLNode.getType();
        return string == "com.objfac.xmlstarttag" || string == "com.objfac.xmlemptytag";
    }

    public boolean isAttribute(Object object) {
        return object instanceof XMLAttr;
    }

    public boolean isNamespace(Object object) {
        return object instanceof XMLNode.Namespace;
    }

    public boolean isComment(Object object) {
        if (!(object instanceof XMLNode)) {
            return false;
        }
        XMLNode xMLNode = (XMLNode)object;
        String string = xMLNode.getType();
        return string == "com.objfac.xmlcomment";
    }

    public boolean isText(Object object) {
        if (!(object instanceof XMLNode)) {
            return false;
        }
        XMLNode xMLNode = (XMLNode)object;
        String string = xMLNode.getType();
        return string == "com.objfac.xmltext" || string == "com.objfac.xmlcdata";
    }

    public boolean isProcessingInstruction(Object object) {
        if (!(object instanceof XMLNode)) {
            return false;
        }
        XMLNode xMLNode = (XMLNode)object;
        String string = xMLNode.getType();
        return string == "com.objfac.xmlpi";
    }

    public String getCommentStringValue(Object object) {
        XMLNode xMLNode = (XMLNode)object;
        String string = xMLNode.getContents();
        int n = "<!--".length();
        int n2 = string.length();
        if (string.endsWith("-->")) {
            n2 -= "-->".length();
        } else if (string.endsWith("--")) {
            n2 -= "--".length();
        } else if (string.endsWith("-")) {
            n2 -= "-".length();
        }
        return string.substring(n, n2);
    }

    public String getElementStringValue(Object object) {
        XMLNode xMLNode = (XMLNode)object;
        StringBuffer stringBuffer = new StringBuffer();
        XMLNode xMLNode2 = xMLNode.getFirstChild();
        while (xMLNode2 != null) {
            String string = xMLNode2.getType();
            if (string == "com.objfac.xmltext") {
                stringBuffer.append(this.getTextStringValue(xMLNode2));
            } else if (string == "com.objfac.xmlcdata") {
                stringBuffer.append(this.getCdataStringValue(xMLNode2));
            }
            xMLNode2 = xMLNode2.getNextSibling();
        }
        return stringBuffer.toString();
    }

    private Object getCdataStringValue(XMLNode xMLNode) {
        XMLNode xMLNode2 = xMLNode;
        String string = xMLNode2.getContents();
        int n = "<![CDATA[".length();
        int n2 = string.length();
        if (string.endsWith("]]>")) {
            n2 -= "]]>".length();
        } else if (string.endsWith("]]")) {
            n2 -= "]]".length();
        } else if (string.endsWith("]")) {
            n2 -= "]".length();
        }
        return string.substring(n, n2);
    }

    public String getAttributeStringValue(Object object) {
        XMLAttr xMLAttr = (XMLAttr)object;
        return xMLAttr.getValue();
    }

    public String getNamespaceStringValue(Object object) {
        return ((XMLNode.Namespace)object).uri;
    }

    public String getTextStringValue(Object object) {
        XMLNode xMLNode = (XMLNode)object;
        StringBuffer stringBuffer = new StringBuffer();
        while (xMLNode != null) {
            String string = xMLNode.getType();
            if (string == "com.objfac.xmltext") {
                stringBuffer.append(xMLNode.getContents());
            } else if (string == "com.objfac.xmlcdata") {
                stringBuffer.append(this.getCdataStringValue(xMLNode));
            }
            xMLNode = xMLNode.getNextSibling();
        }
        return stringBuffer.toString();
    }

    public String getNamespacePrefix(Object object) {
        return ((XMLNode.Namespace)object).prefix;
    }

    public XPath parseXPath(String string) throws SAXPathException {
        return new XMLXPath(string, this);
    }

    public Object getDocumentNode(Object object) {
        XMLTree xMLTree = null;
        if (object instanceof XMLTree) {
            xMLTree = (XMLTree)object;
        } else {
            XMLNode xMLNode = null;
            if (object instanceof XMLNode) {
                xMLNode = (XMLNode)object;
            } else if (object instanceof XMLAttr) {
                xMLNode = ((XMLAttr)object).getParent();
            }
            if (xMLNode != null) {
                while (xMLNode.getParent() != null) {
                    xMLNode = xMLNode.getParent();
                }
                Object v = this.rootmap.get(xMLNode);
                if (v instanceof XMLTree) {
                    xMLTree = (XMLTree)v;
                } else if (v instanceof TreeMapEntry) {
                    xMLTree = ((TreeMapEntry)v).tree;
                }
            }
        }
        return xMLTree;
    }

    public String translateNamespacePrefixToUri(String string, Object object) {
        XMLNode xMLNode = null;
        String string2 = null;
        if (object instanceof XMLNode) {
            xMLNode = (XMLNode)object;
        } else if (object instanceof XMLAttr) {
            xMLNode = ((XMLAttr)object).getParent();
        }
        if (xMLNode != null) {
            string2 = xMLNode.getNamespace(string);
        }
        return string2;
    }

    public String getProcessingInstructionTarget(Object object) {
        XMLNode xMLNode;
        if (object instanceof XMLNode && (xMLNode = (XMLNode)object).getType() == "com.objfac.xmlpi") {
            return xMLNode.getQName();
        }
        return null;
    }

    public String getProcessingInstructionData(Object object) {
        XMLNode xMLNode;
        String string = null;
        if (object instanceof XMLNode && (xMLNode = (XMLNode)object).getType() == "com.objfac.xmlpi") {
            String string2 = xMLNode.getQName();
            int n = string2.length();
            int n2 = n + 2;
            string = xMLNode.getContents();
            if (string.endsWith("?>")) {
                n -= 2;
            } else if (string.endsWith("?")) {
                --n;
            }
            string = n <= n2 ? "" : string.substring(n2, n);
        }
        return string;
    }

    public Object getDocument(String string) throws FunctionCallException {
        TreeMapEntry treeMapEntry = this.mapEntry(this.finder.findDocument(string, this.url));
        return treeMapEntry == null ? null : treeMapEntry.tree;
    }

    private static class ChildIterator
    implements Iterator {
        private XMLNode next;

        public ChildIterator(XMLNode xMLNode) {
            this.next = xMLNode;
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public Object next() {
            if (this.next == null) {
                throw new IllegalStateException("next() called when hasNext() false");
            }
            XMLNode xMLNode = this.next;
            this.next = xMLNode.getNextSibling();
            return xMLNode;
        }

        public void remove() {
            throw new UnimplementedException("remove() unimplemented");
        }
    }

    private class ParentIterator
    implements Iterator {
        Object next;

        public ParentIterator(Object object) {
            this.next = object;
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public Object next() {
            if (this.next == null) {
                throw new IllegalStateException("next() called when hasNext() false");
            }
            Object object = this.next;
            if (this.next instanceof XMLNode) {
                this.next = ((XMLNode)this.next).getParent();
                if (this.next == null) {
                    TreeMapEntry treeMapEntry = (TreeMapEntry)DocumentNavigator.this.rootmap.get(object);
                    this.next = treeMapEntry.tree;
                }
            } else if (this.next instanceof XMLTree) {
                this.next = null;
            }
            return object;
        }

        public void remove() {
            throw new UnimplementedException("remove() unimplemented");
        }
    }

    private static class EmptyIterator
    implements Iterator {
        EmptyIterator() {
        }

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new IllegalStateException("next() called when hasNext() false");
        }

        public void remove() {
            throw new UnimplementedException("remove() unimplemented");
        }
    }

    private static class ArrayListIterator
    implements Iterator {
        private int index;
        private ArrayList list;

        public ArrayListIterator(ArrayList arrayList) {
            this.list = arrayList;
            this.index = 0;
        }

        public boolean hasNext() {
            return this.index < this.list.size();
        }

        public Object next() {
            if (this.index >= this.list.size()) {
                throw new IllegalStateException("next() called when hasNext() false");
            }
            return this.list.get(this.index++);
        }

        public void remove() {
            throw new UnimplementedException("remove() unimplemented");
        }
    }
}

