/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor.xpath;

import com.objfac.util.Local;
import com.objfac.xml.XMLCharacter;
import com.objfac.xmleditor.XMLPlugin;
import com.objfac.xmleditor.resources.AbstractEditor;
import com.objfac.xmleditor.xmltree.XMLNode;
import com.objfac.xmleditor.xmltree.XMLTree;
import com.objfac.xmleditor.xpath.DocumentNavigator;
import com.objfac.xmleditor.xpath.ResultImpl;
import com.objfac.xmleditor.xpath.XPathRunner;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jaxen.JaxenException;
import org.jaxen.XPath;
import org.saxpath.SAXPathException;

public class SaxenRunner
implements XPathRunner {
    public List evaluate(String string, AbstractEditor abstractEditor, XMLNode xMLNode) {
        XPath xPath;
        LinkedList linkedList = new LinkedList();
        XMLTree xMLTree = abstractEditor.getXMLTree();
        DocumentNavigator documentNavigator = new DocumentNavigator(xMLTree, abstractEditor.getUrl());
        try {
            xPath = documentNavigator.parseXPath(string);
        }
        catch (SAXPathException sAXPathException) {
            this.addError(sAXPathException, linkedList);
            return linkedList;
        }
        XMLNode xMLNode2 = this.nearestContext(xMLNode, xMLTree);
        if (xMLNode2 != null) {
            this.addNamespaces(xPath, xMLNode2);
        }
        try {
            Object object = xPath.evaluate(xMLNode == null ? xMLTree : xMLNode);
            this.addValues(object, linkedList);
        }
        catch (JaxenException jaxenException) {
            this.addError(jaxenException, linkedList);
        }
        return linkedList;
    }

    private void addValues(Object object, List list) {
        if (object == null) {
            return;
        }
        if (object instanceof List) {
            List list2 = (List)object;
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                this.addValues(e, list);
            }
        } else if (object instanceof XMLNode) {
            int n;
            Object object2;
            XMLNode xMLNode = (XMLNode)object;
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            boolean bl2 = true;
            XMLNode xMLNode2 = xMLNode.getFirstChild();
            while (xMLNode2 != null) {
                if (xMLNode2.getType() == "com.objfac.xmltext") {
                    object2 = xMLNode2.getContents();
                    n = 0;
                    int n2 = ((String)object2).length();
                    while (n < n2) {
                        char c = ((String)object2).charAt(n);
                        if (XMLCharacter.isWhitespace((char)c)) {
                            bl = true;
                        } else {
                            if (bl && !bl2) {
                                stringBuffer.append(' ');
                            }
                            bl = false;
                            bl2 = false;
                            stringBuffer.append(c);
                        }
                        ++n;
                    }
                }
                xMLNode2 = xMLNode2.getNextSibling();
            }
            object2 = xMLNode.getAttributeList();
            n = 1;
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (!iterator.hasNext()) continue;
                if (n != 0) {
                    if (!bl2) {
                        stringBuffer.append(' ');
                    }
                    n = 0;
                    stringBuffer.append('(');
                } else {
                    stringBuffer.append(' ');
                }
                String string2 = (String)iterator.next();
                stringBuffer.append(string).append("=\"").append(string2).append('\"');
            }
            if (n == 0) {
                stringBuffer.append(')');
            }
            list.add(new ResultImpl(1, xMLNode.getQName(), stringBuffer.toString(), 0));
        } else if (object instanceof XMLTree) {
            list.add(new ResultImpl(6, "Document", "", 0));
        } else if (object instanceof Boolean) {
            list.add(new ResultImpl(8, "Boolean", object.toString(), 0));
        } else if (object instanceof String) {
            list.add(new ResultImpl(8, "String", object.toString(), 0));
        } else if (object instanceof Number) {
            list.add(new ResultImpl(8, "Number", object.toString(), 0));
        }
    }

    private void addError(Throwable throwable, LinkedList linkedList) {
        Object object;
        if (throwable instanceof JaxenException && (object = (JaxenException)throwable).getRootCause() != null) {
            throwable = object.getRootCause();
        }
        if ((object = throwable.getLocalizedMessage()) == null) {
            object = throwable.toString();
        }
        linkedList.add(new ResultImpl(0, Local.getString((String)"Error"), (String)object, 0));
    }

    private XMLNode nearestContext(XMLNode xMLNode, XMLTree xMLTree) {
        if (xMLNode == null) {
            return xMLTree.getRoot();
        }
        return xMLNode;
    }

    private void addNamespaces(XPath xPath, XMLNode xMLNode) {
        XMLNode.Namespace namespace = xMLNode.getNamespaceChain();
        while (namespace != null) {
            try {
                if (namespace.prefix != null && namespace.uri != null && namespace.uri.length() > 0) {
                    xPath.addNamespace(namespace.prefix, namespace.uri);
                }
            }
            catch (JaxenException jaxenException) {
                XMLPlugin.log(jaxenException);
            }
            namespace = namespace.next;
        }
    }
}

