/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor.xpath;

import com.objfac.util.Local;
import com.objfac.xmleditor.BaseEditor;
import com.objfac.xmleditor.Config;
import com.objfac.xmleditor.SelectListener;
import com.objfac.xmleditor.XMLEditor;
import com.objfac.xmleditor.validate.XPathEvaluationShell;
import com.objfac.xmleditor.wizards.WizardUtils;
import com.objfac.xmleditor.xmltree.XMLNode;
import com.objfac.xmleditor.xpath.Result;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.part.ViewPart;

public class XPathView
extends ViewPart
implements SelectListener {
    private HashMap fDialogMap;
    private boolean fValid;
    private XPathEvaluationShell fEval;
    private IEditorInput fCachedInput;
    private XMLEditor fEditor;
    private Table fTable;
    private Button fEvalClick;
    private Button fEvalTyping;
    private Button fFromElement;
    private Button fFromDocument;
    private Button fXpath2;
    private Button fXpath1;
    private Text fXpathIn;
    private Button fEvaluate;
    private static final Object[] fParams;
    private ParamAdapter fParamAdapter = new ParamAdapter();
    protected PartListener fPartListener = new PartListener();
    static /* synthetic */ Class class$0;

    static {
        Object[] objectArray = new Object[12];
        objectArray[0] = "com.objfac.xpathsyntax";
        objectArray[1] = "syntax";
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectArray[2] = clazz;
        objectArray[3] = "1.0";
        objectArray[4] = "com.objfac.xpathcontext";
        objectArray[5] = "context";
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectArray[6] = clazz2;
        objectArray[7] = "element";
        objectArray[8] = "com.objfac.xpatheval";
        objectArray[9] = "eval";
        Class<?> clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectArray[10] = clazz3;
        objectArray[11] = "click";
        fParams = objectArray;
    }

    public void createPartControl(Composite composite) {
        this.fDialogMap = new HashMap();
        WizardUtils.getDialogSettings(this.fDialogMap, fParams);
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(1, false));
        composite2.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                XPathView.this.disposing();
            }
        });
        Composite composite3 = new Composite(composite2, 0);
        GridData gridData = new GridData(768);
        composite3.setLayoutData((Object)gridData);
        composite3.setLayout((Layout)new GridLayout(3, false));
        gridData = new Label(composite3, 0);
        gridData.setText(Local.getString((String)"XPath:"));
        GridData gridData2 = new GridData();
        gridData2.horizontalAlignment = 1;
        gridData.setLayoutData((Object)gridData2);
        this.fXpathIn = new Text(composite3, 2052);
        gridData2 = new GridData(768);
        this.fXpathIn.setLayoutData((Object)gridData2);
        this.fXpathIn.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                XPathView.this.xpathModified();
            }
        });
        this.fEvaluate = new Button(composite3, 8);
        this.fEvaluate.setText(Local.getString((String)"&Evaluate"));
        gridData2 = new GridData();
        gridData2.horizontalAlignment = 3;
        this.fEvaluate.setLayoutData((Object)gridData2);
        this.fEvaluate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                XPathView.this.evaluate();
            }
        });
        this.fTable = new Table(composite2, 84740);
        this.fTable.setLinesVisible(true);
        this.fTable.setHeaderVisible(true);
        gridData2 = new GridData(1808);
        gridData2.heightHint = 60;
        this.fTable.setLayoutData((Object)gridData2);
        TableLayout tableLayout = new TableLayout();
        ColumnWeightData columnWeightData = new ColumnWeightData(40, 40);
        tableLayout.addColumnData((ColumnLayoutData)columnWeightData);
        ColumnWeightData columnWeightData2 = new ColumnWeightData(60, 40);
        tableLayout.addColumnData((ColumnLayoutData)columnWeightData2);
        this.fTable.setLayout((Layout)tableLayout);
        TableColumn tableColumn = new TableColumn(this.fTable, 0);
        tableColumn.setText(Local.getString((String)"Name"));
        TableColumn tableColumn2 = new TableColumn(this.fTable, 0);
        tableColumn2.setText(Local.getString((String)"Value (Attributes)"));
        gridData2 = new Composite(composite2, 0);
        tableLayout = new GridData(768);
        gridData2.setLayoutData((Object)tableLayout);
        gridData2.setLayout((Layout)new GridLayout(3, true));
        tableLayout = new Group((Composite)gridData2, 16);
        tableLayout.setText(Local.getString((String)"XPath syntax"));
        tableLayout.setLayoutData((Object)new GridData(2));
        tableLayout.setLayout((Layout)new GridLayout(1, false));
        this.fXpath1 = new Button((Composite)tableLayout, 16);
        this.fXpath1.setText(Local.getString((String)"XPath 1.0"));
        this.fXpath1.setLayoutData((Object)new GridData(1));
        this.fXpath1.setSelection("1.0".equals(this.fDialogMap.get("syntax")));
        this.fXpath2 = new Button((Composite)tableLayout, 16);
        this.fXpath2.setText(Local.getString((String)"XPath 2.0"));
        this.fXpath2.setLayoutData((Object)new GridData(1));
        this.fXpath2.setSelection("2.0".equals(this.fDialogMap.get("syntax")));
        columnWeightData = new Group((Composite)gridData2, 16);
        columnWeightData.setText(Local.getString((String)"XPath context"));
        columnWeightData.setLayoutData((Object)new GridData(2));
        columnWeightData.setLayout((Layout)new GridLayout(1, false));
        this.fFromDocument = new Button((Composite)columnWeightData, 16);
        this.fFromDocument.setText(Local.getString((String)"From Document"));
        this.fFromDocument.setLayoutData((Object)new GridData(1));
        this.fFromDocument.setSelection("document".equals(this.fDialogMap.get("context")));
        this.fFromElement = new Button((Composite)columnWeightData, 16);
        this.fFromElement.setText(Local.getString((String)"From Selected Element"));
        this.fFromElement.setLayoutData((Object)new GridData(1));
        this.fFromElement.setSelection("element".equals(this.fDialogMap.get("context")));
        columnWeightData2 = new Group((Composite)gridData2, 16);
        columnWeightData2.setText(Local.getString((String)"Evaluation"));
        columnWeightData2.setLayoutData((Object)new GridData(2));
        columnWeightData2.setLayout((Layout)new GridLayout(1, false));
        this.fEvalTyping = new Button((Composite)columnWeightData2, 16);
        this.fEvalTyping.setText(Local.getString((String)"Evaluate While Typing"));
        this.fEvalTyping.setLayoutData((Object)new GridData(1));
        this.fEvalTyping.setSelection("continuous".equals(this.fDialogMap.get("eval")));
        this.fEvalClick = new Button((Composite)columnWeightData2, 16);
        this.fEvalClick.setText(Local.getString((String)"Evaluate On Button Click"));
        this.fEvalClick.setLayoutData((Object)new GridData(1));
        this.fEvalClick.setSelection("click".equals(this.fDialogMap.get("eval")));
        this.fXpath1.addSelectionListener((SelectionListener)this.fParamAdapter);
        this.fXpath2.addSelectionListener((SelectionListener)this.fParamAdapter);
        this.fFromDocument.addSelectionListener((SelectionListener)this.fParamAdapter);
        this.fFromElement.addSelectionListener((SelectionListener)this.fParamAdapter);
        this.fEvalTyping.addSelectionListener((SelectionListener)this.fParamAdapter);
        this.fEvalClick.addSelectionListener((SelectionListener)this.fParamAdapter);
        this.setupActions();
        this.initializeToolBar();
        tableColumn = new MenuManager("#PopUp");
        tableColumn.setRemoveAllWhenShown(true);
        tableColumn.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                XPathView.this.fillContextMenu(iMenuManager);
            }
        });
        tableColumn2 = tableColumn.createContextMenu((Control)this.fXpathIn);
        this.fXpathIn.setMenu((Menu)tableColumn2);
        this.fEval = new XPathEvaluationShell();
        BaseEditor.addSelectListener(this);
        this.validate();
    }

    protected void xpathModified() {
        this.validate();
        if (this.fEvalTyping.getSelection()) {
            this.clearResults();
            if (this.fValid) {
                this.evaluate();
            }
        }
    }

    private void validate() {
        Result result;
        boolean bl;
        List list;
        this.setMessage(null);
        XMLNode xMLNode = null;
        String string = this.fXpathIn.getText();
        if (string.length() == 0) {
            this.setMessage(Local.getString((String)"Specify an XPath expression"));
        }
        if (this.fValid) {
            if (!this.checkContext()) {
                this.setMessage(Local.getString((String)"No active XML editor"));
            } else if (this.fFromElement.getSelection() && this.getSelectedElement() == null) {
                this.setMessage(Local.getString((String)"No element selected"));
            }
        }
        if (this.fValid && (list = this.fEval.check(string, xMLNode = this.fFromElement.getSelection() ? this.getSelectedElement() : this.getDocumentRoot(), bl = this.fXpath1.getSelection())).size() > 0 && (result = (Result)list.get(0)).getType() == 0) {
            this.setMessage(result.getDisplayValue());
        }
    }

    private XMLNode getDocumentRoot() {
        XMLNode xMLNode = null;
        if (this.fEditor != null && (xMLNode = this.fEditor.getXMLTree().getRoot()) == null) {
            xMLNode = this.fEditor.getXMLTree().getHead();
        }
        return xMLNode;
    }

    private void setMessage(String string) {
        this.fValid = string == null;
        String string2 = this.fValid ? "" : string;
        this.updateStatusMessage(string2);
        this.fEvaluate.setEnabled(Config.pro() && this.fValid);
    }

    private void updateStatusMessage(String string) {
        this.getViewSite().getActionBars().getStatusLineManager().setMessage(string);
    }

    private boolean checkContext() {
        IWorkbenchPage iWorkbenchPage = this.getSite().getPage();
        IEditorPart iEditorPart = iWorkbenchPage.getActiveEditor();
        this.fEditor = iEditorPart instanceof XMLEditor ? (XMLEditor)iEditorPart : null;
        return this.fEditor != null;
    }

    private int getSelectionStart() {
        ISourceViewer iSourceViewer = this.fEditor.getViewer();
        if (iSourceViewer == null) {
            return -1;
        }
        StyledText styledText = iSourceViewer.getTextWidget();
        if (styledText == null) {
            return -1;
        }
        Point point = styledText.getSelectionRange();
        return point.x;
    }

    private XMLNode getSelectedElement() {
        int n = this.getSelectionStart();
        return this.getSelectedElement(n);
    }

    private XMLNode getSelectedElement(int n) {
        if (n >= 0) {
            String string;
            XMLNode xMLNode = this.fEditor.getXMLTree().findExactNode(n);
            if (xMLNode.getOffset() == n && n > 0) {
                xMLNode = this.fEditor.getXMLTree().findExactNode(n - 1);
            }
            if ((string = xMLNode.getType()) != "com.objfac.xmlstarttag" && string != "com.objfac.xmlemptytag") {
                xMLNode = xMLNode.getParent();
            }
            if (xMLNode != null && (xMLNode.getType() == "com.objfac.xmlstarttag" || xMLNode.getType() == "com.objfac.xmlemptytag")) {
                return xMLNode;
            }
        }
        return null;
    }

    protected void evaluate() {
        if (!this.checkContext()) {
            this.setMessage(Local.getString((String)"No context to evaluate in"));
            return;
        }
        XMLNode xMLNode = this.fFromElement.getSelection() ? this.getSelectedElement() : this.getDocumentRoot();
        boolean bl = this.fXpath1.getSelection();
        List list = this.fEval.evaluate(this.fXpathIn.getText(), this.fEditor, xMLNode, bl);
        this.clearResults();
        if (list.size() == 0) {
            TableItem tableItem = new TableItem(this.fTable, 0);
            tableItem.setText(0, Local.getString((String)"No results"));
            tableItem.setText(1, "");
        } else {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Result result = (Result)iterator.next();
                if (result.getType() == 0) {
                    this.setMessage(result.getDisplayValue());
                }
                TableItem tableItem = new TableItem(this.fTable, 0);
                tableItem.setText(0, result.getDisplayName());
                tableItem.setText(1, result.getDisplayValue());
            }
        }
    }

    private void clearResults() {
        int n = this.fTable.getItemCount();
        if (n > 0) {
            this.fTable.remove(0, n - 1);
        }
    }

    private void initializeToolBar() {
        this.getViewSite().getActionBars().getToolBarManager();
        this.getViewSite().getActionBars().updateActionBars();
    }

    protected void fillContextMenu(IMenuManager iMenuManager) {
    }

    private void setupActions() {
        this.getViewSite().getActionBars();
    }

    public void setFocus() {
        this.fXpathIn.setFocus();
    }

    private void setParams() {
        if (this.fXpath1.getSelection()) {
            this.fDialogMap.put("syntax", "1.0");
        } else if (this.fXpath2.getSelection()) {
            this.fDialogMap.put("syntax", "2.0");
        }
        if (this.fFromDocument.getSelection()) {
            this.fDialogMap.put("context", "document");
        } else if (this.fFromElement.getSelection()) {
            this.fDialogMap.put("context", "element");
        }
        if (this.fEvalClick.getSelection()) {
            this.fDialogMap.put("eval", "click");
        } else if (this.fEvalTyping.getSelection()) {
            this.fDialogMap.put("eval", "continuous");
        }
    }

    protected void disposing() {
        WizardUtils.putDialogSettings(this.fDialogMap, fParams);
    }

    public void selectionChanged(BaseEditor baseEditor) {
        this.validate();
    }

    private class ParamAdapter
    extends SelectionAdapter {
        ParamAdapter() {
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            XPathView.this.setParams();
            XPathView.this.validate();
        }
    }

    protected class PartListener
    implements IPartListener2 {
        protected PartListener() {
        }

        public void partActivated(IWorkbenchPartReference iWorkbenchPartReference) {
            XPathView.this.validate();
        }

        public void partBroughtToTop(IWorkbenchPartReference iWorkbenchPartReference) {
            XPathView.this.validate();
        }

        public void partClosed(IWorkbenchPartReference iWorkbenchPartReference) {
            XPathView.this.validate();
        }

        public void partDeactivated(IWorkbenchPartReference iWorkbenchPartReference) {
            XPathView.this.validate();
        }

        public void partOpened(IWorkbenchPartReference iWorkbenchPartReference) {
            XPathView.this.validate();
        }

        public void partHidden(IWorkbenchPartReference iWorkbenchPartReference) {
            XPathView.this.validate();
        }

        public void partVisible(IWorkbenchPartReference iWorkbenchPartReference) {
            XPathView.this.validate();
        }

        public void partInputChanged(IWorkbenchPartReference iWorkbenchPartReference) {
            XPathView.this.validate();
        }
    }
}

