/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.moved;

import com.objfac.util.Local;
import com.objfac.xmleditor.MigrationUtils;
import com.objfac.xmleditor.search.SearchUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.internal.ui.util.ExceptionHandler;
import org.eclipse.search.ui.ISearchResultView;
import org.eclipse.search.ui.ISearchResultViewEntry;
import org.eclipse.search.ui.SearchUI;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;

public class GotoMarkerAction
extends Action {
    private IEditorPart fEditor;

    public void run() {
        ISearchResultView iSearchResultView = SearchUI.getSearchResultView();
        ISelection iSelection = iSearchResultView.getSelection();
        Object object = null;
        if (iSelection instanceof IStructuredSelection) {
            object = ((IStructuredSelection)iSelection).getFirstElement();
        }
        if (object instanceof ISearchResultViewEntry) {
            ISearchResultViewEntry iSearchResultViewEntry = (ISearchResultViewEntry)object;
            this.show(iSearchResultViewEntry.getSelectedMarker());
        }
    }

    private void show(IMarker iMarker) {
        if (SearchUI.reuseEditor()) {
            this.showWithReuse(iMarker);
        } else {
            this.showWithoutReuse(iMarker);
        }
    }

    private void showWithReuse(IMarker iMarker) {
        IWorkbenchPage iWorkbenchPage = SearchUtils.getActivePage();
        IResource iResource = iMarker.getResource();
        if (iWorkbenchPage == null || !(iResource instanceof IFile)) {
            return;
        }
        FileEditorInput fileEditorInput = new FileEditorInput((IFile)iResource);
        String string = null;
        IEditorDescriptor iEditorDescriptor = SearchPlugin.getDefault().getWorkbench().getEditorRegistry().getDefaultEditor(iResource.getName());
        string = iEditorDescriptor == null ? SearchPlugin.getDefault().getWorkbench().getEditorRegistry().getDefaultEditor().getId() : iEditorDescriptor.getId();
        IEditorPart iEditorPart = iWorkbenchPage.findEditor((IEditorInput)fileEditorInput);
        if (iEditorPart != null) {
            iWorkbenchPage.bringToTop((IWorkbenchPart)iEditorPart);
        } else {
            int n;
            boolean bl = false;
            if (this.fEditor != null) {
                IEditorReference[] iEditorReferenceArray = iWorkbenchPage.getEditorReferences();
                n = 0;
                while (!bl && n < iEditorReferenceArray.length) {
                    boolean bl2 = bl = this.fEditor == iEditorReferenceArray[n++].getEditor(false);
                }
            }
            boolean bl3 = bl && !this.fEditor.isDirty() && !this.isPinned(this.fEditor);
            int n2 = n = this.fEditor != null && this.fEditor.getSite().getId().equals(string) ? 1 : 0;
            if (bl3 && n == 0) {
                iWorkbenchPage.closeEditor(this.fEditor, false);
                this.fEditor = null;
            }
            if (bl3 && n != 0) {
                ((IReusableEditor)this.fEditor).setInput((IEditorInput)fileEditorInput);
                iWorkbenchPage.bringToTop((IWorkbenchPart)this.fEditor);
                iEditorPart = this.fEditor;
            } else {
                try {
                    iEditorPart = iWorkbenchPage.openEditor((IEditorInput)fileEditorInput, string, false);
                    this.fEditor = iEditorPart instanceof IReusableEditor ? iEditorPart : null;
                }
                catch (PartInitException partInitException) {
                    ExceptionHandler.handle((CoreException)((Object)partInitException), (String)Local.getString((String)"Search.Error.openEditor.title"), (String)Local.getString((String)"Search.Error.openEditor.message"));
                    return;
                }
            }
        }
        if (iEditorPart != null) {
            MigrationUtils.gotoMarker(iEditorPart, iMarker);
        }
    }

    private boolean isPinned(IEditorPart iEditorPart) {
        if (iEditorPart == null) {
            return false;
        }
        IEditorReference[] iEditorReferenceArray = iEditorPart.getEditorSite().getPage().getEditorReferences();
        int n = 0;
        while (n < iEditorReferenceArray.length) {
            if (iEditorPart.equals(iEditorReferenceArray[n].getEditor(false))) {
                return iEditorReferenceArray[n].isPinned();
            }
            ++n;
        }
        return false;
    }

    private void showWithoutReuse(IMarker iMarker) {
        IWorkbenchPage iWorkbenchPage = SearchPlugin.getActivePage();
        if (iWorkbenchPage == null) {
            return;
        }
        MigrationUtils.openEditor(iWorkbenchPage, iMarker);
    }
}

