/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.helper;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.persistence.exceptions.ConcurrencyException;
import org.eclipse.persistence.internal.helper.DeferredLockManager;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.localization.ToStringLocalization;
import org.eclipse.persistence.logging.AbstractSessionLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrencyManager
implements Serializable {
    protected int numberOfReaders = 0;
    protected int depth = 0;
    protected int numberOfWritersWaiting = 0;
    protected volatile transient Thread activeThread;
    public static Map<Thread, DeferredLockManager> deferredLockManagers = ConcurrencyManager.initializeDeferredLockManagers();
    protected boolean lockedByMergeManager;
    protected static boolean shouldTrackStack = System.getProperty("eclipselink.cache.record-stack-on-lock") != null;
    protected Exception stack;
    protected CacheKey ownerCacheKey;

    public ConcurrencyManager() {
    }

    public ConcurrencyManager(CacheKey cacheKey) {
        this();
        this.ownerCacheKey = cacheKey;
    }

    public void acquire() throws ConcurrencyException {
        this.acquire(false);
    }

    public synchronized void acquire(boolean forMerge) throws ConcurrencyException {
        while ((this.activeThread != null || this.numberOfReaders > 0) && this.activeThread != Thread.currentThread()) {
            try {
                ++this.numberOfWritersWaiting;
                this.wait();
                --this.numberOfWritersWaiting;
            }
            catch (InterruptedException exception) {
                throw ConcurrencyException.waitWasInterrupted(exception.getMessage());
            }
        }
        if (this.activeThread == null) {
            this.activeThread = Thread.currentThread();
            if (shouldTrackStack) {
                this.stack = new Exception();
            }
        }
        this.lockedByMergeManager = forMerge;
        ++this.depth;
    }

    public boolean acquireNoWait() throws ConcurrencyException {
        return this.acquireNoWait(false);
    }

    public synchronized boolean acquireNoWait(boolean forMerge) throws ConcurrencyException {
        if ((this.activeThread == null || this.activeThread == Thread.currentThread()) && this.numberOfReaders == 0) {
            this.acquire(forMerge);
            return true;
        }
        return false;
    }

    public synchronized boolean acquireWithWait(boolean forMerge, int wait) throws ConcurrencyException {
        if ((this.activeThread == null || this.activeThread == Thread.currentThread()) && this.numberOfReaders == 0) {
            this.acquire(forMerge);
            return true;
        }
        try {
            this.wait(wait);
        }
        catch (InterruptedException e) {
            return false;
        }
        if ((this.activeThread == null || this.activeThread == Thread.currentThread()) && this.numberOfReaders == 0) {
            this.acquire(forMerge);
            return true;
        }
        return false;
    }

    public synchronized boolean acquireIfUnownedNoWait(boolean forMerge) throws ConcurrencyException {
        if (this.activeThread == null && this.numberOfReaders == 0) {
            this.acquire(forMerge);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireDeferredLock() throws ConcurrencyException {
        Thread currentThread = Thread.currentThread();
        DeferredLockManager lockManager = ConcurrencyManager.getDeferredLockManager(currentThread);
        if (lockManager == null) {
            lockManager = new DeferredLockManager();
            this.putDeferredLock(currentThread, lockManager);
        }
        lockManager.incrementDepth();
        ConcurrencyManager concurrencyManager = this;
        synchronized (concurrencyManager) {
            while (this.numberOfReaders != 0) {
                try {
                    ++this.numberOfWritersWaiting;
                    this.wait();
                    --this.numberOfWritersWaiting;
                }
                catch (InterruptedException exception) {
                    throw ConcurrencyException.waitWasInterrupted(exception.getMessage());
                }
            }
            if (this.activeThread == currentThread || !this.isAcquired()) {
                lockManager.addActiveLock(this);
                this.acquire();
            } else {
                lockManager.addDeferredLock(this);
                if (AbstractSessionLog.getLog().shouldLog(2)) {
                    AbstractSessionLog.getLog().log(2, "acquiring_deferred_lock", this.getOwnerCacheKey().getObject(), currentThread.getName());
                }
            }
        }
    }

    public void checkDeferredLock() throws ConcurrencyException {
        if (this.activeThread == null) {
            return;
        }
        this.acquireDeferredLock();
        this.releaseDeferredLock();
    }

    public void checkReadLock() throws ConcurrencyException {
        if (this.activeThread == null) {
            return;
        }
        this.acquireReadLock();
        this.releaseReadLock();
    }

    public synchronized void acquireReadLock() throws ConcurrencyException {
        while (this.activeThread != null && this.activeThread != Thread.currentThread()) {
            try {
                this.wait();
            }
            catch (InterruptedException exception) {
                throw ConcurrencyException.waitWasInterrupted(exception.getMessage());
            }
        }
        ++this.numberOfReaders;
    }

    public synchronized boolean acquireReadLockNoWait() {
        if (this.activeThread == null || this.activeThread == Thread.currentThread()) {
            this.acquireReadLock();
            return true;
        }
        return false;
    }

    public Thread getActiveThread() {
        return this.activeThread;
    }

    public static DeferredLockManager getDeferredLockManager(Thread thread) {
        return ConcurrencyManager.getDeferredLockManagers().get(thread);
    }

    protected static Map<Thread, DeferredLockManager> getDeferredLockManagers() {
        return deferredLockManagers;
    }

    protected static Map initializeDeferredLockManagers() {
        return new ConcurrentHashMap();
    }

    public int getDepth() {
        return this.depth;
    }

    public int getNumberOfReaders() {
        return this.numberOfReaders;
    }

    public int getNumberOfWritersWaiting() {
        return this.numberOfWritersWaiting;
    }

    public CacheKey getOwnerCacheKey() {
        return this.ownerCacheKey;
    }

    public boolean isAcquired() {
        return this.depth > 0;
    }

    public boolean isLockedByMergeManager() {
        return this.lockedByMergeManager;
    }

    public static boolean isBuildObjectOnThreadComplete(Thread thread, Map recursiveSet) {
        if (recursiveSet.containsKey(thread)) {
            return true;
        }
        recursiveSet.put(thread, thread);
        DeferredLockManager lockManager = ConcurrencyManager.getDeferredLockManager(thread);
        if (lockManager == null) {
            return true;
        }
        Vector deferredLocks = lockManager.getDeferredLocks();
        Enumeration deferredLocksEnum = deferredLocks.elements();
        while (deferredLocksEnum.hasMoreElements()) {
            ConcurrencyManager deferedLock = (ConcurrencyManager)deferredLocksEnum.nextElement();
            Thread activeThread = null;
            if (!deferedLock.isAcquired() || (activeThread = deferedLock.getActiveThread()) == null) continue;
            DeferredLockManager currentLockManager = ConcurrencyManager.getDeferredLockManager(activeThread);
            if (currentLockManager == null) {
                return false;
            }
            if (currentLockManager.isThreadComplete()) {
                activeThread = deferedLock.getActiveThread();
                if (activeThread == null || ConcurrencyManager.isBuildObjectOnThreadComplete(activeThread, recursiveSet)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public boolean isNested() {
        return this.depth > 1;
    }

    public void putDeferredLock(Thread thread, DeferredLockManager lockManager) {
        ConcurrencyManager.getDeferredLockManagers().put(thread, lockManager);
    }

    public synchronized void release() throws ConcurrencyException {
        if (this.depth == 0) {
            throw ConcurrencyException.signalAttemptedBeforeWait();
        }
        --this.depth;
        if (this.depth == 0) {
            this.activeThread = null;
            if (shouldTrackStack) {
                this.stack = null;
            }
            this.lockedByMergeManager = false;
            this.notifyAll();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void releaseDeferredLock() throws ConcurrencyException {
        currentThread = Thread.currentThread();
        lockManager = ConcurrencyManager.getDeferredLockManager(currentThread);
        if (lockManager == null) {
            return;
        }
        depth = lockManager.getThreadDepth();
        if (depth > 1) {
            lockManager.decrementDepth();
            return;
        }
        if (!lockManager.hasDeferredLock()) {
            lockManager.releaseActiveLocksOnThread();
            ConcurrencyManager.removeDeferredLockManager(currentThread);
            return;
        }
        lockManager.setIsThreadComplete(true);
        try {
            while (true) lbl-1000:
            // 2 sources

            {
                if (ConcurrencyManager.isBuildObjectOnThreadComplete(currentThread, recursiveSet = new IdentityHashMap<K, V>())) {
                    lockManager.releaseActiveLocksOnThread();
                    ConcurrencyManager.removeDeferredLockManager(currentThread);
                    AbstractSessionLog.getLog().log(2, "deferred_locks_released", currentThread.getName());
                    return;
                }
                try {
                    Thread.sleep(1L);
                    continue;
                }
                catch (InterruptedException interrupted) {
                    AbstractSessionLog.getLog().logThrowable(7, interrupted);
                    lockManager.releaseActiveLocksOnThread();
                    ConcurrencyManager.removeDeferredLockManager(currentThread);
                    throw ConcurrencyException.waitWasInterrupted(interrupted.getMessage());
                }
                break;
            }
        }
        catch (Error error) {
            AbstractSessionLog.getLog().logThrowable(7, error);
            lockManager.releaseActiveLocksOnThread();
            ConcurrencyManager.removeDeferredLockManager(currentThread);
            throw error;
        }
        {
            ** while (true)
        }
    }

    public synchronized void releaseReadLock() throws ConcurrencyException {
        if (this.numberOfReaders == 0) {
            throw ConcurrencyException.signalAttemptedBeforeWait();
        }
        --this.numberOfReaders;
        if (this.numberOfReaders == 0) {
            this.notifyAll();
        }
    }

    public static DeferredLockManager removeDeferredLockManager(Thread thread) {
        return ConcurrencyManager.getDeferredLockManagers().remove(thread);
    }

    public void setActiveThread(Thread activeThread) {
        this.activeThread = activeThread;
    }

    protected void setDepth(int depth) {
        this.depth = depth;
    }

    public void setIsLockedByMergeManager(boolean state) {
        this.lockedByMergeManager = state;
    }

    protected void setNumberOfReaders(int numberOfReaders) {
        this.numberOfReaders = numberOfReaders;
    }

    protected void setNumberOfWritersWaiting(int numberOfWritersWaiting) {
        this.numberOfWritersWaiting = numberOfWritersWaiting;
    }

    public synchronized void transitionToDeferredLock() {
        Thread currentThread = Thread.currentThread();
        DeferredLockManager lockManager = ConcurrencyManager.getDeferredLockManager(currentThread);
        if (lockManager == null) {
            lockManager = new DeferredLockManager();
            this.putDeferredLock(currentThread, lockManager);
        }
        lockManager.incrementDepth();
        lockManager.addActiveLock(this);
    }

    public String toString() {
        Object[] args = new Object[]{this.getDepth()};
        return Helper.getShortClassName(this.getClass()) + ToStringLocalization.buildMessage("nest_level", args);
    }

    public Exception getStack() {
        return this.stack;
    }

    public void setStack(Exception stack) {
        this.stack = stack;
    }

    public static boolean shouldTrackStack() {
        return shouldTrackStack;
    }

    public static void setShouldTrackStack(boolean shouldTrackStack) {
        ConcurrencyManager.shouldTrackStack = shouldTrackStack;
    }
}

