/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.security;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.security.Securable;

public class JCEEncryptor
implements Securable {
    private static final String DES = "DES/ECB/PKCS5Padding";
    private Cipher decryptCipherDES = Cipher.getInstance("DES/ECB/PKCS5Padding");
    private static final String AES = "AES/ECB/PKCS5Padding";
    private Cipher encryptCipherAES;
    private Cipher decryptCipherAES;

    public JCEEncryptor() throws Exception {
        this.decryptCipherDES.init(2, Synergizer.getDESMultitasker());
        this.encryptCipherAES = Cipher.getInstance(AES);
        this.encryptCipherAES.init(1, Synergizer.getAESMultitasker());
        this.decryptCipherAES = Cipher.getInstance(AES);
        this.decryptCipherAES.init(2, Synergizer.getAESMultitasker());
    }

    public synchronized String encryptPassword(String password) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            CipherOutputStream cos = new CipherOutputStream(baos, this.encryptCipherAES);
            ObjectOutputStream oos = new ObjectOutputStream(cos);
            oos.writeObject(password);
            oos.flush();
            oos.close();
            return Helper.buildHexStringFromBytes(baos.toByteArray());
        }
        catch (Exception e) {
            throw ValidationException.errorEncryptingPassword(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized String decryptPassword(String encryptedPswd) {
        String password;
        block16: {
            password = "";
            ObjectInputStream ois = null;
            byte[] bytePassword = Helper.buildBytesFromHexString(encryptedPswd);
            ByteArrayInputStream bais = new ByteArrayInputStream(bytePassword);
            CipherInputStream cis = new CipherInputStream(bais, this.decryptCipherAES);
            ois = new ObjectInputStream(cis);
            password = (String)ois.readObject();
            Object var9_14 = null;
            try {
                if (ois != null) {
                    ois.close();
                }
                break block16;
            }
            catch (IOException ioexception) {}
            break block16;
            {
                catch (Exception ex) {
                    try {
                        byte[] bytePassword2 = Helper.buildBytesFromHexString(encryptedPswd);
                        ByteArrayInputStream bais2 = new ByteArrayInputStream(bytePassword2);
                        CipherInputStream cis2 = new CipherInputStream(bais2, this.decryptCipherDES);
                        ois = new ObjectInputStream(cis2);
                        password = (String)ois.readObject();
                        ois.close();
                    }
                    catch (IOException e) {
                        password = encryptedPswd;
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        password = encryptedPswd;
                    }
                    catch (ConversionException e) {
                        password = encryptedPswd;
                    }
                    catch (Exception e) {
                        throw ValidationException.errorDecryptingPassword(e);
                    }
                    Object var9_15 = null;
                    try {
                        if (ois != null) {
                            ois.close();
                        }
                        break block16;
                    }
                    catch (IOException ioexception) {}
                }
            }
            catch (Throwable throwable) {
                Object var9_16 = null;
                try {
                    if (ois != null) {
                        ois.close();
                    }
                }
                catch (IOException ioexception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return password;
    }

    private static class Synergizer {
        private Synergizer() {
        }

        private static SecretKey getDESMultitasker() throws Exception {
            SecretKeyFactory factory = SecretKeyFactory.getInstance("DES");
            return factory.generateSecret(new DESKeySpec(Helper.buildBytesFromHexString("E60B80C7AEC78038")));
        }

        private static SecretKey getAESMultitasker() throws Exception {
            return new SecretKeySpec(Helper.buildBytesFromHexString("3E7CFEF156E712906E1F603B59463C67"), "AES");
        }
    }
}

