/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions.remote;

import java.util.Enumeration;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.persistence.config.ReferenceMode;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.Platform;
import org.eclipse.persistence.internal.helper.ConcurrencyManager;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.InvalidObject;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.CommitManager;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.internal.sessions.remote.RemoteSessionController;
import org.eclipse.persistence.internal.sessions.remote.Transporter;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.sessions.remote.RemoteSession;
import org.eclipse.persistence.sessions.server.ServerSession;

public class RemoteUnitOfWork
extends UnitOfWorkImpl {
    protected Vector newObjectsCache;
    protected Vector unregisteredNewObjectsCache;
    protected boolean isOnClient = true;
    protected transient RemoteSessionController parentSessionController;

    public RemoteUnitOfWork(RemoteUnitOfWork parent) {
        this(parent, null);
    }

    public RemoteUnitOfWork(RemoteSession parent) {
        this(parent, null);
        this.isOnClient = true;
    }

    public RemoteUnitOfWork(RemoteUnitOfWork parent, ReferenceMode referenceMode) {
        super(parent, referenceMode);
    }

    public RemoteUnitOfWork(RemoteSession parent, ReferenceMode referenceMode) {
        super(parent, referenceMode);
    }

    public UnitOfWorkImpl acquireUnitOfWork() {
        return this.acquireUnitOfWork(null);
    }

    public UnitOfWorkImpl acquireUnitOfWork(ReferenceMode referenceMode) {
        this.log(2, "transaction", "acquire_unit_of_work");
        this.setNumberOfActiveUnitsOfWork(this.getNumberOfActiveUnitsOfWork() + 1);
        RemoteUnitOfWork ruow = new RemoteUnitOfWork(this, referenceMode);
        ruow.discoverAllUnregisteredNewObjectsInParent();
        return ruow;
    }

    protected Vector collectNewObjects() {
        Set keys = this.getNewObjectsCloneToOriginal().keySet();
        Vector vector = new Vector(keys.size());
        Iterator enumeration = keys.iterator();
        while (enumeration.hasNext()) {
            vector.addElement(enumeration.next());
        }
        return vector;
    }

    protected Vector collectUnregisteredNewObjects() {
        this.discoverAllUnregisteredNewObjects();
        return Helper.buildVectorFromMapElements(this.getUnregisteredNewObjects());
    }

    protected void commitIntoRemoteUnitOfWork() {
        ((UnitOfWorkImpl)this.getParent()).setWasTransactionBegunPrematurely(this.wasTransactionBegunPrematurely());
        MergeManager manager = new MergeManager(this);
        manager.mergeWorkingCopyIntoRemote();
        Iterator clones = new IdentityHashMap(this.getCloneMapping()).keySet().iterator();
        while (clones.hasNext()) {
            manager.mergeChanges(clones.next(), null, this);
        }
    }

    public void commitRootUnitOfWork() {
        RemoteUnitOfWork remoteUnitOfWork;
        if (!this.isOnClient()) {
            if (this.isSynchronized()) {
                if (this.getParent().wasJTSTransactionInternallyStarted()) {
                    this.commitInternallyStartedExternalTransaction();
                }
                return;
            }
            if (this.eventManager != null) {
                this.eventManager.preCommitUnitOfWork();
            }
            super.commitRootUnitOfWork();
            if (this.eventManager != null) {
                this.eventManager.postCommitUnitOfWork();
            }
            return;
        }
        this.setNewObjectsCache(this.collectNewObjects());
        this.setUnregisteredNewObjectsCache(this.collectUnregisteredNewObjects());
        try {
            remoteUnitOfWork = ((RemoteSession)this.getParent()).getRemoteConnection().commitRootUnitOfWork(this);
        }
        catch (RuntimeException exception) {
            if (this.wasTransactionBegunPrematurely()) {
                this.getParent().getTransactionMutex().release();
            }
            this.setWasTransactionBegunPrematurely(false);
            throw exception;
        }
        if (this.wasTransactionBegunPrematurely()) {
            this.getParent().getTransactionMutex().release();
        }
        remoteUnitOfWork.setParent(this);
        remoteUnitOfWork.setProject(this.getProject());
        remoteUnitOfWork.prepareForMergeIntoRemoteUnitOfWork();
        remoteUnitOfWork.commitIntoRemoteUnitOfWork();
        this.commitRootUnitOfWorkOnClient();
    }

    protected void commitRootUnitOfWorkOnClient() {
        this.collectAndPrepareObjectsForNestedMerge();
        UnitOfWorkChangeSet uowChangeSet = (UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet();
        if (uowChangeSet == null) {
            this.setUnitOfWorkChangeSet(new UnitOfWorkChangeSet(this));
            uowChangeSet = (UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet();
            this.calculateChanges(this.cloneMap(this.getCloneMapping()), (UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet(), false);
            this.allClones = null;
        }
        for (Map<ObjectChangeSet, ObjectChangeSet> newList : uowChangeSet.getNewObjectChangeSets().values()) {
            Iterator<ObjectChangeSet> newChangeSets = new IdentityHashMap<ObjectChangeSet, ObjectChangeSet>(newList).keySet().iterator();
            while (newChangeSets.hasNext()) {
                uowChangeSet.putNewObjectInChangesList(newChangeSets.next(), this);
            }
        }
        Iterator iterator = this.getObjectsDeletedDuringCommit().keySet().iterator();
        while (iterator.hasNext()) {
            ((UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet()).addDeletedObject(iterator.next(), this);
        }
        this.mergeChangesIntoParent();
    }

    public Object executeQuery(String queryName) throws DatabaseException {
        return this.executeQuery(queryName, new Vector(1));
    }

    public Object executeQuery(String queryName, Class domainClass) throws DatabaseException {
        return this.executeQuery(queryName, domainClass, new Vector(1));
    }

    public Object executeQuery(String queryName, Class domainClass, Vector argumentValues) throws DatabaseException {
        RemoteSession remoteSession = null;
        if (this.getParent().isRemoteSession()) {
            remoteSession = (RemoteSession)this.getParent();
        } else {
            RemoteUnitOfWork uow = (RemoteUnitOfWork)this.getParent();
            while (uow.getParent().isRemoteUnitOfWork()) {
                uow = (RemoteUnitOfWork)uow.getParent();
            }
            remoteSession = (RemoteSession)uow.getParent();
        }
        Transporter transporter = remoteSession.getRemoteConnection().remoteExecuteNamedQuery(queryName, domainClass, argumentValues);
        transporter.getQuery().setSession(this);
        return transporter.getQuery().extractRemoteResult(transporter);
    }

    public Object executeQuery(String queryName, Vector argumentValues) throws DatabaseException {
        if (this.containsQuery(queryName)) {
            return super.executeQuery(queryName, argumentValues);
        }
        return this.executeQuery(queryName, null, argumentValues);
    }

    public ClassDescriptor getDescriptor(Class domainClass) {
        return this.getParent().getDescriptor(domainClass);
    }

    public Vector getNewObjectsCache() {
        return this.newObjectsCache;
    }

    public RemoteSessionController getParentSessionController() {
        return this.parentSessionController;
    }

    public DatabasePlatform getPlatform() {
        return this.getParent().getPlatform();
    }

    public Platform getDatasourcePlatform() {
        return this.getParent().getDatasourcePlatform();
    }

    public Vector getUnregisteredNewObjectsCache() {
        return this.unregisteredNewObjectsCache;
    }

    public Object internalExecuteQuery(DatabaseQuery query, AbstractRecord Record2) throws DatabaseException, QueryException {
        if (this.isOnClient()) {
            boolean objectLevelRead;
            boolean bl = objectLevelRead = query.isObjectLevelReadQuery() && !query.isReportQuery() && query.shouldMaintainCache();
            if (objectLevelRead) {
                ObjectLevelReadQuery readQuery = (ObjectLevelReadQuery)query;
                if (this.isAfterWriteChangesButBeforeCommit()) {
                    throw ValidationException.illegalOperationForUnitOfWorkLifecycle(this.getLifecycle(), "executeQuery(ObjectLevelReadQuery)");
                }
                Object result = readQuery.checkEarlyReturn(this, Record2);
                if (result != null) {
                    if (result == InvalidObject.instance) {
                        return null;
                    }
                    return result;
                }
                if (readQuery.isLockQuery(this) && !this.wasTransactionBegunPrematurely()) {
                    this.beginEarlyTransaction();
                }
            } else if (query.isObjectLevelModifyQuery()) {
                return query.executeInUnitOfWork(this, Record2);
            }
            if (!this.getCommitManager().isActive() && query.isDataModifyQuery() && !this.wasTransactionBegunPrematurely()) {
                this.beginEarlyTransaction();
            }
            Object result = this.getParent().executeQuery(query, Record2);
            if (objectLevelRead) {
                result = ((ObjectLevelReadQuery)query).registerResultInUnitOfWork(result, this, Record2, false);
            }
            return result;
        }
        return query.executeInUnitOfWork(this, Record2);
    }

    protected boolean isOnClient() {
        return this.isOnClient;
    }

    public boolean isRemoteUnitOfWork() {
        return true;
    }

    protected void prepareForMergeIntoRemoteUnitOfWork() {
        IdentityHashMap<Object, Object> originalToClone = new IdentityHashMap<Object, Object>();
        IdentityHashMap<Object, Object> cloneToOriginal = new IdentityHashMap<Object, Object>();
        Enumeration returnedNewObjects = this.getNewObjectsCache().elements();
        Enumeration newObjects = ((RemoteUnitOfWork)this.getParent()).getNewObjectsCache().elements();
        while (returnedNewObjects.hasMoreElements()) {
            Object cloneFromParent = newObjects.nextElement();
            Object cloneFromSelf = returnedNewObjects.nextElement();
            if (cloneFromSelf == null) continue;
            originalToClone.put(cloneFromParent, cloneFromSelf);
            cloneToOriginal.put(cloneFromSelf, cloneFromParent);
        }
        Enumeration returnedUnregisteredNewObjects = this.getUnregisteredNewObjectsCache().elements();
        Enumeration unregisteredNewObjects = ((RemoteUnitOfWork)this.getParent()).getUnregisteredNewObjectsCache().elements();
        while (returnedUnregisteredNewObjects.hasMoreElements()) {
            Object cloneFromParent = ((RemoteUnitOfWork)this.getParent()).getUnregisteredNewObjects().get(unregisteredNewObjects.nextElement());
            Object cloneFromSelf = this.getUnregisteredNewObjects().get(returnedUnregisteredNewObjects.nextElement());
            originalToClone.put(cloneFromParent, cloneFromSelf);
            cloneToOriginal.put(cloneFromSelf, cloneFromParent);
        }
        this.setNewObjectsOriginalToClone(originalToClone);
        this.setNewObjectsCloneToOriginal(cloneToOriginal);
        IdentityHashMap<Object, Object> objectsDeletedDuringCommit = new IdentityHashMap<Object, Object>();
        for (Object deletedObject : this.getObjectsDeletedDuringCommit().keySet()) {
            Object primaryKey = this.getId(deletedObject);
            Object cloneFromParent = this.getParent().getIdentityMapAccessor().getFromIdentityMap(primaryKey, deletedObject.getClass());
            if (cloneFromParent == null && (cloneFromParent = cloneToOriginal.get(deletedObject)) == null) {
                cloneFromParent = deletedObject;
            }
            objectsDeletedDuringCommit.put(cloneFromParent, this.getId(cloneFromParent));
            ((UnitOfWorkImpl)this.getParent()).getIdentityMapAccessor().removeFromIdentityMap(cloneFromParent);
        }
        ((UnitOfWorkImpl)this.getParent()).setObjectsDeletedDuringCommit(objectsDeletedDuringCommit);
    }

    public void reinitializeForSession(AbstractSession session, RemoteSessionController parentSessionController) {
        if (session.isServerSession()) {
            session = ((ServerSession)session).acquireClientSession();
        }
        this.setIsOnClient(false);
        this.setParentSessionController(parentSessionController);
        this.setParent(session);
        this.setProject(session.getProject());
        this.setProfiler(this.getProfiler());
        if (session.hasEventManager()) {
            this.setEventManager(session.getEventManager().clone(this));
        }
        this.setSessionLog(session.getSessionLog());
        this.setLog(session.getLog());
        this.setCommitManager(new CommitManager(this));
        this.setTransactionMutex(new ConcurrencyManager());
        this.getCommitManager().setCommitOrder(session.getCommitManager().getCommitOrder());
        if (this.getParent().hasExternalTransactionController()) {
            this.getParent().getExternalTransactionController().registerSynchronizationListener(this, this.getParent());
        }
    }

    protected void setIsOnClient(boolean isOnClient) {
        this.isOnClient = isOnClient;
    }

    protected void setNewObjectsCache(Vector newObjectsCache) {
        this.newObjectsCache = newObjectsCache;
    }

    public void setParentSessionController(RemoteSessionController parentSessionController) {
        this.parentSessionController = parentSessionController;
    }

    protected void setUnregisteredNewObjectsCache(Vector unregisteredNewObjectsCache) {
        this.unregisteredNewObjectsCache = unregisteredNewObjectsCache;
    }

    public String toString() {
        return Helper.getShortClassName(this.getClass()) + "()";
    }

    public boolean verifyDelete(Object domainObject) {
        return this.getParent().verifyDelete(domainObject);
    }
}

