/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.ui.internal.format;

import java.util.LinkedList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioningListener;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.TypedPosition;
import org.eclipse.jface.text.formatter.ContextBasedFormattingStrategy;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.wst.jsdt.internal.formatter.DefaultCodeFormatter;
import org.eclipse.wst.jsdt.web.core.internal.Logger;
import org.eclipse.wst.jsdt.web.core.javascript.IJsTranslation;
import org.eclipse.wst.jsdt.web.core.javascript.IJsTranslator;
import org.eclipse.wst.jsdt.web.core.javascript.JsTranslation;
import org.eclipse.wst.jsdt.web.core.javascript.JsTranslator;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.text.BasicStructuredDocument;

public class FormattingStrategyJSDT
extends ContextBasedFormattingStrategy {
    private static final Pattern END_PATTERN = Pattern.compile("((//.*-->\\s*)\\z)");
    private static final int regionStartIndentLevel = 1;
    private final LinkedList fDocuments = new LinkedList();
    private final LinkedList fPartitions = new LinkedList();
    private int startIndentLevel;
    static /* synthetic */ Class class$0;

    public void format() {
        super.format();
        IStructuredDocument document = (IStructuredDocument)this.fDocuments.removeFirst();
        TypedPosition partition = (TypedPosition)this.fPartitions.removeFirst();
        if (document != null) {
            IStructuredDocumentRegion scriptTagStartRegion = document.getRegionAtCharacterOffset(partition.offset - 1);
            String scriptRegionIndent = "";
            if (scriptTagStartRegion != null) {
                try {
                    int scriptRegionIndentLevel = this.getIndentOfLine((IDocument)document, document.getLineOfOffset(scriptTagStartRegion.getStartOffset())).length();
                    scriptRegionIndent = this.getIndentationString(this.getPreferences(), scriptRegionIndentLevel);
                    this.startIndentLevel += scriptRegionIndentLevel;
                }
                catch (BadLocationException e) {
                    Logger.logException((String)"Could not calculate starting indent of the script region, using 0", (Throwable)e);
                }
            }
            String lineDelim = TextUtilities.getDefaultLineDelimiter((IDocument)document);
            try {
                IJsTranslator translator;
                String jsTextNotTranslated = document.get(partition.getOffset(), partition.getLength());
                String preText = "";
                String postText = String.valueOf(lineDelim) + scriptRegionIndent;
                Pattern startPattern = Pattern.compile("(\\A(\\s*<!--.*(" + lineDelim + ")?))");
                Matcher matcher = startPattern.matcher(jsTextNotTranslated);
                if (matcher.find()) {
                    jsTextNotTranslated = matcher.replaceFirst("");
                    preText = String.valueOf(lineDelim) + scriptRegionIndent + matcher.group().trim();
                }
                if ((matcher = END_PATTERN.matcher(jsTextNotTranslated)).find()) {
                    jsTextNotTranslated = matcher.replaceFirst("");
                    postText = String.valueOf(lineDelim) + scriptRegionIndent + matcher.group().trim() + postText;
                }
                ReplaceEdit replaceEdit = new ReplaceEdit(partition.getOffset(), partition.getLength(), jsTextNotTranslated);
                replaceEdit.apply((IDocument)document);
                int jsRegionLength = jsTextNotTranslated.length();
                IJsTranslation translation = this.getTranslation(document);
                String jsTextTranslated = translation.getJsText();
                TextEdit edit = CodeFormatterUtil.format2((int)8, (String)jsTextTranslated, (int)partition.getOffset(), (int)jsRegionLength, (int)this.startIndentLevel, (String)lineDelim, (Map)this.getPreferences());
                Document jsDoc = new Document(jsTextTranslated);
                if (translation instanceof JsTranslation && (translator = ((JsTranslation)translation).getTranslator()) instanceof JsTranslator) {
                    Region[] regions = ((JsTranslator)translator).getGeneratedRanges();
                    int r = 0;
                    while (r < regions.length) {
                        jsDoc.replace(regions[r].getOffset(), regions[r].getLength(), document.get(regions[r].getOffset(), regions[r].getLength()));
                        ++r;
                    }
                }
                if (edit == null) {
                    return;
                }
                edit.apply((IDocument)jsDoc);
                String replaceText = String.valueOf(lineDelim) + this.getIndentationString(this.getPreferences(), this.startIndentLevel) + jsDoc.get(edit.getOffset(), edit.getLength()).trim();
                replaceText = String.valueOf(preText) + replaceText + postText;
                replaceEdit = new ReplaceEdit(partition.getOffset(), jsRegionLength, replaceText);
                replaceEdit.apply((IDocument)document);
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    public void formatterStarts(IFormattingContext context) {
        this.fPartitions.addLast(context.getProperty((Object)"formatting.context.partition"));
        this.fDocuments.addLast(context.getProperty((Object)"formatting.context.medium"));
        this.startIndentLevel = 1;
        Map projectOptions = (Map)context.getProperty((Object)"formatting.context.preferences");
        if (projectOptions == null) {
            IDocument doc = (IDocument)context.getProperty((Object)"formatting.context.medium");
            context.setProperty((Object)"formatting.context.preferences", (Object)this.getProjectOptions(doc));
        }
        super.formatterStarts(context);
    }

    public void formatterStops() {
        super.formatterStops();
        this.fPartitions.clear();
        this.fDocuments.clear();
        this.startIndentLevel = 0;
    }

    public String getIndentationString(Map options, int indentationLevel) {
        DefaultCodeFormatter formatter = new DefaultCodeFormatter(options);
        return formatter.createIndentationString(indentationLevel);
    }

    private Map getProjectOptions(IDocument baseDocument) {
        IJavaScriptProject javaProject = null;
        Map options = null;
        ITextFileBuffer buffer = FileBuffers.getTextFileBufferManager().getTextFileBuffer(baseDocument);
        if (buffer != null) {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IPath filePath = buffer.getLocation();
            IProject project = null;
            if (filePath.segmentCount() > 0) {
                project = root.getProject(filePath.segment(0));
            }
            if (project != null) {
                javaProject = JavaScriptCore.create(project);
            }
        }
        if (javaProject != null) {
            options = javaProject.getOptions(true);
        }
        if (options == null) {
            options = JavaScriptCore.getOptions();
        }
        return options;
    }

    /*
     * Exception decompiling
     */
    public IJsTranslation getTranslation(IStructuredDocument document) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 107->110)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String getIndentOfLine(IDocument d, int line) throws BadLocationException {
        if (line > -1) {
            int start = d.getLineOffset(line);
            int end = start + d.getLineLength(line) - 1;
            int whiteEnd = this.findEndOfWhiteSpace(d, start, end);
            return d.get(start, whiteEnd - start);
        }
        return "";
    }

    private int findEndOfWhiteSpace(IDocument document, int offset, int end) throws BadLocationException {
        while (offset < end) {
            char c = document.getChar(offset);
            if (c != ' ' && c != '\t') {
                return offset;
            }
            ++offset;
        }
        return end;
    }

    class ModelIrritant
    implements IDocumentPartitioningListener {
        public ModelIrritant(IDocument attachedDoc) {
        }

        public void documentPartitioningChanged(IDocument document) {
            document.removeDocumentPartitioningListener((IDocumentPartitioningListener)this);
            if (document instanceof BasicStructuredDocument) {
                try {
                    ((BasicStructuredDocument)document).replace(0, document.getLength(), document.get());
                }
                catch (BadLocationException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }
}

