/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.common.core.tableviewer;

import java.util.Vector;
import org.eclipse.datatools.sqltools.common.core.tableviewer.IRowData;
import org.eclipse.datatools.sqltools.common.core.tableviewer.ITableData;
import org.eclipse.datatools.sqltools.common.core.tableviewer.ITableDataChangeListener;
import org.eclipse.datatools.sqltools.common.core.tableviewer.RowData;
import org.eclipse.jface.util.ListenerList;

public abstract class AbstractTableData
implements ITableData {
    protected Vector _rows = new Vector();
    protected ListenerList _listenerList = new ListenerList();

    public void setRows(Vector rows) {
        this._rows = rows;
    }

    public void deleteRow(IRowData row) {
        if (((RowData)row).getState() == 3 || ((RowData)row).getState() == 0 || ((RowData)row).getState() == 1) {
            this._rows.remove(row);
        } else {
            ((RowData)row).setState(2);
        }
        Object[] listeners = this._listenerList.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((ITableDataChangeListener)listeners[i]).rowDeleted(row);
            ++i;
        }
    }

    public IRowData insertRow() {
        Object[] data = new Object[this.getColumnCount()];
        RowData row = new RowData(this, 3, data);
        this._rows.add(row);
        Object[] listeners = this._listenerList.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((ITableDataChangeListener)listeners[i]).rowAdded(row);
            ++i;
        }
        return row;
    }

    public void insertRow(IRowData rowData, int row) {
        this._rows.insertElementAt(rowData, row);
        Object[] listeners = this._listenerList.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((ITableDataChangeListener)listeners[i]).rowAdded(rowData);
            ++i;
        }
    }

    public void revert() {
        int i = 0;
        while (i < this._rows.size()) {
            RowData row = (RowData)this._rows.elementAt(i);
            if (row.getState() == 1 || row.getState() == 2) {
                row.revertToOriginal();
                ++i;
                continue;
            }
            if (row.getState() == 3) {
                this._rows.remove(i);
                continue;
            }
            if (row.getState() != 0) continue;
            ++i;
        }
    }

    public void resetRowsToOriginal() {
        int i = 0;
        while (i < this._rows.size()) {
            RowData row = (RowData)this._rows.elementAt(i);
            if (row.getState() == 1 || row.getState() == 3) {
                row.resetToOriginal();
                ++i;
                continue;
            }
            if (row.getState() == 2) {
                this._rows.remove(i);
                continue;
            }
            if (row.getState() != 0) continue;
            ++i;
        }
    }

    public void fireUpdated(IRowData row, int colIndex, Object oldVal, Object newVal) {
        Object[] listeners = this._listenerList.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((ITableDataChangeListener)listeners[i]).rowDataUpdated(row, colIndex, oldVal, newVal);
            ++i;
        }
    }

    public void addTableDataChangeListener(ITableDataChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (listener instanceof ITableDataChangeListener) {
            this._listenerList.add((Object)listener);
        }
    }

    public void removeTableDataChangeListener(ITableDataChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (listener instanceof ITableDataChangeListener) {
            this._listenerList.remove((Object)listener);
        }
    }

    public boolean isNewRowDataAllowed() {
        return true;
    }

    public abstract boolean isReadonly();

    public abstract int getColumnCount();

    public abstract String getColumnName(int var1);

    public abstract int getColumnType(int var1);

    public abstract String getColumnHeader(int var1);

    public abstract Vector getRows();

    public abstract boolean save() throws Exception;
}

