/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsil.util;

import java.io.IOException;
import java.util.Properties;
import org.apache.wsil.util.Util;

public final class WSILProperties {
    protected static Properties props = new Properties();
    protected static final String DEF_DOCUMENT_FACTORY = "org.apache.wsil.impl.WSILDocumentFactoryImpl";
    protected static final String PROP_DOCUMENT_FACTORY = "wsil.document.factory";
    protected static final String PROP_FILENAME = "wsil.properties";
    public static final String WSDL_EXTENSION = "wsdl";
    public static String TRANSPORT_CLASS = "org.uddi4j.transport.ApacheAxisTransport";
    public static final String PROP_TRANSPORT_CLASS = "wsil.transport.class";
    public static String WSIL_HOSTNAME = "localhost";
    public static final String PROP_WSIL_HOSTNAME = "wsil.hostname";
    public static String WSIL_PORT = "8080";
    public static final String PROP_WSIL_PORT = "wsil.port";
    public static String WSIL_DOCUMENT_NAME = "inspection.wsil";
    public static final String PROP_WSIL_DOCUMENT_NAME = "wsil.document.name";
    private static ThreadLocal propsThreadLocal = new ThreadLocal();

    public static void loadProperties() {
        try {
            props.load(Util.getInputStream(PROP_FILENAME));
            TRANSPORT_CLASS = props.getProperty(PROP_TRANSPORT_CLASS, TRANSPORT_CLASS);
            WSIL_HOSTNAME = props.getProperty(PROP_WSIL_HOSTNAME, WSIL_HOSTNAME);
            WSIL_PORT = props.getProperty(PROP_WSIL_PORT, WSIL_PORT);
            WSIL_DOCUMENT_NAME = props.getProperty(PROP_WSIL_DOCUMENT_NAME, WSIL_DOCUMENT_NAME);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        WSILProperties.getProperties();
    }

    private WSILProperties() {
    }

    public static Properties getProperties() {
        props = (Properties)propsThreadLocal.get();
        if (props == null) {
            props = System.getProperties();
        }
        return props;
    }

    public static void setProperties(Properties properties) {
        propsThreadLocal.set(properties);
    }

    public static String getDocumentFactory() {
        return WSILProperties.getProperties().getProperty(PROP_DOCUMENT_FACTORY, DEF_DOCUMENT_FACTORY);
    }

    public static void main(String[] stringArray) {
        try {
            for (int i = 0; i < 5; ++i) {
                new Thread(new ThreadTest("test" + i)).start();
                try {
                    Thread.sleep(200L);
                    System.out.println("System Properties? - " + WSILProperties.getProperties());
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        WSILProperties.loadProperties();
    }

    private static class ThreadTest
    extends Thread {
        String name;

        ThreadTest(String string) {
            this.name = string;
        }

        public void run() {
            Properties properties = new Properties();
            properties.setProperty(WSILProperties.PROP_DOCUMENT_FACTORY, this.name);
            WSILProperties.setProperties(properties);
        }
    }
}

