/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.core.parser.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.mylyn.wikitext.core.parser.outline.OutlineItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SplitOutlineItem
extends OutlineItem {
    private String splitTarget;
    private Map<String, SplitOutlineItem> outlineItemById;
    private List<SplitOutlineItem> pages;

    public SplitOutlineItem(OutlineItem parent, int level, String id, int offset, int length, String label) {
        super(parent, level, id, offset, length, label);
    }

    public void setSplitTarget(String splitTarget) {
        this.splitTarget = splitTarget;
    }

    public String getSplitTarget() {
        if (this.splitTarget == null && this.getParent() != null) {
            return this.getParent().getSplitTarget();
        }
        return this.splitTarget;
    }

    public List<SplitOutlineItem> getPageOrder() {
        if (this.getParent() != null) {
            return this.getParent().getPageOrder();
        }
        if (this.pages == null) {
            final HashSet pageTargets = new HashSet();
            this.pages = new ArrayList<SplitOutlineItem>();
            this.accept(new OutlineItem.Visitor(){

                public boolean visit(OutlineItem item) {
                    SplitOutlineItem split = (SplitOutlineItem)item;
                    if (pageTargets.add(split.getSplitTarget())) {
                        SplitOutlineItem.this.pages.add(split);
                    }
                    return true;
                }
            });
        }
        return this.pages;
    }

    @Override
    public SplitOutlineItem getParent() {
        return (SplitOutlineItem)super.getParent();
    }

    public SplitOutlineItem getOutlineItemById(String id) {
        if (this.getParent() != null) {
            return this.getParent().getOutlineItemById(id);
        }
        if (this.outlineItemById == null) {
            final HashMap<String, SplitOutlineItem> splitTargetById = new HashMap<String, SplitOutlineItem>();
            this.accept(new OutlineItem.Visitor(){

                public boolean visit(OutlineItem item) {
                    if (item.getId() != null) {
                        if (splitTargetById.containsKey(item.getId())) {
                            throw new IllegalStateException(String.format("Duplicate id '%s'", item.getId()));
                        }
                        splitTargetById.put(item.getId(), (SplitOutlineItem)item);
                    }
                    return true;
                }
            });
            this.outlineItemById = splitTargetById;
        }
        return this.outlineItemById.get(id);
    }
}

