/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.wst.server.core.IModuleArtifact;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.internal.ILaunchableAdapter;
import org.eclipse.wst.server.core.internal.Trace;
import org.eclipse.wst.server.core.model.LaunchableAdapterDelegate;

public class LaunchableAdapter
implements ILaunchableAdapter {
    private IConfigurationElement element;
    private LaunchableAdapterDelegate delegate;

    public LaunchableAdapter(IConfigurationElement element) {
        this.element = element;
    }

    public String getId() {
        return this.element.getAttribute("id");
    }

    public int getPriority() {
        try {
            return Integer.parseInt(this.element.getAttribute("priority"));
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public LaunchableAdapterDelegate getDelegate() {
        block3: {
            if (this.delegate == null) {
                try {
                    this.delegate = (LaunchableAdapterDelegate)this.element.createExecutableExtension("class");
                }
                catch (Throwable t) {
                    if (!Trace.SEVERE) break block3;
                    Trace.trace("/severe", "Could not create delegate" + this.toString(), t);
                }
            }
        }
        return this.delegate;
    }

    public Object getLaunchable(IServer server, IModuleArtifact object) throws CoreException {
        try {
            return this.getDelegate().getLaunchable(server, object);
        }
        catch (CoreException ce) {
            throw ce;
        }
        catch (Exception e) {
            if (Trace.SEVERE) {
                Trace.trace("/severe", "Error calling delegate " + this.toString(), e);
            }
            return null;
        }
    }

    public String toString() {
        return "LaunchableAdapter[" + this.getId() + "]";
    }
}

