/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.common.widgets;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class IntegerDocument
extends PlainDocument {
    private static final long serialVersionUID = 2217237305506835428L;
    private int currentValue = 0;

    public int getValue() {
        return this.currentValue;
    }

    public void insertString(int offset, String str, AttributeSet attributes) throws BadLocationException {
        String newValue;
        if (str == null) {
            return;
        }
        int length = this.getLength();
        if (length == 0) {
            newValue = str;
        } else {
            String currentContent = this.getText(0, length);
            StringBuilder currentBuffer = new StringBuilder(currentContent);
            currentBuffer.insert(offset, str);
            newValue = currentBuffer.toString();
        }
        this.currentValue = this.checkInput(newValue, offset);
        super.insertString(offset, str, attributes);
    }

    public void remove(int offset, int length) throws BadLocationException {
        int currentLength = this.getLength();
        String currentContent = this.getText(0, currentLength);
        String before = currentContent.substring(0, offset);
        String after = currentContent.substring(length + offset, currentLength);
        String newValue = String.valueOf(before) + after;
        this.currentValue = this.checkInput(newValue, offset);
        super.remove(offset, length);
    }

    private int checkInput(String proposedValue, int offset) throws BadLocationException {
        if (proposedValue.length() > 0) {
            try {
                int newValue = Integer.parseInt(proposedValue);
                return newValue;
            }
            catch (NumberFormatException numberFormatException) {
                throw new BadLocationException(proposedValue, offset);
            }
        }
        return 0;
    }
}

