/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.common.widgets;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;
import org.insightech.er.Activator;
import org.insightech.er.ResourceString;
import org.insightech.er.common.widgets.table.CellEditWorker;
import org.insightech.er.common.widgets.table.CustomCellEditor;
import org.insightech.er.common.widgets.table.HeaderClickListener;
import org.insightech.er.common.widgets.table.PanelCellEditor;
import org.insightech.er.util.Format;

public class RowHeaderTable
extends JScrollPane
implements ClipboardOwner {
    private static final long serialVersionUID = 1L;
    private DefaultListModel listModel;
    private DefaultTableModel tableModel;
    private JTable table;
    private MultiLineHeaderRenderer headerRenderer;
    private MultiLineHeaderRenderer selectedHeaderRenderer;
    private CellEditWorker cellEditWorker;
    private Map<Integer, PanelCellEditor> cellEditorMap = new HashMap<Integer, PanelCellEditor>();
    private boolean clipbordOn = true;
    private HeaderClickListener headerClickListener;
    private int mouseOverColumn = -1;
    private boolean editable;
    private Color MODIFIED_COLOR = new Color(199, 255, 183);

    public RowHeaderTable(int width, int height, final int rowHeaderWidth, int rowHeight, boolean iconEnable, final boolean editable) {
        this.editable = editable;
        this.table = new JTable(){
            private static final long serialVersionUID = 1L;
            private JPopupMenu pupupMenu;
            {
                this.pupupMenu = new TablePopupMenu();
            }

            public void editingStopped(ChangeEvent e) {
                Object value;
                TableCellEditor editor;
                if (RowHeaderTable.this.cellEditWorker != null && (editor = this.getCellEditor()) != null && !"".equals((value = editor.getCellEditorValue()).toString()) && this.getEditingRow() == this.getRowCount() - 1) {
                    RowHeaderTable.this.cellEditWorker.addNewRow();
                }
                super.editingStopped(e);
            }

            public Component prepareRenderer(TableCellRenderer tcr, int row, int column) {
                Component c = super.prepareRenderer(tcr, row, column);
                if (RowHeaderTable.this.cellEditWorker != null && !RowHeaderTable.this.table.isRowSelected(row)) {
                    if (RowHeaderTable.this.cellEditWorker.isModified(row, column)) {
                        c.setBackground(RowHeaderTable.this.MODIFIED_COLOR);
                    } else {
                        c.setBackground(null);
                    }
                }
                return c;
            }

            public boolean isCellEditable(int row, int column) {
                if (!editable) {
                    return false;
                }
                return super.isCellEditable(row, column);
            }

            protected void processMouseEvent(MouseEvent event) {
                super.processMouseEvent(event);
                if (event.isPopupTrigger()) {
                    if (!event.isControlDown() && !event.isShiftDown()) {
                        Point origin = event.getPoint();
                        int row = this.rowAtPoint(origin);
                        if (!this.isRowSelected(row)) {
                            this.clearSelection();
                        }
                        if (row != -1) {
                            this.addRowSelectionInterval(row, row);
                        }
                    }
                    this.editingStopped(new ChangeEvent(this));
                    this.pupupMenu.show(event.getComponent(), event.getX(), event.getY());
                }
            }
        };
        this.table.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyevent) {
                if (RowHeaderTable.this.clipbordOn) {
                    if (editable) {
                        if (keyevent.isControlDown() && (keyevent.getKeyCode() == 118 || keyevent.getKeyCode() == 86)) {
                            RowHeaderTable.this.pasteRows();
                        } else if (keyevent.isControlDown() && (keyevent.getKeyCode() == 120 || keyevent.getKeyCode() == 88)) {
                            RowHeaderTable.this.cutRows();
                        }
                    }
                    if (keyevent.isControlDown() && (keyevent.getKeyCode() == 99 || keyevent.getKeyCode() == 67)) {
                        RowHeaderTable.this.copyRows();
                    }
                }
            }
        });
        this.table.setAutoCreateColumnsFromModel(true);
        this.table.setAutoResizeMode(0);
        this.headerRenderer = new MultiLineHeaderRenderer(null, iconEnable);
        this.selectedHeaderRenderer = new MultiLineHeaderRenderer(UIManager.getColor("Table.selectionBackground"), iconEnable);
        final JTableHeader tableHeader = this.table.getTableHeader();
        tableHeader.setReorderingAllowed(false);
        tableHeader.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent e) {
                int column = RowHeaderTable.this.table.getTableHeader().columnAtPoint(e.getPoint());
                if (column != -1 && RowHeaderTable.this.headerClickListener != null && RowHeaderTable.this.mouseOverColumn != column) {
                    if (RowHeaderTable.this.mouseOverColumn != -1) {
                        TableColumn oldTableColumn = RowHeaderTable.this.table.getColumnModel().getColumn(RowHeaderTable.this.mouseOverColumn);
                        oldTableColumn.setHeaderRenderer(RowHeaderTable.this.headerRenderer);
                    }
                    TableColumn newTableColumn = RowHeaderTable.this.table.getColumnModel().getColumn(column);
                    newTableColumn.setHeaderRenderer(RowHeaderTable.this.selectedHeaderRenderer);
                    tableHeader.repaint();
                    RowHeaderTable.this.mouseOverColumn = column;
                }
            }
        });
        tableHeader.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent e) {
                int column = RowHeaderTable.this.table.getTableHeader().columnAtPoint(e.getPoint());
                if (column != -1 && RowHeaderTable.this.headerClickListener != null) {
                    RowHeaderTable.this.mouseOverColumn = column;
                    TableColumn tableColumn = RowHeaderTable.this.table.getColumnModel().getColumn(column);
                    tableColumn.setHeaderRenderer(RowHeaderTable.this.selectedHeaderRenderer);
                    tableHeader.repaint();
                }
            }

            public void mouseExited(MouseEvent e) {
                if (RowHeaderTable.this.headerClickListener != null && RowHeaderTable.this.mouseOverColumn != -1) {
                    TableColumn tableColumn = RowHeaderTable.this.table.getColumnModel().getColumn(RowHeaderTable.this.mouseOverColumn);
                    tableColumn.setHeaderRenderer(RowHeaderTable.this.headerRenderer);
                    RowHeaderTable.this.mouseOverColumn = -1;
                }
            }

            public void mouseClicked(MouseEvent e) {
                int column = RowHeaderTable.this.table.getTableHeader().columnAtPoint(e.getPoint());
                if (RowHeaderTable.this.headerClickListener != null) {
                    RowHeaderTable.this.headerClickListener.onHeaderClick(column);
                }
            }
        });
        this.table.setRowHeight(rowHeight);
        this.table.setGridColor(new Color(230, 230, 230));
        this.tableModel = new DefaultTableModel();
        this.table.setModel(this.tableModel);
        if (rowHeaderWidth > 0) {
            final JList rowHeader = new JList(){
                private static final long serialVersionUID = 1L;

                protected void processMouseEvent(MouseEvent event) {
                    super.processMouseEvent(event);
                    if (event.isPopupTrigger()) {
                        event.setSource(RowHeaderTable.this.table);
                        event.translatePoint(-rowHeaderWidth, 0);
                        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
                        eventQueue.postEvent(event);
                    }
                }

                protected void processKeyEvent(KeyEvent event) {
                    super.processKeyEvent(event);
                    if (event.getID() == 401) {
                        if (editable) {
                            if (event.isControlDown() && (event.getKeyCode() == 118 || event.getKeyCode() == 86)) {
                                RowHeaderTable.this.pasteRows();
                            } else if (event.isControlDown() && (event.getKeyCode() == 120 || event.getKeyCode() == 88)) {
                                RowHeaderTable.this.cutRows();
                            }
                        }
                        if (event.isControlDown() && (event.getKeyCode() == 99 || event.getKeyCode() == 67)) {
                            RowHeaderTable.this.copyRows();
                        }
                    }
                }
            };
            rowHeader.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    RowHeaderTable.this.table.editingStopped(new ChangeEvent(this));
                    int[] selectedIndices = rowHeader.getSelectedIndices();
                    RowHeaderTable.this.table.clearSelection();
                    int i = 0;
                    while (i < selectedIndices.length) {
                        RowHeaderTable.this.table.addRowSelectionInterval(selectedIndices[i], selectedIndices[i]);
                        ++i;
                    }
                }
            });
            rowHeader.setFixedCellWidth(rowHeaderWidth);
            rowHeader.setFixedCellHeight(this.table.getRowHeight());
            rowHeader.setCellRenderer(new RowHeaderRenderer(this.table));
            rowHeader.setBackground(this.table.getTableHeader().getBackground());
            this.listModel = new DefaultListModel();
            rowHeader.setModel(this.listModel);
            this.setRowHeaderView(rowHeader);
        }
        this.setViewportView(this.table);
        this.setPreferredSize(new Dimension(width, height - 10));
    }

    public void addColumnHeader(String value, int width) {
        TableColumn column;
        TableColumnModel columnModel = this.table.getColumnModel();
        int[] oldWidth = new int[columnModel.getColumnCount()];
        int i = 0;
        while (i < columnModel.getColumnCount()) {
            column = columnModel.getColumn(i);
            oldWidth[i] = column.getPreferredWidth();
            ++i;
        }
        this.tableModel.addColumn(value);
        i = 0;
        while (i < columnModel.getColumnCount()) {
            column = columnModel.getColumn(i);
            column.setHeaderRenderer(this.headerRenderer);
            PanelCellEditor cellEditor = this.cellEditorMap.get(i);
            if (cellEditor != null) {
                column.setCellEditor(cellEditor);
                column.setCellRenderer(cellEditor);
            } else {
                column.setCellEditor(new CustomCellEditor(this.table));
            }
            if (i == columnModel.getColumnCount() - 1) {
                column.setPreferredWidth(width);
            } else {
                column.setPreferredWidth(oldWidth[i]);
            }
            ++i;
        }
    }

    public void addRow(final String headerValue, final Object[] values) {
        if (EventQueue.isDispatchThread()) {
            if (this.listModel != null) {
                this.listModel.addElement(headerValue);
                if (this.listModel.size() >= 2) {
                    this.listModel.set(this.listModel.size() - 2, String.valueOf(this.listModel.size() - 1));
                }
            }
            this.tableModel.addRow(values);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        if (RowHeaderTable.this.listModel != null) {
                            RowHeaderTable.this.listModel.addElement(headerValue);
                            if (RowHeaderTable.this.listModel.size() >= 2) {
                                RowHeaderTable.this.listModel.set(RowHeaderTable.this.listModel.size() - 2, String.valueOf(RowHeaderTable.this.listModel.size() - 1));
                            }
                        }
                        RowHeaderTable.this.tableModel.addRow(values);
                    }
                });
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
        if (this.cellEditWorker != null) {
            this.cellEditWorker.changeRowNum();
        }
    }

    public void addRow(final int row, final String headerValue, final Object[] values) {
        if (EventQueue.isDispatchThread()) {
            if (this.listModel != null) {
                this.listModel.add(row, headerValue);
                int i = row;
                while (i < this.listModel.getSize() - 1) {
                    this.listModel.set(i, String.valueOf(i + 1));
                    ++i;
                }
                this.listModel.set(this.listModel.getSize() - 1, "+");
            }
            this.tableModel.insertRow(row, values);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        if (RowHeaderTable.this.listModel != null) {
                            RowHeaderTable.this.listModel.add(row, headerValue);
                            int i = row;
                            while (i < RowHeaderTable.this.listModel.getSize() - 1) {
                                RowHeaderTable.this.listModel.set(i, String.valueOf(i + 1));
                                ++i;
                            }
                            RowHeaderTable.this.listModel.set(RowHeaderTable.this.listModel.getSize() - 1, "+");
                        }
                        RowHeaderTable.this.tableModel.insertRow(row, values);
                    }
                });
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
        if (this.cellEditWorker != null) {
            this.cellEditWorker.changeRowNum();
        }
    }

    public void removeSelectedRows() {
        if (EventQueue.isDispatchThread()) {
            int[] rows = this.table.getSelectedRows();
            int i = rows.length - 1;
            while (i >= 0) {
                this.removeRow(rows[i]);
                --i;
            }
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        int[] rows = RowHeaderTable.this.table.getSelectedRows();
                        int i = rows.length - 1;
                        while (i >= 0) {
                            RowHeaderTable.this.removeRow(rows[i]);
                            --i;
                        }
                    }
                });
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
    }

    public void removeRow(final int row) {
        if (EventQueue.isDispatchThread()) {
            this.tableModel.removeRow(row);
            if (this.listModel != null) {
                this.listModel.remove(row);
                int i = row;
                while (i < this.listModel.getSize() - 1) {
                    this.listModel.set(i, String.valueOf(i + 1));
                    ++i;
                }
            }
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        RowHeaderTable.this.tableModel.removeRow(row);
                        if (RowHeaderTable.this.listModel != null) {
                            RowHeaderTable.this.listModel.remove(row);
                            int i = row;
                            while (i < RowHeaderTable.this.listModel.getSize() - 1) {
                                RowHeaderTable.this.listModel.set(i, String.valueOf(i + 1));
                                ++i;
                            }
                        }
                    }
                });
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
        if (this.cellEditWorker != null) {
            this.cellEditWorker.changeRowNum();
        }
    }

    public void removeAllRow() {
        while (this.tableModel.getRowCount() > 0) {
            this.removeRow(0);
        }
    }

    public void removeData() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    if (RowHeaderTable.this.listModel != null) {
                        RowHeaderTable.this.listModel.removeAllElements();
                    }
                    RowHeaderTable.this.tableModel.setRowCount(0);
                    RowHeaderTable.this.tableModel.setColumnCount(0);
                }
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
        if (this.cellEditWorker != null) {
            this.cellEditWorker.changeRowNum();
        }
    }

    public int getItemCount() {
        return this.tableModel.getRowCount();
    }

    public int getColumnCount() {
        return this.tableModel.getColumnCount();
    }

    public Object getValueAt(int row, int column) {
        return this.tableModel.getValueAt(row, column);
    }

    public void setValueAt(Object value, int row, int column) {
        this.tableModel.setValueAt(value, row, column);
    }

    public int[] getSelection() {
        return this.table.getSelectedRows();
    }

    public void setCellEditWorker(CellEditWorker cellEditWorker) {
        this.cellEditWorker = cellEditWorker;
    }

    private void copyToClipboard() {
        int[] selectedRows = this.getSelection();
        if (selectedRows.length == 0) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        int columnCount = this.getColumnCount();
        int[] nArray = selectedRows;
        int n = selectedRows.length;
        int n2 = 0;
        while (n2 < n) {
            int selectedRow = nArray[n2];
            int column = 0;
            while (column < columnCount) {
                Object value = this.getValueAt(selectedRow, column);
                builder.append(Format.toString(value));
                builder.append("\t");
                ++column;
            }
            builder.deleteCharAt(builder.length() - 1);
            builder.append("\r\n");
            ++n2;
        }
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(new StringSelection(builder.toString()), this);
    }

    private int pasteFromClipboard(boolean insert) {
        int count = 0;
        if (this.getSelection().length == 0) {
            return 0;
        }
        int row = this.getSelection()[0];
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(this);
        if (transferable == null || !transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            return count;
        }
        try {
            String data = (String)transferable.getTransferData(DataFlavor.stringFlavor);
            Scanner scanner = new Scanner(data);
            Scanner lineScanner = null;
            while (scanner.hasNextLine()) {
                String text;
                String line = scanner.nextLine();
                lineScanner = new Scanner(line);
                lineScanner.useDelimiter("\t");
                if (!insert) {
                    if (row == this.getItemCount() - 1) {
                        if (this.cellEditWorker == null) break;
                        this.cellEditWorker.addNewRow();
                    }
                    int column = 0;
                    while (lineScanner.hasNext()) {
                        text = lineScanner.next();
                        this.setValueAt(text, row, column++);
                    }
                } else {
                    ArrayList<String> texts = new ArrayList<String>();
                    while (lineScanner.hasNext()) {
                        text = lineScanner.next();
                        texts.add(text);
                    }
                    this.addRow(row, "", texts.toArray(new String[texts.size()]));
                }
                ++row;
                ++count;
            }
        }
        catch (Exception e) {
            Activator.showExceptionDialog(e);
        }
        return count;
    }

    public void setClipbordOn(boolean clipbordOn) {
        this.clipbordOn = clipbordOn;
    }

    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    public void setCellEditor(int column, PanelCellEditor cellEditor) {
        this.cellEditorMap.put(column, cellEditor);
    }

    public PanelCellEditor getCellEditor(int column) {
        return this.cellEditorMap.get(column);
    }

    public void setHeaderClickListener(HeaderClickListener headerClickListener) {
        this.headerClickListener = headerClickListener;
    }

    private void copyRows() {
        this.copyToClipboard();
    }

    private void cutRows() {
        this.copyToClipboard();
        this.removeSelectedRows();
    }

    private void pasteRows() {
        int[] selectedRows = this.getSelection();
        if (selectedRows.length == 0) {
            return;
        }
        int count = this.pasteFromClipboard(false);
        this.table.clearSelection();
        this.table.addRowSelectionInterval(selectedRows[0], selectedRows[0] + count - 1);
    }

    public void insertRow() {
        int[] selectedRows = this.getSelection();
        if (selectedRows.length == 0) {
            return;
        }
        this.addRow(selectedRows[0], "", null);
        this.table.clearSelection();
        this.table.addRowSelectionInterval(selectedRows[0], selectedRows[0]);
    }

    public void insertAndPasteRows() {
        int[] selectedRows = this.getSelection();
        if (selectedRows.length == 0) {
            return;
        }
        int count = this.pasteFromClipboard(true);
        this.table.clearSelection();
        this.table.addRowSelectionInterval(selectedRows[0], selectedRows[0] + count - 1);
    }

    public void deleteRows() {
        this.removeSelectedRows();
    }

    private static class MultiLineHeaderRenderer
    extends JList
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        public MultiLineHeaderRenderer(Color backgroundColor, boolean iconEnable) {
            this.setCellRenderer(new IconListCellRenderer(iconEnable));
            this.setOpaque(true);
            this.setForeground(UIManager.getColor("TableHeader.foreground"));
            if (backgroundColor == null) {
                backgroundColor = UIManager.getColor("TableHeader.background");
            }
            this.setBackground(backgroundColor);
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            JLabel renderer = (JLabel)((Object)this.getCellRenderer());
            renderer.setHorizontalAlignment(0);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setFont(table.getFont());
            String str = value == null ? "" : value.toString();
            BufferedReader br = new BufferedReader(new StringReader(str));
            Vector<String> v = new Vector<String>();
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    v.addElement(line);
                }
            }
            catch (IOException iOException) {}
            this.setListData(v);
            return this;
        }

        public static class IconListCellRenderer
        extends DefaultListCellRenderer {
            private static final long serialVersionUID = -1712884508057784069L;
            private static final ImageIcon ICON;
            private boolean iconEnable;

            static {
                try {
                    URL iconUrl = RowHeaderTable.class.getResource("/wrench.png");
                    ICON = new ImageIcon(iconUrl);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new ExceptionInInitializerError();
                }
            }

            private IconListCellRenderer(boolean iconEnable) {
                this.iconEnable = iconEnable;
            }

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, hasFocus);
                if (this.iconEnable && index == 0) {
                    label.setIcon(ICON);
                } else if (index == 1) {
                    Font font = label.getFont().deriveFont(10.0f);
                    label.setFont(font);
                    label.setForeground(Color.GRAY);
                }
                return label;
            }
        }
    }

    private static class RowHeaderRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = 1L;

        public RowHeaderRenderer(JTable table) {
            JTableHeader header = table.getTableHeader();
            this.setOpaque(true);
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            this.setHorizontalAlignment(0);
            this.setForeground(header.getForeground());
            this.setBackground(header.getBackground());
            this.setFont(header.getFont());
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setText(value == null ? "" : value.toString());
            return this;
        }
    }

    private class TablePopupMenu
    extends JPopupMenu {
        private static final long serialVersionUID = 7496925348009972492L;
        private JMenuItem cutMenu;
        private JMenuItem deleteMenu;

        private TablePopupMenu() {
            FontData fontData = Display.getCurrent().getSystemFont().getFontData()[0];
            Font font = new Font(fontData.getName(), 0, 12);
            if (RowHeaderTable.this.clipbordOn) {
                if (RowHeaderTable.this.editable) {
                    this.cutMenu = new JMenuItem(ResourceString.getResourceString("action.title.cut"));
                    this.cutMenu.setFont(font);
                    this.add(this.cutMenu);
                    this.cutMenu.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent even) {
                            RowHeaderTable.this.cutRows();
                        }
                    });
                }
                JMenuItem copyMenu = new JMenuItem(ResourceString.getResourceString("action.title.copy"));
                copyMenu.setFont(font);
                this.add(copyMenu);
                copyMenu.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent even) {
                        RowHeaderTable.this.copyRows();
                    }
                });
                if (RowHeaderTable.this.editable) {
                    JMenuItem pasteMenu = new JMenuItem(ResourceString.getResourceString("action.title.paste"));
                    pasteMenu.setFont(font);
                    this.add(pasteMenu);
                    pasteMenu.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent even) {
                            RowHeaderTable.this.pasteRows();
                        }
                    });
                    this.addSeparator();
                }
            }
            if (RowHeaderTable.this.editable) {
                JMenuItem insertMenu = new JMenuItem(ResourceString.getResourceString("action.title.insert"));
                insertMenu.setFont(font);
                this.add(insertMenu);
                insertMenu.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent even) {
                        RowHeaderTable.this.insertRow();
                    }
                });
                if (RowHeaderTable.this.clipbordOn) {
                    JMenuItem insertPasteMenu = new JMenuItem(ResourceString.getResourceString("action.title.insert.and.paste"));
                    insertPasteMenu.setFont(font);
                    this.add(insertPasteMenu);
                    insertPasteMenu.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent even) {
                            RowHeaderTable.this.insertAndPasteRows();
                        }
                    });
                }
                this.deleteMenu = new JMenuItem(ResourceString.getResourceString("label.delete"));
                this.deleteMenu.setFont(font);
                this.add(this.deleteMenu);
                this.deleteMenu.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent even) {
                        RowHeaderTable.this.deleteRows();
                    }
                });
            }
        }

        public void show(Component invoker, int x, int y) {
            int[] selectedIndexes = RowHeaderTable.this.getSelection();
            if (selectedIndexes.length == 0 || selectedIndexes[selectedIndexes.length - 1] == RowHeaderTable.this.table.getRowCount() - 1) {
                if (this.cutMenu != null) {
                    this.cutMenu.setEnabled(false);
                    this.deleteMenu.setEnabled(false);
                }
            } else if (this.cutMenu != null) {
                this.cutMenu.setEnabled(true);
                this.deleteMenu.setEnabled(true);
            }
            super.show(invoker, x, y);
        }
    }
}

