/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.db.impl.mysql;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.insightech.er.db.sqltype.SqlType;
import org.insightech.er.editor.model.dbimport.ImportFromDBManagerBase;
import org.insightech.er.editor.model.diagram_contents.element.node.table.ERTable;
import org.insightech.er.editor.model.diagram_contents.element.node.table.index.Index;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MySQLTableImportManager
extends ImportFromDBManagerBase {
    @Override
    protected String getViewDefinitionSQL(String schema) {
        if (schema != null) {
            return "SELECT view_definition FROM information_schema.views WHERE table_schema = ? AND table_name = ?";
        }
        return "SELECT view_definition FROM information_schema.views WHERE table_name = ?";
    }

    @Override
    protected List<Index> getIndexes(ERTable table, DatabaseMetaData metaData, List<ImportFromDBManagerBase.PrimaryKeyData> primaryKeys) throws SQLException {
        List<Index> indexes = super.getIndexes(table, metaData, primaryKeys);
        Iterator<Index> iter = indexes.iterator();
        while (iter.hasNext()) {
            Index index = iter.next();
            if (!"PRIMARY".equalsIgnoreCase(index.getName())) continue;
            iter.remove();
        }
        return indexes;
    }

    @Override
    protected String getConstraintName(ImportFromDBManagerBase.PrimaryKeyData data) {
        return null;
    }

    @Override
    protected void cashOtherColumnData(String tableName, String schema, ImportFromDBManagerBase.ColumnData columnData) throws SQLException {
        String tableNameWithSchema = this.dbSetting.getTableNameWithSchema(tableName, schema);
        SqlType sqlType = SqlType.valueOfId(columnData.type);
        if (sqlType != null && sqlType.doesNeedArgs()) {
            String restrictType = this.getRestrictType(tableNameWithSchema, columnData);
            Pattern p = Pattern.compile(String.valueOf(columnData.type.toLowerCase()) + "\\((.*)\\)");
            Matcher m = p.matcher(restrictType);
            if (m.matches()) {
                columnData.enumData = m.group(1);
            }
        } else if (columnData.type.equals("year")) {
            String restrictType;
            columnData.type = restrictType = this.getRestrictType(tableNameWithSchema, columnData);
        }
    }

    private String getRestrictType(String tableNameWithSchema, ImportFromDBManagerBase.ColumnData columnData) throws SQLException {
        String type = null;
        Statement ps = null;
        ResultSet rs = null;
        try {
            ps = this.con.prepareStatement("SHOW COLUMNS FROM `" + tableNameWithSchema + "` LIKE ?");
            ps.setString(1, columnData.columnName);
            rs = ps.executeQuery();
            if (rs.next()) {
                type = rs.getString("Type");
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (ps != null) {
                ps.close();
            }
        }
        return type;
    }

    @Override
    protected ImportFromDBManagerBase.ColumnData createColumnData(ResultSet columnSet) throws SQLException {
        ImportFromDBManagerBase.ColumnData columnData = super.createColumnData(columnSet);
        String type = columnData.type.toLowerCase();
        if (type.startsWith("decimal")) {
            if (columnData.size == 10 && columnData.decimalDegits == 0) {
                columnData.size = 0;
            }
        } else if (type.startsWith("double")) {
            if (columnData.size == 22 && columnData.decimalDegits == 0) {
                columnData.size = 0;
            }
        } else if (type.startsWith("float") && columnData.size == 12 && columnData.decimalDegits == 0) {
            columnData.size = 0;
        }
        return columnData;
    }
}

