/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.db.impl.sqlserver.tablespace;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.insightech.er.common.widgets.CompositeFactory;
import org.insightech.er.db.impl.sqlserver.tablespace.SqlServerTablespaceProperties;
import org.insightech.er.editor.model.diagram_contents.not_element.tablespace.TablespaceProperties;
import org.insightech.er.editor.view.dialog.outline.tablespace.TablespaceDialog;
import org.insightech.er.util.Format;

public class SqlServerTablespaceDialog
extends TablespaceDialog {
    private Text type;
    private Text pageSize;
    private Text managedBy;
    private Text container;
    private Text extentSize;
    private Text prefetchSize;
    private Text bufferPoolName;

    protected void initialize(Composite composite) {
        super.initialize(composite);
        this.type = CompositeFactory.createText(this, composite, "label.tablespace.type", false);
        this.pageSize = CompositeFactory.createText(this, composite, "label.tablespace.page.size", false);
        this.managedBy = CompositeFactory.createText(this, composite, "label.tablespace.managed.by", false);
        this.container = CompositeFactory.createText(this, composite, "label.tablespace.container", false);
        this.extentSize = CompositeFactory.createText(this, composite, "label.tablespace.extent.size", false);
        this.prefetchSize = CompositeFactory.createText(this, composite, "label.tablespace.prefetch.size", false);
        this.bufferPoolName = CompositeFactory.createText(this, composite, "label.tablespace.buffer.pool.name", false);
    }

    protected TablespaceProperties setTablespaceProperties() {
        SqlServerTablespaceProperties tablespaceProperties = new SqlServerTablespaceProperties();
        tablespaceProperties.setType(this.type.getText().trim());
        tablespaceProperties.setPageSize(this.pageSize.getText().trim());
        tablespaceProperties.setManagedBy(this.managedBy.getText().trim());
        tablespaceProperties.setContainer(this.container.getText().trim());
        tablespaceProperties.setExtentSize(this.extentSize.getText().trim());
        tablespaceProperties.setPrefetchSize(this.prefetchSize.getText().trim());
        tablespaceProperties.setBufferPoolName(this.bufferPoolName.getText().trim());
        return tablespaceProperties;
    }

    protected void setData(TablespaceProperties tablespaceProperties) {
        if (tablespaceProperties instanceof SqlServerTablespaceProperties) {
            SqlServerTablespaceProperties properties = (SqlServerTablespaceProperties)tablespaceProperties;
            this.type.setText(Format.toString(properties.getType()));
            this.pageSize.setText(Format.toString(properties.getPageSize()));
            this.managedBy.setText(Format.toString(properties.getManagedBy()));
            this.container.setText(Format.toString(properties.getContainer()));
            this.extentSize.setText(Format.toString(properties.getExtentSize()));
            this.prefetchSize.setText(Format.toString(properties.getPrefetchSize()));
            this.bufferPoolName.setText(Format.toString(properties.getBufferPoolName()));
        }
    }
}

