/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.operations.IOperationApprover;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.text.undo.DocumentUndoManagerRegistry;
import org.eclipse.text.undo.IDocumentUndoManager;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.texteditor.DocumentProviderRegistry;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IDocumentProviderExtension;
import org.eclipse.ui.texteditor.IDocumentProviderExtension2;
import org.eclipse.ui.texteditor.IDocumentProviderExtension3;
import org.eclipse.ui.texteditor.IElementStateListener;
import org.eclipse.ui.texteditor.IElementStateListenerExtension;
import org.insightech.er.Activator;
import org.osgi.framework.Bundle;

public class TestEditor
extends EditorPart {
    private IDocumentProvider fImplicitDocumentProvider;
    private SourceViewerConfiguration fConfiguration;
    private ISourceViewer fSourceViewer;
    private Image fTitleImage;
    private IElementStateListener fElementStateListener = new ElementStateListener();
    private long fModificationStamp = -1L;
    private boolean fIsSanityCheckEnabled = true;
    private boolean fIsStateValidationEnabled = true;
    private IOperationApprover fNonLocalOperationApprover;
    private IOperationApprover fLinearUndoViolationApprover;

    public IDocumentProvider getDocumentProvider() {
        return this.fImplicitDocumentProvider;
    }

    protected final SourceViewerConfiguration getSourceViewerConfiguration() {
        return this.fConfiguration;
    }

    protected final ISourceViewer getSourceViewer() {
        return this.fSourceViewer;
    }

    protected void setSourceViewerConfiguration(SourceViewerConfiguration configuration) {
        Assert.isNotNull((Object)configuration);
        this.fConfiguration = configuration;
    }

    public boolean isEditable() {
        IDocumentProvider provider = this.getDocumentProvider();
        if (provider instanceof IDocumentProviderExtension) {
            IDocumentProviderExtension extension = (IDocumentProviderExtension)provider;
            return extension.isModifiable((Object)this.getEditorInput());
        }
        return false;
    }

    protected final void internalInit(IWorkbenchWindow window, IEditorSite site, final IEditorInput input) throws PartInitException {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    try {
                        if (TestEditor.this.getDocumentProvider() instanceof IDocumentProviderExtension2) {
                            IDocumentProviderExtension2 extension = (IDocumentProviderExtension2)TestEditor.this.getDocumentProvider();
                            extension.setProgressMonitor(monitor);
                        }
                        TestEditor.this.doSetInput(input);
                    }
                    catch (CoreException x) {
                        throw new InvocationTargetException(x);
                    }
                }
                finally {
                    if (TestEditor.this.getDocumentProvider() instanceof IDocumentProviderExtension2) {
                        IDocumentProviderExtension2 extension = (IDocumentProviderExtension2)TestEditor.this.getDocumentProvider();
                        extension.setProgressMonitor(null);
                    }
                }
            }
        };
        try {
            this.getSite().getWorkbenchWindow().run(false, true, runnable);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            Activator.log(e);
        }
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.internalInit(site.getWorkbenchWindow(), site, input);
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        return new SourceViewer(parent, ruler, styles);
    }

    public void createPartControl(Composite parent) {
        int styles = 512;
        this.fSourceViewer = this.createSourceViewer(parent, null, styles);
        if (this.fConfiguration == null) {
            this.fConfiguration = new SourceViewerConfiguration();
        }
        this.fSourceViewer.configure(this.fConfiguration);
        this.initializeSourceViewer(this.getEditorInput());
    }

    private void initializeSourceViewer(IEditorInput input) {
        IDocumentProvider documentProvider = this.getDocumentProvider();
        IAnnotationModel model = documentProvider.getAnnotationModel((Object)input);
        IDocument document = documentProvider.getDocument((Object)input);
        if (document != null) {
            this.fSourceViewer.setDocument(document, model);
            this.fSourceViewer.setEditable(this.isEditable());
            this.fSourceViewer.showAnnotations(model != null);
        }
        if (this.fElementStateListener instanceof IElementStateListenerExtension) {
            boolean isStateValidated = false;
            if (documentProvider instanceof IDocumentProviderExtension) {
                isStateValidated = ((IDocumentProviderExtension)documentProvider).isStateValidated((Object)input);
            }
            IElementStateListenerExtension extension = (IElementStateListenerExtension)this.fElementStateListener;
            extension.elementStateValidationChanged((Object)input, isStateValidated);
        }
    }

    private void initializeTitle(IEditorInput input) {
        Image oldImage = this.fTitleImage;
        this.fTitleImage = null;
        String title = "";
        if (input != null) {
            IEditorRegistry editorRegistry = PlatformUI.getWorkbench().getEditorRegistry();
            IEditorDescriptor editorDesc = editorRegistry.findEditor(this.getSite().getId());
            ImageDescriptor imageDesc = editorDesc != null ? editorDesc.getImageDescriptor() : null;
            this.fTitleImage = imageDesc != null ? imageDesc.createImage() : null;
            title = input.getName();
        }
        this.setTitleImage(this.fTitleImage);
        this.setPartName(title);
        this.firePropertyChange(257);
        if (oldImage != null && !oldImage.isDisposed()) {
            oldImage.dispose();
        }
    }

    protected void setDocumentProvider(IEditorInput input) {
        this.fImplicitDocumentProvider = DocumentProviderRegistry.getDefault().getDocumentProvider(input);
    }

    private void updateDocumentProvider(IEditorInput input) {
        IDocumentProviderExtension2 extension;
        IProgressMonitor rememberedProgressMonitor = null;
        IDocumentProvider provider = this.getDocumentProvider();
        if (provider != null) {
            provider.removeElementStateListener(this.fElementStateListener);
            if (provider instanceof IDocumentProviderExtension2) {
                extension = (IDocumentProviderExtension2)provider;
                rememberedProgressMonitor = extension.getProgressMonitor();
                extension.setProgressMonitor(null);
            }
        }
        this.setDocumentProvider(input);
        provider = this.getDocumentProvider();
        if (provider != null) {
            provider.addElementStateListener(this.fElementStateListener);
            if (provider instanceof IDocumentProviderExtension2) {
                extension = (IDocumentProviderExtension2)provider;
                extension.setProgressMonitor(rememberedProgressMonitor);
            }
        }
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        if (input == null) {
            this.close(this.isSaveOnCloseNeeded());
        } else {
            IEditorInput oldInput = this.getEditorInput();
            if (oldInput != null) {
                this.getDocumentProvider().disconnect((Object)oldInput);
            }
            super.setInput(input);
            this.updateDocumentProvider(input);
            IDocumentProvider provider = this.getDocumentProvider();
            provider.connect((Object)input);
            this.initializeTitle(input);
            if (this.fSourceViewer != null) {
                this.initializeSourceViewer(input);
            }
        }
    }

    protected final void setInputWithNotify(IEditorInput input) {
        try {
            this.doSetInput(input);
            this.firePropertyChange(258);
        }
        catch (CoreException e) {
            Activator.log(e);
        }
    }

    public final void setInput(IEditorInput input) {
        this.setInputWithNotify(input);
    }

    public void close(final boolean save) {
        this.enableSanityChecking(false);
        Display display = this.getSite().getShell().getDisplay();
        display.asyncExec(new Runnable(){

            public void run() {
                if (TestEditor.this.fSourceViewer != null) {
                    TestEditor.this.getSite().getPage().closeEditor((IEditorPart)TestEditor.this, save);
                }
            }
        });
    }

    public void dispose() {
        IOperationHistory history;
        if (this.fTitleImage != null) {
            this.fTitleImage.dispose();
            this.fTitleImage = null;
        }
        this.disposeDocumentProvider();
        if (this.fSourceViewer != null) {
            this.fSourceViewer = null;
        }
        if (this.fConfiguration != null) {
            this.fConfiguration = null;
        }
        if ((history = OperationHistoryFactory.getOperationHistory()) != null) {
            if (this.fNonLocalOperationApprover != null) {
                history.removeOperationApprover(this.fNonLocalOperationApprover);
            }
            if (this.fLinearUndoViolationApprover != null) {
                history.removeOperationApprover(this.fLinearUndoViolationApprover);
            }
        }
        this.fNonLocalOperationApprover = null;
        this.fLinearUndoViolationApprover = null;
        super.dispose();
    }

    protected void disposeDocumentProvider() {
        IDocumentProvider provider = this.getDocumentProvider();
        if (provider != null) {
            IEditorInput input = this.getEditorInput();
            if (input != null) {
                provider.disconnect((Object)input);
            }
            if (this.fElementStateListener != null) {
                provider.removeElementStateListener(this.fElementStateListener);
                this.fElementStateListener = null;
            }
        }
        this.fImplicitDocumentProvider = null;
    }

    public void doSaveAs() {
    }

    public void doSave(IProgressMonitor progressMonitor) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enableSanityChecking(boolean enable) {
        TestEditor testEditor = this;
        synchronized (testEditor) {
            this.fIsSanityCheckEnabled = enable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void safelySanityCheckState(IEditorInput input) {
        boolean enabled = false;
        TestEditor testEditor = this;
        synchronized (testEditor) {
            enabled = this.fIsSanityCheckEnabled;
        }
        if (enabled) {
            this.sanityCheckState(input);
        }
    }

    protected void sanityCheckState(IEditorInput input) {
        IDocumentProvider p = this.getDocumentProvider();
        if (p == null) {
            return;
        }
        if (p instanceof IDocumentProviderExtension3) {
            long stamp = p.getModificationStamp((Object)input);
            if (stamp != this.fModificationStamp) {
                this.fModificationStamp = stamp;
            }
        } else {
            long stamp;
            if (this.fModificationStamp == -1L) {
                this.fModificationStamp = p.getSynchronizationStamp((Object)input);
            }
            if ((stamp = p.getModificationStamp((Object)input)) != this.fModificationStamp) {
                this.fModificationStamp = stamp;
            }
        }
        this.updateState(this.getEditorInput());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enableStateValidation(boolean enable) {
        TestEditor testEditor = this;
        synchronized (testEditor) {
            this.fIsStateValidationEnabled = enable;
        }
    }

    protected void validateState(IEditorInput input) {
        IDocumentProvider provider = this.getDocumentProvider();
        if (!(provider instanceof IDocumentProviderExtension)) {
            return;
        }
        IDocumentProviderExtension extension = (IDocumentProviderExtension)provider;
        try {
            extension.validateState((Object)input, (Object)this.getSite().getShell());
        }
        catch (CoreException x) {
            IStatus status = x.getStatus();
            if (status == null || status.getSeverity() != 8) {
                Bundle bundle = Platform.getBundle((String)"org.eclipse.ui");
                ILog log = Platform.getLog((Bundle)bundle);
                log.log(x.getStatus());
                Shell shell = this.getSite().getShell();
                String title = "EditorMessages.Editor_error_validateEdit_title";
                String msg = "EditorMessages.Editor_error_validateEdit_message";
                ErrorDialog.openError((Shell)shell, (String)title, (String)msg, (IStatus)x.getStatus());
            }
            return;
        }
        if (this.fSourceViewer != null) {
            this.fSourceViewer.setEditable(this.isEditable());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validateEditorInputState() {
        boolean enabled = false;
        TestEditor testEditor = this;
        synchronized (testEditor) {
            enabled = this.fIsStateValidationEnabled;
        }
        if (enabled) {
            ISourceViewer viewer = this.fSourceViewer;
            if (viewer == null) {
                return false;
            }
            final IEditorInput input = this.getEditorInput();
            BusyIndicator.showWhile((Display)this.getSite().getShell().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    TestEditor.this.validateState(input);
                }
            });
            this.sanityCheckState(input);
            return true;
        }
        return true;
    }

    protected void updateState(IEditorInput input) {
        IDocumentProvider provider = this.getDocumentProvider();
        if (provider instanceof IDocumentProviderExtension) {
            IDocumentProviderExtension extension = (IDocumentProviderExtension)provider;
            try {
                extension.updateStateCache((Object)input);
                if (this.fSourceViewer != null) {
                    this.fSourceViewer.setEditable(this.isEditable());
                }
            }
            catch (CoreException e) {
                Activator.log(e);
            }
        }
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isDirty() {
        IDocumentProvider p = this.getDocumentProvider();
        return p == null ? false : p.canSaveDocument((Object)this.getEditorInput());
    }

    public Object getAdapter(Class required) {
        return super.getAdapter(required);
    }

    public void setFocus() {
    }

    protected void firePropertyChange(int property) {
        super.firePropertyChange(property);
    }

    class ElementStateListener
    implements IElementStateListener,
    IElementStateListenerExtension {
        private Validator fValidator;
        private Display fDisplay;

        ElementStateListener() {
        }

        public void elementStateValidationChanged(Object element, final boolean isStateValidated) {
            if (element != null && element.equals(TestEditor.this.getEditorInput())) {
                Runnable r = new Runnable(){

                    public void run() {
                        StyledText textWidget;
                        ISourceViewer viewer;
                        TestEditor.this.enableSanityChecking(true);
                        if (isStateValidated) {
                            ISourceViewer viewer2;
                            if (ElementStateListener.this.fValidator != null && (viewer2 = TestEditor.this.fSourceViewer) != null) {
                                StyledText textWidget2 = viewer2.getTextWidget();
                                if (textWidget2 != null && !textWidget2.isDisposed()) {
                                    textWidget2.removeVerifyListener((VerifyListener)ElementStateListener.this.fValidator);
                                }
                                ElementStateListener.this.fValidator = null;
                            }
                            TestEditor.this.enableStateValidation(false);
                        } else if (!isStateValidated && ElementStateListener.this.fValidator == null && (viewer = TestEditor.this.fSourceViewer) != null && (textWidget = viewer.getTextWidget()) != null && !textWidget.isDisposed()) {
                            ElementStateListener.this.fValidator = new Validator();
                            TestEditor.this.enableStateValidation(true);
                            textWidget.addVerifyListener((VerifyListener)ElementStateListener.this.fValidator);
                        }
                    }
                };
                this.execute(r, false);
            }
        }

        public void elementDirtyStateChanged(Object element, boolean isDirty) {
            if (element != null && element.equals(TestEditor.this.getEditorInput())) {
                Runnable r = new Runnable(){

                    public void run() {
                        TestEditor.this.enableSanityChecking(true);
                        TestEditor.this.firePropertyChange(257);
                    }
                };
                this.execute(r, false);
            }
        }

        public void elementContentAboutToBeReplaced(Object element) {
            if (element != null && element.equals(TestEditor.this.getEditorInput())) {
                Runnable r = new Runnable(){

                    public void run() {
                        TestEditor.this.enableSanityChecking(true);
                    }
                };
                this.execute(r, false);
            }
        }

        public void elementContentReplaced(Object element) {
            if (element != null && element.equals(TestEditor.this.getEditorInput())) {
                Runnable r = new Runnable(){

                    public void run() {
                        TestEditor.this.enableSanityChecking(true);
                        TestEditor.this.firePropertyChange(257);
                    }
                };
                this.execute(r, false);
            }
        }

        public void elementDeleted(Object deletedElement) {
            if (deletedElement != null && deletedElement.equals(TestEditor.this.getEditorInput())) {
                Runnable r = new Runnable(){

                    public void run() {
                        TestEditor.this.enableSanityChecking(true);
                        TestEditor.this.close(false);
                    }
                };
                this.execute(r, false);
            }
        }

        public void elementMoved(Object originalElement, final Object movedElement) {
            if (originalElement != null && originalElement.equals(TestEditor.this.getEditorInput())) {
                final boolean doValidationAsync = Display.getCurrent() != null;
                Runnable r = new Runnable(){

                    public void run() {
                        TestEditor.this.enableSanityChecking(true);
                        if (TestEditor.this.fSourceViewer == null) {
                            return;
                        }
                        if (movedElement == null || movedElement instanceof IEditorInput) {
                            String previousContent;
                            final IDocumentProvider d = TestEditor.this.getDocumentProvider();
                            IDocumentUndoManager previousUndoManager = null;
                            IDocument changed = null;
                            boolean wasDirty = TestEditor.this.isDirty();
                            changed = d.getDocument((Object)TestEditor.this.getEditorInput());
                            if (changed != null) {
                                previousContent = wasDirty ? changed.get() : null;
                                previousUndoManager = DocumentUndoManagerRegistry.getDocumentUndoManager((IDocument)changed);
                                if (previousUndoManager != null) {
                                    previousUndoManager.connect((Object)this);
                                }
                            } else {
                                previousContent = null;
                            }
                            TestEditor.this.setInput((IEditorInput)movedElement);
                            if (previousUndoManager != null) {
                                IDocumentUndoManager newUndoManager;
                                IDocument newDocument = TestEditor.this.getDocumentProvider().getDocument(movedElement);
                                if (newDocument != null && (newUndoManager = DocumentUndoManagerRegistry.getDocumentUndoManager((IDocument)newDocument)) != null) {
                                    newUndoManager.transferUndoHistory(previousUndoManager);
                                }
                                previousUndoManager.disconnect((Object)this);
                            }
                            if (wasDirty && changed != null) {
                                Runnable r2 = new Runnable(){

                                    public void run() {
                                        TestEditor.this.validateState(TestEditor.this.getEditorInput());
                                        d.getDocument((Object)TestEditor.this.getEditorInput()).set(previousContent);
                                    }
                                };
                                ElementStateListener.this.execute(r2, doValidationAsync);
                            }
                        }
                    }
                };
                this.execute(r, false);
            }
        }

        public void elementStateChanging(Object element) {
            if (element != null && element.equals(TestEditor.this.getEditorInput())) {
                TestEditor.this.enableSanityChecking(false);
            }
        }

        public void elementStateChangeFailed(Object element) {
            if (element != null && element.equals(TestEditor.this.getEditorInput())) {
                TestEditor.this.enableSanityChecking(true);
            }
        }

        private void execute(Runnable runnable, boolean postAsync) {
            if (postAsync || Display.getCurrent() == null) {
                if (this.fDisplay == null) {
                    this.fDisplay = TestEditor.this.getSite().getShell().getDisplay();
                }
                this.fDisplay.asyncExec(runnable);
            } else {
                runnable.run();
            }
        }

        class Validator
        implements VerifyListener {
            Validator() {
            }

            public void verifyText(VerifyEvent e) {
                IDocument document = TestEditor.this.getDocumentProvider().getDocument((Object)TestEditor.this.getEditorInput());
                final boolean[] documentChanged = new boolean[1];
                IDocumentListener listener = new IDocumentListener(){

                    public void documentAboutToBeChanged(DocumentEvent event) {
                    }

                    public void documentChanged(DocumentEvent event) {
                        documentChanged[0] = true;
                    }
                };
                try {
                    if (document != null) {
                        document.addDocumentListener(listener);
                    }
                    if (!TestEditor.this.validateEditorInputState() || documentChanged[0]) {
                        e.doit = false;
                    }
                }
                finally {
                    if (document != null) {
                        document.removeDocumentListener(listener);
                    }
                }
            }
        }
    }
}

