/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.controller.editpart.outline.dictionary;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.tools.SelectEditPartTracker;
import org.eclipse.ui.PlatformUI;
import org.insightech.er.Activator;
import org.insightech.er.editor.controller.command.diagram_contents.not_element.dictionary.EditWordCommand;
import org.insightech.er.editor.controller.editpart.outline.AbstractOutlineEditPart;
import org.insightech.er.editor.model.ERDiagram;
import org.insightech.er.editor.model.diagram_contents.element.node.category.Category;
import org.insightech.er.editor.model.diagram_contents.element.node.table.ERTable;
import org.insightech.er.editor.model.diagram_contents.element.node.table.column.ColumnHolder;
import org.insightech.er.editor.model.diagram_contents.element.node.table.column.NormalColumn;
import org.insightech.er.editor.model.diagram_contents.element.node.view.View;
import org.insightech.er.editor.model.diagram_contents.not_element.dictionary.Word;
import org.insightech.er.editor.model.diagram_contents.not_element.group.ColumnGroup;
import org.insightech.er.editor.view.dialog.word.word.WordDialog;

public class WordOutlineEditPart
extends AbstractOutlineEditPart {
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("dictionary")) {
            this.refreshVisuals();
        }
    }

    protected List getModelChildren() {
        ArrayList wordHolderList = new ArrayList();
        ArrayList<ERTable> wordHolderList1 = new ArrayList<ERTable>();
        ArrayList<View> wordHolderList2 = new ArrayList<View>();
        ArrayList<ColumnGroup> wordHolderList3 = new ArrayList<ColumnGroup>();
        ERDiagram diagram = (ERDiagram)this.getRoot().getContents().getModel();
        Word word = (Word)this.getModel();
        List<NormalColumn> normalColumns = diagram.getDiagramContents().getDictionary().getColumnList(word);
        Category category = this.getCurrentCategory();
        for (NormalColumn normalColumn : normalColumns) {
            ColumnHolder columnHolder = normalColumn.getColumnHolder();
            if (columnHolder instanceof ERTable) {
                ERTable table = (ERTable)columnHolder;
                if (wordHolderList1.contains(table) || category != null && !category.contains(table)) continue;
                wordHolderList1.add(table);
                continue;
            }
            if (columnHolder instanceof View) {
                View view = (View)columnHolder;
                if (wordHolderList2.contains(view) || category != null && !category.contains(view)) continue;
                wordHolderList2.add(view);
                continue;
            }
            if (!(columnHolder instanceof ColumnGroup) || wordHolderList3.contains(columnHolder)) continue;
            wordHolderList3.add((ColumnGroup)columnHolder);
        }
        Collections.sort(wordHolderList1);
        Collections.sort(wordHolderList2);
        Collections.sort(wordHolderList3);
        wordHolderList.addAll(wordHolderList1);
        wordHolderList.addAll(wordHolderList2);
        wordHolderList.addAll(wordHolderList3);
        return wordHolderList;
    }

    protected void refreshOutlineVisuals() {
        Word word = (Word)this.getModel();
        ERDiagram diagram = (ERDiagram)this.getRoot().getContents().getModel();
        int viewMode = diagram.getDiagramContents().getSettings().getOutlineViewMode();
        String name = null;
        if (viewMode == 1) {
            name = word.getPhysicalName() != null ? word.getPhysicalName() : "";
        } else if (viewMode == 0) {
            name = word.getLogicalName() != null ? word.getLogicalName() : "";
        } else {
            name = word.getLogicalName() != null ? word.getLogicalName() : "";
            name = String.valueOf(name) + "/";
            if (word.getPhysicalName() != null) {
                name = String.valueOf(name) + word.getPhysicalName();
            }
        }
        this.setWidgetText(diagram.filter(name));
        this.setWidgetImage(Activator.getImage("WORD"));
    }

    public void performRequest(Request request) {
        WordDialog dialog;
        Word word = (Word)this.getModel();
        ERDiagram diagram = this.getDiagram();
        if (request.getType().equals("open") && (dialog = new WordDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), word, false, diagram)).open() == 0) {
            EditWordCommand command = new EditWordCommand(word, dialog.getWord(), diagram);
            this.execute(command);
        }
        super.performRequest(request);
    }

    public DragTracker getDragTracker(Request req) {
        return new SelectEditPartTracker((EditPart)this);
    }
}

