/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.model.dbexport.excel.sheet_generator;

import java.awt.Dimension;
import org.apache.poi.hssf.usermodel.HSSFAnchor;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFPicture;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.insightech.er.util.POIUtils;

public class PictureSheetGenerator {
    private static final String KEYWORD_ER = "$ER";
    private byte[] imageBuffer;
    private int pictureIndex;
    private int excelPictureType;

    public PictureSheetGenerator(HSSFWorkbook workbook, byte[] imageBuffer, int excelPictureType) {
        this.imageBuffer = imageBuffer;
        this.excelPictureType = excelPictureType;
        if (this.imageBuffer != null) {
            this.pictureIndex = workbook.addPicture(this.imageBuffer, this.excelPictureType);
        }
    }

    public void setImage(HSSFWorkbook workbook, HSSFSheet sheet) {
        POIUtils.CellLocation cellLocation = POIUtils.findMatchCell(sheet, "\\$ER.*");
        System.out.println(cellLocation);
        if (cellLocation != null) {
            int middleIndex;
            int width = -1;
            int height = -1;
            String value = POIUtils.getCellValue(sheet, cellLocation);
            int startIndex = value.indexOf("(");
            if (startIndex != -1 && (middleIndex = value.indexOf(",", startIndex + 1)) != -1) {
                width = Integer.parseInt(value.substring(startIndex + 1, middleIndex).trim());
                height = Integer.parseInt(value.substring(middleIndex + 1, value.length() - 1).trim());
            }
            this.setImage(workbook, sheet, cellLocation, width, height);
        }
    }

    private void setImage(HSSFWorkbook workbook, HSSFSheet sheet, POIUtils.CellLocation cellLocation, int width, int height) {
        POIUtils.setCellValue(sheet, cellLocation, "");
        System.out.println("this.imageBuffer:" + this.imageBuffer);
        if (this.imageBuffer != null) {
            HSSFPatriarch patriarch = sheet.createDrawingPatriarch();
            HSSFPicture picture = patriarch.createPicture(new HSSFClientAnchor(), this.pictureIndex);
            Dimension dimension = picture.getImageDimension();
            float rate = dimension.width / dimension.height;
            float specifiedRate = width / height;
            if (width == -1 || height == -1) {
                width = dimension.width;
                height = dimension.height;
            } else if (rate > specifiedRate) {
                if (dimension.width > width) {
                    height = (int)((float)width / rate);
                } else {
                    width = dimension.width;
                    height = dimension.height;
                }
            } else if (dimension.height > height) {
                width = (int)((float)height * rate);
            } else {
                width = dimension.width;
                height = dimension.height;
            }
            HSSFClientAnchor preferredSize = this.getPreferredSize(sheet, new HSSFClientAnchor(0, 0, 0, 0, (short)cellLocation.c, cellLocation.r, 0, 0), width, height);
            picture.setAnchor((HSSFAnchor)preferredSize);
        }
    }

    public HSSFClientAnchor getPreferredSize(HSSFSheet sheet, HSSFClientAnchor anchor, int width, int height) {
        float w = 0.0f;
        w += this.getColumnWidthInPixels(sheet, anchor.getCol1()) * (float)(1 - anchor.getDx1() / 1024);
        short col2 = (short)(anchor.getCol1() + 1);
        int dx2 = 0;
        while (w < (float)width) {
            short s = col2;
            col2 = (short)(s + 1);
            w += this.getColumnWidthInPixels(sheet, s);
        }
        if (w > (float)width) {
            col2 = (short)(col2 - 1);
            float cw = this.getColumnWidthInPixels(sheet, col2);
            float delta = w - (float)width;
            dx2 = (int)((cw - delta) / cw * 1024.0f);
        }
        anchor.setCol2(col2);
        anchor.setDx2(dx2);
        float h = 0.0f;
        h += (float)(1 - anchor.getDy1() / 256) * this.getRowHeightInPixels(sheet, anchor.getRow1());
        int row2 = anchor.getRow1() + 1;
        int dy2 = 0;
        while (h < (float)height) {
            h += this.getRowHeightInPixels(sheet, row2++);
        }
        if (h > (float)height) {
            float ch = this.getRowHeightInPixels(sheet, --row2);
            float delta = h - (float)height;
            dy2 = (int)((ch - delta) / ch * 256.0f);
        }
        anchor.setRow2(row2);
        anchor.setDy2(dy2);
        return anchor;
    }

    private float getColumnWidthInPixels(HSSFSheet sheet, int column) {
        int cw = sheet.getColumnWidth(column);
        float px = this.getPixelWidth(sheet, column);
        return (float)cw / px;
    }

    private float getRowHeightInPixels(HSSFSheet sheet, int i) {
        HSSFRow row = sheet.getRow(i);
        float height = row != null ? (float)row.getHeight() : (float)sheet.getDefaultRowHeight();
        return height / 15.0f;
    }

    private float getPixelWidth(HSSFSheet sheet, int column) {
        int def = sheet.getDefaultColumnWidth() * 256;
        int cw = sheet.getColumnWidth(column);
        return cw != def ? 36.56f : 32.0f;
    }
}

