/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.model.dbimport;

import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.insightech.er.Activator;
import org.insightech.er.ResourceString;
import org.insightech.er.common.exception.InputException;
import org.insightech.er.db.sqltype.SqlType;
import org.insightech.er.editor.TranslationResources;
import org.insightech.er.editor.model.ERDiagram;
import org.insightech.er.editor.model.dbimport.DBObject;
import org.insightech.er.editor.model.dbimport.ImportFromDBManager;
import org.insightech.er.editor.model.diagram_contents.element.connection.Relation;
import org.insightech.er.editor.model.diagram_contents.element.node.table.ERTable;
import org.insightech.er.editor.model.diagram_contents.element.node.table.column.Column;
import org.insightech.er.editor.model.diagram_contents.element.node.table.column.NormalColumn;
import org.insightech.er.editor.model.diagram_contents.element.node.table.index.Index;
import org.insightech.er.editor.model.diagram_contents.element.node.table.properties.TableViewProperties;
import org.insightech.er.editor.model.diagram_contents.element.node.table.unique_key.ComplexUniqueKey;
import org.insightech.er.editor.model.diagram_contents.element.node.view.View;
import org.insightech.er.editor.model.diagram_contents.not_element.dictionary.TypeData;
import org.insightech.er.editor.model.diagram_contents.not_element.dictionary.UniqueWord;
import org.insightech.er.editor.model.diagram_contents.not_element.dictionary.Word;
import org.insightech.er.editor.model.diagram_contents.not_element.sequence.Sequence;
import org.insightech.er.editor.model.diagram_contents.not_element.tablespace.Tablespace;
import org.insightech.er.editor.model.diagram_contents.not_element.trigger.Trigger;
import org.insightech.er.editor.model.settings.DBSetting;
import org.insightech.er.util.Check;
import org.insightech.er.util.Format;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ImportFromDBManagerBase
implements ImportFromDBManager,
IRunnableWithProgress {
    private static Logger logger = Logger.getLogger(ImportFromDBManagerBase.class.getName());
    private static final boolean LOG_SQL_TYPE = false;
    private static final Pattern AS_PATTERN = Pattern.compile("(.+) [aA][sS] (.+)");
    protected Connection con;
    private DatabaseMetaData metaData;
    protected DBSetting dbSetting;
    private ERDiagram diagram;
    private List<DBObject> dbObjectList;
    private Map<String, ERTable> tableMap = new HashMap<String, ERTable>();
    protected Map<String, String> tableCommentMap = new HashMap<String, String>();
    protected Map<String, Map<String, ColumnData>> columnDataCash = new HashMap<String, Map<String, ColumnData>>();
    private Map<String, List<ForeignKeyData>> tableForeignKeyDataMap = new HashMap<String, List<ForeignKeyData>>();
    private Map<UniqueWord, Word> dictionary = new HashMap<UniqueWord, Word>();
    private List<ERTable> importedTables;
    private List<Sequence> importedSequences;
    private List<Trigger> importedTriggers;
    private List<Tablespace> importedTablespaces;
    private List<View> importedViews;
    private Exception exception;
    protected TranslationResources translationResources;
    private boolean useCommentAsLogicalName;
    private boolean mergeWord;

    @Override
    public void init(Connection con, DBSetting dbSetting, ERDiagram diagram, List<DBObject> dbObjectList, boolean useCommentAsLogicalName, boolean mergeWord) throws SQLException {
        this.con = con;
        this.dbSetting = dbSetting;
        this.diagram = diagram;
        this.dbObjectList = dbObjectList;
        this.useCommentAsLogicalName = useCommentAsLogicalName;
        this.mergeWord = mergeWord;
        this.metaData = con.getMetaData();
        this.translationResources = new TranslationResources(diagram.getDiagramContents().getSettings().getTranslationSetting());
        if (this.mergeWord) {
            for (Word word : this.diagram.getDiagramContents().getDictionary().getWordList()) {
                this.dictionary.put(new UniqueWord(word), word);
            }
        }
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            monitor.beginTask(ResourceString.getResourceString("dialog.message.import.table"), this.dbObjectList.size());
            this.importedSequences = this.importSequences(this.dbObjectList);
            this.importedTriggers = this.importTriggers(this.dbObjectList);
            this.importedTablespaces = this.importTablespaces(this.dbObjectList);
            this.importedTables = this.importTables(this.dbObjectList, monitor);
            this.importedTables.addAll(this.importSynonyms());
            this.setForeignKeys(this.importedTables);
            this.importedViews = this.importViews(this.dbObjectList);
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            logger.log(Level.WARNING, e.getMessage(), e);
            this.exception = e;
        }
        monitor.done();
    }

    protected void cashColumnData(List<DBObject> dbObjectList, IProgressMonitor monitor) throws SQLException, InterruptedException {
        this.cashColumnDataX(null, dbObjectList, monitor);
    }

    protected void cashColumnDataX(String tableName, List<DBObject> dbObjectList, IProgressMonitor monitor) throws SQLException, InterruptedException {
        ResultSet columnSet = null;
        try {
            columnSet = this.metaData.getColumns(null, null, tableName, null);
            while (columnSet.next()) {
                Map<String, ColumnData> cash;
                tableName = columnSet.getString("TABLE_NAME");
                String schema = columnSet.getString("TABLE_SCHEM");
                String tableNameWithSchema = this.dbSetting.getTableNameWithSchema(tableName, schema);
                if (monitor != null) {
                    monitor.subTask("reading : " + tableNameWithSchema);
                }
                if ((cash = this.columnDataCash.get(tableNameWithSchema)) == null) {
                    cash = new LinkedHashMap<String, ColumnData>();
                    this.columnDataCash.put(tableNameWithSchema, cash);
                }
                ColumnData columnData = this.createColumnData(columnSet);
                this.cashOtherColumnData(tableName, schema, columnData);
                cash.put(columnData.columnName, columnData);
                if (monitor == null || !monitor.isCanceled()) continue;
                throw new InterruptedException("Cancel has been requested.");
            }
        }
        finally {
            if (columnSet != null) {
                columnSet.close();
            }
        }
    }

    protected ColumnData createColumnData(ResultSet columnSet) throws SQLException {
        ColumnData columnData = new ColumnData();
        columnData.columnName = columnSet.getString("COLUMN_NAME");
        columnData.type = columnSet.getString("TYPE_NAME").toLowerCase();
        columnData.size = columnSet.getInt("COLUMN_SIZE");
        columnData.decimalDegits = columnSet.getInt("DECIMAL_DIGITS");
        columnData.nullable = columnSet.getInt("NULLABLE");
        columnData.defaultValue = columnSet.getString("COLUMN_DEF");
        if (columnData.defaultValue != null && "bit".equals(columnData.type)) {
            byte[] bits = columnData.defaultValue.getBytes();
            columnData.defaultValue = "";
            int i = 0;
            while (i < bits.length) {
                columnData.defaultValue = String.valueOf(columnData.defaultValue) + bits[i];
                ++i;
            }
        }
        columnData.description = columnSet.getString("REMARKS");
        return columnData;
    }

    protected void cashOtherColumnData(String tableName, String schema, ColumnData columnData) throws SQLException {
    }

    protected void cashTableComment(IProgressMonitor monitor) throws SQLException, InterruptedException {
    }

    private List<Sequence> importSequences(List<DBObject> dbObjectList) throws SQLException {
        ArrayList<Sequence> list = new ArrayList<Sequence>();
        for (DBObject dbObject : dbObjectList) {
            String name;
            String schema;
            Sequence sequence;
            if (!"sequence".equals(dbObject.getType()) || (sequence = this.importSequence(schema = dbObject.getSchema(), name = dbObject.getName())) == null) continue;
            list.add(sequence);
        }
        return list;
    }

    protected Sequence importSequence(String schema, String sequenceName) throws SQLException {
        ResultSet rs;
        PreparedStatement stmt;
        block2: {
            Sequence sequence;
            stmt = null;
            rs = null;
            String sequenceNameWithSchema = this.getTableNameWithSchema(schema, sequenceName);
            try {
                stmt = this.con.prepareStatement("SELECT * FROM " + sequenceNameWithSchema);
                rs = stmt.executeQuery();
                if (!rs.next()) break block2;
                Sequence sequence2 = new Sequence();
                sequence2.setName(sequenceName);
                sequence2.setSchema(schema);
                sequence2.setIncrement(rs.getInt("INCREMENT_BY"));
                sequence2.setMinValue(rs.getLong("MIN_VALUE"));
                BigDecimal maxValue = rs.getBigDecimal("MAX_VALUE");
                sequence2.setMaxValue(maxValue);
                sequence2.setStart(rs.getLong("LAST_VALUE"));
                sequence2.setCache(rs.getInt("CACHE_VALUE"));
                sequence2.setCycle(rs.getBoolean("IS_CYCLED"));
                sequence = sequence2;
            }
            catch (Throwable throwable) {
                this.close(rs);
                this.close(stmt);
                throw throwable;
            }
            this.close(rs);
            this.close(stmt);
            return sequence;
        }
        this.close(rs);
        this.close(stmt);
        return null;
    }

    private List<Trigger> importTriggers(List<DBObject> dbObjectList) throws SQLException {
        ArrayList<Trigger> list = new ArrayList<Trigger>();
        for (DBObject dbObject : dbObjectList) {
            String name;
            String schema;
            Trigger trigger;
            if (!"trigger".equals(dbObject.getType()) || (trigger = this.importTrigger(schema = dbObject.getSchema(), name = dbObject.getName())) == null) continue;
            list.add(trigger);
        }
        return list;
    }

    protected Trigger importTrigger(String schema, String triggerName) throws SQLException {
        return null;
    }

    protected List<ERTable> importTables(List<DBObject> dbObjectList, IProgressMonitor monitor) throws SQLException, InterruptedException {
        ArrayList<ERTable> list = new ArrayList<ERTable>();
        this.cashTableComment(monitor);
        this.cashColumnData(dbObjectList, monitor);
        int i = 0;
        for (DBObject dbObject : dbObjectList) {
            if ("table".equals(dbObject.getType())) {
                String tableName = dbObject.getName();
                String schema = dbObject.getSchema();
                String tableNameWithSchema = this.dbSetting.getTableNameWithSchema(tableName, schema);
                monitor.subTask("(" + ++i + "/" + this.dbObjectList.size() + ") " + tableNameWithSchema);
                monitor.worked(1);
                ERTable table = this.importTable(tableNameWithSchema, tableName, schema);
                if (table != null) {
                    list.add(table);
                }
            }
            if (!monitor.isCanceled()) continue;
            throw new InterruptedException("Cancel has been requested.");
        }
        return list;
    }

    protected List<ERTable> importSynonyms() throws SQLException, InterruptedException {
        return new ArrayList<ERTable>();
    }

    protected String getConstraintName(PrimaryKeyData data) {
        return data.constraintName;
    }

    protected ERTable importTable(String tableNameWithSchema, String tableName, String schema) throws SQLException, InterruptedException {
        String autoIncrementColumnName = null;
        try {
            autoIncrementColumnName = this.getAutoIncrementColumnName(this.con, this.getTableNameWithSchema(schema, tableName));
        }
        catch (SQLException sQLException) {
            return null;
        }
        ERTable table = new ERTable();
        TableViewProperties tableProperties = table.getTableViewProperties(this.dbSetting.getDbsystem());
        tableProperties.setSchema(schema);
        table.setPhysicalName(tableName);
        table.setLogicalName(this.translationResources.translate(tableName));
        table.setDescription(this.tableCommentMap.get(tableNameWithSchema));
        List<PrimaryKeyData> primaryKeys = this.getPrimaryKeys(table, this.metaData);
        if (!primaryKeys.isEmpty()) {
            table.setPrimaryKeyName(this.getConstraintName(primaryKeys.get(0)));
        }
        List<Index> indexes = this.getIndexes(table, this.metaData, primaryKeys);
        List<Column> columns = this.getColumns(tableNameWithSchema, tableName, schema, indexes, primaryKeys, autoIncrementColumnName);
        table.setColumns(columns);
        table.setIndexes(indexes);
        this.tableMap.put(tableNameWithSchema, table);
        for (Index index : indexes) {
            this.setIndexColumn(table, index);
        }
        return table;
    }

    protected String getTableNameWithSchema(String schema, String tableName) {
        return this.dbSetting.getTableNameWithSchema(tableName, schema);
    }

    protected void setForeignKeys(List<ERTable> list) throws SQLException {
        this.cashForeignKeyData();
        for (ERTable target : list) {
            if (this.tableForeignKeyDataMap != null) {
                this.setForeignKeysUsingCash(target);
                continue;
            }
            this.setForeignKeys(target);
        }
    }

    private String getAutoIncrementColumnName(Connection con, String tableNameWithSchema) throws SQLException {
        String autoIncrementColumnName = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.createStatement();
            rs = stmt.executeQuery("SELECT * FROM " + tableNameWithSchema);
            ResultSetMetaData md = rs.getMetaData();
            int i = 0;
            while (i < md.getColumnCount()) {
                if (md.isAutoIncrement(i + 1)) {
                    autoIncrementColumnName = md.getColumnName(i + 1);
                    break;
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            this.close(rs);
            this.close(stmt);
            throw throwable;
        }
        this.close(rs);
        this.close(stmt);
        return autoIncrementColumnName;
    }

    protected List<Index> getIndexes(ERTable table, DatabaseMetaData metaData, List<PrimaryKeyData> primaryKeys) throws SQLException {
        Index index;
        ArrayList<Index> indexes = new ArrayList<Index>();
        HashMap<String, Index> indexMap = new HashMap<String, Index>();
        ResultSet indexSet = null;
        try {
            indexSet = metaData.getIndexInfo(null, table.getTableViewProperties(this.dbSetting.getDbsystem()).getSchema(), table.getPhysicalName(), false, true);
            while (indexSet.next()) {
                String name = indexSet.getString("INDEX_NAME");
                if (name == null) continue;
                index = (Index)indexMap.get(name);
                if (index == null) {
                    boolean nonUnique = indexSet.getBoolean("NON_UNIQUE");
                    String type = null;
                    short indexType = indexSet.getShort("TYPE");
                    if (indexType == 3) {
                        type = "BTREE";
                    }
                    index = new Index(table, name, nonUnique, type, null);
                    indexMap.put(name, index);
                    indexes.add(index);
                }
                String columnName = indexSet.getString("COLUMN_NAME");
                String ascDesc = indexSet.getString("ASC_OR_DESC");
                if (columnName.startsWith("\"") && columnName.endsWith("\"")) {
                    columnName = columnName.substring(1, columnName.length() - 1);
                }
                Boolean desc = null;
                if ("A".equals(ascDesc)) {
                    desc = Boolean.FALSE;
                } else if ("D".equals(ascDesc)) {
                    desc = Boolean.TRUE;
                }
                index.addColumnName(columnName, desc);
            }
        }
        catch (Throwable throwable) {
            this.close(indexSet);
            throw throwable;
        }
        this.close(indexSet);
        Iterator iter = indexes.iterator();
        while (iter.hasNext()) {
            index = (Index)iter.next();
            List<String> indexColumns = index.getColumnNames();
            if (indexColumns.size() != primaryKeys.size()) continue;
            boolean equals = true;
            int i = 0;
            while (i < indexColumns.size()) {
                if (!indexColumns.get(i).equals(primaryKeys.get(i).columnName)) {
                    equals = false;
                    break;
                }
                ++i;
            }
            if (!equals) continue;
            iter.remove();
        }
        return indexes;
    }

    private void setIndexColumn(ERTable erTable, Index index) {
        block0: for (String columnName : index.getColumnNames()) {
            for (Column column : erTable.getColumns()) {
                NormalColumn normalColumn;
                if (!(column instanceof NormalColumn) || !(normalColumn = (NormalColumn)column).getPhysicalName().equals(columnName)) continue;
                index.addColumn(normalColumn);
                continue block0;
            }
        }
    }

    private List<PrimaryKeyData> getPrimaryKeys(ERTable table, DatabaseMetaData metaData) throws SQLException {
        ArrayList<PrimaryKeyData> primaryKeys;
        block6: {
            primaryKeys = new ArrayList<PrimaryKeyData>();
            ResultSet primaryKeySet = null;
            try {
                try {
                    primaryKeySet = metaData.getPrimaryKeys(null, table.getTableViewProperties(this.dbSetting.getDbsystem()).getSchema(), table.getPhysicalName());
                    while (primaryKeySet.next()) {
                        PrimaryKeyData data = new PrimaryKeyData();
                        data.columnName = primaryKeySet.getString("COLUMN_NAME");
                        data.constraintName = primaryKeySet.getString("PK_NAME");
                        primaryKeys.add(data);
                    }
                }
                catch (SQLException sQLException) {
                    this.close(primaryKeySet);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.close(primaryKeySet);
                throw throwable;
            }
            this.close(primaryKeySet);
        }
        return primaryKeys;
    }

    protected Map<String, ColumnData> getColumnDataMap(String tableNameWithSchema, String tableName, String schema) throws SQLException, InterruptedException {
        return this.columnDataCash.get(tableNameWithSchema);
    }

    private List<Column> getColumns(String tableNameWithSchema, String tableName, String schema, List<Index> indexes, List<PrimaryKeyData> primaryKeys, String autoIncrementColumnName) throws SQLException, InterruptedException {
        ArrayList<Column> columns = new ArrayList<Column>();
        Map<String, ColumnData> columnDataMap = this.getColumnDataMap(tableNameWithSchema, tableName, schema);
        if (columnDataMap == null) {
            return new ArrayList<Column>();
        }
        Collection<ColumnData> columnSet = columnDataMap.values();
        for (ColumnData columnData : columnSet) {
            String args;
            TypeData typeData;
            Word word;
            UniqueWord uniqueWord;
            int arrayStartIndex;
            String columnName = columnData.columnName;
            String type = columnData.type;
            boolean array = false;
            Integer arrayDimension = null;
            boolean unsigned = false;
            int unsignedIndex = type.indexOf(" UNSIGNED");
            if (unsignedIndex != -1) {
                unsigned = true;
                type = type.substring(0, unsignedIndex);
            }
            if ((arrayStartIndex = type.indexOf("[")) != -1) {
                array = true;
                String str = type.substring(arrayStartIndex + 1, type.indexOf("]"));
                arrayDimension = Integer.parseInt(str);
                type = type.substring(0, arrayStartIndex);
            }
            int size = this.getLength(type, columnData.size);
            Integer length = new Integer(size);
            SqlType sqlType = SqlType.valueOf(this.dbSetting.getDbsystem(), type, size);
            if (sqlType == null) {
                logger.info(String.valueOf(columnName) + ": " + type + ", " + size + ", " + columnData.decimalDegits);
            }
            int decimalDegits = columnData.decimalDegits;
            Integer decimal = new Integer(decimalDegits);
            boolean notNull = false;
            if (columnData.nullable == 0) {
                notNull = true;
            }
            String defaultValue = Format.null2blank(columnData.defaultValue);
            if (sqlType != null && ("serial".equals(sqlType.getId()) || "bigserial".equals(sqlType.getId()))) {
                defaultValue = "";
            }
            String description = Format.null2blank(columnData.description);
            String constraint = Format.null2blank(columnData.constraint);
            boolean primaryKey = false;
            for (PrimaryKeyData primaryKeyData : primaryKeys) {
                if (!columnName.equals(primaryKeyData.columnName)) continue;
                primaryKey = true;
                break;
            }
            boolean uniqueKey = this.isUniqueKey(columnName, indexes, primaryKeys);
            boolean autoIncrement = columnName.equalsIgnoreCase(autoIncrementColumnName);
            String logicalName = null;
            if (this.useCommentAsLogicalName && !Check.isEmpty(description)) {
                logicalName = description.replaceAll("[\r\n]", "");
            }
            if (Check.isEmpty(logicalName)) {
                logicalName = this.translationResources.translate(columnName);
            }
            if (this.dictionary.get(uniqueWord = new UniqueWord(word = new Word(columnName, logicalName, sqlType, typeData = new TypeData(length, decimal, array, arrayDimension, unsigned, args = columnData.enumData), description, this.diagram.getDatabase()))) != null) {
                word = this.dictionary.get(uniqueWord);
            } else {
                this.dictionary.put(uniqueWord, word);
            }
            NormalColumn column = new NormalColumn(word, notNull, primaryKey, uniqueKey, autoIncrement, defaultValue, constraint, null, null, null);
            columns.add(column);
        }
        return columns;
    }

    private boolean isUniqueKey(String columnName, List<Index> indexes, List<PrimaryKeyData> primaryKeys) {
        String primaryKey = null;
        if (primaryKeys.size() == 1) {
            primaryKey = primaryKeys.get(0).columnName;
        }
        if (columnName == null) {
            return false;
        }
        for (Index index : indexes) {
            String indexColumnName;
            List<String> columnNames = index.getColumnNames();
            if (columnNames.size() != 1 || !columnName.equals(indexColumnName = columnNames.get(0)) || index.isNonUnique()) continue;
            if (!columnName.equals(primaryKey)) {
                indexes.remove(index);
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean isCyclicForeignKye(ForeignKeyData foreignKeyData) {
        if (foreignKeyData.sourceSchemaName == null ? foreignKeyData.targetSchemaName != null : !foreignKeyData.sourceSchemaName.equals(foreignKeyData.targetSchemaName)) {
            return false;
        }
        if (!foreignKeyData.sourceTableName.equals(foreignKeyData.targetTableName)) {
            return false;
        }
        return foreignKeyData.sourceColumnName.equals(foreignKeyData.targetColumnName);
    }

    private void cashForeignKeyData() throws SQLException {
        block7: {
            ResultSet foreignKeySet = null;
            try {
                try {
                    foreignKeySet = this.metaData.getImportedKeys(null, null, null);
                    while (foreignKeySet.next()) {
                        ForeignKeyData foreignKeyData = new ForeignKeyData();
                        foreignKeyData.name = foreignKeySet.getString("FK_NAME");
                        foreignKeyData.sourceSchemaName = foreignKeySet.getString("PKTABLE_SCHEM");
                        foreignKeyData.sourceTableName = foreignKeySet.getString("PKTABLE_NAME");
                        foreignKeyData.sourceColumnName = foreignKeySet.getString("PKCOLUMN_NAME");
                        foreignKeyData.targetSchemaName = foreignKeySet.getString("FKTABLE_SCHEM");
                        foreignKeyData.targetTableName = foreignKeySet.getString("FKTABLE_NAME");
                        foreignKeyData.targetColumnName = foreignKeySet.getString("FKCOLUMN_NAME");
                        foreignKeyData.updateRule = foreignKeySet.getShort("UPDATE_RULE");
                        foreignKeyData.deleteRule = foreignKeySet.getShort("DELETE_RULE");
                        if (this.isCyclicForeignKye(foreignKeyData)) continue;
                        String key = this.dbSetting.getTableNameWithSchema(foreignKeyData.targetTableName, foreignKeyData.targetSchemaName);
                        List<ForeignKeyData> foreignKeyDataList = this.tableForeignKeyDataMap.get(key);
                        if (foreignKeyDataList == null) {
                            foreignKeyDataList = new ArrayList<ForeignKeyData>();
                            this.tableForeignKeyDataMap.put(key, foreignKeyDataList);
                        }
                        foreignKeyDataList.add(foreignKeyData);
                    }
                }
                catch (SQLException sQLException) {
                    this.tableForeignKeyDataMap = null;
                    this.close(foreignKeySet);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                this.close(foreignKeySet);
                throw throwable;
            }
            this.close(foreignKeySet);
        }
    }

    private void setForeignKeysUsingCash(ERTable target) throws SQLException {
        String tableName = target.getPhysicalName();
        String schema = target.getTableViewProperties(this.dbSetting.getDbsystem()).getSchema();
        List<ForeignKeyData> foreignKeyList = this.tableForeignKeyDataMap.get(tableName = this.dbSetting.getTableNameWithSchema(tableName, schema));
        if (foreignKeyList == null) {
            return;
        }
        Map<String, List<ForeignKeyData>> sameNameForeignKeyDataMap = this.collectSameNameForeignKeyData(foreignKeyList);
        for (Map.Entry<String, List<ForeignKeyData>> entry : sameNameForeignKeyDataMap.entrySet()) {
            this.createRelation(target, entry.getValue());
        }
    }

    private void setForeignKeys(ERTable target) throws SQLException {
        ArrayList<ForeignKeyData> foreignKeyList;
        ResultSet foreignKeySet;
        block7: {
            String tableName = target.getPhysicalName();
            String schemaName = target.getTableViewProperties(this.dbSetting.getDbsystem()).getSchema();
            foreignKeySet = null;
            foreignKeySet = this.metaData.getImportedKeys(null, schemaName, tableName);
            foreignKeyList = new ArrayList<ForeignKeyData>();
            while (foreignKeySet.next()) {
                ForeignKeyData foreignKeyData = new ForeignKeyData();
                foreignKeyData.name = foreignKeySet.getString("FK_NAME");
                foreignKeyData.sourceTableName = foreignKeySet.getString("PKTABLE_NAME");
                foreignKeyData.sourceSchemaName = foreignKeySet.getString("PKTABLE_SCHEM");
                foreignKeyData.sourceColumnName = foreignKeySet.getString("PKCOLUMN_NAME");
                foreignKeyData.targetSchemaName = foreignKeySet.getString("FKTABLE_SCHEM");
                foreignKeyData.targetColumnName = foreignKeySet.getString("FKCOLUMN_NAME");
                foreignKeyData.updateRule = foreignKeySet.getShort("UPDATE_RULE");
                foreignKeyData.deleteRule = foreignKeySet.getShort("DELETE_RULE");
                foreignKeyList.add(foreignKeyData);
            }
            if (!foreignKeyList.isEmpty()) break block7;
            this.close(foreignKeySet);
            return;
        }
        try {
            try {
                Map<String, List<ForeignKeyData>> sameNameForeignKeyDataMap = this.collectSameNameForeignKeyData(foreignKeyList);
                for (Map.Entry<String, List<ForeignKeyData>> entry : sameNameForeignKeyDataMap.entrySet()) {
                    this.createRelation(target, entry.getValue());
                }
            }
            catch (SQLException sQLException) {
                this.close(foreignKeySet);
            }
        }
        catch (Throwable throwable) {
            this.close(foreignKeySet);
            throw throwable;
        }
        this.close(foreignKeySet);
    }

    private Map<String, List<ForeignKeyData>> collectSameNameForeignKeyData(List<ForeignKeyData> foreignKeyList) {
        HashMap<String, List<ForeignKeyData>> map = new HashMap<String, List<ForeignKeyData>>();
        for (ForeignKeyData foreignKyeData : foreignKeyList) {
            ArrayList<ForeignKeyData> list = (ArrayList<ForeignKeyData>)map.get(foreignKyeData.name);
            if (list == null) {
                list = new ArrayList<ForeignKeyData>();
                map.put(foreignKyeData.name, list);
            }
            list.add(foreignKyeData);
        }
        return map;
    }

    private Relation createRelation(ERTable target, List<ForeignKeyData> foreignKeyDataList) {
        ForeignKeyData representativeData = foreignKeyDataList.get(0);
        String sourceTableName = representativeData.sourceTableName;
        String sourceSchemaName = representativeData.sourceSchemaName;
        ERTable source = this.tableMap.get(sourceTableName = this.dbSetting.getTableNameWithSchema(sourceTableName, sourceSchemaName));
        if (source == null) {
            return null;
        }
        boolean referenceForPK = true;
        List<NormalColumn> primaryKeys = source.getPrimaryKeys();
        if (primaryKeys.size() != foreignKeyDataList.size()) {
            referenceForPK = false;
        }
        HashMap referenceMap = new HashMap();
        for (ForeignKeyData foreignKeyData : foreignKeyDataList) {
            NormalColumn sourceColumn = null;
            for (NormalColumn normalColumn : source.getNormalColumns()) {
                if (!normalColumn.getPhysicalName().equals(foreignKeyData.sourceColumnName)) continue;
                sourceColumn = normalColumn;
                break;
            }
            if (sourceColumn == null) {
                return null;
            }
            if (!sourceColumn.isPrimaryKey()) {
                referenceForPK = false;
            }
            Object targetColumn = null;
            for (NormalColumn normalColumn : target.getNormalColumns()) {
                if (!normalColumn.getPhysicalName().equals(foreignKeyData.targetColumnName)) continue;
                targetColumn = normalColumn;
                break;
            }
            if (targetColumn == null) {
                return null;
            }
            referenceMap.put(sourceColumn, targetColumn);
        }
        ComplexUniqueKey referencedComplexUniqueKey = null;
        NormalColumn referencedColumn = null;
        if (!referenceForPK) {
            if (referenceMap.size() > 1) {
                referencedComplexUniqueKey = new ComplexUniqueKey("");
                for (NormalColumn column : referenceMap.keySet()) {
                    referencedComplexUniqueKey.addColumn(column);
                }
                source.getComplexUniqueKeyList().add(referencedComplexUniqueKey);
            } else {
                referencedColumn = (NormalColumn)referenceMap.keySet().iterator().next();
            }
        }
        Relation relation = new Relation(referenceForPK, referencedComplexUniqueKey, referencedColumn);
        relation.setName(representativeData.name);
        relation.setSource(source);
        relation.setTargetWithoutForeignKey(target);
        String onUpdateAction = null;
        onUpdateAction = representativeData.updateRule == 0 ? "CASCADE" : (representativeData.updateRule == 1 ? "RESTRICT" : (representativeData.updateRule == 3 ? "NO ACTION" : (representativeData.updateRule == 4 ? "SET DEFAULT" : (representativeData.updateRule == 2 ? "SET NULL" : ""))));
        relation.setOnUpdateAction(onUpdateAction);
        String onDeleteAction = null;
        onDeleteAction = representativeData.deleteRule == 0 ? "CASCADE" : (representativeData.deleteRule == 1 ? "RESTRICT" : (representativeData.deleteRule == 3 ? "NO ACTION" : (representativeData.deleteRule == 4 ? "SET DEFAULT" : (representativeData.deleteRule == 2 ? "SET NULL" : ""))));
        relation.setOnDeleteAction(onDeleteAction);
        for (Map.Entry entry : referenceMap.entrySet()) {
            ((NormalColumn)entry.getValue()).addReference((NormalColumn)entry.getKey(), relation);
        }
        return relation;
    }

    public List<ERTable> getImportedTables() {
        return this.importedTables;
    }

    public List<Sequence> getImportedSequences() {
        return this.importedSequences;
    }

    public List<View> getImportedViews() {
        return this.importedViews;
    }

    private List<View> importViews(List<DBObject> dbObjectList) throws SQLException {
        ArrayList<View> list = new ArrayList<View>();
        for (DBObject dbObject : dbObjectList) {
            String name;
            String schema;
            View view;
            if (!"view".equals(dbObject.getType()) || (view = this.importView(schema = dbObject.getSchema(), name = dbObject.getName())) == null) continue;
            list.add(view);
        }
        return list;
    }

    protected View importView(String schema, String viewName) throws SQLException {
        ResultSet rs;
        PreparedStatement stmt;
        block5: {
            View view;
            stmt = null;
            rs = null;
            String sql = this.getViewDefinitionSQL(schema);
            if (sql == null) {
                return null;
            }
            try {
                stmt = this.con.prepareStatement(sql);
                if (schema != null) {
                    stmt.setString(1, schema);
                    stmt.setString(2, viewName);
                } else {
                    stmt.setString(1, viewName);
                }
                rs = stmt.executeQuery();
                if (!rs.next()) break block5;
                View view2 = new View();
                view2.setPhysicalName(viewName);
                view2.setLogicalName(this.translationResources.translate(viewName));
                String definitionSQL = rs.getString(1);
                view2.setSql(definitionSQL);
                view2.getTableViewProperties().setSchema(schema);
                List<Column> columnList = this.getViewColumnList(definitionSQL);
                view2.setColumns(columnList);
                view = view2;
            }
            catch (Throwable throwable) {
                this.close(rs);
                this.close(stmt);
                throw throwable;
            }
            this.close(rs);
            this.close(stmt);
            return view;
        }
        this.close(rs);
        this.close(stmt);
        return null;
    }

    protected abstract String getViewDefinitionSQL(String var1);

    private List<Column> getViewColumnList(String sql) {
        ArrayList<Column> columnList = new ArrayList<Column>();
        String upperSql = sql.toUpperCase();
        int selectIndex = upperSql.indexOf("SELECT ");
        int fromIndex = upperSql.indexOf(" FROM ");
        if (selectIndex == -1) {
            return null;
        }
        String columnsPart = null;
        String fromPart = null;
        if (fromIndex != -1) {
            columnsPart = sql.substring(selectIndex + "SELECT ".length(), fromIndex);
            fromPart = sql.substring(fromIndex + " FROM ".length());
        } else {
            columnsPart = sql.substring(selectIndex + "SELECT ".length());
            fromPart = "";
        }
        int whereIndex = fromPart.toUpperCase().indexOf(" WHERE ");
        if (whereIndex != -1) {
            fromPart = fromPart.substring(0, whereIndex);
        }
        HashMap<String, String> aliasTableMap = new HashMap<String, String>();
        StringTokenizer fromTokenizer = new StringTokenizer(fromPart, ",");
        while (fromTokenizer.hasMoreTokens()) {
            String tableName = fromTokenizer.nextToken().trim();
            tableName.replaceAll(" AS", "");
            tableName.replaceAll(" as", "");
            tableName.replaceAll(" As", "");
            tableName.replaceAll(" aS", "");
            String tableAlias = null;
            int asIndex = tableName.toUpperCase().indexOf(" ");
            if (asIndex == -1) continue;
            tableAlias = tableName.substring(asIndex + 1).trim();
            int dotIndex = (tableName = tableName.substring(0, asIndex).trim()).indexOf(".");
            if (dotIndex != -1) {
                tableName = tableName.substring(dotIndex + 1);
            }
            aliasTableMap.put(tableAlias, tableName);
        }
        StringTokenizer columnTokenizer = new StringTokenizer(columnsPart, ",");
        String previousColumn = null;
        while (columnTokenizer.hasMoreTokens()) {
            String columnName = columnTokenizer.nextToken();
            if (previousColumn != null) {
                columnName = String.valueOf(previousColumn) + "," + columnName;
                previousColumn = null;
            }
            if (columnName.split("\\(").length > columnName.split("\\)").length) {
                previousColumn = columnName;
                continue;
            }
            columnName = columnName.trim();
            columnName = columnName.replaceAll("\"", "");
            String columnAlias = null;
            Matcher matcher = AS_PATTERN.matcher(columnName);
            if (matcher.matches()) {
                columnAlias = matcher.toMatchResult().group(2).trim();
                columnName = matcher.toMatchResult().group(1).trim();
            } else {
                int asIndex = columnName.indexOf(" ");
                if (asIndex != -1) {
                    columnAlias = columnName.substring(asIndex + 1).trim();
                    columnName = columnName.substring(0, asIndex).trim();
                }
            }
            int dotIndex = columnName.indexOf(".");
            String tableName = null;
            if (dotIndex != -1) {
                String aliasTableName = columnName.substring(0, dotIndex);
                if ((dotIndex = (columnName = columnName.substring(dotIndex + 1)).indexOf(".")) != -1) {
                    aliasTableName = columnName.substring(0, dotIndex);
                    columnName = columnName.substring(dotIndex + 1);
                }
                if ((tableName = (String)aliasTableMap.get(aliasTableName)) == null) {
                    tableName = aliasTableName;
                }
            }
            if (columnAlias == null) {
                columnAlias = columnName;
            }
            NormalColumn targetColumn = null;
            if (columnName == null) continue;
            if (tableName != null) {
                tableName = tableName.toLowerCase();
            }
            if (!"*".equals(columnName = columnName.toLowerCase())) {
                for (ERTable table : this.importedTables) {
                    if (tableName != null && (table.getPhysicalName() == null || !tableName.equals(table.getPhysicalName().toLowerCase()))) continue;
                    for (NormalColumn column : table.getExpandedColumns()) {
                        if (column.getPhysicalName() == null || !columnName.equals(column.getPhysicalName().toLowerCase())) continue;
                        targetColumn = column;
                        break;
                    }
                    if (targetColumn != null) break;
                }
                this.addColumnToView(columnList, targetColumn, columnAlias);
                continue;
            }
            for (ERTable table : this.importedTables) {
                if (tableName != null && (table.getPhysicalName() == null || !tableName.equals(table.getPhysicalName().toLowerCase()))) continue;
                for (NormalColumn column : table.getExpandedColumns()) {
                    this.addColumnToView(columnList, column, null);
                }
            }
        }
        return columnList;
    }

    private void addColumnToView(List<Column> columnList, NormalColumn targetColumn, String columnAlias) {
        UniqueWord uniqueWord;
        Word word = null;
        if (targetColumn != null) {
            word = new Word(targetColumn.getWord());
            if (columnAlias != null) {
                word.setPhysicalName(columnAlias);
            }
        } else {
            word = new Word(columnAlias, this.translationResources.translate(columnAlias), null, new TypeData(null, null, false, null, false, null), null, null);
        }
        if (this.dictionary.get(uniqueWord = new UniqueWord(word)) != null) {
            word = this.dictionary.get(uniqueWord);
        } else {
            this.dictionary.put(uniqueWord, word);
        }
        NormalColumn column = new NormalColumn(word, false, false, false, false, null, null, null, null, null);
        columnList.add(column);
    }

    public List<Tablespace> getImportedTablespaces() {
        return this.importedTablespaces;
    }

    private List<Tablespace> importTablespaces(List<DBObject> dbObjectList) throws SQLException {
        ArrayList<Tablespace> list = new ArrayList<Tablespace>();
        for (DBObject dbObject : dbObjectList) {
            String name;
            Tablespace tablespace;
            if (!"tablespace".equals(dbObject.getType()) || (tablespace = this.importTablespace(name = dbObject.getName())) == null) continue;
            list.add(tablespace);
        }
        return list;
    }

    public List<Trigger> getImportedTriggers() {
        return this.importedTriggers;
    }

    protected Tablespace importTablespace(String tablespaceName) throws SQLException {
        return null;
    }

    public Exception getException() {
        return this.exception;
    }

    protected int getLength(String type, int size) {
        return size;
    }

    public static void main(String[] args) throws InputException, InstantiationException, IllegalAccessException, SQLException {
        new Activator();
        DBSetting setting = new DBSetting("Oracle", "localhost", 1521, "XE", "nakajima", "nakajima", true, null, null);
        Connection con = null;
        try {
            con = setting.connect();
            DatabaseMetaData metaData = con.getMetaData();
            metaData.getIndexInfo(null, "SYS", "ALERT_QT", false, false);
        }
        finally {
            if (con != null) {
                con.close();
            }
        }
    }

    protected void close(ResultSet rs) throws SQLException {
        if (rs != null) {
            rs.close();
        }
    }

    protected void close(Statement stmt) throws SQLException {
        if (stmt != null) {
            stmt.close();
        }
    }

    protected static class ColumnData {
        public String columnName;
        public String type;
        public int size;
        public int decimalDegits;
        public int nullable;
        public String defaultValue;
        public String description;
        public String constraint;
        public String enumData;

        protected ColumnData() {
        }

        public String toString() {
            return "ColumnData [columnName=" + this.columnName + ", type=" + this.type + ", size=" + this.size + ", decimalDegits=" + this.decimalDegits + "]";
        }
    }

    private static class ForeignKeyData {
        private String name;
        private String sourceTableName;
        private String sourceSchemaName;
        private String sourceColumnName;
        private String targetTableName;
        private String targetSchemaName;
        private String targetColumnName;
        private short updateRule;
        private short deleteRule;

        private ForeignKeyData() {
        }
    }

    protected static class PrimaryKeyData {
        private String columnName;
        private String constraintName;

        protected PrimaryKeyData() {
        }
    }
}

