/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.model.diagram_contents.element.connection;

import java.util.ArrayList;
import java.util.List;
import org.insightech.er.editor.model.AbstractModel;
import org.insightech.er.editor.model.diagram_contents.element.connection.Bendpoint;
import org.insightech.er.editor.model.diagram_contents.element.node.NodeElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConnectionElement
extends AbstractModel {
    private static final long serialVersionUID = -5418951773059063716L;
    public static final String PROPERTY_CHANGE_CONNECTION = "connection";
    public static final String PROPERTY_CHANGE_BEND_POINT = "bendPoint";
    public static final String PROPERTY_CHANGE_CONNECTION_ATTRIBUTE = "connection_attribute";
    protected NodeElement source;
    protected NodeElement target;
    private List<Bendpoint> bendPoints = new ArrayList<Bendpoint>();

    public NodeElement getSource() {
        return this.source;
    }

    public void setSource(NodeElement source) {
        if (this.source != null) {
            this.source.removeOutgoing(this);
        }
        this.source = source;
        if (this.source != null) {
            this.source.addOutgoing(this);
        }
        this.firePropertyChange(PROPERTY_CHANGE_CONNECTION, null, source);
    }

    public void setSourceAndTarget(NodeElement source, NodeElement target) {
        this.source = source;
        this.target = target;
    }

    public void setTarget(NodeElement target) {
        if (this.target != null) {
            this.target.removeIncoming(this);
        }
        this.target = target;
        if (this.target != null) {
            this.target.addIncoming(this);
        }
        this.firePropertyChange(PROPERTY_CHANGE_CONNECTION, null, this.source);
    }

    public NodeElement getTarget() {
        return this.target;
    }

    public void delete() {
        this.source.removeOutgoing(this);
        this.target.removeIncoming(this);
    }

    public void connect() {
        if (this.source != null) {
            this.source.addOutgoing(this);
        }
        if (this.target != null) {
            this.target.addIncoming(this);
        }
    }

    public void addBendpoint(int index, Bendpoint point) {
        this.bendPoints.add(index, point);
        this.firePropertyChange(PROPERTY_CHANGE_BEND_POINT, null, null);
    }

    public void setBendpoints(List<Bendpoint> points) {
        this.bendPoints = points;
        this.firePropertyChange(PROPERTY_CHANGE_BEND_POINT, null, null);
    }

    public List<Bendpoint> getBendpoints() {
        return this.bendPoints;
    }

    public void removeBendpoint(int index) {
        this.bendPoints.remove(index);
        this.firePropertyChange(PROPERTY_CHANGE_BEND_POINT, null, null);
    }

    public void replaceBendpoint(int index, Bendpoint point) {
        this.bendPoints.set(index, point);
        this.firePropertyChange(PROPERTY_CHANGE_BEND_POINT, null, null);
    }

    public void setParentMove() {
        this.firePropertyChange(PROPERTY_CHANGE_CONNECTION_ATTRIBUTE, null, null);
    }

    @Override
    public ConnectionElement clone() {
        ConnectionElement clone = (ConnectionElement)super.clone();
        ArrayList<Bendpoint> cloneBendPoints = new ArrayList<Bendpoint>();
        for (Bendpoint bendPoint : this.bendPoints) {
            cloneBendPoints.add((Bendpoint)bendPoint.clone());
        }
        clone.bendPoints = cloneBendPoints;
        return clone;
    }
}

