/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.view.action.dbexport;

import java.util.HashMap;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.SimpleRootEditPart;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.insightech.er.Activator;
import org.insightech.er.ResourceString;
import org.insightech.er.editor.ERDiagramEditor;
import org.insightech.er.editor.controller.editpart.element.node.NodeElementEditPart;
import org.insightech.er.editor.model.ERDiagram;
import org.insightech.er.editor.model.dbexport.image.ExportToImageWithProgressManager;
import org.insightech.er.editor.model.diagram_contents.element.connection.Bendpoint;
import org.insightech.er.editor.model.diagram_contents.element.connection.ConnectionElement;
import org.insightech.er.editor.model.diagram_contents.element.node.NodeElement;
import org.insightech.er.editor.model.diagram_contents.element.node.category.Category;
import org.insightech.er.editor.view.action.dbexport.AbstractExportAction;

public class ExportToImageAction
extends AbstractExportAction {
    public static final String ID = ExportToImageAction.class.getName();

    public ExportToImageAction(ERDiagramEditor editor) {
        super(ID, ResourceString.getResourceString("action.title.export.image"), editor);
        this.setImageDescriptor(Activator.getImageDescriptor("EXPORT_TO_IMAGE"));
    }

    public void execute(Event event) throws Exception {
        this.save((IEditorPart)this.getEditorPart(), this.getGraphicalViewer());
    }

    protected void save(IEditorPart editorPart, GraphicalViewer viewer, String saveFilePath) {
        ProgressMonitorDialog monitor = new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        try {
            if (ExportToImageAction.outputImage(monitor, viewer, saveFilePath) != -1) {
                Activator.showMessageDialog("dialog.message.export.finish");
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    public static int outputImage(ProgressMonitorDialog monitor, GraphicalViewer viewer, String saveFilePath) throws InterruptedException {
        int format = ExportToImageAction.getFormatType(saveFilePath);
        if (format == -1) {
            Activator.showMessageDialog("dialog.message.export.image.not.supported");
            return -1;
        }
        Image img = null;
        try {
            try {
                img = ExportToImageAction.createImage(viewer);
                ExportToImageWithProgressManager exportToImageManager = new ExportToImageWithProgressManager(img, format, saveFilePath);
                monitor.run(true, true, (IRunnableWithProgress)exportToImageManager);
                Exception exception = exportToImageManager.getException();
                if (exception != null) {
                    throw exception;
                }
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (Exception e) {
                if (e.getCause() instanceof OutOfMemoryError) {
                    Activator.showMessageDialog("dialog.message.export.image.out.of.memory");
                } else {
                    Activator.showExceptionDialog(e);
                }
                if (img != null) {
                    img.dispose();
                }
                return -1;
            }
        }
        finally {
            if (img != null) {
                img.dispose();
            }
        }
        return format;
    }

    public static int getFormatType(String saveFilePath) {
        int format = -1;
        int index = saveFilePath.lastIndexOf(".");
        String ext = null;
        ext = index != -1 && index != saveFilePath.length() - 1 ? saveFilePath.substring(index + 1, saveFilePath.length()) : "";
        if (ext.equalsIgnoreCase("jpeg") || ext.equalsIgnoreCase("jpg")) {
            format = 4;
        } else if (ext.equalsIgnoreCase("bmp")) {
            format = 0;
        } else if (ext.equalsIgnoreCase("png")) {
            format = 5;
        }
        return format;
    }

    public static Image createImage(GraphicalViewer viewer) {
        Image img = null;
        GC figureCanvasGC = null;
        GC imageGC = null;
        try {
            ScalableFreeformRootEditPart rootEditPart = (ScalableFreeformRootEditPart)viewer.getEditPartRegistry().get(LayerManager.ID);
            rootEditPart.refresh();
            IFigure rootFigure = rootEditPart.getLayer((Object)"Printable Layers");
            EditPart editPart = viewer.getContents();
            editPart.refresh();
            ERDiagram diagram = (ERDiagram)editPart.getModel();
            Rectangle rootFigureBounds = ExportToImageAction.getBounds(diagram, (SimpleRootEditPart)rootEditPart, rootFigure.getBounds());
            Control figureCanvas = viewer.getControl();
            figureCanvasGC = new GC((Drawable)figureCanvas);
            img = new Image((Device)Display.getCurrent(), rootFigureBounds.width + 20, rootFigureBounds.height + 20);
            imageGC = new GC((Drawable)img);
            imageGC.setBackground(figureCanvasGC.getBackground());
            imageGC.setForeground(figureCanvasGC.getForeground());
            imageGC.setFont(figureCanvasGC.getFont());
            imageGC.setLineStyle(figureCanvasGC.getLineStyle());
            imageGC.setLineWidth(figureCanvasGC.getLineWidth());
            imageGC.setAntialias(0);
            SWTGraphics imgGraphics = new SWTGraphics(imageGC);
            imgGraphics.setBackgroundColor(figureCanvas.getBackground());
            imgGraphics.fillRectangle(0, 0, rootFigureBounds.width + 20, rootFigureBounds.height + 20);
            imgGraphics.translate(ExportToImageAction.translateX(rootFigureBounds.x), ExportToImageAction.translateY(rootFigureBounds.y));
            rootFigure.paint((Graphics)imgGraphics);
            Image image = img;
            return image;
        }
        finally {
            if (figureCanvasGC != null) {
                figureCanvasGC.dispose();
            }
            if (imageGC != null) {
                imageGC.dispose();
            }
        }
    }

    public static int translateX(int x) {
        return -x + 10;
    }

    public static int translateY(int y) {
        return -y + 10;
    }

    protected String[] getFilterExtensions() {
        return new String[]{"*.png", "*.jpeg", "*.bmp"};
    }

    public static Rectangle getBounds(ERDiagram diagram, SimpleRootEditPart rootEditPart, Rectangle rootFigureBounds) {
        Category category = diagram.getCurrentCategory();
        if (category == null) {
            return rootFigureBounds;
        }
        Rectangle rectangle = new Rectangle();
        int minX = rootFigureBounds.x + rootFigureBounds.width;
        int minY = rootFigureBounds.y + rootFigureBounds.height;
        int maxX = rootFigureBounds.x;
        int maxY = rootFigureBounds.y;
        HashMap<NodeElement, IFigure> visibleElements = new HashMap<NodeElement, IFigure>();
        for (Object child : rootEditPart.getContents().getChildren()) {
            NodeElementEditPart editPart = (NodeElementEditPart)child;
            NodeElement nodeElement = (NodeElement)editPart.getModel();
            if (!category.isVisible(nodeElement, diagram)) continue;
            IFigure figure = editPart.getFigure();
            Rectangle figureRectangle = figure.getBounds();
            visibleElements.put(nodeElement, figure);
            if (figureRectangle.x < minX) {
                minX = figureRectangle.x;
            }
            if (figureRectangle.x + figureRectangle.width > maxX) {
                maxX = figureRectangle.x + figureRectangle.width;
            }
            if (figureRectangle.y < minY) {
                minY = figureRectangle.y;
            }
            if (figureRectangle.y + figureRectangle.height <= maxY) continue;
            maxY = figureRectangle.y + figureRectangle.height;
        }
        for (NodeElement sourceElement : visibleElements.keySet()) {
            for (ConnectionElement connection : sourceElement.getOutgoings()) {
                if (!visibleElements.containsKey(connection.getTarget())) continue;
                for (Bendpoint bendpoint : connection.getBendpoints()) {
                    int x = bendpoint.getX();
                    int y = bendpoint.getY();
                    if (bendpoint.isRelative()) {
                        IFigure figure = (IFigure)visibleElements.get(sourceElement);
                        Rectangle figureRectangle = figure.getBounds();
                        x = figureRectangle.x + figureRectangle.width * 2;
                        y = figureRectangle.y + figureRectangle.height * 2;
                    }
                    if (x < minX) {
                        minX = x;
                    } else if (x > maxX) {
                        maxX = x;
                    }
                    if (y < minY) {
                        minY = y;
                        continue;
                    }
                    if (y <= maxY) continue;
                    maxY = y;
                }
            }
        }
        rectangle.x = minX;
        rectangle.y = minY;
        rectangle.width = maxX - minX;
        rectangle.height = maxY - minY;
        if (rectangle.width < 0) {
            rectangle.x = 0;
            rectangle.width = 0;
        }
        if (rectangle.height < 0) {
            rectangle.y = 0;
            rectangle.height = 0;
        }
        return rectangle;
    }

    protected String getDefaultExtension() {
        return ".png";
    }
}

