/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.view.action.edit;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.LabelRetargetAction;
import org.insightech.er.Activator;
import org.insightech.er.ResourceString;
import org.insightech.er.editor.ERDiagramEditor;
import org.insightech.er.editor.controller.command.common.ChangeBackgroundColorCommand;
import org.insightech.er.editor.controller.editpart.element.node.column.NormalColumnEditPart;
import org.insightech.er.editor.model.ERDiagram;
import org.insightech.er.editor.model.ViewableModel;

public class ChangeBackgroundColorAction
extends SelectionAction {
    public static final String ID = ChangeBackgroundColorAction.class.getName();
    private RGB rgb;
    private Image image;

    public ChangeBackgroundColorAction(IWorkbenchPart part, ERDiagram diagram) {
        super(part, 4);
        this.setId(ID);
        this.setText(ResourceString.getResourceString("action.title.change.background.color"));
        this.setToolTipText(ResourceString.getResourceString("action.title.change.background.color"));
        int[] defaultColor = diagram.getDefaultColor();
        this.rgb = new RGB(defaultColor[0], defaultColor[1], defaultColor[2]);
        this.setColorToImage();
    }

    private void setColorToImage() {
        ImageData imageData = Activator.getImageDescriptor("CHANGE_BACKGROUND_COLOR").getImageData();
        int blackPixel = imageData.palette.getPixel(new RGB(0, 0, 0));
        imageData.transparentPixel = imageData.palette.getPixel(new RGB(255, 255, 255));
        imageData.palette.colors[blackPixel] = this.rgb;
        this.image = new Image((Device)Display.getCurrent(), imageData);
        ImageDescriptor descriptor = ImageDescriptor.createFromImage((Image)this.image);
        this.setImageDescriptor(descriptor);
    }

    private void setRGB(RGB rgb) {
        this.rgb = rgb;
        EditPart editPart = ((ERDiagramEditor)this.getWorkbenchPart()).getGraphicalViewer().getContents();
        ERDiagram diagram = (ERDiagram)editPart.getModel();
        diagram.setDefaultColor(this.rgb.red, this.rgb.green, this.rgb.blue);
        this.setColorToImage();
    }

    public void runWithEvent(Event event) {
        Command command = this.createCommand(this.getSelectedObjects(), this.rgb);
        this.getCommandStack().execute(command);
    }

    protected List getSelectedObjects() {
        ArrayList objects = new ArrayList(super.getSelectedObjects());
        Iterator iter = objects.iterator();
        while (iter.hasNext()) {
            if (!(iter.next() instanceof NormalColumnEditPart)) continue;
            iter.remove();
        }
        return objects;
    }

    protected boolean calculateEnabled() {
        List objects = this.getSelectedObjects();
        if (objects.isEmpty()) {
            return false;
        }
        return objects.get(0) instanceof GraphicalEditPart;
    }

    private Command createCommand(List objects, RGB rgb) {
        if (objects.isEmpty()) {
            return null;
        }
        if (!(objects.get(0) instanceof GraphicalEditPart)) {
            return null;
        }
        CompoundCommand command = new CompoundCommand();
        int i = 0;
        while (i < objects.size()) {
            GraphicalEditPart part = (GraphicalEditPart)objects.get(i);
            command.add((Command)new ChangeBackgroundColorCommand((ViewableModel)part.getModel(), rgb.red, rgb.green, rgb.blue));
            ++i;
        }
        return command;
    }

    public void dispose() {
        this.image.dispose();
        super.dispose();
    }

    public static class ChangeBackgroundColorRetargetAction
    extends LabelRetargetAction {
        public ChangeBackgroundColorRetargetAction() {
            super(ID, ResourceString.getResourceString("action.title.change.background.color"), 4);
            this.setImageDescriptor(Activator.getImageDescriptor("CHANGE_BACKGROUND_COLOR"));
            this.setDisabledImageDescriptor(Activator.getImageDescriptor("CHANGE_BACKGROUND_COLOR_DISABLED"));
            this.setToolTipText(ResourceString.getResourceString("action.title.change.background.color"));
            this.setMenuCreator(new IMenuCreator(){

                public Menu getMenu(Control parent) {
                    Menu menu = new Menu(parent);
                    try {
                        MenuItem item1 = new MenuItem(menu, 0);
                        item1.setText(ResourceString.getResourceString("action.title.select.color"));
                        item1.setImage(Activator.getImage("PALETTE"));
                        item1.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                ColorDialog colorDialog = new ColorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 0);
                                colorDialog.setText(ResourceString.getResourceString("dialog.title.change.background.color"));
                                ChangeBackgroundColorAction action = (ChangeBackgroundColorAction)ChangeBackgroundColorRetargetAction.this.getActionHandler();
                                RGB rgb = colorDialog.open();
                                action.setRGB(rgb);
                                action.runWithEvent(null);
                            }
                        });
                    }
                    catch (Exception e) {
                        Activator.showExceptionDialog(e);
                    }
                    return menu;
                }

                public Menu getMenu(Menu parent) {
                    return null;
                }

                public void dispose() {
                }
            });
        }
    }
}

