/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.view.dialog.element.table.tab;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;
import org.insightech.er.ResourceString;
import org.insightech.er.common.dialog.AbstractDialog;
import org.insightech.er.common.exception.InputException;
import org.insightech.er.common.widgets.CompositeFactory;
import org.insightech.er.common.widgets.ValidatableTabWrapper;
import org.insightech.er.editor.model.diagram_contents.element.node.table.ERTable;
import org.insightech.er.editor.model.diagram_contents.element.node.table.column.NormalColumn;
import org.insightech.er.editor.model.diagram_contents.element.node.table.index.CopyIndex;
import org.insightech.er.editor.model.diagram_contents.element.node.table.index.Index;
import org.insightech.er.editor.view.dialog.element.table.sub.IndexDialog;
import org.insightech.er.util.Format;

public class IndexTabWrapper
extends ValidatableTabWrapper {
    private static final int BUTTON_WIDTH = 60;
    private ERTable copyData;
    private Table indexTable;
    private List<Button> checkButtonList;
    private List<TableEditor> editorList;
    private Button addButton;
    private Button editButton;
    private Button deleteButton;

    public IndexTabWrapper(AbstractDialog dialog, TabFolder parent, int style, ERTable copyData) {
        super(dialog, parent, style, "label.index");
        this.copyData = copyData;
        this.checkButtonList = new ArrayList<Button>();
        this.editorList = new ArrayList<TableEditor>();
        this.init();
    }

    public void validatePage() throws InputException {
        this.resutuctIndexData();
    }

    public void initComposite() {
        this.setLayout((Layout)new GridLayout());
        Composite content = new Composite((Composite)this, 2048);
        this.createBody(content);
    }

    private void createBody(Composite content) {
        GridData contentGridData = new GridData();
        contentGridData.horizontalAlignment = 4;
        contentGridData.grabExcessHorizontalSpace = true;
        content.setLayoutData((Object)contentGridData);
        content.setLayout((Layout)new GridLayout(3, false));
        this.initTable(content);
        this.initTableButton(content);
        this.setTableData();
    }

    private void initTable(Composite parent) {
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.heightHint = 200;
        this.indexTable = new Table(parent, 34816);
        this.indexTable.setHeaderVisible(true);
        this.indexTable.setLayoutData((Object)gridData);
        this.indexTable.setLinesVisible(true);
        CompositeFactory.createTableColumn(this.indexTable, "label.column.name", 150, 0);
        TableColumn separatorColumn = CompositeFactory.createTableColumn(this.indexTable, "", 3, 0);
        separatorColumn.setResizable(false);
    }

    private void initTableButton(Composite parent) {
        GridData gridData = new GridData();
        gridData.widthHint = 60;
        this.addButton = new Button(parent, 0);
        this.addButton.setText(ResourceString.getResourceString("label.button.add"));
        this.addButton.setLayoutData((Object)gridData);
        this.editButton = new Button(parent, 0);
        this.editButton.setText(ResourceString.getResourceString("label.button.edit"));
        this.editButton.setLayoutData((Object)gridData);
        this.deleteButton = new Button(parent, 0);
        this.deleteButton.setText(ResourceString.getResourceString("label.button.delete"));
        this.deleteButton.setLayoutData((Object)gridData);
    }

    protected void addListener() {
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IndexDialog dialog = new IndexDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), null, IndexTabWrapper.this.copyData);
                if (dialog.open() == 0) {
                    IndexTabWrapper.this.addIndexData(dialog.getResultIndex(), true);
                }
            }
        });
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Index targetIndex = IndexTabWrapper.this.getTargetIndex();
                if (targetIndex == null) {
                    return;
                }
                IndexDialog dialog = new IndexDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), targetIndex, IndexTabWrapper.this.copyData);
                if (dialog.open() == 0) {
                    IndexTabWrapper.this.addIndexData(dialog.getResultIndex(), false);
                }
            }
        });
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IndexTabWrapper.this.removeIndex();
            }
        });
    }

    private void setTableData() {
        List<Index> indexes = this.copyData.getIndexes();
        TableItem radioTableItem = new TableItem(this.indexTable, 0);
        int i = 0;
        while (i < indexes.size()) {
            TableColumn tableColumn = new TableColumn(this.indexTable, 0x1000000);
            tableColumn.setWidth(60);
            tableColumn.setResizable(false);
            tableColumn.setText("Index" + (i + 1));
            TableEditor editor = new TableEditor(this.indexTable);
            Button radioButton = new Button((Composite)this.indexTable, 16);
            radioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    IndexTabWrapper.this.setButtonEnabled(true);
                }
            });
            radioButton.pack();
            editor.minimumWidth = radioButton.getSize().x;
            editor.horizontalAlignment = 0x1000000;
            editor.setEditor((Control)radioButton, radioTableItem, i + 2);
            this.checkButtonList.add(radioButton);
            this.editorList.add(editor);
            ++i;
        }
        for (NormalColumn normalColumn : this.copyData.getExpandedColumns()) {
            TableItem tableItem = new TableItem(this.indexTable, 0);
            tableItem.setText(0, Format.null2blank(normalColumn.getName()));
            int i2 = 0;
            while (i2 < indexes.size()) {
                Index index = indexes.get(i2);
                List<NormalColumn> indexColumns = index.getColumns();
                int j = 0;
                while (j < indexColumns.size()) {
                    NormalColumn indexColumn = indexColumns.get(j);
                    if (normalColumn.equals(indexColumn)) {
                        tableItem.setText(i2 + 2, String.valueOf(j + 1));
                        break;
                    }
                    ++j;
                }
                ++i2;
            }
        }
        this.setButtonEnabled(false);
    }

    public void addIndexData(Index index, boolean add) {
        int selectedIndex = -1;
        int i = 0;
        while (i < this.checkButtonList.size()) {
            Button checkButton = this.checkButtonList.get(i);
            if (checkButton.getSelection()) {
                selectedIndex = i;
                break;
            }
            ++i;
        }
        Index copyIndex = null;
        if (add || selectedIndex == -1) {
            copyIndex = new CopyIndex(this.copyData, index, null);
            this.copyData.addIndex(copyIndex);
        } else {
            copyIndex = this.copyData.getIndex(selectedIndex);
            CopyIndex.copyData(index, copyIndex);
        }
        this.restruct();
    }

    public void removeIndex() {
        int selectedIndex = -1;
        int i = 0;
        while (i < this.checkButtonList.size()) {
            Button checkButton = this.checkButtonList.get(i);
            if (checkButton.getSelection()) {
                selectedIndex = i;
                break;
            }
            ++i;
        }
        if (selectedIndex == -1) {
            return;
        }
        this.copyData.removeIndex(selectedIndex);
        this.restruct();
    }

    public void restruct() {
        this.clearButtonAndEditor();
        while (this.indexTable.getColumnCount() > 2) {
            TableColumn tableColumn = this.indexTable.getColumn(2);
            tableColumn.dispose();
        }
        this.indexTable.removeAll();
        this.resutuctIndexData();
        this.setTableData();
    }

    private void resutuctIndexData() {
        for (Index index : this.copyData.getIndexes()) {
            List<NormalColumn> indexColumns = index.getColumns();
            Iterator<NormalColumn> columnIterator = indexColumns.iterator();
            Iterator<Boolean> descIterator = index.getDescs().iterator();
            while (columnIterator.hasNext()) {
                NormalColumn indexColumn = columnIterator.next();
                descIterator.next();
                if (this.copyData.getExpandedColumns().contains(indexColumn)) continue;
                columnIterator.remove();
                descIterator.remove();
            }
        }
    }

    private void clearButtonAndEditor() {
        for (Button checkButton : this.checkButtonList) {
            checkButton.dispose();
        }
        this.checkButtonList.clear();
        for (TableEditor editor : this.editorList) {
            editor.dispose();
        }
        this.editorList.clear();
    }

    public Index getTargetIndex() {
        int selectedIndex = -1;
        int i = 0;
        while (i < this.checkButtonList.size()) {
            Button checkButton = this.checkButtonList.get(i);
            if (checkButton.getSelection()) {
                selectedIndex = i;
                break;
            }
            ++i;
        }
        if (selectedIndex == -1) {
            return null;
        }
        return this.copyData.getIndex(selectedIndex);
    }

    private void setButtonEnabled(boolean enabled) {
        this.editButton.setEnabled(enabled);
        this.deleteButton.setEnabled(enabled);
    }

    public void setInitFocus() {
    }

    public void perfomeOK() {
    }
}

