/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.view.dialog.translation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.insightech.er.ResourceString;
import org.insightech.er.common.dialog.AbstractDialog;
import org.insightech.er.common.exception.InputException;
import org.insightech.er.editor.model.ERDiagram;
import org.insightech.er.editor.model.settings.Settings;
import org.insightech.er.editor.model.settings.TranslationSetting;

public class TranslationManageDialog
extends AbstractDialog {
    private static final int BUTTON_WIDTH = 60;
    private Table dictionaryTable = null;
    private TranslationSetting translationSettings;
    private Map<String, TableEditor> translationCheckMap;
    private Button useButton;
    private List<String> allTranslations;

    public TranslationManageDialog(Shell parentShell, Settings settings, ERDiagram diagram) {
        super(parentShell, 1);
        this.translationSettings = settings.getTranslationSetting();
        this.allTranslations = this.translationSettings.getAllTranslations();
    }

    protected void initialize(Composite composite) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        Group group = new Group(composite, 0);
        group.setText(ResourceString.getResourceString("label.translation.message"));
        group.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 4;
        this.useButton = new Button((Composite)group, 32);
        this.useButton.setText(ResourceString.getResourceString("label.translation.use"));
        this.useButton.setLayoutData((Object)gridData);
        GridData tableGridData = new GridData();
        tableGridData.heightHint = 200;
        tableGridData.horizontalSpan = 3;
        tableGridData.verticalSpan = 2;
        this.dictionaryTable = new Table((Composite)group, 67584);
        this.dictionaryTable.setHeaderVisible(true);
        this.dictionaryTable.setLayoutData((Object)tableGridData);
        this.dictionaryTable.setLinesVisible(true);
        GridData upButtonGridData = new GridData();
        upButtonGridData.grabExcessHorizontalSpace = false;
        upButtonGridData.verticalAlignment = 3;
        upButtonGridData.grabExcessVerticalSpace = true;
        upButtonGridData.widthHint = 60;
        GridData downButtonGridData = new GridData();
        downButtonGridData.grabExcessVerticalSpace = true;
        downButtonGridData.verticalAlignment = 1;
        downButtonGridData.widthHint = 60;
        GridData textGridData = new GridData();
        textGridData.widthHint = 150;
        TableColumn tableColumn = new TableColumn(this.dictionaryTable, 0);
        tableColumn.setWidth(30);
        tableColumn.setResizable(false);
        TableColumn tableColumn1 = new TableColumn(this.dictionaryTable, 0);
        tableColumn1.setWidth(230);
        tableColumn1.setResizable(false);
        tableColumn1.setText(ResourceString.getResourceString("label.translation.file.name"));
    }

    private void setUse(boolean use) {
        this.dictionaryTable.setEnabled(use);
    }

    private void initTranslationTable() {
        this.dictionaryTable.removeAll();
        if (this.translationCheckMap != null) {
            for (TableEditor editor : this.translationCheckMap.values()) {
                editor.getEditor().dispose();
                editor.dispose();
            }
            this.translationCheckMap.clear();
        } else {
            this.translationCheckMap = new HashMap<String, TableEditor>();
        }
        for (String translation : this.allTranslations) {
            TableItem tableItem = new TableItem(this.dictionaryTable, 0);
            Button selectCheckButton = new Button((Composite)this.dictionaryTable, 32);
            selectCheckButton.pack();
            TableEditor editor = new TableEditor(this.dictionaryTable);
            editor.minimumWidth = selectCheckButton.getSize().x;
            editor.horizontalAlignment = 0x1000000;
            editor.setEditor((Control)selectCheckButton, tableItem, 0);
            tableItem.setText(1, translation);
            if (this.translationSettings.isSelected(translation)) {
                selectCheckButton.setSelection(true);
            }
            this.translationCheckMap.put(translation, editor);
        }
    }

    protected void addListener() {
        this.useButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TranslationManageDialog.this.setUse(TranslationManageDialog.this.useButton.getSelection());
            }
        });
    }

    protected String getTitle() {
        return "label.translation";
    }

    protected void perfomeOK() throws InputException {
        this.validatePage();
    }

    protected void setData() {
        this.initTranslationTable();
        this.useButton.setSelection(this.translationSettings.isUse());
        this.setUse(this.translationSettings.isUse());
    }

    protected String getErrorMessage() {
        return null;
    }

    public void validatePage() {
        ArrayList<String> selectedTranslations = new ArrayList<String>();
        for (String translation : this.allTranslations) {
            Button button = (Button)this.translationCheckMap.get(translation).getEditor();
            if (!button.getSelection()) continue;
            selectedTranslations.add(translation);
        }
        this.translationSettings.setSelectedTranslations(selectedTranslations);
        this.translationSettings.setUse(this.useButton.getSelection());
    }
}

