/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.util.CellRangeAddress;
import org.insightech.er.util.Check;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class POIUtils {
    public static CellLocation findCell(HSSFSheet sheet, String str) {
        return POIUtils.findCell(sheet, new String[]{str});
    }

    public static CellLocation findCell(HSSFSheet sheet, String[] strs) {
        int rowNum = sheet.getFirstRowNum();
        while (rowNum < sheet.getLastRowNum() + 1) {
            HSSFRow row = sheet.getRow(rowNum);
            if (row != null) {
                int i = 0;
                while (i < strs.length) {
                    Integer colNum = POIUtils.findColumn(row, strs[i]);
                    if (colNum != null) {
                        return new CellLocation(rowNum, colNum.shortValue());
                    }
                    ++i;
                }
            }
            ++rowNum;
        }
        return null;
    }

    public static Integer findColumn(HSSFRow row, String str) {
        int colNum = row.getFirstCellNum();
        while (colNum <= row.getLastCellNum()) {
            HSSFRichTextString cellValue;
            HSSFCell cell = row.getCell(colNum);
            if (cell != null && cell.getCellType() == 1 && str.equals((cellValue = cell.getRichStringCellValue()).getString())) {
                return colNum;
            }
            ++colNum;
        }
        return null;
    }

    public static CellLocation findMatchCell(HSSFSheet sheet, String regexp) {
        int rowNum = sheet.getFirstRowNum();
        while (rowNum < sheet.getLastRowNum() + 1) {
            Integer colNum;
            HSSFRow row = sheet.getRow(rowNum);
            if (row != null && (colNum = POIUtils.findMatchColumn(row, regexp)) != null) {
                return new CellLocation(rowNum, colNum.shortValue());
            }
            ++rowNum;
        }
        return null;
    }

    public static Integer findMatchColumn(HSSFRow row, String str) {
        int colNum = row.getFirstCellNum();
        while (colNum <= row.getLastCellNum()) {
            HSSFRichTextString cellValue;
            HSSFCell cell = row.getCell(colNum);
            if (cell != null && cell.getCellType() == 1 && (cellValue = cell.getRichStringCellValue()).getString().matches(str)) {
                return colNum;
            }
            ++colNum;
        }
        return null;
    }

    public static CellLocation findCell(HSSFSheet sheet, String str, int colNum) {
        int rowNum = sheet.getFirstRowNum();
        while (rowNum < sheet.getLastRowNum() + 1) {
            HSSFRichTextString cellValue;
            HSSFCell cell;
            HSSFRow row = sheet.getRow(rowNum);
            if (row != null && (cell = row.getCell(colNum)) != null && !Check.isEmpty((cellValue = cell.getRichStringCellValue()).getString()) && cellValue.getString().equals(str)) {
                return new CellLocation(rowNum, (short)colNum);
            }
            ++rowNum;
        }
        return null;
    }

    public static void replace(HSSFSheet sheet, String keyword, String str) {
        CellLocation location = POIUtils.findCell(sheet, keyword);
        if (location == null) {
            return;
        }
        POIUtils.setCellValue(sheet, location, str);
    }

    public static String getCellValue(HSSFSheet sheet, CellLocation location) {
        HSSFRow row = sheet.getRow(location.r);
        HSSFCell cell = row.getCell(location.c);
        HSSFRichTextString cellValue = cell.getRichStringCellValue();
        return cellValue.toString();
    }

    public static String getCellValue(HSSFSheet sheet, int r, int c) {
        HSSFRow row = sheet.getRow(r);
        if (row == null) {
            return null;
        }
        HSSFCell cell = row.getCell(c);
        if (cell == null) {
            return null;
        }
        HSSFRichTextString cellValue = cell.getRichStringCellValue();
        return cellValue.toString();
    }

    public static int getIntCellValue(HSSFSheet sheet, int r, int c) {
        HSSFRow row = sheet.getRow(r);
        if (row == null) {
            return 0;
        }
        HSSFCell cell = row.getCell(c);
        if (cell.getCellType() != 0) {
            return 0;
        }
        return (int)cell.getNumericCellValue();
    }

    public static boolean getBooleanCellValue(HSSFSheet sheet, int r, int c) {
        HSSFRow row = sheet.getRow(r);
        if (row == null) {
            return false;
        }
        HSSFCell cell = row.getCell(c);
        if (cell == null) {
            return false;
        }
        return cell.getBooleanCellValue();
    }

    public static short getCellColor(HSSFSheet sheet, int r, int c) {
        HSSFRow row = sheet.getRow(r);
        if (row == null) {
            return -1;
        }
        HSSFCell cell = row.getCell(c);
        return cell.getCellStyle().getFillForegroundColor();
    }

    public static void setCellValue(HSSFSheet sheet, CellLocation location, String value) {
        HSSFRow row = sheet.getRow(location.r);
        HSSFCell cell = row.getCell(location.c);
        HSSFRichTextString text = new HSSFRichTextString(value);
        cell.setCellValue((RichTextString)text);
    }

    public static HSSFWorkbook readExcelBook(File excelFile) throws IOException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(excelFile);
            HSSFWorkbook hSSFWorkbook = POIUtils.readExcelBook(fis);
            return hSSFWorkbook;
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
    }

    public static HSSFWorkbook readExcelBook(InputStream stream) throws IOException {
        BufferedInputStream bis = null;
        try {
            bis = new BufferedInputStream(stream);
            HSSFWorkbook hSSFWorkbook = new HSSFWorkbook((InputStream)bis);
            return hSSFWorkbook;
        }
        finally {
            if (bis != null) {
                bis.close();
            }
        }
    }

    public static void writeExcelFile(File excelFile, HSSFWorkbook workbook) throws IOException {
        FileOutputStream fos = null;
        FilterOutputStream bos = null;
        try {
            fos = new FileOutputStream(excelFile);
            bos = new BufferedOutputStream(fos);
            workbook.write((OutputStream)bos);
        }
        finally {
            if (bos != null) {
                bos.close();
            }
            if (fos != null) {
                fos.close();
            }
        }
    }

    public static CellRangeAddress getMergedRegion(HSSFSheet sheet, CellLocation location) {
        int i = 0;
        while (i < sheet.getNumMergedRegions()) {
            int colFrom;
            CellRangeAddress region = sheet.getMergedRegion(i);
            int rowFrom = region.getFirstRow();
            int rowTo = region.getLastRow();
            if (rowFrom == location.r && rowTo == location.r && (colFrom = region.getFirstColumn()) == location.c) {
                return region;
            }
            ++i;
        }
        return null;
    }

    public static List<CellRangeAddress> getMergedRegionList(HSSFSheet sheet, int rowNum) {
        ArrayList<CellRangeAddress> regionList = new ArrayList<CellRangeAddress>();
        int i = 0;
        while (i < sheet.getNumMergedRegions()) {
            CellRangeAddress region = sheet.getMergedRegion(i);
            int rowFrom = region.getFirstRow();
            int rowTo = region.getLastRow();
            if (rowFrom == rowNum && rowTo == rowNum) {
                regionList.add(region);
            }
            ++i;
        }
        return regionList;
    }

    public static void copyRow(HSSFSheet oldSheet, HSSFSheet newSheet, int oldStartRowNum, int oldEndRowNum, int newStartRowNum) {
        HSSFRow oldAboveRow = oldSheet.getRow(oldStartRowNum - 1);
        int newRowNum = newStartRowNum;
        int oldRowNum = oldStartRowNum;
        while (oldRowNum <= oldEndRowNum) {
            POIUtils.copyRow(oldSheet, newSheet, oldRowNum, newRowNum++);
            ++oldRowNum;
        }
        HSSFRow newTopRow = newSheet.getRow(newStartRowNum);
        if (oldAboveRow != null) {
            int colNum = newTopRow.getFirstCellNum();
            while (colNum <= newTopRow.getLastCellNum()) {
                HSSFCell oldAboveCell = oldAboveRow.getCell(colNum);
                if (oldAboveCell != null) {
                    HSSFCell newTopCell = newTopRow.getCell(colNum);
                    newTopCell.getCellStyle().setBorderTop(oldAboveCell.getCellStyle().getBorderBottom());
                }
                ++colNum;
            }
        }
    }

    public static void copyRow(HSSFSheet oldSheet, HSSFSheet newSheet, int oldRowNum, int newRowNum) {
        HSSFRow oldRow = oldSheet.getRow(oldRowNum);
        HSSFRow newRow = newSheet.createRow(newRowNum);
        if (oldRow == null) {
            return;
        }
        newRow.setHeight(oldRow.getHeight());
        if (oldRow.getFirstCellNum() == -1) {
            return;
        }
        int colNum = oldRow.getFirstCellNum();
        while (colNum <= oldRow.getLastCellNum()) {
            HSSFCell oldCell = oldRow.getCell(colNum);
            HSSFCell newCell = newRow.createCell(colNum);
            if (oldCell != null) {
                HSSFCellStyle style = oldCell.getCellStyle();
                newCell.setCellStyle(style);
                int cellType = oldCell.getCellType();
                newCell.setCellType(cellType);
                if (cellType == 4) {
                    newCell.setCellValue(oldCell.getBooleanCellValue());
                } else if (cellType == 2) {
                    newCell.setCellFormula(oldCell.getCellFormula());
                } else if (cellType == 0) {
                    newCell.setCellValue(oldCell.getNumericCellValue());
                } else if (cellType == 1) {
                    newCell.setCellValue((RichTextString)oldCell.getRichStringCellValue());
                }
            }
            ++colNum;
        }
        POIUtils.copyMergedRegion(newSheet, POIUtils.getMergedRegionList(oldSheet, oldRowNum), newRowNum);
    }

    public static void copyMergedRegion(HSSFSheet sheet, List<CellRangeAddress> regionList, int rowNum) {
        for (CellRangeAddress region : regionList) {
            CellRangeAddress address = new CellRangeAddress(rowNum, rowNum, region.getFirstColumn(), region.getLastColumn());
            sheet.addMergedRegion(address);
        }
    }

    public static List<HSSFCellStyle> copyCellStyle(HSSFWorkbook workbook, HSSFRow row) {
        ArrayList<HSSFCellStyle> cellStyleList = new ArrayList<HSSFCellStyle>();
        int colNum = row.getFirstCellNum();
        while (colNum <= row.getLastCellNum()) {
            HSSFCell cell = row.getCell(colNum);
            if (cell != null) {
                HSSFCellStyle style = cell.getCellStyle();
                HSSFCellStyle newCellStyle = POIUtils.copyCellStyle(workbook, style);
                cellStyleList.add(newCellStyle);
            } else {
                cellStyleList.add(null);
            }
            ++colNum;
        }
        return cellStyleList;
    }

    public static HSSFCellStyle copyCellStyle(HSSFWorkbook workbook, HSSFCellStyle style) {
        HSSFCellStyle newCellStyle = workbook.createCellStyle();
        newCellStyle.setAlignment(style.getAlignment());
        newCellStyle.setBorderBottom(style.getBorderBottom());
        newCellStyle.setBorderLeft(style.getBorderLeft());
        newCellStyle.setBorderRight(style.getBorderRight());
        newCellStyle.setBorderTop(style.getBorderTop());
        newCellStyle.setBottomBorderColor(style.getBottomBorderColor());
        newCellStyle.setDataFormat(style.getDataFormat());
        newCellStyle.setFillBackgroundColor(style.getFillBackgroundColor());
        newCellStyle.setFillForegroundColor(style.getFillForegroundColor());
        newCellStyle.setFillPattern(style.getFillPattern());
        newCellStyle.setHidden(style.getHidden());
        newCellStyle.setIndention(style.getIndention());
        newCellStyle.setLeftBorderColor(style.getLeftBorderColor());
        newCellStyle.setLocked(style.getLocked());
        newCellStyle.setRightBorderColor(style.getRightBorderColor());
        newCellStyle.setRotation(style.getRotation());
        newCellStyle.setTopBorderColor(style.getTopBorderColor());
        newCellStyle.setVerticalAlignment(style.getVerticalAlignment());
        newCellStyle.setWrapText(style.getWrapText());
        HSSFFont font = workbook.getFontAt(style.getFontIndex());
        newCellStyle.setFont(font);
        return newCellStyle;
    }

    public static HSSFFont copyFont(HSSFWorkbook workbook, HSSFFont font) {
        HSSFFont newFont = workbook.createFont();
        return newFont;
    }

    public static HSSFRow insertRow(HSSFSheet sheet, int rowNum) {
        sheet.shiftRows(rowNum + 1, sheet.getLastRowNum(), 1);
        return sheet.getRow(rowNum);
    }

    public static class CellLocation {
        public int r;
        public int c;

        private CellLocation(int r, short c) {
            this.r = r;
            this.c = c;
        }

        public String toString() {
            String str = "(" + this.r + ", " + this.c + ")";
            return str;
        }
    }
}

