/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.wizard.page;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.insightech.er.Activator;
import org.insightech.er.ResourceString;
import org.insightech.er.editor.model.ERDiagram;
import org.insightech.er.editor.persistent.Persistent;

public class NewDiagramWizardPage1
extends WizardNewFileCreationPage {
    private ERDiagram diagram;
    private static final String EXTENSION = ".erm";

    public NewDiagramWizardPage1(IStructuredSelection selection) {
        super(ResourceString.getResourceString("wizard.new.diagram.title"), selection);
        this.setTitle(ResourceString.getResourceString("wizard.new.diagram.title"));
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.setFileName("newfile");
    }

    protected boolean validatePage() {
        String fileName;
        boolean valid = super.validatePage();
        if (valid && (fileName = this.getFileName()).indexOf(".") != -1 && !fileName.endsWith(EXTENSION)) {
            this.setErrorMessage(ResourceString.getResourceString("error.erm.extension"));
            valid = false;
        }
        if (valid) {
            IPath containerPath;
            IPath newFilePath;
            IWorkspace workspace;
            IWorkspaceRoot root;
            fileName = this.getFileName();
            if (fileName.indexOf(".") == -1) {
                fileName = String.valueOf(fileName) + EXTENSION;
            }
            if ((root = (workspace = ResourcesPlugin.getWorkspace()).getRoot()).getFile(newFilePath = (containerPath = this.getContainerFullPath()).append(fileName)).exists()) {
                this.setErrorMessage("'" + fileName + "' " + ResourceString.getResourceString("error.file.already.exists"));
                valid = false;
            }
        }
        if (valid) {
            this.setMessage(ResourceString.getResourceString("wizard.new.diagram.message"));
        }
        return valid;
    }

    public void createERDiagram(String database) {
        this.diagram = new ERDiagram(database);
        this.diagram.init();
    }

    protected InputStream getInitialContents() {
        Persistent persistent = Persistent.getInstance();
        try {
            InputStream in = persistent.createInputStream(this.diagram);
            return in;
        }
        catch (IOException e) {
            Activator.showExceptionDialog(e);
            return null;
        }
    }

    public IFile createNewFile() {
        String fileName = this.getFileName();
        if (fileName.indexOf(".") == -1) {
            this.setFileName(String.valueOf(fileName) + EXTENSION);
        }
        return super.createNewFile();
    }
}

