/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.java;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.Filter;
import org.eclipse.jpt.common.utility.internal.ClassName;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.Tools;
import org.eclipse.jpt.common.utility.internal.iterables.ChainIterable;
import org.eclipse.jpt.common.utility.internal.iterables.CompositeIterable;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterables.FilteringIterable;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SnapshotCloneIterable;
import org.eclipse.jpt.common.utility.internal.iterables.TransformationIterable;
import org.eclipse.jpt.common.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.jpa.core.JpaFile;
import org.eclipse.jpt.jpa.core.JpaStructureNode;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.context.AccessType;
import org.eclipse.jpt.jpa.core.context.JpaContextNode;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.ReadOnlyPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.java.JavaTypeMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaTypeMappingDefinition;
import org.eclipse.jpt.jpa.core.internal.context.ContextContainerTools;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.SourceNode;
import org.eclipse.jpt.jpa.core.resource.java.Annotation;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jst.j2ee.model.internal.validation.ValidationCancelledException;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaPersistentType
extends AbstractJavaJpaContextNode
implements JavaPersistentType {
    protected final JavaResourcePersistentType resourcePersistentType;
    protected String name;
    protected PersistentType superPersistentType;
    protected AccessType specifiedAccess;
    protected AccessType defaultAccess;
    protected JavaTypeMapping mapping;
    protected final Vector<JavaPersistentAttribute> attributes = new Vector();
    protected final AttributeContainerAdapter attributeContainerAdapter = new AttributeContainerAdapter();

    protected AbstractJavaPersistentType(PersistentType.Owner parent, JavaResourcePersistentType resourcePersistentType) {
        super(parent);
        this.resourcePersistentType = resourcePersistentType;
        this.name = resourcePersistentType.getQualifiedName();
        this.specifiedAccess = this.buildSpecifiedAccess();
        this.defaultAccess = AccessType.FIELD;
        this.mapping = this.buildMapping();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setName(this.resourcePersistentType.getQualifiedName());
        this.setSpecifiedAccess_(this.buildSpecifiedAccess());
        this.syncMapping();
        this.synchronizeNodesWithResourceModel((Iterable<? extends JpaContextNode>)this.getAttributes());
    }

    @Override
    public void update() {
        super.update();
        this.setSuperPersistentType(this.buildSuperPersistentType());
        this.setDefaultAccess(this.buildDefaultAccess());
        this.mapping.update();
        this.updateAttributes();
        this.registerRootStructureNode();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getSimpleName() {
        return ClassName.getSimpleName((String)this.name);
    }

    protected void setName(String name) {
        String old = this.name;
        this.name = name;
        this.firePropertyChanged("name", old, name);
    }

    @Override
    public PersistentType getSuperPersistentType() {
        return this.superPersistentType;
    }

    protected void setSuperPersistentType(PersistentType superPersistentType) {
        PersistentType old = this.superPersistentType;
        this.superPersistentType = superPersistentType;
        this.firePropertyChanged("superPersistentType", old, superPersistentType);
    }

    protected PersistentType buildSuperPersistentType() {
        HashSet<JavaResourcePersistentType> visited = new HashSet<JavaResourcePersistentType>();
        visited.add(this.resourcePersistentType);
        PersistentType spt = this.resolveSuperPersistentType(this.resourcePersistentType.getSuperclassQualifiedName(), visited);
        if (spt == null) {
            return null;
        }
        if (CollectionTools.contains(spt.inheritanceHierarchy(), (Object)this)) {
            return null;
        }
        return spt.isMapped() ? spt : spt.getSuperPersistentType();
    }

    protected PersistentType resolveSuperPersistentType(String typeName, Collection<JavaResourcePersistentType> visited) {
        if (typeName == null) {
            return null;
        }
        JavaResourcePersistentType resourceType = this.getJpaProject().getJavaResourcePersistentType(typeName);
        if (resourceType == null || visited.contains(resourceType)) {
            return null;
        }
        visited.add(resourceType);
        PersistentType spt = this.resolvePersistentType(typeName);
        return spt != null ? spt : this.resolveSuperPersistentType(resourceType.getSuperclassQualifiedName(), visited);
    }

    protected PersistentType resolvePersistentType(String typeName) {
        return this.getPersistenceUnit().getPersistentType(typeName);
    }

    @Override
    public AccessType getAccess() {
        return this.specifiedAccess != null ? this.specifiedAccess : this.defaultAccess;
    }

    @Override
    public AccessType getSpecifiedAccess() {
        return this.specifiedAccess;
    }

    protected void setSpecifiedAccess_(AccessType access) {
        AccessType old = this.specifiedAccess;
        this.specifiedAccess = access;
        this.firePropertyChanged("specifiedAccess", (Object)old, (Object)access);
    }

    protected abstract AccessType buildSpecifiedAccess();

    @Override
    public AccessType getDefaultAccess() {
        return this.defaultAccess;
    }

    protected void setDefaultAccess(AccessType access) {
        AccessType old = this.defaultAccess;
        this.defaultAccess = access;
        this.firePropertyChanged("defaultAccess", (Object)old, (Object)access);
    }

    protected AccessType buildDefaultAccess() {
        AccessType accessType = AccessType.fromJavaResourceModel(JavaResourcePersistentType.Tools.buildAccess(this.resourcePersistentType));
        if (accessType != null) {
            return accessType;
        }
        accessType = this.getOwnerOverrideAccess();
        if (accessType != null) {
            return accessType;
        }
        if (this.superPersistentType != null && (accessType = this.superPersistentType.getAccess()) != null) {
            return accessType;
        }
        accessType = this.getOwnerDefaultAccess();
        if (accessType != null) {
            return accessType;
        }
        return AccessType.FIELD;
    }

    @Override
    public JavaTypeMapping getMapping() {
        return this.mapping;
    }

    @Override
    public String getMappingKey() {
        return this.mapping.getKey();
    }

    @Override
    public void setMappingKey(String key) {
        if (this.valuesAreDifferent(key, this.getMappingKey())) {
            this.setMapping(this.buildMapping(key));
        }
    }

    protected JavaTypeMapping buildMapping(String key) {
        for (JavaTypeMappingDefinition definition : this.getMappingDefinitions()) {
            if (!Tools.valuesAreEqual((Object)definition.getKey(), (Object)key)) continue;
            Annotation annotation = this.resourcePersistentType.setPrimaryAnnotation(definition.getAnnotationName(), definition.getSupportingAnnotationNames());
            return definition.buildMapping(this, annotation, this.getJpaFactory());
        }
        this.resourcePersistentType.setPrimaryAnnotation(null, EmptyIterable.instance());
        return this.buildNullMapping();
    }

    protected void setMapping(JavaTypeMapping mapping) {
        JavaTypeMapping old = this.mapping;
        this.mapping = mapping;
        this.firePropertyChanged("mapping", old, mapping);
    }

    protected JavaTypeMapping buildMapping() {
        for (JavaTypeMappingDefinition definition : this.getMappingDefinitions()) {
            Annotation annotation = this.resourcePersistentType.getAnnotation(definition.getAnnotationName());
            if (annotation == null) continue;
            return definition.buildMapping(this, annotation, this.getJpaFactory());
        }
        return this.buildNullMapping();
    }

    protected void syncMapping() {
        JavaTypeMappingDefinition definition = null;
        Annotation annotation = null;
        Iterator<JavaTypeMappingDefinition> stream = this.mappingDefinitions();
        while (stream.hasNext()) {
            definition = stream.next();
            annotation = this.resourcePersistentType.getAnnotation(definition.getAnnotationName());
            if (annotation != null) break;
        }
        if (this.mapping.getMappingAnnotation() == annotation) {
            this.mapping.synchronizeWithResourceModel();
        } else {
            this.setMapping(this.buildMapping(annotation, definition));
        }
    }

    protected JavaTypeMapping buildMapping(Annotation annotation, JavaTypeMappingDefinition definition) {
        return annotation != null ? definition.buildMapping(this, annotation, this.getJpaFactory()) : this.buildNullMapping();
    }

    protected Iterator<JavaTypeMappingDefinition> mappingDefinitions() {
        return this.getMappingDefinitions().iterator();
    }

    protected Iterable<JavaTypeMappingDefinition> getMappingDefinitions() {
        return this.getJpaPlatform().getJavaTypeMappingDefinitions();
    }

    protected JavaTypeMapping buildNullMapping() {
        return this.getJpaFactory().buildJavaNullTypeMapping(this);
    }

    @Override
    public boolean isMapped() {
        return this.mapping.isMapped();
    }

    @Override
    public ListIterator<JavaPersistentAttribute> attributes() {
        return this.getAttributes().iterator();
    }

    protected ListIterable<JavaPersistentAttribute> getAttributes() {
        return new LiveCloneListIterable(this.attributes);
    }

    @Override
    public int attributesSize() {
        return this.attributes.size();
    }

    @Override
    public Iterator<String> attributeNames() {
        return this.getAttributeNames().iterator();
    }

    protected Iterable<String> getAttributeNames() {
        return this.convertToNames((Iterable<? extends ReadOnlyPersistentAttribute>)this.getAttributes());
    }

    @Override
    public JavaPersistentAttribute getAttributeNamed(String attributeName) {
        Iterator<JavaPersistentAttribute> stream = this.getAttributesNamed(attributeName).iterator();
        return stream.hasNext() ? stream.next() : null;
    }

    @Override
    public JavaPersistentAttribute getAttributeFor(JavaResourcePersistentAttribute javaResourceAttribute) {
        for (JavaPersistentAttribute javaAttribute : this.getAttributes()) {
            if (javaAttribute.getResourcePersistentAttribute() != javaResourceAttribute) continue;
            return javaAttribute;
        }
        return null;
    }

    @Override
    public Iterator<ReadOnlyPersistentAttribute> allAttributes() {
        return this.getAllAttributes().iterator();
    }

    protected Iterable<ReadOnlyPersistentAttribute> getAllAttributes() {
        return new CompositeIterable((Iterable)new TransformationIterable<PersistentType, Iterable<ReadOnlyPersistentAttribute>>(this.getInheritanceHierarchy()){

            protected Iterable<ReadOnlyPersistentAttribute> transform(PersistentType pt) {
                return new SnapshotCloneIterable(pt.attributes());
            }
        });
    }

    @Override
    public Iterator<String> allAttributeNames() {
        return this.getAllAttributeNames().iterator();
    }

    protected Iterable<String> getAllAttributeNames() {
        return this.convertToNames(this.getAllAttributes());
    }

    protected Iterable<JavaPersistentAttribute> getAttributesNamed(final String attributeName) {
        return new FilteringIterable<JavaPersistentAttribute>(this.getAttributes()){

            protected boolean accept(JavaPersistentAttribute attribute) {
                return Tools.valuesAreEqual((Object)attributeName, (Object)attribute.getName());
            }
        };
    }

    @Override
    public ReadOnlyPersistentAttribute resolveAttribute(String attributeName) {
        Iterator<JavaPersistentAttribute> stream = this.getAttributesNamed(attributeName).iterator();
        if (stream.hasNext()) {
            JavaPersistentAttribute attribute = stream.next();
            return stream.hasNext() ? null : attribute;
        }
        return this.superPersistentType == null ? null : this.superPersistentType.resolveAttribute(attributeName);
    }

    protected Iterable<String> convertToNames(Iterable<? extends ReadOnlyPersistentAttribute> attrs) {
        return new TransformationIterable<ReadOnlyPersistentAttribute, String>(attrs){

            protected String transform(ReadOnlyPersistentAttribute attribute) {
                return attribute.getName();
            }
        };
    }

    protected Iterator<JavaResourcePersistentAttribute> resourceAttributes() {
        return this.getAccess() == AccessType.PROPERTY ? this.resourcePersistentType.persistableProperties() : this.resourcePersistentType.persistableFields();
    }

    protected Iterable<JavaResourcePersistentAttribute> getResourceAttributes() {
        return CollectionTools.iterable(this.resourceAttributes());
    }

    protected JavaPersistentAttribute buildAttribute(JavaResourcePersistentAttribute resourceAttribute) {
        return this.getJpaFactory().buildJavaPersistentAttribute(this, resourceAttribute);
    }

    @Override
    public boolean hasAnyAnnotatedAttributes() {
        return this.resourcePersistentType.hasAnyAnnotatedAttributes();
    }

    protected void updateAttributes() {
        ContextContainerTools.update(this.attributeContainerAdapter);
    }

    protected void moveAttribute(int index, JavaPersistentAttribute attribute) {
        this.moveItemInList(index, attribute, this.attributes, "attributes");
    }

    protected void addAttribute(int index, JavaResourcePersistentAttribute resourceAttribute) {
        this.addItemToList(index, this.buildAttribute(resourceAttribute), this.attributes, "attributes");
    }

    protected void removeAttribute(JavaPersistentAttribute attribute) {
        this.removeItemFromList(attribute, this.attributes, "attributes");
    }

    @Override
    public Iterator<PersistentType> inheritanceHierarchy() {
        return this.getInheritanceHierarchy().iterator();
    }

    public Iterable<PersistentType> getInheritanceHierarchy() {
        return this.getInheritanceHierarchyOf(this);
    }

    @Override
    public Iterator<PersistentType> ancestors() {
        return this.getAncestors().iterator();
    }

    public Iterable<PersistentType> getAncestors() {
        return this.getInheritanceHierarchyOf(this.superPersistentType);
    }

    protected Iterable<PersistentType> getInheritanceHierarchyOf(PersistentType start) {
        return new ChainIterable<PersistentType>(start){

            protected PersistentType nextLink(PersistentType persistentType) {
                return persistentType.getSuperPersistentType();
            }
        };
    }

    @Override
    public String getId() {
        return "org.eclipse.jpt.jpa.core.java.persistentType";
    }

    @Override
    public JpaStructureNode getStructureNode(int offset) {
        CompilationUnit astRoot = this.buildASTRoot();
        if (this.contains(offset, astRoot)) {
            for (JavaPersistentAttribute persistentAttribute : this.getAttributes()) {
                if (!persistentAttribute.contains(offset, astRoot)) continue;
                return persistentAttribute;
            }
            return this;
        }
        return null;
    }

    protected boolean contains(int offset, CompilationUnit astRoot) {
        TextRange fullTextRange = this.resourcePersistentType.getTextRange(astRoot);
        return fullTextRange == null ? false : fullTextRange.includes(offset);
    }

    @Override
    public TextRange getSelectionTextRange() {
        return this.getSelectionTextRange(this.buildASTRoot());
    }

    protected TextRange getSelectionTextRange(CompilationUnit astRoot) {
        return this.resourcePersistentType.getNameTextRange(astRoot);
    }

    @Override
    public void dispose() {
        this.unregisterRootStructureNode();
    }

    protected void registerRootStructureNode() {
        JpaFile jpaFile = this.getJpaFile();
        if (jpaFile != null) {
            jpaFile.addRootStructureNode(this.name, this);
        }
    }

    protected void unregisterRootStructureNode() {
        JpaFile jpaFile = this.getJpaFile();
        if (jpaFile != null) {
            jpaFile.removeRootStructureNode(this.name, this);
        }
    }

    @Override
    public Iterator<String> javaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator<String> result = super.javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        Iterator values = this.mapping.javaCompletionProposals(pos, filter, astRoot);
        if (values != null) {
            return values;
        }
        for (JavaPersistentAttribute attribute : this.getAttributes()) {
            values = attribute.javaCompletionProposals(pos, filter, astRoot);
            if (values == null) continue;
            return values;
        }
        return EmptyIterator.instance();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        if (reporter.isCancelled()) {
            throw new ValidationCancelledException();
        }
        IFile file = this.resourcePersistentType.getFile();
        if (file != null && file.getProject().equals((Object)this.getJpaProject().getProject()) && this.resourcePersistentType instanceof SourceNode) {
            this.validate(messages, reporter, this.buildASTRoot());
        }
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        this.validateMapping(messages, reporter, astRoot);
        this.validateAttributes(messages, reporter, astRoot);
    }

    protected void validateMapping(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        try {
            this.mapping.validate(messages, reporter, astRoot);
        }
        catch (Throwable t) {
            JptJpaCorePlugin.log(t);
        }
    }

    protected void validateAttributes(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        for (JavaPersistentAttribute attribute : this.getAttributes()) {
            this.validateAttribute(attribute, reporter, messages, astRoot);
        }
    }

    protected void validateAttribute(JavaPersistentAttribute attribute, IReporter reporter, List<IMessage> messages, CompilationUnit astRoot) {
        try {
            attribute.validate(messages, reporter, astRoot);
        }
        catch (Throwable t) {
            JptJpaCorePlugin.log(t);
        }
    }

    @Override
    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        return this.getSelectionTextRange(astRoot);
    }

    @Override
    public TextRange getValidationTextRange() {
        return this.getSelectionTextRange();
    }

    @Override
    public PersistentType.Owner getParent() {
        return (PersistentType.Owner)super.getParent();
    }

    @Override
    public IResource getResource() {
        return this.resourcePersistentType.getFile();
    }

    @Override
    public JavaResourcePersistentType getResourcePersistentType() {
        return this.resourcePersistentType;
    }

    @Override
    public AccessType getOwnerOverrideAccess() {
        return this.getParent().getOverridePersistentTypeAccess();
    }

    @Override
    public AccessType getOwnerDefaultAccess() {
        return this.getParent().getDefaultPersistentTypeAccess();
    }

    protected CompilationUnit buildASTRoot() {
        return this.resourcePersistentType.getJavaResourceCompilationUnit().buildASTRoot();
    }

    protected JpaFile getJpaFile() {
        return this.getJpaFile(this.resourcePersistentType.getFile());
    }

    @Override
    public boolean isFor(String typeName) {
        return Tools.valuesAreEqual((Object)typeName, (Object)this.getName());
    }

    @Override
    public boolean isIn(IPackageFragment packageFragment) {
        return Tools.valuesAreEqual((Object)packageFragment.getElementName(), (Object)this.getPackageName());
    }

    protected String getPackageName() {
        return this.getResourcePersistentType().getPackageName();
    }

    public void toString(StringBuilder sb) {
        sb.append(this.name);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class AttributeContainerAdapter
    implements ContextContainerTools.Adapter<JavaPersistentAttribute, JavaResourcePersistentAttribute> {
        protected AttributeContainerAdapter() {
        }

        @Override
        public Iterable<JavaPersistentAttribute> getContextElements() {
            return AbstractJavaPersistentType.this.getAttributes();
        }

        @Override
        public Iterable<JavaResourcePersistentAttribute> getResourceElements() {
            return AbstractJavaPersistentType.this.getResourceAttributes();
        }

        @Override
        public JavaResourcePersistentAttribute getResourceElement(JavaPersistentAttribute contextElement) {
            return contextElement.getResourcePersistentAttribute();
        }

        @Override
        public void moveContextElement(int index, JavaPersistentAttribute element) {
            AbstractJavaPersistentType.this.moveAttribute(index, element);
        }

        @Override
        public void addContextElement(int index, JavaResourcePersistentAttribute resourceElement) {
            AbstractJavaPersistentType.this.addAttribute(index, resourceElement);
        }

        @Override
        public void removeContextElement(JavaPersistentAttribute element) {
            AbstractJavaPersistentType.this.removeAttribute(element);
        }
    }
}

