/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.resource.java.source;

import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.internal.utility.jdt.AnnotatedElementAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ElementAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.NestedIndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.IndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.Member;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneIterable;
import org.eclipse.jpt.common.utility.internal.iterators.CloneListIterator;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.AnnotationContainerTools;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.SourceUniqueConstraintAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.AnnotationContainer;
import org.eclipse.jpt.jpa.core.resource.java.BaseTableAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.jpa.core.resource.java.NestableUniqueConstraintAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.UniqueConstraintAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SourceBaseTableAnnotation
extends SourceAnnotation<Member>
implements BaseTableAnnotation {
    DeclarationAnnotationElementAdapter<String> nameDeclarationAdapter;
    AnnotationElementAdapter<String> nameAdapter;
    String name;
    DeclarationAnnotationElementAdapter<String> schemaDeclarationAdapter;
    AnnotationElementAdapter<String> schemaAdapter;
    String schema;
    DeclarationAnnotationElementAdapter<String> catalogDeclarationAdapter;
    AnnotationElementAdapter<String> catalogAdapter;
    String catalog;
    final Vector<NestableUniqueConstraintAnnotation> uniqueConstraints = new Vector();
    final UniqueConstraintsAnnotationContainer uniqueConstraintsContainer = new UniqueConstraintsAnnotationContainer();

    protected SourceBaseTableAnnotation(JavaResourceNode parent, Member member, DeclarationAnnotationAdapter daa) {
        this(parent, member, daa, (AnnotationAdapter)new ElementAnnotationAdapter((AnnotatedElement)member, daa));
    }

    protected SourceBaseTableAnnotation(JavaResourceNode parent, Member member, DeclarationAnnotationAdapter daa, AnnotationAdapter annotationAdapter) {
        super(parent, member, daa, annotationAdapter);
        this.nameDeclarationAdapter = this.buildNameDeclarationAdapter();
        this.nameAdapter = this.buildNameAdapter();
        this.schemaDeclarationAdapter = this.buildSchemaDeclarationAdapter();
        this.schemaAdapter = this.buildSchemaAdapter();
        this.catalogDeclarationAdapter = this.buildCatalogDeclarationAdapter();
        this.catalogAdapter = this.buildCatalogAdapter();
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        this.name = this.buildName(astRoot);
        this.schema = this.buildSchema(astRoot);
        this.catalog = this.buildCatalog(astRoot);
        AnnotationContainerTools.initialize(this.uniqueConstraintsContainer, astRoot);
    }

    @Override
    public void synchronizeWith(CompilationUnit astRoot) {
        this.syncName(this.buildName(astRoot));
        this.syncSchema(this.buildSchema(astRoot));
        this.syncCatalog(this.buildCatalog(astRoot));
        AnnotationContainerTools.synchronize(this.uniqueConstraintsContainer, astRoot);
    }

    protected abstract String getUniqueConstraintsElementName();

    @Override
    public boolean isSpecified() {
        return true;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        if (this.attributeValueHasChanged(this.name, name)) {
            this.name = name;
            this.nameAdapter.setValue((Object)name);
        }
    }

    private void syncName(String astName) {
        String old = this.name;
        this.name = astName;
        this.firePropertyChanged("name", old, astName);
    }

    private String buildName(CompilationUnit astRoot) {
        return (String)this.nameAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getNameTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.nameDeclarationAdapter, astRoot);
    }

    @Override
    public boolean nameTouches(int pos, CompilationUnit astRoot) {
        return this.elementTouches(this.nameDeclarationAdapter, pos, astRoot);
    }

    protected abstract DeclarationAnnotationElementAdapter<String> buildNameDeclarationAdapter();

    private AnnotationElementAdapter<String> buildNameAdapter() {
        return this.buildAnnotationElementAdapter(this.nameDeclarationAdapter);
    }

    @Override
    public String getSchema() {
        return this.schema;
    }

    @Override
    public void setSchema(String schema) {
        if (this.attributeValueHasChanged(this.schema, schema)) {
            this.schema = schema;
            this.schemaAdapter.setValue((Object)schema);
        }
    }

    private void syncSchema(String astSchema) {
        String old = this.schema;
        this.schema = astSchema;
        this.firePropertyChanged("schema", old, astSchema);
    }

    private String buildSchema(CompilationUnit astRoot) {
        return (String)this.schemaAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getSchemaTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.schemaDeclarationAdapter, astRoot);
    }

    @Override
    public boolean schemaTouches(int pos, CompilationUnit astRoot) {
        return this.elementTouches(this.schemaDeclarationAdapter, pos, astRoot);
    }

    protected abstract DeclarationAnnotationElementAdapter<String> buildSchemaDeclarationAdapter();

    private AnnotationElementAdapter<String> buildSchemaAdapter() {
        return this.buildAnnotationElementAdapter(this.schemaDeclarationAdapter);
    }

    @Override
    public String getCatalog() {
        return this.catalog;
    }

    @Override
    public void setCatalog(String catalog) {
        if (this.attributeValueHasChanged(this.catalog, catalog)) {
            this.catalog = catalog;
            this.catalogAdapter.setValue((Object)catalog);
        }
    }

    private void syncCatalog(String astCatalog) {
        String old = this.catalog;
        this.catalog = astCatalog;
        this.firePropertyChanged("catalog", old, astCatalog);
    }

    private String buildCatalog(CompilationUnit astRoot) {
        return (String)this.catalogAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getCatalogTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.catalogDeclarationAdapter, astRoot);
    }

    @Override
    public boolean catalogTouches(int pos, CompilationUnit astRoot) {
        return this.elementTouches(this.catalogDeclarationAdapter, pos, astRoot);
    }

    protected abstract DeclarationAnnotationElementAdapter<String> buildCatalogDeclarationAdapter();

    private AnnotationElementAdapter<String> buildCatalogAdapter() {
        return this.buildAnnotationElementAdapter(this.catalogDeclarationAdapter);
    }

    @Override
    public ListIterator<UniqueConstraintAnnotation> uniqueConstraints() {
        return new CloneListIterator(this.uniqueConstraints);
    }

    Iterable<NestableUniqueConstraintAnnotation> getNestableUniqueConstraints() {
        return new LiveCloneIterable(this.uniqueConstraints);
    }

    @Override
    public int uniqueConstraintsSize() {
        return this.uniqueConstraints.size();
    }

    @Override
    public NestableUniqueConstraintAnnotation uniqueConstraintAt(int index) {
        return this.uniqueConstraints.get(index);
    }

    @Override
    public int indexOfUniqueConstraint(UniqueConstraintAnnotation uniqueConstraint) {
        return this.uniqueConstraints.indexOf(uniqueConstraint);
    }

    private NestableUniqueConstraintAnnotation addUniqueConstraint() {
        return this.addUniqueConstraint(this.uniqueConstraints.size());
    }

    @Override
    public NestableUniqueConstraintAnnotation addUniqueConstraint(int index) {
        return (NestableUniqueConstraintAnnotation)AnnotationContainerTools.addNestedAnnotation(index, this.uniqueConstraintsContainer);
    }

    NestableUniqueConstraintAnnotation addUniqueConstraint_() {
        return this.addUniqueConstraint_(this.uniqueConstraints.size());
    }

    private NestableUniqueConstraintAnnotation addUniqueConstraint_(int index) {
        NestableUniqueConstraintAnnotation uniqueConstraint = this.buildUniqueConstraint(index);
        this.uniqueConstraints.add(index, uniqueConstraint);
        return uniqueConstraint;
    }

    void syncAddUniqueConstraint(Annotation astAnnotation) {
        int index = this.uniqueConstraints.size();
        NestableUniqueConstraintAnnotation uniqueConstraint = this.addUniqueConstraint_(index);
        uniqueConstraint.initialize((CompilationUnit)astAnnotation.getRoot());
        this.fireItemAdded("uniqueConstraints", index, uniqueConstraint);
    }

    NestableUniqueConstraintAnnotation buildUniqueConstraint(int index) {
        return new SourceUniqueConstraintAnnotation((JavaResourceNode)this, (Member)this.annotatedElement, this.buildUniqueConstraintAnnotationAdapter(index));
    }

    IndexedDeclarationAnnotationAdapter buildUniqueConstraintAnnotationAdapter(int index) {
        return new NestedIndexedDeclarationAnnotationAdapter(this.daa, this.getUniqueConstraintsElementName(), index, "javax.persistence.UniqueConstraint");
    }

    void uniqueConstraintAdded(int index, NestableUniqueConstraintAnnotation constraint) {
        this.fireItemAdded("uniqueConstraints", index, constraint);
    }

    @Override
    public void moveUniqueConstraint(int targetIndex, int sourceIndex) {
        AnnotationContainerTools.moveNestedAnnotation(targetIndex, sourceIndex, this.uniqueConstraintsContainer);
    }

    NestableUniqueConstraintAnnotation moveUniqueConstraint_(int targetIndex, int sourceIndex) {
        return (NestableUniqueConstraintAnnotation)CollectionTools.move(this.uniqueConstraints, (int)targetIndex, (int)sourceIndex).get(targetIndex);
    }

    @Override
    public void removeUniqueConstraint(int index) {
        AnnotationContainerTools.removeNestedAnnotation(index, this.uniqueConstraintsContainer);
    }

    NestableUniqueConstraintAnnotation removeUniqueConstraint_(int index) {
        return this.uniqueConstraints.remove(index);
    }

    void syncRemoveUniqueConstraints(int index) {
        this.removeItemsFromList(index, this.uniqueConstraints, "uniqueConstraints");
    }

    @Override
    public boolean isUnset() {
        return super.isUnset() && this.name == null && this.schema == null && this.catalog == null && this.uniqueConstraints.isEmpty();
    }

    @Override
    protected void rebuildAdapters() {
        super.rebuildAdapters();
        this.nameDeclarationAdapter = this.buildNameDeclarationAdapter();
        this.nameAdapter = this.buildNameAdapter();
        this.schemaDeclarationAdapter = this.buildSchemaDeclarationAdapter();
        this.schemaAdapter = this.buildSchemaAdapter();
        this.catalogDeclarationAdapter = this.buildCatalogDeclarationAdapter();
        this.catalogAdapter = this.buildCatalogAdapter();
    }

    @Override
    public void storeOn(Map<String, Object> map) {
        super.storeOn(map);
        map.put("name", this.name);
        this.name = null;
        map.put("schema", this.schema);
        this.schema = null;
        map.put("catalog", this.catalog);
        this.catalog = null;
        List<Map<String, Object>> constraintsState = this.buildStateList(this.uniqueConstraints.size());
        for (NestableUniqueConstraintAnnotation constraint : this.getNestableUniqueConstraints()) {
            HashMap<String, Object> constraintState = new HashMap<String, Object>();
            constraint.storeOn(constraintState);
            constraintsState.add(constraintState);
        }
        map.put("uniqueConstraints", constraintsState);
        this.uniqueConstraints.clear();
    }

    @Override
    public void restoreFrom(Map<String, Object> map) {
        super.restoreFrom(map);
        this.setName((String)map.get("name"));
        this.setSchema((String)map.get("schema"));
        this.setCatalog((String)map.get("catalog"));
        List constraintsState = (List)map.get("uniqueConstraints");
        for (Map constraintState : constraintsState) {
            this.addUniqueConstraint().restoreFrom(constraintState);
        }
    }

    private AnnotationElementAdapter<String> buildAnnotationElementAdapter(DeclarationAnnotationElementAdapter<String> daea) {
        return new AnnotatedElementAnnotationElementAdapter(this.annotatedElement, daea);
    }

    public void toString(StringBuilder sb) {
        sb.append(this.name);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class UniqueConstraintsAnnotationContainer
    implements AnnotationContainer<NestableUniqueConstraintAnnotation> {
        UniqueConstraintsAnnotationContainer() {
        }

        @Override
        public Annotation getAstAnnotation(CompilationUnit astRoot) {
            return SourceBaseTableAnnotation.this.getAstAnnotation(astRoot);
        }

        @Override
        public String getElementName() {
            return SourceBaseTableAnnotation.this.getUniqueConstraintsElementName();
        }

        @Override
        public String getNestedAnnotationName() {
            return "javax.persistence.UniqueConstraint";
        }

        @Override
        public Iterable<NestableUniqueConstraintAnnotation> getNestedAnnotations() {
            return SourceBaseTableAnnotation.this.getNestableUniqueConstraints();
        }

        @Override
        public int getNestedAnnotationsSize() {
            return SourceBaseTableAnnotation.this.uniqueConstraintsSize();
        }

        @Override
        public NestableUniqueConstraintAnnotation addNestedAnnotation() {
            return SourceBaseTableAnnotation.this.addUniqueConstraint_();
        }

        @Override
        public void syncAddNestedAnnotation(Annotation astAnnotation) {
            SourceBaseTableAnnotation.this.syncAddUniqueConstraint(astAnnotation);
        }

        @Override
        public NestableUniqueConstraintAnnotation moveNestedAnnotation(int targetIndex, int sourceIndex) {
            return SourceBaseTableAnnotation.this.moveUniqueConstraint_(targetIndex, sourceIndex);
        }

        @Override
        public NestableUniqueConstraintAnnotation removeNestedAnnotation(int index) {
            return SourceBaseTableAnnotation.this.removeUniqueConstraint_(index);
        }

        @Override
        public void syncRemoveNestedAnnotations(int index) {
            SourceBaseTableAnnotation.this.syncRemoveUniqueConstraints(index);
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this);
        }
    }
}

