/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTRequestor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.dom.ASTBatchParser;
import org.eclipse.jdt.internal.corext.fix.CleanUpPreferenceUtil;
import org.eclipse.jdt.internal.corext.fix.FixMessages;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationStateChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.MultiStateCompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.refactoring.util.TextEditUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.fix.IMultiFix;
import org.eclipse.jdt.internal.ui.fix.MapCleanUpOptions;
import org.eclipse.jdt.internal.ui.refactoring.IScheduledRefactoring;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.cleanup.CleanUpContext;
import org.eclipse.jdt.ui.cleanup.ICleanUp;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.CategorizedTextEditGroup;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.ContentStamp;
import org.eclipse.ltk.core.refactoring.GroupCategory;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringTickProvider;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextEditBasedChangeGroup;
import org.eclipse.swt.widgets.Display;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.text.edits.UndoEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CleanUpRefactoring
extends Refactoring
implements IScheduledRefactoring {
    private static final RefactoringTickProvider CLEAN_UP_REFACTORING_TICK_PROVIDER = new RefactoringTickProvider(0, 1, 0, 0);
    private static final int SLOW_CLEAN_UP_THRESHOLD = 2000;
    private final List<ICleanUp> fCleanUps;
    private final Hashtable<IJavaProject, List<CleanUpTarget>> fProjects;
    private Change fChange;
    private boolean fLeaveFilesDirty;
    private final String fName;
    private boolean fUseOptionsFromProfile;

    public CleanUpRefactoring() {
        this(FixMessages.CleanUpRefactoring_Refactoring_name);
    }

    public CleanUpRefactoring(String name) {
        this.fName = name;
        this.fCleanUps = new ArrayList<ICleanUp>();
        this.fProjects = new Hashtable();
        this.fUseOptionsFromProfile = false;
    }

    public void setUseOptionsFromProfile(boolean enabled) {
        this.fUseOptionsFromProfile = enabled;
    }

    public void addCompilationUnit(ICompilationUnit unit) {
        this.addCleanUpTarget(new CleanUpTarget(unit));
    }

    public void addCleanUpTarget(CleanUpTarget target) {
        IJavaProject javaProject = target.getCompilationUnit().getJavaProject();
        if (!this.fProjects.containsKey(javaProject)) {
            this.fProjects.put(javaProject, new ArrayList());
        }
        List<CleanUpTarget> targets = this.fProjects.get(javaProject);
        targets.add(target);
    }

    public CleanUpTarget[] getCleanUpTargets() {
        ArrayList<CleanUpTarget> result = new ArrayList<CleanUpTarget>();
        for (List<CleanUpTarget> projectTargets : this.fProjects.values()) {
            result.addAll(projectTargets);
        }
        return result.toArray(new CleanUpTarget[result.size()]);
    }

    public int getCleanUpTargetsSize() {
        int result = 0;
        for (List<CleanUpTarget> projectTargets : this.fProjects.values()) {
            result += projectTargets.size();
        }
        return result;
    }

    public void addCleanUp(ICleanUp fix) {
        this.fCleanUps.add(fix);
    }

    public void clearCleanUps() {
        this.fCleanUps.clear();
    }

    public boolean hasCleanUps() {
        return !this.fCleanUps.isEmpty();
    }

    public ICleanUp[] getCleanUps() {
        return this.fCleanUps.toArray(new ICleanUp[this.fCleanUps.size()]);
    }

    public IJavaProject[] getProjects() {
        return this.fProjects.keySet().toArray(new IJavaProject[this.fProjects.keySet().size()]);
    }

    public void setLeaveFilesDirty(boolean leaveFilesDirty) {
        this.fLeaveFilesDirty = leaveFilesDirty;
    }

    public String getName() {
        return this.fName;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (pm != null) {
            pm.beginTask("", 1);
            pm.worked(1);
            pm.done();
        }
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (pm != null) {
            pm.beginTask("", 1);
            pm.worked(1);
            pm.done();
        }
        return this.fChange;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (pm == null) {
            pm = new NullProgressMonitor();
        }
        if (this.fProjects.size() == 0 || this.fCleanUps.size() == 0) {
            pm.beginTask("", 1);
            pm.worked(1);
            pm.done();
            this.fChange = new NullChange();
            return new RefactoringStatus();
        }
        int cuCount = this.getCleanUpTargetsSize();
        RefactoringStatus result = new RefactoringStatus();
        ICleanUp[] cleanUps = this.getCleanUps();
        pm.beginTask("", cuCount * 2 * this.fCleanUps.size() + 4 * cleanUps.length);
        try {
            DynamicValidationStateChange change = new DynamicValidationStateChange(this.getName());
            change.setSchedulingRule(this.getSchedulingRule());
            for (Map.Entry<IJavaProject, List<CleanUpTarget>> entry : this.fProjects.entrySet()) {
                IJavaProject project = entry.getKey();
                List<CleanUpTarget> targetsList = entry.getValue();
                CleanUpTarget[] targets = targetsList.toArray(new CleanUpTarget[targetsList.size()]);
                if (this.fUseOptionsFromProfile) {
                    result.merge(this.setOptionsFromProfile(project, cleanUps));
                    if (result.hasFatalError()) {
                        RefactoringStatus refactoringStatus = result;
                        return refactoringStatus;
                    }
                }
                result.merge(this.checkPreConditions(project, targets, (IProgressMonitor)new SubProgressMonitor(pm, 3 * cleanUps.length)));
                if (result.hasFatalError()) {
                    RefactoringStatus refactoringStatus = result;
                    return refactoringStatus;
                }
                Change[] changes = this.cleanUpProject(project, targets, cleanUps, pm);
                result.merge(this.checkPostConditions(new SubProgressMonitor(pm, cleanUps.length)));
                if (result.hasFatalError()) {
                    RefactoringStatus refactoringStatus = result;
                    return refactoringStatus;
                }
                int i = 0;
                while (i < changes.length) {
                    change.add(changes[i]);
                    ++i;
                }
            }
            this.fChange = change;
            ArrayList<IResource> files = new ArrayList<IResource>();
            this.findFilesToBeModified(change, files);
            result.merge(Checks.validateModifiesFiles(files.toArray(new IFile[files.size()]), this.getValidationContext()));
        }
        finally {
            pm.done();
        }
        return result;
    }

    private void findFilesToBeModified(CompositeChange change, List<IResource> result) throws JavaModelException {
        Change[] children = change.getChildren();
        int i = 0;
        while (i < children.length) {
            Change child = children[i];
            if (child instanceof CompositeChange) {
                this.findFilesToBeModified((CompositeChange)child, result);
            } else if (child instanceof MultiStateCompilationUnitChange) {
                result.add(((MultiStateCompilationUnitChange)child).getCompilationUnit().getCorrespondingResource());
            } else if (child instanceof CompilationUnitChange) {
                result.add(((CompilationUnitChange)child).getCompilationUnit().getCorrespondingResource());
            }
            ++i;
        }
    }

    private Change[] cleanUpProject(IJavaProject project, CleanUpTarget[] targets, ICleanUp[] cleanUps, IProgressMonitor monitor) throws CoreException {
        CleanUpFixpointIterator iter = new CleanUpFixpointIterator(targets, cleanUps);
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 2 * targets.length * cleanUps.length);
        subMonitor.beginTask("", targets.length);
        subMonitor.subTask(Messages.format(FixMessages.CleanUpRefactoring_Parser_Startup_message, BasicElementLabels.getResourceName((IResource)project.getProject())));
        try {
            while (iter.hasNext()) {
                iter.next((IProgressMonitor)subMonitor);
            }
            Change[] changeArray = iter.getResult();
            return changeArray;
        }
        finally {
            iter.dispose();
            subMonitor.done();
        }
    }

    private RefactoringStatus setOptionsFromProfile(IJavaProject javaProject, ICleanUp[] cleanUps) {
        Map<String, String> options = CleanUpPreferenceUtil.loadOptions((IScopeContext)new ProjectScope(javaProject.getProject()));
        if (options == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(FixMessages.CleanUpRefactoring_could_not_retrive_profile, BasicElementLabels.getResourceName((IResource)javaProject.getProject())));
        }
        MapCleanUpOptions cleanUpOptions = new MapCleanUpOptions(options);
        int i = 0;
        while (i < cleanUps.length) {
            cleanUps[i].setOptions(cleanUpOptions);
            ++i;
        }
        return new RefactoringStatus();
    }

    private RefactoringStatus checkPreConditions(IJavaProject javaProject, CleanUpTarget[] targets, IProgressMonitor monitor) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        ICompilationUnit[] compilationUnits = new ICompilationUnit[targets.length];
        int i = 0;
        while (i < targets.length) {
            compilationUnits[i] = targets[i].getCompilationUnit();
            ++i;
        }
        ICleanUp[] cleanUps = this.getCleanUps();
        monitor.beginTask("", compilationUnits.length * cleanUps.length);
        monitor.subTask(Messages.format(FixMessages.CleanUpRefactoring_Initialize_message, BasicElementLabels.getResourceName((IResource)javaProject.getProject())));
        try {
            int j = 0;
            while (j < cleanUps.length) {
                result.merge(cleanUps[j].checkPreConditions(javaProject, compilationUnits, (IProgressMonitor)new SubProgressMonitor(monitor, compilationUnits.length)));
                if (result.hasFatalError()) {
                    RefactoringStatus refactoringStatus = result;
                    return refactoringStatus;
                }
                ++j;
            }
        }
        finally {
            monitor.done();
        }
        return result;
    }

    private RefactoringStatus checkPostConditions(SubProgressMonitor monitor) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        ICleanUp[] cleanUps = this.getCleanUps();
        monitor.beginTask("", cleanUps.length);
        monitor.subTask(FixMessages.CleanUpRefactoring_checkingPostConditions_message);
        try {
            int j = 0;
            while (j < cleanUps.length) {
                result.merge(cleanUps[j].checkPostConditions((IProgressMonitor)new SubProgressMonitor((IProgressMonitor)monitor, 1)));
                ++j;
            }
        }
        finally {
            monitor.done();
        }
        return result;
    }

    private static String getChangeName(ICompilationUnit compilationUnit) {
        StringBuffer buf = new StringBuffer();
        JavaElementLabels.getCompilationUnitLabel(compilationUnit, JavaElementLabels.ALL_DEFAULT, buf);
        buf.append(JavaElementLabels.CONCAT_STRING);
        StringBuffer buf2 = new StringBuffer();
        JavaElementLabels.getPackageFragmentLabel((IPackageFragment)compilationUnit.getParent(), 0x800000000L, buf2);
        buf.append(buf2.toString().replace('.', '/'));
        return buf.toString();
    }

    public static CleanUpChange calculateChange(CleanUpContext context, ICleanUp[] cleanUps, List<ICleanUp> undoneCleanUps, HashSet<ICleanUp> slowCleanUps) throws CoreException {
        if (cleanUps.length == 0) {
            return null;
        }
        CleanUpChange solution = null;
        int i = 0;
        do {
            ICleanUpFix fix;
            ICleanUp cleanUp = cleanUps[i];
            if (slowCleanUps != null) {
                long timeBefore = System.currentTimeMillis();
                fix = cleanUp.createFix(context);
                if (System.currentTimeMillis() - timeBefore > 2000L) {
                    slowCleanUps.add(cleanUp);
                }
            } else {
                fix = cleanUp.createFix(context);
            }
            if (fix == null) continue;
            CompilationUnitChange current = fix.createChange(null);
            TextEdit currentEdit = current.getEdit();
            if (solution != null) {
                if (TextEditUtil.overlaps(currentEdit, solution.getEdit())) {
                    undoneCleanUps.add(cleanUp);
                    continue;
                }
                CleanUpChange merge = new CleanUpChange(FixMessages.CleanUpRefactoring_clean_up_multi_chang_name, context.getCompilationUnit());
                merge.setEdit(TextEditUtil.merge(currentEdit, solution.getEdit()));
                CleanUpRefactoring.copyChangeGroups(merge, solution);
                CleanUpRefactoring.copyChangeGroups(merge, current);
                solution = merge;
                continue;
            }
            solution = new CleanUpChange(current.getName(), context.getCompilationUnit());
            solution.setEdit(currentEdit);
            CleanUpRefactoring.copyChangeGroups(solution, current);
        } while (++i < cleanUps.length && (context.getAST() == null || !cleanUps[i].getRequirements().requiresFreshAST()));
        while (i < cleanUps.length) {
            undoneCleanUps.add(cleanUps[i]);
            ++i;
        }
        return solution;
    }

    private static void copyChangeGroups(CompilationUnitChange target, CompilationUnitChange source) {
        TextEditBasedChangeGroup[] changeGroups = source.getChangeGroups();
        int i = 0;
        while (i < changeGroups.length) {
            TextEditGroup newGroup;
            TextEditGroup textEditGroup = changeGroups[i].getTextEditGroup();
            if (textEditGroup instanceof CategorizedTextEditGroup) {
                String label = textEditGroup.getName();
                newGroup = new CategorizedTextEditGroup(label, new GroupCategorySet(new GroupCategory(label, label, label)));
            } else {
                newGroup = new TextEditGroup(textEditGroup.getName());
            }
            TextEdit[] textEdits = textEditGroup.getTextEdits();
            int j = 0;
            while (j < textEdits.length) {
                newGroup.addTextEdit(textEdits[j]);
                ++j;
            }
            target.addTextEditGroup(newGroup);
            ++i;
        }
    }

    protected RefactoringTickProvider doGetRefactoringTickProvider() {
        return CLEAN_UP_REFACTORING_TICK_PROVIDER;
    }

    @Override
    public ISchedulingRule getSchedulingRule() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public static ASTParser createCleanUpASTParser() {
        ASTParser result = ASTParser.newParser((int)3);
        result.setResolveBindings(true);
        result.setStatementsRecovery(true);
        result.setBindingsRecovery(true);
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CleanUpASTRequestor
    extends ASTRequestor {
        private final List<ParseListElement> fUndoneElements;
        private final Hashtable<ICompilationUnit, List<CleanUpChange>> fSolutions;
        private final Hashtable<ICompilationUnit, ParseListElement> fCompilationUnitParseElementMap;
        private final CleanUpRefactoringProgressMonitor fMonitor;

        public CleanUpASTRequestor(List<ParseListElement> parseList, Hashtable<ICompilationUnit, List<CleanUpChange>> solutions, CleanUpRefactoringProgressMonitor monitor) {
            this.fSolutions = solutions;
            this.fMonitor = monitor;
            this.fUndoneElements = new ArrayList<ParseListElement>();
            this.fCompilationUnitParseElementMap = new Hashtable(parseList.size());
            for (ParseListElement element : parseList) {
                this.fCompilationUnitParseElementMap.put(element.getTarget().getCompilationUnit(), element);
            }
        }

        public void acceptAST(ICompilationUnit source, CompilationUnit ast) {
            this.fMonitor.subTask(this.fMonitor.getSubTaskMessage(source));
            ICompilationUnit primary = (ICompilationUnit)source.getPrimaryElement();
            ParseListElement element = this.fCompilationUnitParseElementMap.get(primary);
            CleanUpTarget target = element.getTarget();
            CleanUpContext context = target instanceof MultiFixTarget ? new IMultiFix.MultiFixContext(source, ast, ((MultiFixTarget)target).getProblems()) : new CleanUpContext(source, ast);
            ICleanUp[] rejectedCleanUps = this.calculateSolutions(context, element.getCleanUps());
            if (rejectedCleanUps.length > 0) {
                this.fUndoneElements.add(new ParseListElement(target, rejectedCleanUps));
                this.fMonitor.reset();
            } else {
                this.fMonitor.flush();
            }
        }

        public void acceptSource(ICompilationUnit source) {
            this.acceptAST(source, null);
        }

        public List<ParseListElement> getUndoneElements() {
            return this.fUndoneElements;
        }

        private ICleanUp[] calculateSolutions(CleanUpContext context, ICleanUp[] cleanUps) {
            CleanUpChange solution;
            ArrayList<ICleanUp> result = new ArrayList<ICleanUp>();
            try {
                solution = CleanUpRefactoring.calculateChange(context, cleanUps, result, null);
            }
            catch (CoreException e) {
                throw new FixCalculationException(e);
            }
            if (solution != null) {
                this.integrateSolution(solution, context.getCompilationUnit());
            }
            return result.toArray(new ICleanUp[result.size()]);
        }

        private void integrateSolution(CleanUpChange solution, ICompilationUnit source) {
            ICompilationUnit primary = source.getPrimary();
            List<CleanUpChange> changes = this.fSolutions.get(primary);
            if (changes == null) {
                changes = new ArrayList<CleanUpChange>();
                this.fSolutions.put(primary, changes);
            }
            changes.add(solution);
        }
    }

    public static class CleanUpChange
    extends CompilationUnitChange {
        private UndoEdit fUndoEdit;

        public CleanUpChange(String name, ICompilationUnit cunit) {
            super(name, cunit);
        }

        protected Change createUndoChange(UndoEdit edit, ContentStamp stampToRestore) {
            this.fUndoEdit = edit;
            return super.createUndoChange(edit, stampToRestore);
        }

        public UndoEdit getUndoEdit() {
            return this.fUndoEdit;
        }

        public Change perform(final IProgressMonitor pm) throws CoreException {
            if (Display.getCurrent() == null) {
                final Change[] result = new Change[1];
                final CoreException[] exs = new CoreException[1];
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        try {
                            result[0] = CleanUpChange.super.perform(pm);
                        }
                        catch (CoreException e) {
                            exs[0] = e;
                        }
                    }
                });
                if (exs[0] != null) {
                    throw exs[0];
                }
                return result[0];
            }
            return super.perform(pm);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CleanUpFixpointIterator {
        private List<ParseListElement> fParseList;
        private final Hashtable<ICompilationUnit, List<CleanUpChange>> fSolutions;
        private final Hashtable<ICompilationUnit, ICompilationUnit> fWorkingCopies;
        private final Map<String, String> fCleanUpOptions;
        private final int fSize;
        private int fIndex;

        public CleanUpFixpointIterator(CleanUpTarget[] targets, ICleanUp[] cleanUps) {
            this.fSolutions = new Hashtable(targets.length);
            this.fWorkingCopies = new Hashtable();
            this.fParseList = new ArrayList<ParseListElement>(targets.length);
            int i = 0;
            while (i < targets.length) {
                this.fParseList.add(new ParseListElement(targets[i], cleanUps));
                ++i;
            }
            this.fCleanUpOptions = new Hashtable<String, String>();
            i = 0;
            while (i < cleanUps.length) {
                ICleanUp cleanUp = cleanUps[i];
                Map<String, String> currentCleanUpOption = cleanUp.getRequirements().getCompilerOptions();
                if (currentCleanUpOption != null) {
                    this.fCleanUpOptions.putAll(currentCleanUpOption);
                }
                ++i;
            }
            this.fSize = targets.length;
            this.fIndex = 1;
        }

        public boolean hasNext() {
            return !this.fParseList.isEmpty();
        }

        public void next(IProgressMonitor monitor) throws CoreException {
            ArrayList<ICompilationUnit> parseList = new ArrayList<ICompilationUnit>();
            ArrayList<ICompilationUnit> sourceList = new ArrayList<ICompilationUnit>();
            for (ParseListElement element : this.fParseList) {
                ICompilationUnit compilationUnit = element.getTarget().getCompilationUnit();
                if (this.fSolutions.containsKey(compilationUnit)) {
                    if (this.fWorkingCopies.containsKey(compilationUnit)) {
                        compilationUnit = this.fWorkingCopies.get(compilationUnit);
                    } else {
                        compilationUnit = compilationUnit.getWorkingCopy(new WorkingCopyOwner(){}, null);
                        this.fWorkingCopies.put(compilationUnit.getPrimary(), compilationUnit);
                    }
                    this.applyChange(compilationUnit, this.fSolutions.get(compilationUnit.getPrimary()));
                }
                if (this.requiresAST(element.getCleanUps())) {
                    parseList.add(compilationUnit);
                    continue;
                }
                sourceList.add(compilationUnit);
            }
            CleanUpRefactoringProgressMonitor cuMonitor = new CleanUpRefactoringProgressMonitor(monitor, parseList.size() + sourceList.size(), this.fSize, this.fIndex);
            CleanUpASTRequestor requestor = new CleanUpASTRequestor(this.fParseList, this.fSolutions, cuMonitor);
            if (parseList.size() > 0) {
                ASTBatchParser parser = new ASTBatchParser(){

                    protected ASTParser createParser(IJavaProject project) {
                        ASTParser result = CleanUpRefactoring.createCleanUpASTParser();
                        result.setProject(project);
                        Map<String, String> options = RefactoringASTParser.getCompilerOptions((IJavaElement)project);
                        options.putAll(CleanUpFixpointIterator.this.fCleanUpOptions);
                        result.setCompilerOptions(options);
                        return result;
                    }
                };
                try {
                    ICompilationUnit[] units = parseList.toArray(new ICompilationUnit[parseList.size()]);
                    parser.createASTs(units, new String[0], requestor, (IProgressMonitor)cuMonitor);
                }
                catch (FixCalculationException e) {
                    throw e.getException();
                }
            }
            for (ICompilationUnit cu : sourceList) {
                monitor.worked(1);
                requestor.acceptSource(cu);
                if (!monitor.isCanceled()) continue;
                throw new OperationCanceledException();
            }
            this.fParseList = requestor.getUndoneElements();
            this.fIndex = cuMonitor.getIndex();
        }

        public void dispose() {
            for (ICompilationUnit cu : this.fWorkingCopies.values()) {
                try {
                    cu.discardWorkingCopy();
                }
                catch (JavaModelException e) {
                    JavaPlugin.log(e);
                }
            }
            this.fWorkingCopies.clear();
        }

        private boolean requiresAST(ICleanUp[] cleanUps) {
            int i = 0;
            while (i < cleanUps.length) {
                if (cleanUps[i].getRequirements().requiresAST()) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public Change[] getResult() {
            Change[] result = new Change[this.fSolutions.size()];
            int i = 0;
            for (Map.Entry<ICompilationUnit, List<CleanUpChange>> entry : this.fSolutions.entrySet()) {
                List<CleanUpChange> changes = entry.getValue();
                ICompilationUnit unit = entry.getKey();
                int saveMode = CleanUpRefactoring.this.fLeaveFilesDirty ? 4 : 1;
                if (changes.size() == 1) {
                    CleanUpChange change = changes.get(0);
                    change.setSaveMode(saveMode);
                    result[i] = change;
                } else {
                    MultiStateCompilationUnitChange mscuc = new MultiStateCompilationUnitChange(CleanUpRefactoring.getChangeName(unit), unit);
                    int j = 0;
                    while (j < changes.size()) {
                        mscuc.addChange(this.createGroupFreeChange(changes.get(j)));
                        ++j;
                    }
                    mscuc.setSaveMode(saveMode);
                    result[i] = mscuc;
                }
                ++i;
            }
            return result;
        }

        private TextChange createGroupFreeChange(CleanUpChange change) {
            CleanUpChange result = new CleanUpChange(change.getName(), change.getCompilationUnit());
            result.setEdit(change.getEdit());
            result.setSaveMode(change.getSaveMode());
            return result;
        }

        private void applyChange(ICompilationUnit compilationUnit, List<CleanUpChange> changes) throws JavaModelException, CoreException {
            Document document = new Document(changes.get(0).getCurrentContent((IProgressMonitor)new NullProgressMonitor()));
            int i = 0;
            while (i < changes.size()) {
                CleanUpChange change = changes.get(i);
                TextEdit edit = change.getEdit().copy();
                try {
                    edit.apply((IDocument)document, 2);
                }
                catch (MalformedTreeException e) {
                    JavaPlugin.log(e);
                }
                catch (BadLocationException e) {
                    JavaPlugin.log(e);
                }
                ++i;
            }
            compilationUnit.getBuffer().setContents(document.get());
        }
    }

    private final class CleanUpRefactoringProgressMonitor
    extends SubProgressMonitor {
        private double fRealWork;
        private int fFlushCount;
        private final int fSize;
        private final int fIndex;

        private CleanUpRefactoringProgressMonitor(IProgressMonitor monitor, int ticks, int size, int index) {
            super(monitor, ticks);
            this.fFlushCount = 0;
            this.fSize = size;
            this.fIndex = index;
        }

        public void internalWorked(double work) {
            this.fRealWork += work;
        }

        public void flush() {
            super.internalWorked(this.fRealWork);
            this.reset();
            ++this.fFlushCount;
        }

        public void reset() {
            this.fRealWork = 0.0;
        }

        public void done() {
        }

        public int getIndex() {
            return this.fIndex + this.fFlushCount;
        }

        public String getSubTaskMessage(ICompilationUnit source) {
            String typeName = BasicElementLabels.getFileName((ITypeRoot)source);
            return Messages.format(FixMessages.CleanUpRefactoring_ProcessingCompilationUnit_message, new Object[]{new Integer(this.getIndex()), new Integer(this.fSize), typeName});
        }
    }

    public static class CleanUpTarget {
        private final ICompilationUnit fCompilationUnit;

        public CleanUpTarget(ICompilationUnit unit) {
            this.fCompilationUnit = unit;
        }

        public ICompilationUnit getCompilationUnit() {
            return this.fCompilationUnit;
        }
    }

    private static class FixCalculationException
    extends RuntimeException {
        private static final long serialVersionUID = 3807273310144726165L;
        private final CoreException fException;

        public FixCalculationException(CoreException exception) {
            this.fException = exception;
        }

        public CoreException getException() {
            return this.fException;
        }
    }

    public static class MultiFixTarget
    extends CleanUpTarget {
        private final IProblemLocation[] fProblems;

        public MultiFixTarget(ICompilationUnit unit, IProblemLocation[] problems) {
            super(unit);
            this.fProblems = problems;
        }

        public IProblemLocation[] getProblems() {
            return this.fProblems;
        }
    }

    private static class ParseListElement {
        private final CleanUpTarget fTarget;
        private final ICleanUp[] fCleanUpsArray;

        public ParseListElement(CleanUpTarget cleanUpTarget, ICleanUp[] cleanUps) {
            this.fTarget = cleanUpTarget;
            this.fCleanUpsArray = cleanUps;
        }

        public CleanUpTarget getTarget() {
            return this.fTarget;
        }

        public ICleanUp[] getCleanUps() {
            return this.fCleanUpsArray;
        }
    }
}

