/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor.xerces;

import com.objfac.xml.DefaultLocatorInfo;
import com.objfac.xml.ErrorCallback;
import com.objfac.xml.LocatorInfo;
import com.objfac.xmleditor.resources.ResourceWatcherCallback;
import com.objfac.xmleditor.validate.XercesValidator;
import com.objfac.xmleditor.xerces.CacheEntityResolver;
import com.objfac.xmleditor.xerces.SAXParseBundle;
import java.io.IOException;
import java.io.Reader;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class DTDValidator
implements XercesValidator {
    private boolean fFatal;

    public void validateSchema(Reader reader, ErrorCallback errorCallback, String string, String string2, String string3, String string4, ResourceWatcherCallback resourceWatcherCallback) {
    }

    public void validate(Reader reader, ErrorCallback errorCallback, String string, String string2, String string3, String string4, String string5, boolean bl, ResourceWatcherCallback resourceWatcherCallback) {
        boolean bl2 = bl;
        boolean bl3 = string5 != null || bl || string != null || string2 != null;
        boolean bl4 = bl;
        boolean bl5 = bl;
        String string6 = "noparser";
        try {
            XMLReader xMLReader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            XercesErrorHandler xercesErrorHandler = new XercesErrorHandler(errorCallback);
            xMLReader.setErrorHandler(xercesErrorHandler);
            xMLReader.setEntityResolver(new CacheEntityResolver(resourceWatcherCallback));
            xMLReader.setFeature("http://xml.org/sax/features/namespaces", bl2);
            xMLReader.setFeature("http://xml.org/sax/features/validation", bl3);
            xMLReader.setFeature("http://apache.org/xml/features/validation/schema", bl4);
            xMLReader.setFeature("http://apache.org/xml/features/validation/schema-full-checking", bl5);
            xMLReader.setFeature("http://apache.org/xml/features/continue-after-fatal-error", false);
            string6 = "parsefailed";
            this.fFatal = false;
            InputSource inputSource = new InputSource(reader);
            inputSource.setSystemId(string3);
            inputSource.setEncoding(string4);
            xMLReader.parse(inputSource);
        }
        catch (SAXParseException sAXParseException) {
            this.initError(null, null, string6, sAXParseException, errorCallback);
            return;
        }
        catch (SAXException sAXException) {
            System.out.println("Could not check document because " + sAXException.getMessage());
        }
        catch (IOException iOException) {
            this.initError(null, null, string6, iOException, errorCallback);
            return;
        }
        catch (RuntimeException runtimeException) {
            this.initError(null, null, string6, runtimeException, errorCallback);
            return;
        }
    }

    public void validate(Reader reader, ErrorCallback errorCallback, ResourceWatcherCallback resourceWatcherCallback) {
    }

    private void initError(String string, String string2, String string3, Throwable throwable, ErrorCallback errorCallback) {
        if (!this.fFatal) {
            DefaultLocatorInfo defaultLocatorInfo = new DefaultLocatorInfo(string, string2, 1, 0);
            errorCallback.error(0, this.format(string3, throwable), (LocatorInfo)defaultLocatorInfo);
        }
    }

    private String format(String string, Throwable throwable) {
        ResourceBundle resourceBundle = SAXParseBundle.bundle();
        String string2 = resourceBundle.getString(string);
        String string3 = throwable.getMessage();
        if (string3 == null) {
            string3 = throwable.toString();
        }
        return MessageFormat.format(resourceBundle.getString("format"), string2, string3);
    }

    private class XercesErrorHandler
    implements ErrorHandler {
        private ErrorCallback fErrors;

        public XercesErrorHandler(ErrorCallback errorCallback) {
            this.fErrors = errorCallback;
        }

        private void parseError(int n, String string, SAXParseException sAXParseException) {
            sAXParseException.getColumnNumber();
            DefaultLocatorInfo defaultLocatorInfo = new DefaultLocatorInfo(sAXParseException.getPublicId(), sAXParseException.getSystemId(), sAXParseException.getLineNumber(), sAXParseException.getColumnNumber());
            this.fErrors.error(n, DTDValidator.this.format(string, sAXParseException), (LocatorInfo)defaultLocatorInfo);
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            this.parseError(1, "warning", sAXParseException);
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            this.parseError(2, "error", sAXParseException);
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            DTDValidator.this.fFatal = true;
            this.parseError(3, "fatal", sAXParseException);
        }
    }
}

