/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor.xerces;

import com.objfac.util.Misc;
import com.objfac.util.UnimplementedException;
import com.objfac.walker.EmptyWalker;
import com.objfac.walker.IWalker;
import com.objfac.xml.ErrorCallback;
import com.objfac.xmleditor.log.Log;
import com.objfac.xmleditor.resources.ResourceWatcherCallback;
import com.objfac.xmleditor.resources.URIResource;
import com.objfac.xmleditor.xerces.XMLSchemaWalker;
import com.objfac.xmleditor.xerces.XercesSchemaReader;
import com.thaiopensource.relaxng.impl.DTDWalker;
import com.thaiopensource.relaxng.impl.PatternPool;
import com.thaiopensource.relaxng.impl.SchemaWalkerFactory;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.apache.xerces.impl.dtd.DTDGrammar;
import org.apache.xerces.impl.dtd.XMLEntityDecl;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.xni.grammars.Grammar;
import org.apache.xerces.xni.grammars.XMLGrammarDescription;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.grammars.XMLSchemaDescription;

public class XMLCachingGrammarPool
implements XMLGrammarPool {
    private ResourceWatcherCallback rwcb;
    private ErrorCallback ecb;
    private String noNamespaceSchemaLocation;
    private HashMap nsmap = new HashMap();
    private HashMap pfxmap = new HashMap();
    private boolean fLocked;
    private static HashMap grammarMap = new HashMap();
    private static final EmptyWalker EMPTY_WALKER = new EmptyWalker();
    private static final HashSet alreadyReportedInternalErrors = new HashSet();
    private static long uniqueMod = 1L;

    public XMLCachingGrammarPool(String[] stringArray, String string, ErrorCallback errorCallback, ResourceWatcherCallback resourceWatcherCallback) {
        this.noNamespaceSchemaLocation = string;
        this.ecb = errorCallback;
        this.rwcb = resourceWatcherCallback;
        int n = 0;
        while (n < stringArray.length) {
            this.nsmap.put(stringArray[n], stringArray[n + 1]);
            if (stringArray[n + 2].length() > 0) {
                this.pfxmap.put(stringArray[n], stringArray[n + 2]);
            }
            n += 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCacheForUri(String string) {
        HashMap hashMap = grammarMap;
        synchronized (hashMap) {
            Iterator iterator = grammarMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String cfr_ignored_0 = (String)entry.getKey();
                SoftReference softReference = (SoftReference)entry.getValue();
                if (softReference != null) {
                    CachedGrammar cachedGrammar = (CachedGrammar)softReference.get();
                    if (cachedGrammar != null && !string.equals(cachedGrammar.uri)) continue;
                    iterator.remove();
                    continue;
                }
                iterator.remove();
            }
        }
    }

    private CachedGrammar getGrammarCache(String string) {
        CachedGrammar cachedGrammar = null;
        SoftReference softReference = (SoftReference)grammarMap.get(string);
        if (softReference != null && (cachedGrammar = (CachedGrammar)softReference.get()) == null) {
            grammarMap.remove(string);
        }
        return cachedGrammar;
    }

    private Grammar getFirstCachedGrammar(String string) {
        CachedGrammar cachedGrammar = this.getGrammarCache(string);
        if (cachedGrammar != null) {
            return cachedGrammar.grammar;
        }
        return null;
    }

    private Grammar getCachedGrammar(String string, String string2) {
        CachedGrammar cachedGrammar;
        CachedGrammar cachedGrammar2 = cachedGrammar = this.getGrammarCache(string);
        Object var5_5 = null;
        while (cachedGrammar2 != null) {
            if (cachedGrammar2.uri.equals(string2)) {
                if (this.getMod(cachedGrammar2.uri) == cachedGrammar2.mod) {
                    return cachedGrammar2.grammar;
                }
                if (var5_5 != null) {
                    var5_5.next = cachedGrammar2.next;
                } else if (cachedGrammar2.next != null) {
                    grammarMap.put(string, new SoftReference<CachedGrammar>(cachedGrammar2.next));
                } else {
                    grammarMap.remove(string);
                }
            }
            cachedGrammar2 = cachedGrammar2.next;
        }
        return null;
    }

    private void putCachedGrammar(String string, String string2, Grammar grammar, String string3) {
        CachedGrammar cachedGrammar = this.makeCache(string, grammar, string2, string3, this.getMod(string2));
        CachedGrammar cachedGrammar2 = null;
        SoftReference softReference = (SoftReference)grammarMap.get(string);
        if (softReference != null && (cachedGrammar2 = (CachedGrammar)softReference.get()) == null) {
            grammarMap.remove(string);
        }
        CachedGrammar cachedGrammar3 = cachedGrammar2;
        Object var9_9 = null;
        while (cachedGrammar3 != null) {
            if (cachedGrammar3.uri.equals(string2) && cachedGrammar3.grammarType.equals(string3)) {
                if (cachedGrammar3.mod == this.getMod(string2)) {
                    return;
                }
                if (var9_9 != null) {
                    var9_9.next = cachedGrammar3.next;
                } else if (cachedGrammar3.next != null) {
                    grammarMap.put(cachedGrammar3.uri, new SoftReference<CachedGrammar>(cachedGrammar3.next));
                } else {
                    grammarMap.remove(string);
                    cachedGrammar2 = null;
                }
            }
            cachedGrammar3 = cachedGrammar3.next;
        }
        if (cachedGrammar2 != null) {
            cachedGrammar.next = cachedGrammar2.next;
            cachedGrammar2.next = cachedGrammar;
        } else {
            grammarMap.put(string, new SoftReference<CachedGrammar>(cachedGrammar));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Grammar getNoNamespaceGrammar() {
        if (this.noNamespaceSchemaLocation == null) {
            return null;
        }
        HashMap hashMap = grammarMap;
        synchronized (hashMap) {
            Grammar grammar = this.getCachedGrammar("", this.noNamespaceSchemaLocation);
            if (grammar != null) {
                return grammar;
            }
            XMLGrammarPool xMLGrammarPool = XercesSchemaReader.getGrammarPool(this.noNamespaceSchemaLocation, this.ecb, this.rwcb);
            Grammar[] grammarArray = xMLGrammarPool.retrieveInitialGrammarSet("http://www.w3.org/2001/XMLSchema");
            int n = 0;
            while (n < grammarArray.length) {
                SchemaGrammar schemaGrammar = (SchemaGrammar)grammarArray[n];
                XMLGrammarDescription xMLGrammarDescription = schemaGrammar.getGrammarDescription();
                if (this.noNamespaceSchemaLocation.equals(xMLGrammarDescription.getExpandedSystemId())) {
                    this.putCachedGrammar("", this.noNamespaceSchemaLocation, (Grammar)schemaGrammar, "http://www.w3.org/2001/XMLSchema");
                    return schemaGrammar;
                }
                ++n;
            }
        }
        return null;
    }

    public Grammar[] retrieveInitialGrammarSet(String string) {
        Grammar grammar;
        if (this.noNamespaceSchemaLocation != null && (grammar = this.getNoNamespaceGrammar()) != null) {
            return new Grammar[]{grammar};
        }
        return new Grammar[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheGrammars(String string, Grammar[] grammarArray) {
        if (this.fLocked) {
            return;
        }
        HashMap hashMap = grammarMap;
        synchronized (hashMap) {
            int n = 0;
            while (n < grammarArray.length) {
                String string2;
                Grammar grammar = grammarArray[n];
                XMLGrammarDescription xMLGrammarDescription = grammar.getGrammarDescription();
                String string3 = xMLGrammarDescription.getGrammarType();
                if (string3 == "http://www.w3.org/2001/XMLSchema") {
                    string2 = xMLGrammarDescription.getExpandedSystemId();
                    if (string2 == null) {
                        string2 = xMLGrammarDescription.getLiteralSystemId();
                    }
                    String string4 = xMLGrammarDescription.getNamespace();
                    this.putCachedGrammar(string4, string2, grammar, string3);
                } else if (string3 == "http://www.w3.org/TR/REC-xml") {
                    string2 = xMLGrammarDescription.getExpandedSystemId();
                    if (string2 == null) {
                        string2 = xMLGrammarDescription.getLiteralSystemId();
                    }
                    if (string2 == null) {
                        string2 = "";
                    }
                    this.putCachedGrammar("", string2, grammar, string3);
                }
                ++n;
            }
        }
    }

    private CachedGrammar makeCache(String string, Grammar grammar, String string2, String string3, long l) {
        CachedGrammar cachedGrammar = new CachedGrammar();
        cachedGrammar.grammar = grammar;
        cachedGrammar.uri = string2;
        cachedGrammar.ns = string;
        cachedGrammar.grammarType = string3;
        cachedGrammar.mod = l;
        return cachedGrammar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IWalker getWalker() {
        HashMap hashMap = grammarMap;
        synchronized (hashMap) {
            if (grammarMap.size() == 0) {
                return EMPTY_WALKER;
            }
            PatternPool patternPool = new PatternPool();
            XMLSchemaWalker xMLSchemaWalker = new XMLSchemaWalker(patternPool);
            xMLSchemaWalker.setDefaultPrefixMap(this.pfxmap);
            Iterator iterator = grammarMap.values().iterator();
            while (iterator.hasNext()) {
                CachedGrammar cachedGrammar;
                SoftReference softReference = (SoftReference)iterator.next();
                CachedGrammar cachedGrammar2 = cachedGrammar = (CachedGrammar)softReference.get();
                while (cachedGrammar2 != null) {
                    if (cachedGrammar2.grammarType.equals("http://www.w3.org/2001/XMLSchema")) {
                        if (cachedGrammar2.walker == null) {
                            try {
                                cachedGrammar2.walker = SchemaWalkerFactory.schemaToWalker((SchemaGrammar)((SchemaGrammar)cachedGrammar2.grammar), (PatternPool)patternPool);
                            }
                            catch (IllegalStateException illegalStateException) {
                                this.handleExceptions(illegalStateException, cachedGrammar2.uri);
                            }
                            catch (StackOverflowError stackOverflowError) {
                                this.handleExceptions(stackOverflowError, cachedGrammar2.uri);
                            }
                        }
                        if (cachedGrammar2.walker != null) {
                            xMLSchemaWalker.addWalker(cachedGrammar2.ns, cachedGrammar2.walker);
                        }
                    } else if (cachedGrammar2.grammarType.equals("http://www.w3.org/TR/REC-xml")) {
                        DTDGrammar dTDGrammar = (DTDGrammar)cachedGrammar2.grammar;
                        DTDWalker dTDWalker = new DTDWalker(patternPool);
                        XMLEntityDecl xMLEntityDecl = new XMLEntityDecl();
                        boolean bl = false;
                        int n = 0;
                        while (dTDGrammar.getEntityDecl(n, xMLEntityDecl)) {
                            if (!xMLEntityDecl.isPE) {
                                String string = xMLEntityDecl.name;
                                String string2 = xMLEntityDecl.value;
                                if (string != null && string2 != null) {
                                    dTDWalker.addGE(string, (Object)string2);
                                    bl = true;
                                }
                            }
                            ++n;
                        }
                        if (bl) {
                            xMLSchemaWalker.setDtdWalker((IWalker)dTDWalker);
                        }
                    }
                    cachedGrammar2 = cachedGrammar2.next;
                }
            }
            if (xMLSchemaWalker.numSchemas() == 0) {
                return EMPTY_WALKER;
            }
            return xMLSchemaWalker;
        }
    }

    private void handleExceptions(Throwable throwable, String string) {
        if (!alreadyReportedInternalErrors.contains(string)) {
            alreadyReportedInternalErrors.add(string);
            Log.log(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Grammar retrieveGrammar(XMLGrammarDescription xMLGrammarDescription) {
        Object object;
        Object object2;
        String string = null;
        LinkedList<String> linkedList = new LinkedList<String>();
        String string2 = xMLGrammarDescription.getExpandedSystemId();
        if (string2 != null) {
            linkedList.add(string2);
        }
        if (xMLGrammarDescription.getGrammarType() == "http://www.w3.org/2001/XMLSchema") {
            object2 = (XMLSchemaDescription)xMLGrammarDescription;
            object = object2.getLocationHints();
            int n = 0;
            while (object != null && n < ((String[])object).length) {
                if (!linkedList.contains(object[n])) {
                    linkedList.add(object[n]);
                }
                ++n;
            }
            string = object2.getNamespace();
        } else if (xMLGrammarDescription.getGrammarType() == "http://www.w3.org/TR/REC-xml") {
            string = "";
        }
        object2 = (String)this.nsmap.get(string);
        if (object2 != null && !linkedList.contains(object2)) {
            linkedList.addFirst((String)object2);
        }
        if (linkedList.size() > 0) {
            object = grammarMap;
            synchronized (object) {
                String string3;
                String string4;
                Iterator iterator = linkedList.iterator();
                while (iterator.hasNext()) {
                    string4 = (String)iterator.next();
                    if (!Misc.isAbsolute((String)string4)) {
                        string3 = xMLGrammarDescription.getBaseSystemId();
                        string4 = Misc.getAbsUrl((String)string3, (String)string4);
                    }
                    if ((string3 = this.getCachedGrammar(string, string4)) == null) continue;
                    return string3;
                }
                if (xMLGrammarDescription.getGrammarType() == "http://www.w3.org/2001/XMLSchema") {
                    iterator = linkedList.iterator();
                    while (iterator.hasNext()) {
                        string4 = (String)iterator.next();
                        if (!Misc.isAbsolute((String)string4)) {
                            string3 = xMLGrammarDescription.getBaseSystemId();
                            string4 = Misc.getAbsUrl((String)string3, (String)string4);
                        }
                        if ((string3 = XercesSchemaReader.getGrammarPool(string4, this.ecb, this.rwcb)) == null) continue;
                        Grammar[] grammarArray = string3.retrieveInitialGrammarSet("http://www.w3.org/2001/XMLSchema");
                        int n = 0;
                        while (n < grammarArray.length) {
                            SchemaGrammar schemaGrammar = (SchemaGrammar)grammarArray[n];
                            XMLGrammarDescription xMLGrammarDescription2 = schemaGrammar.getGrammarDescription();
                            if (string4.equals(xMLGrammarDescription2.getLiteralSystemId())) {
                                this.putCachedGrammar(string, string4, (Grammar)schemaGrammar, "http://www.w3.org/2001/XMLSchema");
                                xMLGrammarDescription.setLiteralSystemId(string4);
                                return schemaGrammar;
                            }
                            ++n;
                        }
                    }
                }
            }
        }
        return this.getFirstCachedGrammar(string);
    }

    private long getMod(String string) {
        if (string.length() == 0) {
            return uniqueMod++;
        }
        return URIResource.getMod((String)string);
    }

    public void lockPool() {
        this.fLocked = true;
    }

    public void unlockPool() {
        this.fLocked = false;
    }

    public void clear() {
        throw new UnimplementedException();
    }

    private static class CachedGrammar {
        Grammar grammar;
        String ns;
        String uri;
        String grammarType;
        long mod;
        IWalker walker;
        CachedGrammar next;

        CachedGrammar() {
        }
    }
}

