/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor.xerces;

import com.objfac.walker.IWalker;
import com.objfac.xml.ErrorCallback;
import com.objfac.xmleditor.log.Log;
import com.objfac.xmleditor.resources.ResourceWatcherCallback;
import com.objfac.xmleditor.validate.SchemaValidator;
import com.objfac.xmleditor.xerces.CacheEntityResolver;
import com.objfac.xmleditor.xerces.ErrorCallbackErrorHandler;
import com.objfac.xmleditor.xerces.XMLCachingGrammarPool;
import com.objfac.xmleditor.xerces.XercesUtils;
import java.io.IOException;
import java.io.Reader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.apache.xerces.parsers.SAXParser;
import org.apache.xerces.parsers.XMLGrammarPreparser;
import org.apache.xerces.util.EntityResolverWrapper;
import org.apache.xerces.util.ErrorHandlerWrapper;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.LocatorImpl;

public class XercesSchemaValidator
implements SchemaValidator {
    public IWalker validate(String string, Reader reader, String[] stringArray, String string2, ErrorCallback errorCallback, boolean bl, ResourceWatcherCallback resourceWatcherCallback) {
        IWalker iWalker = null;
        CacheEntityResolver cacheEntityResolver = new CacheEntityResolver(resourceWatcherCallback);
        new EntityResolverWrapper((EntityResolver)cacheEntityResolver);
        ErrorCallbackErrorHandler errorCallbackErrorHandler = new ErrorCallbackErrorHandler(errorCallback);
        SymbolTable symbolTable = new SymbolTable();
        XMLCachingGrammarPool xMLCachingGrammarPool = new XMLCachingGrammarPool(stringArray, string2, errorCallback, resourceWatcherCallback);
        SAXParser sAXParser = new SAXParser(symbolTable, (XMLGrammarPool)xMLCachingGrammarPool);
        sAXParser.setEntityResolver((EntityResolver)cacheEntityResolver);
        sAXParser.setErrorHandler((ErrorHandler)errorCallbackErrorHandler);
        try {
            sAXParser.setFeature("http://xml.org/sax/features/namespaces", true);
            sAXParser.setFeature("http://xml.org/sax/features/validation", true);
            sAXParser.setFeature("http://apache.org/xml/features/validation/schema", true);
            sAXParser.setFeature("http://apache.org/xml/features/validation/schema-full-checking", true);
            if (bl) {
                sAXParser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", (Object)"http://www.w3.org/2001/XMLSchema");
                sAXParser.setFeature("http://xml.org/sax/features/external-general-entities", true);
            }
            InputSource inputSource = new InputSource(reader);
            inputSource.setSystemId(string);
            sAXParser.parse(inputSource);
            iWalker = xMLCachingGrammarPool.getWalker();
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            Log.log(sAXNotRecognizedException);
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            Log.log(sAXNotSupportedException);
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {}
        return iWalker;
    }

    public IWalker validate2(String string, Reader reader, String[] stringArray, String string2, ErrorCallback errorCallback, ResourceWatcherCallback resourceWatcherCallback) {
        Object object;
        javax.xml.parsers.SAXParser sAXParser;
        IWalker iWalker = null;
        CacheEntityResolver cacheEntityResolver = new CacheEntityResolver(resourceWatcherCallback);
        new EntityResolverWrapper((EntityResolver)cacheEntityResolver);
        ErrorCallbackErrorHandler errorCallbackErrorHandler = new ErrorCallbackErrorHandler(errorCallback);
        SymbolTable symbolTable = new SymbolTable();
        XMLCachingGrammarPool xMLCachingGrammarPool = new XMLCachingGrammarPool(stringArray, string2, errorCallback, resourceWatcherCallback);
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setNamespaceAware(true);
        sAXParserFactory.setValidating(true);
        try {
            sAXParser = sAXParserFactory.newSAXParser();
            object = sAXParser.getParser();
            sAXParser.getXMLReader();
            sAXParser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            SAXParser sAXParser2 = (SAXParser)object;
            sAXParser2.setFeature("http://apache.org/xml/features/validation/schema-full-checking", true);
            sAXParser2.setProperty("foo", (Object)"bar");
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (SAXException sAXException) {
            Log.log(sAXException);
        }
        sAXParser = new SAXParser(symbolTable, (XMLGrammarPool)xMLCachingGrammarPool);
        sAXParser.setEntityResolver(cacheEntityResolver);
        sAXParser.setErrorHandler(errorCallbackErrorHandler);
        try {
            sAXParser.setFeature("http://xml.org/sax/features/namespaces", true);
            sAXParser.setFeature("http://xml.org/sax/features/validation", true);
            sAXParser.setFeature("http://apache.org/xml/features/validation/schema", true);
            sAXParser.setFeature("http://apache.org/xml/features/validation/schema-full-checking", true);
            object = new InputSource(reader);
            ((InputSource)object).setSystemId(string);
            sAXParser.parse((InputSource)object);
            iWalker = xMLCachingGrammarPool.getWalker();
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            Log.log(sAXNotRecognizedException);
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            Log.log(sAXNotSupportedException);
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {}
        return iWalker;
    }

    public IWalker validateSchema(String string, Reader reader, String[] stringArray, String string2, ErrorCallback errorCallback, ResourceWatcherCallback resourceWatcherCallback) {
        resourceWatcherCallback.watchResource(string);
        SymbolTable symbolTable = new SymbolTable();
        XMLGrammarPreparser xMLGrammarPreparser = new XMLGrammarPreparser(symbolTable);
        XMLCachingGrammarPool xMLCachingGrammarPool = new XMLCachingGrammarPool(stringArray, null, errorCallback, resourceWatcherCallback);
        xMLCachingGrammarPool.removeCacheForUri(string);
        xMLGrammarPreparser.registerPreparser("http://www.w3.org/2001/XMLSchema", null);
        xMLGrammarPreparser.setGrammarPool((XMLGrammarPool)xMLCachingGrammarPool);
        ErrorCallbackErrorHandler errorCallbackErrorHandler = new ErrorCallbackErrorHandler(errorCallback);
        ErrorHandlerWrapper errorHandlerWrapper = new ErrorHandlerWrapper((ErrorHandler)errorCallbackErrorHandler);
        xMLGrammarPreparser.setErrorHandler((XMLErrorHandler)errorHandlerWrapper);
        CacheEntityResolver cacheEntityResolver = new CacheEntityResolver(resourceWatcherCallback);
        EntityResolverWrapper entityResolverWrapper = new EntityResolverWrapper((EntityResolver)cacheEntityResolver);
        xMLGrammarPreparser.setEntityResolver((XMLEntityResolver)entityResolverWrapper);
        XMLInputSource xMLInputSource = new XMLInputSource(null, string, null, reader, null);
        try {
            xMLGrammarPreparser.preparseGrammar("http://www.w3.org/2001/XMLSchema", xMLInputSource);
            LocatorImpl locatorImpl = new LocatorImpl();
            locatorImpl.setSystemId(string);
            locatorImpl.setLineNumber(-1);
            locatorImpl.setColumnNumber(-1);
            return xMLCachingGrammarPool.getWalker();
        }
        catch (XNIException xNIException) {
            errorCallbackErrorHandler.initializationError("parsing schema", XercesUtils.toSAXException(xNIException), string);
        }
        catch (IOException iOException) {
            errorCallbackErrorHandler.initializationError("parsing schema", iOException, string);
        }
        return null;
    }
}

